<?php defined('SYSTEM_INIT') or die('Invalid Usage.'); 
$flexiPaymentHtml  = '';
if(!empty($partialPaymentCartSummary['rentalProdSummary'])){
    $flexiPaymentHtml  = '<div class="tooltip-table">
        <div class="tooltip-header">Product Name</div>
        <div class="tooltip-header">Total</div>
        <div class="tooltip-header">Upfront</div>';
    foreach($partialPaymentCartSummary['rentalProdSummary'] as $selProd){
        foreach($selProd as $key => $val){  
            
            $flexiPaymentHtml .= '<div class="tooltip-cell">'.CommonHelper::truncateCharacters($val['selprod_title'],25).'</div>';
            $flexiPaymentHtml .= '<div class="tooltip-cell">'.CommonHelper::displayMoneyFormat($val['productTotal']).'</div>';
            if($val['productTotal'] == $val['upfrontTotal']){
                $flexiPaymentHtml .= '<div class="tooltip-cell">'.CommonHelper::displayMoneyFormat($val['productTotal']).'</div>';
            }else{
                $flexiPaymentHtml .= '<div class="tooltip-cell">'.CommonHelper::displayMoneyFormat($val['upfrontTotal']).'</div>';
            }
            
        }
    }
    $flexiPaymentHtml .= '</div>';
}   
?>
  <style>
        .tooltip.show{
            opacity: 1;
        }

        .tooltip-inner {
            max-width: none;
            text-align: left;
            background-color: white;
            color: black;
            border: 1px solid #ddd;
            padding: 10px;
        }
        .tooltip-table {
            display: grid;
            grid-template-columns: repeat(3, auto);
            gap: 5px;
            font-size: 14px;
        }
        .tooltip-header {
            font-weight: bold;
            background-color: #343a40;
            color: white;
            padding: 5px;
            text-align: center;
        }
        .tooltip-cell {
            padding: 5px;
            border-bottom: 1px solid #ddd;
        }
    </style>
<div class="cart-total-head">
    <h3 class="cart-total-title">
        <?php echo Labels::getLabel("LBL_Price_summary", $siteLangId); ?>
    </h3>
</div>

<ul class="cart-summary">
    <li class="cart-summary-item">
        <?php if ($cartSummary['cartType'] == applicationConstants::PRODUCT_FOR_SALE) { ?>
            <span class="label">
                <?php echo Labels::getLabel('LBL_Sale_Amount', $siteLangId); ?>
            </span>
        <?php } else { ?>
            <span class="label">
            <?php 
            if(!empty($cartSummary['pendingAmt'])){
                echo Labels::getLabel('LBL_Upfront_Rental_Amount', $siteLangId);
                ?>
                <?php
            }else{
                echo Labels::getLabel('LBL_Rental_Amount', $siteLangId);
            }
            ?>
            </span>
        <?php } ?>
        <span class="value">
            <?php echo CommonHelper::displayMoneyFormat($cartSummary['cartTotal']); ?>
        </span>
    </li>
    <?php if ($cartSummary['rentalSecurityTotal'] > 0) { ?>
        <li class="cart-summary-item">
            <span class="label">
                <?php echo Labels::getLabel('LBL_Rental_Security', $siteLangId); ?>
            </span>
            <span class="value">
                <?php echo CommonHelper::displayMoneyFormat($cartSummary['rentalSecurityTotal']); ?>
            </span>
        </li>
    <?php } ?>
    <?php if ($cartSummary['addonTotalAmount'] > 0) { ?>
        <li class="cart-summary-item">
            <span class="label">
                <?php echo Labels::getLabel('LBL_Addons_Total_Amount', $siteLangId); ?>
            </span> <span class="value">
                <?php echo CommonHelper::displayMoneyFormat($cartSummary['addonTotalAmount']); ?>
            </span>
        </li>
    <?php } ?>

    <?php if ($cartSummary['cartVolumeDiscount']) { ?>
        <li class="cart-summary-item">
            <span class="label">
                <?php echo Labels::getLabel('LBL_Loyalty/Volume_Discount', $siteLangId); ?>
            </span>
            <span class="value txt-success"> -
                <?php echo CommonHelper::displayMoneyFormat($cartSummary['cartVolumeDiscount']); ?>
            </span>
        </li>
    <?php } ?>
    <?php if ($cartSummary['cartDurationDiscount']) { ?>
        <li class="cart-summary-item">
            <span class="label">
                <?php echo Labels::getLabel('LBL_Duration', $siteLangId); ?>
            </span> <span class="value txt-success">
                -
                <?php echo CommonHelper::displayMoneyFormat($cartSummary['cartDurationDiscount']); ?>
            </span>
        </li>
    <?php } ?>
    <?php if (FatApp::getConfig('CONF_TAX_AFTER_DISOCUNT', FatUtility::VAR_INT, 0) && !empty($cartSummary['cartDiscounts'])) { ?>
        <li class="cart-summary-item">
            <span class="label">
                <?php echo Labels::getLabel('LBL_Discount', $siteLangId); ?>
            </span> <span class="value txt-success"> -
                <?php echo CommonHelper::displayMoneyFormat($cartSummary['cartDiscounts']['coupon_discount_total']); ?>
            </span>
        </li>
    <?php } ?>
    <?php
    if ( /* 0 < $shippingAddress && */isset($cartSummary['taxOptions'])) {
        foreach ($cartSummary['taxOptions'] as $taxName => $taxVal) {
            ?>
            <li class="cart-summary-item">
                <span class="label">
                    <?php echo $taxVal['title']; ?>
                </span>
                <span class="value">
                    <?php echo CommonHelper::displayMoneyFormat($taxVal['value']); ?>
                </span>
            </li>
            <?php
        }
    }
    ?>
    <?php if (!FatApp::getConfig('CONF_TAX_AFTER_DISOCUNT', FatUtility::VAR_INT, 0) && !empty($cartSummary['cartDiscounts'])) { ?>
        <li class="cart-summary-item">
            <span class="label">
                <?php echo Labels::getLabel('LBL_Discount', $siteLangId); ?>
            </span>
            <span class="value txt-success"> -
                <?php echo CommonHelper::displayMoneyFormat($cartSummary['cartDiscounts']['coupon_discount_total']); ?>
            </span>
        </li>
    <?php } ?>
    <?php if ($cartSummary['originalShipping']) { ?>
        <li class="cart-summary-item">
            <span class="label">
                <?php echo Labels::getLabel('LBL_Delivery_Charges', $siteLangId); ?>
            </span>
            <span class="value">
                <?php echo CommonHelper::displayMoneyFormat($cartSummary['shippingTotal']); ?>
            </span>
        </li>
    <?php } ?>
    <?php
    if (!empty($cartSummary['cartRewardPoints'])) {
        $appliedRewardPointsDiscount = CommonHelper::convertRewardPointToCurrency($cartSummary['cartRewardPoints']);
        ?>
        <li class="cart-summary-item">
            <span class="label">
                <?php echo Labels::getLabel('LBL_Reward_point_discount', $siteLangId); ?>
            </span>
            <span class="value txt-success"> -
                <?php echo CommonHelper::displayMoneyFormat($appliedRewardPointsDiscount); ?>
            </span>
        </li>
    <?php } ?>
    <?php if (array_key_exists('roundingOff', $cartSummary) && $cartSummary['roundingOff'] != 0) { ?>
        <li class="cart-summary-item">
            <span class="label">
                <?php echo (0 < $cartSummary['roundingOff']) ? Labels::getLabel('LBL_Rounding_Up', $siteLangId) : Labels::getLabel('LBL_Rounding_Down', $siteLangId); ?>
            </span>
            <span class="value">
                <?php echo CommonHelper::displayMoneyFormat($cartSummary['roundingOff']); ?>
            </span>
        </li>
    <?php } ?> 
    <?php
    /* if (0 == $shippingAddress) $orderNetAmt = $orderNetAmt - $cartSummary['cartTaxTotal'];  */
    ?>

    <?php
    if (isset($cartSummary['pendingLateCharges']) && $cartSummary['pendingLateCharges'] > 0) {
        ?>
        <li class="cart-summary-item late-charges">
            <span class="label">
                <?php echo Labels::getLabel('LBL_Pending_Charges', $siteLangId); ?>
            </span>
            <span class="value">
                <?php echo CommonHelper::displayMoneyFormat($cartSummary['pendingLateCharges']); ?>
            </span>
        </li>
        <?php
    }
    $orderNetAmt = $cartSummary['orderNetAmount'];
    if(empty($partialPaymentCartSummary['pendingAmt'])){
    ?>
    <li class="cart-summary-item highlighted">
        <span class="label">
            <?php echo Labels::getLabel('LBL_Net_Payable', $siteLangId); ?>
        </span>
        <span class="value">
            <?php echo CommonHelper::displayMoneyFormat($orderNetAmt); ?>
        </span>
    </li>
        <?php } ?>

        <?php 
        if(!empty($partialPaymentCartSummary['pendingAmt'])){
        ?>
        <li class="cart-summary-item">
            <span class="label">
                <?php echo Labels::getLabel('LBL_Total_Amount', $siteLangId); ?>
            </span>
            <span class="value">
                <?php echo CommonHelper::displayMoneyFormat($orderNetAmt); ?>
            </span>
        </li>
        <li class="cart-summary-item highlighted">
        
                <span class="label">
                <?php 
                if(!empty($partialPaymentCartSummary['pendingAmt'])){
                
                    echo Labels::getLabel('LBL_Upfront_Net_Payable', $siteLangId);
                    ?>
                    &nbsp;<svg width="14px" height="14px" data-bs-toggle="tooltip" data-placement="right" data-bs-html="true" title='<?php echo $flexiPaymentHtml; ?>' xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor"><path d="M12 22C6.47715 22 2 17.5228 2 12C2 6.47715 6.47715 2 12 2C17.5228 2 22 6.47715 22 12C22 17.5228 17.5228 22 12 22ZM12 9.5C12.8284 9.5 13.5 8.82843 13.5 8C13.5 7.17157 12.8284 6.5 12 6.5C11.1716 6.5 10.5 7.17157 10.5 8C10.5 8.82843 11.1716 9.5 12 9.5ZM14 15H13V10.5H10V12.5H11V15H10V17H14V15Z"></path></svg>
                    <?php
                }
                ?>
                </span>
        
            <span class="value">
                <?php echo CommonHelper::displayMoneyFormat($partialPaymentCartSummary['orderNetAmount']); ?>
            </span>
        </li>
       
    <?php 
    if(!empty($partialPaymentCartSummary['pendingAmt'])){
    ?>
    <li class="cart-summary-item">
        <span class="label"><?php echo Labels::getLabel('LBL_Pending_Amount', $siteLangId); ?></span>
        <span class="value"><?php echo CommonHelper::displayMoneyFormat($partialPaymentCartSummary['pendingAmt']); ?></span>
    </li>
    <?php
    }
    ?>
 <?php } ?>
</ul>

<script>
    var isPickup = '<?php echo $isPickup ?>';
    <?php 
    $cartObj = new Cart();
    ?>
    var hasPhysicalProduct = '<?php echo $cartObj->hasPhysicalProduct() ?>';
    (function(){
        if ($(".shipping-js").hasClass('is-active') || $(".verification-js").hasClass('is-active')) {
            $(".checkout-bottom").removeClass('invisible');
        } else {
            $(".checkout-bottom").addClass('invisible');
        }
    })();

    
    scrollToPriceSummary = function (type) {
        $('html, body').animate({
            scrollTop: ($(".sticky-summary").offset().top - $("#header").outerHeight())
        }, 'slow');
    }

    function proccedCheckout() {
        if ($(".verification-js").hasClass('is-active')) {
            $("#frmSubmitVerificationFlds").submit();
        } else if(isPickup == 1 && hasPhysicalProduct == 1) {
            setUpPickUpForSell();
        } else if(isPickup == 1 && hasPhysicalProduct == 0) {
            loadPaymentSummary();
        }else{
            setUpShippingMethod();
        }
    }
    function proccedRentalCheckout() {
        if ($(".verification-js").hasClass('is-active')) {
            $("#frmSubmitVerificationFlds").submit();
        } else if(isPickup == 1) {
            setUpPickup();
        }else{
            setUpShippingMethod();
        }
    }
</script>

<div class="checkout-bottom invisible">
    <div class="amount">
        <strong>
            <?php echo CommonHelper::displayMoneyFormat($orderNetAmt); ?>
        </strong>
        <button type="button" class="link-underline" onclick="scrollToPriceSummary();">
            <?php echo Labels::getLabel('LBL_Summary', $siteLangId); ?>
        </button>
    </div>
    <div class="further-actions">

        <?php 
        if ($cartSummary['cartType'] == applicationConstants::PRODUCT_FOR_SALE) {
            ?>
            <button class="btn btn-brand btn-wide" type="button" onclick="proccedCheckout();">
                <?php echo Labels::getLabel('LBL_Continue', $siteLangId); ?> 
            </button>
            <?php
        }else{
            ?>
        <button class="btn btn-brand btn-wide" type="button" onclick="proccedRentalCheckout();">
            <?php echo Labels::getLabel('LBL_Continue', $siteLangId); ?> 
        </button>
            <?php
        } ?>
        
    </div>
</div>