<?php defined('SYSTEM_INIT') or die('Invalid Usage.'); ?>

<div class="step">
    <form class="form">
        <div class="step-section">
            <div class="step-head">
                <h5 class="step-title">
                    <?php if ($fulfillmentType == Shipping::FULFILMENT_PICKUP || $addressType == Address::ADDRESS_TYPE_BILLING || !$cartHasPhysicalProduct) {
                        echo Labels::getLabel('LBL_Billing_Address', $siteLangId);
                    } else {
                        echo Labels::getLabel('LBL_Delivery_Address', $siteLangId);
                    }
                    ?>
                </h5>
                <button class="link-underline" type="button" onClick="showAddressFormDiv(<?php echo $addressType; ?>);"
                    name="addNewAddress">
                    <?php echo Labels::getLabel('LBL_Add_New_Address', $siteLangId); ?>
                </button>
            </div>
            <div class="step-body">
                <?php if ($addresses) { ?>

                    <ul class="my-addresses">
                        <?php foreach ($addresses as $address) {
                            $selected_shipping_address_id = (!$selected_shipping_address_id && $address['addr_is_default']) ? $address['addr_id'] : $selected_shipping_address_id; ?>
                            <?php $checked = false;
                            if ($addressType == 0 && $selected_shipping_address_id == $address['addr_id']) {
                                $checked = true;
                            }
                            if ($addressType == Address::ADDRESS_TYPE_BILLING && $selected_billing_address_id == $address['addr_id']) {
                                $checked = true;
                            }
                            ?>
                            <li class="my-addresses-item address-<?php echo $address['addr_id']; ?> <?php //echo ($checked == true) ? 'selected' : ''
                                        ?>">

                                <div class="my-addresses-body">
                                    <label class="radio">
                                        <input <?php echo ($checked == true) ? 'checked="checked"' : ''; ?>
                                            name="shipping_address_id" value="<?php echo $address['addr_id']; ?>" type="radio">
                                    </label>
                                    <address class="delivery-address">
                                        <h5>
                                            <span>
                                                <?php echo $address['addr_name']; ?>
                                            </span><span class="tag">
                                                <?php echo ($address['addr_title'] != '') ? $address['addr_title'] : $address['addr_name']; ?>
                                            </span>
                                        </h5>
                                        <p>
                                            <?php echo $address['addr_address1']; ?>
                                            <?php if (strlen($address['addr_address2']) > 0) {
                                                echo ", " . $address['addr_address2']; ?>
                                            <?php } ?>
                                        </p>
                                        <p>
                                            <?php echo $address['addr_city'] . ", " . $address['state_name'] . ", " . $address['country_name'] . ", " . $address['addr_zip']; ?>
                                        </p>
                                        <?php if (strlen($address['addr_phone']) > 0) { ?>
                                            <p class="phone-txt">
                                                <svg class="svg" width="16" height="16">
                                                    <use
                                                        xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#mobile">
                                                    </use>
                                                </svg>
                                                <?php echo $address['addr_dial_code'] . ' ' . $address['addr_phone']; ?>
                                            </p>
                                        <?php } ?>
                                    </address>
                                </div>

                                <div class="my-addresses-footer">
                                    <?php if (!commonhelper::isAppUser()) { ?>
                                        <button class="btn-link" type="button"
                                            onClick="editAddress('<?php echo $address['addr_id']; ?>', '<?php echo $addressType; ?>')">
                                            <?php echo Labels::getLabel('LBL_Edit', $siteLangId); ?>
                                        </button>
                                        <button class="btn-link" type="button"
                                            onclick="removeAddress('<?php echo $address['addr_id']; ?>', '<?php echo $addressType; ?>')">
                                            <?php echo Labels::getLabel('LBL_Delete', $siteLangId); ?>
                                        </button>

                                    <?php } ?>
                                </div>

                            </li>
                        <?php } ?>
                    </ul>

                <?php } ?>

                <div id="addressFormDiv" style="display:none">
                    <?php $tplDataArr = array(
                        'siteLangId' => $siteLangId,
                        'addressFrm' => $addressFrm,
                        'labelHeading' => Labels::getLabel('LBL_Add_New_Address', $siteLangId),
                        'stateId' => $stateId,
                    ); ?>
                    <?php $this->includeTemplate('checkout/address-form.php', $tplDataArr, false); ?>

                </div>
            </div>
            <div class="step-foot">
                <div class="checkout-actions">
                    <?php if ($addressType == Address::ADDRESS_TYPE_BILLING) { ?>
                        <button type="button" class="btn btn-outline-brand btn-wide" onclick="loadPaymentSummary();">
                            <?php echo Labels::getLabel('LBL_Back', $siteLangId); ?>
                        </button>
                    <?php } else { ?>
                        <button class="btn btn-outline-brand btn-wide" onclick="goToBack();" type="button">

                            <?php echo Labels::getLabel('LBL_Back', $siteLangId); ?>
                        </button>
                    <?php } ?>
                    <?php if ($addressType == Address::ADDRESS_TYPE_BILLING) { ?>
                        <button type="button" id="btn-continue-js" onClick="setUpBillingAddressSelection(this);"
                            class="btn btn-brand btn-wide">
                            <?php echo Labels::getLabel('LBL_Continue', $siteLangId); ?>
                        </button>
                    <?php } else { ?>
                        <button type="button" id="btn-continue-js" onClick="setUpAddressSelection();"
                            class="btn btn-brand btn-wide">
                            <?php echo Labels::getLabel('LBL_Continue', $siteLangId); ?>
                        </button>
                    <?php } ?>
                </div>
            </div>
        </div>
    </form>
</div>

<script>
    (function () {
        var isMobileOrTablet = $(window).width() < 992;

        if (isMobileOrTablet && $(".billing-js").length > 0) {
            if ($(".billing-js").length > 0) {
                $(".checkout-content-js .step-foot").show();
            } else {
                $(".checkout-content-js .step-foot").hide();
            }
        }
    })();
</script>