<?php defined('SYSTEM_INIT') or die('Invalid Usage.'); ?>
<?php
$addressType = $addressType ?? 0;
$addressFrm->setFormTagAttribute('class', 'form');
$addressFrm->setFormTagAttribute('onsubmit', 'setUpAddress(this, ' . $addressType . '); return(false);');
$addressFrm->developerTags['colClassPrefix'] = 'col-md-';
$addressFrm->developerTags['fld_default_col'] = 6;

$countryFld = $addressFrm->getField('addr_country_id');
$countryFld->setFieldTagAttribute('id', 'addr_country_id');
$countryFld->setFieldTagAttribute('onChange', 'getCountryStates(this.value, 0 ,\'#addr_state_id\')');

$stateFld = $addressFrm->getField('addr_state_id');
$stateFld->setFieldTagAttribute('id', 'addr_state_id');

$zipCodeFld = $addressFrm->getField('addr_zip');
$zipCodeFld->setFieldTagAttribute('id', 'addr_zip');

$cityFld = $addressFrm->getField('addr_city');
$cityFld->setFieldTagAttribute('id', 'addr_city');

$address1Fld = $addressFrm->getField('addr_address1');
$address1Fld->setFieldTagAttribute('id', 'addr_address1');

if (CommonHelper::isDistanceShippingEnabled()) {
    $mapFld = $addressFrm->getField('addr_map');
    $mapFld->developerTags['col'] = 12;
    $mapFld->developerTags['noCaptionTag'] = true;
    /* $mapFld->value = '<div class="my-2" id="map" style="min-height: 500px; width: 100%"></div>
    <div class="map-locator"><div class="form-on-map"><div class="form-on-map-group"><div class="form-on-map-field">
    <input class="form-on-map-input location-selected" id="ga-autoComplete" type="text" placeholder="'.Labels::getLabel('LBL_Add_Shop_Location', $siteLangId).'">
    <button class="icn-detect" type="button" onclick="loadGeoLocation(); return false;">
        <svg class="svg" width="16" height="16"><use xlink:href="'.CONF_WEBROOT_URL.'images/dashboard/retina/sprite.svg#location-detect"></use>
        </svg>
    </button></div><input class="btn btn-brand btn-locate" type="submit" name="btn_submit" value="'.Labels::getLabel('LBL_Locate', $siteLangId).'" onclick="searchLocation(); return false;">
    </div></div></div>'; */
}

$cancelFld = $addressFrm->getField('btn_cancel');
$cancelFld->setFieldTagAttribute('class', 'btn btn-outline-brand btn-wide');
$cancelFld->setFieldTagAttribute('onclick', 'resetAddress(' . $addressType . ')');
$cancelFld->developerTags['col'] = 12;
$cancelFld->htmlBeforeField = '<div class="checkout-actions mt-0">';
$submitFld = $addressFrm->getField('btn_submit');
$cancelFld->attachField($submitFld);

$submitFld->addFieldTagAttribute('class', 'btn btn-brand btn-wide');
$submitFld->htmlAfterField = '</div>';

?>
<div class="step">
    <div class="step-section">
        <div class="step-head">
            <h5 class="step-title"><?php echo Labels::getLabel('LBL_ADDRESS_DETAILS', $siteLangId); ?>
            </h5>
        </div>
        <div class="step-body">
            <?php echo $addressFrm->getFormHtml(); ?>
        </div>
    </div>
</div>
<script language="javascript">
    $(document).ready(function () {
        <?php if (!empty(FatApp::getConfig('CONF_GOOGLEMAP_API_KEY', FatUtility::VAR_STRING, '')) && FatApp::getConfig('CONF_DISTANCE_BASED_SHIPPING', FatUtility::VAR_INT, 0)) { ?>
            var lat = (!$('#lat').val()) ? '<?php echo FatApp::getConfig('CONF_GEO_DEFAULT_LAT', FatUtility::VAR_FLOAT, 0); ?>' : $('#lat').val();
            var lng = (!$('#lng').val()) ? '<?php echo FatApp::getConfig('CONF_GEO_DEFAULT_LNG', FatUtility::VAR_FLOAT, 0); ?>' : $('#lng').val();
            initAutocomplete();
            initMap(lat, lng);
        <?php } ?>
        getCountryStates($("#addr_country_id").val(), <?php echo $stateId; ?>, '#addr_state_id');
        stylePhoneNumberFld("input[name='addr_phone']", false, 'addr_dial_code', 'addr_country_iso');
    });


</script>
<?php
if (isset($countryIso) && !empty($countryIso)) { ?>
    <script>
        langLbl.defaultCountryCode = '<?php echo $countryIso; ?>';
    </script>
<?php } ?>