<div class="cart-table-row <?php echo isset($product['key']) ? md5($product['key']) : ''; ?> <?php echo (!$product['in_stock']) ? 'disabled' : ''; ?>"
    data-cols="2">
    <div class="cart-table-col cart-table-col-1">
        <div class="product-profile">
            <a class="product-profile-thumbnail" href="<?php echo $productUrl; ?>">
                <img class="img-fluid" data-ratio="3:4" src="<?php echo $imageUrl; ?>"
                    alt="<?php echo $product['product_name']; ?>" title="<?php echo $product['product_name']; ?>">
            </a>
            <div class="product-profile-data">
                <div class="title">
                    <a class="" href="<?php echo $productUrl; ?>">
                        <?php echo $productTitle; ?>
                    </a>
                    <?php if ($product['uwlp_product_type'] == applicationConstants::PRODUCT_FOR_RENT) { ?>
                        <label class="badge badge-success">
                            <?php echo Labels::getLabel('LBL_For_Rent', $siteLangId); ?>
                        </label>
                    <?php } else { ?>
                        <label class="badge badge-info">
                            <?php echo Labels::getLabel('LBL_For_Sale', $siteLangId); ?>
                        </label>
                    <?php } ?>
                </div>
                <div class="product-price">
                    <div class="products-price-new">
                        <?php if ($product['uwlp_product_type'] == applicationConstants::PRODUCT_FOR_RENT) {
                            echo CommonHelper::displayMoneyFormat($product['rent_price']);
                        } else {
                            echo CommonHelper::displayMoneyFormat($product['theprice']);
                        } ?>
                    </div>
                </div>

                <?php if (isset($product['options']) && count($product['options'])) { ?>
                    <div class="options">
                        <p class="">
                            <?php
                            foreach ($product['options'] as $key => $option) {
                                echo (0 < $key) ? ' | ' : "";
                                echo $option['option_name'] . ':';
                                ?>
                                <span class="text--dark">
                                    <?php echo $option['optionvalue_name']; ?>
                                </span>
                                <?php
                            }
                            ?>
                        </p>
                    </div>
                <?php } ?>

                <!--  -->
                <?php
                $moveToBagAction = 'moveToCart(' . $product['selprod_id'] . ', ' . $product['uwlp_uwlist_id'] . ', event, ' . Shipping::FULFILMENT_PICKUP . ')';
                if ($product['uwlp_product_type'] == applicationConstants::PRODUCT_FOR_RENT) {
                    $moveToBagAction = 'quickDetail(' . $product['selprod_id'] . ', ' . $product['uwlp_uwlist_id'] . ', ' . Shipping::FULFILMENT_PICKUP . ');';
                }
                ?>
                <ul class="actions">
                    <li class="actions-item">
                        <button class="actions-text link-underline  product-profile__btn" type="button"
                            onclick="<?php echo $moveToBagAction; ?>"
                            title="<?php echo Labels::getLabel('LBL_Move_To_Cart', $siteLangId); ?>">
                            <?php echo Labels::getLabel('LBL_Move_To_Cart', $siteLangId); ?>
                        </button>
                    </li>
                    <li class="actions-item">
                        <button class="actions-text link-underline" type="button"
                            onclick="removeFromWishlist(<?php echo $product['selprod_id']; ?>, <?php echo $product['uwlp_uwlist_id']; ?>, event)"
                            title="<?php echo Labels::getLabel('LBL_Remove', $siteLangId); ?>">
                            <?php echo Labels::getLabel('LBL_Remove', $siteLangId); ?>
                        </button>
                    </li>
                </ul>
                <!-- <ul class="actions">
                    <li class="actions-item">
                        <button class="actions-link" type="button"
                            onclick="removeFromWishlist(<?php echo $product['selprod_id']; ?>, <?php echo $product['uwlp_uwlist_id']; ?>, event)">
                            <svg class="svg" width="24" height="24"
                                title="<?php echo Labels::getLabel('LBL_Remove', $siteLangId); ?>">
                                <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#remove"></use>
                            </svg>
                        </button>
                    </li>
                </ul> -->
            </div>
        </div>

    </div>

</div>