<?php defined('SYSTEM_INIT') or die('Invalid Usage.'); ?>
<?php 
if ($cartType != applicationConstants::PRODUCT_FOR_EXTEND_RENTAL) {
    if (!empty($cartSummary['cartDiscounts']['coupon_code'])) { ?>
    <div class="coupons-applied">
        <div class="">
            <h6>
                <i class="icn">
                    <svg class="svg" width="16" height="16">
                        <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#tick">
                        </use>
                    </svg>
                </i>
                <?php echo $cartSummary['cartDiscounts']['coupon_code']; ?>
            </h6>
            <p>
                <?php
                    $arr = ['{AMOUNT}' => CommonHelper::displayMoneyFormat($cartSummary['cartDiscounts']['coupon_discount_total'])];
                    echo CommonHelper::replaceStringData(Labels::getLabel("LBL_YOU_SAVED_ADDITIONAL_{AMOUNT}", $siteLangId), $arr);
                    ?>
            </p>
        </div>
        <button class="close-layer" type="button" onClick="removePromoCode()"></button>
    </div>
    <?php } else { ?>
    <div class="coupons">
        <button type="button" class="btn btn-coupon btn-coupon--js disabled-input" onclick="getPromoCode()">
            <p class="btn-coupon-txt">
                <?php echo Labels::getLabel('LBL_Apply_Coupon', $siteLangId); ?>
                <span>
                    <img class="" width="18" src="<?php echo CONF_WEBROOT_URL; ?>images/retina/party.svg" alt="">
                </span>
            </p><i>
                <svg stroke="currentColor" fill="currentColor" stroke-width="0" viewBox="0 0 512 512" color="#3E688E"
                    class="style_arrow__VSmix" height="1em" width="1em" xmlns="http://www.w3.org/2000/svg"
                    style="color: rgb(62, 104, 142);">
                    <path fill="none" stroke-linecap="round" stroke-linejoin="round" stroke-width="48"
                        d="M268 112l144 144-144 144m124-144H100">
                    </path>
                </svg>
            </i>

        </button>
    </div>
<?php } 
} ?>

<ul class="cart-summary">
    <li class="cart-summary-item">
        <?php if ($cartSummary['cartType'] == applicationConstants::PRODUCT_FOR_SALE) { ?>
        <span class="label"><?php echo Labels::getLabel('LBL_Sale_Amount', $siteLangId); ?></span>
        <?php } else { ?>
        <span class="label"><?php echo Labels::getLabel('LBL_Rental_Amount', $siteLangId); ?></span>
        <?php } ?>
        <span class="value"><?php echo CommonHelper::displayMoneyFormat($cartSummary['cartTotal']); ?></span>
    </li>
    <?php if ($cartSummary['rentalSecurityTotal'] > 0) { ?>
    <li class="cart-summary-item">
        <span class="label"><?php echo Labels::getLabel('LBL_Rental_Security', $siteLangId); ?></span>
        <span class="value"><?php echo CommonHelper::displayMoneyFormat($cartSummary['rentalSecurityTotal']); ?></span>
    </li>
    <?php } ?>

    <?php if ($cartSummary['addonTotalAmount'] > 0) { ?>
    <li class="cart-summary-item">
        <span class="label"><?php echo Labels::getLabel('LBL_Addons_Total_Amount', $siteLangId); ?></span>
        <span class="value"><?php echo CommonHelper::displayMoneyFormat($cartSummary['addonTotalAmount']); ?></span>
    </li>
    <?php } ?>

    <?php if ($cartSummary['cartVolumeDiscount']) { ?>
    <li class="cart-summary-item">
        <span class="label"><?php echo Labels::getLabel('LBL_Volume_Discount', $siteLangId); ?></span>
        <span class="value txt-success"> -
            <?php echo CommonHelper::displayMoneyFormat($cartSummary['cartVolumeDiscount']); ?></span>
    </li>
    <?php } ?>
    <?php if ($cartSummary['cartDurationDiscount']) { ?>
    <li class="cart-summary-item">
        <span class="label"><?php echo Labels::getLabel('LBL_Duration_Discount', $siteLangId); ?></span>
        <span class="value txt-success"> -
            <?php echo CommonHelper::displayMoneyFormat($cartSummary['cartDurationDiscount']); ?></span>
    </li>
    <?php } ?>
    <?php if (FatApp::getConfig('CONF_TAX_AFTER_DISOCUNT', FatUtility::VAR_INT, 0) && !empty($cartSummary['cartDiscounts'])) { ?>
    <li class="cart-summary-item">
        <span class="label"><?php echo Labels::getLabel('LBL_Discount', $siteLangId); ?></span>
        <span class="value"> -
            <?php echo CommonHelper::displayMoneyFormat($cartSummary['cartDiscounts']['coupon_discount_total']); ?></span>
    </li>
    <?php } ?>

    <?php if (!FatApp::getConfig('CONF_TAX_AFTER_DISOCUNT', FatUtility::VAR_INT, 0) && !empty($cartSummary['cartDiscounts'])) { ?>
    <li class="cart-summary-item">
        <span class="label"><?php echo Labels::getLabel('LBL_Discount', $siteLangId); ?></span>
        <span class="value txt-success"> -
            <?php echo CommonHelper::displayMoneyFormat($cartSummary['cartDiscounts']['coupon_discount_total']); ?></span>
    </li>
    <?php } ?>
    <?php
    $netChargeAmt = $cartSummary['cartTotal'] + $cartSummary['addonTotalAmount'] + $cartSummary['rentalSecurityTotal'] - ((0 < $cartSummary['cartVolumeDiscount']) ? $cartSummary['cartVolumeDiscount'] : 0) - ((0 < $cartSummary['cartDurationDiscount']) ? $cartSummary['cartDurationDiscount'] : 0);
    $netChargeAmt = $netChargeAmt - ((isset($cartSummary['cartDiscounts']['coupon_discount_total']) && 0 < $cartSummary['cartDiscounts']['coupon_discount_total']) ? $cartSummary['cartDiscounts']['coupon_discount_total'] : 0);
    ?>
    <li class="cart-summary-item hightlighted">
        <span class="label"><?php echo Labels::getLabel('LBL_Net_Payable', $siteLangId); ?></span>
        <span class="value"><?php echo CommonHelper::displayMoneyFormat($netChargeAmt); ?></span>
    </li>
</ul>
<?php
if (FatApp::getConfig("CONF_PRODUCT_INCLUSIVE_TAX", FatUtility::VAR_INT, 0) && (!empty($cartSummary['cartVolumeDiscount']) || !empty($cartSummary['cartDiscounts']))) { ?>
<div class="">
    <?php echo Labels::getLabel('LBL_Note:_Discounts_may_vary_on_the_checkout_page_based_on_tax_and_shipping', $siteLangId); ?>
</div>
<?php } ?>
<input type="hidden" name="pickup_product_count" value="<?php echo $cartSummary['pickUpProductsCount']; ?>" />
<input type="hidden" name="ship_product_count" value="<?php echo $cartSummary['shipProductsCount']; ?>" />
</div>
<?php if (CommonHelper::getCurrencyId() != FatApp::getConfig('CONF_CURRENCY', FatUtility::VAR_INT, 1)) { ?>
<p class="included"><?php echo CommonHelper::currencyDisclaimer($siteLangId, $cartSummary['orderNetAmount']-$cartSummary['cartTaxTotal']); ?> </p>
<?php } ?>

<?php /* if($fulfilmentType == Shipping::FULFILMENT_SHIP && $cartItemCount > $cartSummary['shipProductsCount']) { ?>
<p class="included pt-0 pb-0 text-danger">
    <?php echo Labels::getLabel('LBL_Ship_item_not_available_msg', $siteLangId); ?></p>
<?php } elseif($fulfilmentType == Shipping::FULFILMENT_PICKUP && $cartItemCount > $cartSummary['pickUpProductsCount']) { ?>
<p class="included pt-0 pb-0 text-danger">
    <?php echo Labels::getLabel('LBL_Pickup_item_not_available_msg', $siteLangId); ?></p>
<?php } */ ?>


<div class="checkout-bottom ">
    <div class="amount">
        <strong><?php echo CommonHelper::displayMoneyFormat($netChargeAmt); ?></strong>
        <button class="link-underline" type="button" onclick="scrollToPriceSummary();">
            <?php echo Labels::getLabel('LBL_Summary', $siteLangId); ?> </button>
    </div>
    <div class="further-actions">
        <button class="btn btn-brand btn-wide checkout-btn--js" type="button" onclick="goToCheckout()">
            <?php echo Labels::getLabel('LBL_Checkout', $siteLangId); ?> </button>
    </div>
</div>