$(document).ready(function () {
  $(document).on(
    "click",
    "ul.linksvertical li a.redirect--js",
    function (event) {
      event.stopPropagation();
    }
  );
});
(function () {
  updatePayment = function (frm) {
    if (!$(frm).validate()) return;
    var data = fcom.frmData(frm);
    fcom.updateWithAjax(
      fcom.makeUrl("Buyer", "updatePayment"),
      data,
      function (t) {
        setTimeout(function () {
          location.reload(true);
        }, 2000);
      }
    );
  };
  
  extendRentalOrderForm = function (opId, saveCommentData = 0, frm = "") {
    var formData = "";
    if (frm != "") {
      var formData = $(frm).serialize();
    }

    /* $.facebox(function () { */
    fcom.ajax(
      fcom.makeUrl("Buyer", "extendOrderForm", [opId, saveCommentData]),
      formData,
      function (res) { 
        /* $.facebox(res, 'medium-fb-width'); */
        $("#exampleModal").html(res);
        $("#exampleModal").modal("show");
      }
    );
    /* }); */
  };

  updateOrderStatus = function (frm) {
    fcom.addTrailingSlash();
    if (!$(frm).validate()) return;

    var selectedOrderStatus = $('select[name="op_status_id"]').val();
    if (selectedOrderStatus == RENTAL_RETURN_STATUS_ID) {
      var opId = $("input[name='op_id']").val();
      var orderQty = Number($("input[name='op_qty']").val());
      var returnQty = Number($("input[name='return_qty']").val());
      if (returnQty < orderQty) {
        extendRentalOrderForm(opId, 1, frm);
        return;
      }
    }
    if (
      $('select[name="op_return_fullfillment_type"]').val() == FULLFILLMENT_SHIP
    ) {
      $(".dropfld input").val("");
    }

    $.mbsmessage(langLbl.processing, true, "alert--process alert");
    $('input[name="btn_submit"]').attr("disabled", "disabled");
    $.ajax({
      url: fcom.makeUrl("Buyer", "updateOrderStatus"),
      type: "post",
      dataType: "json",
      data: new FormData($(frm)[0]),
      cache: false,
      contentType: false,
      processData: false,

      success: function (ans) {
        if (ans.status == true) {
          $.mbsmessage(ans.msg, true, "alert--success");
          setTimeout(function () {
            location.reload(true);
          }, 2000);
        } else {
          $('input[name="btn_submit"]').removeAttr("disabled");
          $.mbsmessage(ans.msg, true, "alert--danger");
        }
      },
      error: function (xhr, ajaxOptions, thrownError) {
        alert(
          thrownError + "\r\n" + xhr.statusText + "\r\n" + xhr.responseText
        );
      },
    });
  };

  uploadCommentFormFile = function () {
    var frm = "form[name='frmOrderComments']";
    var formData = new FormData($(frm)[0]);
    var $i = $(frm + "  .commentFileJs");
    var inputBtn = $i[0];
    if (inputBtn.files && inputBtn.files[0]) {
      $.mbsmessage(langLbl.processing, false, "alert--process alert");
      $.ajax({
        url: fcom.makeUrl("Buyer", "uploadCommentFileTemp"),
        type: "post",
        data: formData,
        mimeType: "multipart/form-data",
        cache: false,
        contentType: false,
        processData: false,
        success: function (t) {
          var fileName = inputBtn.files[0].name;
          $(".commentFileJs").val("");
          var ans = $.parseJSON(t);
          if (ans.status == true) {
            $.mbsmessage(ans.msg, true, "alert--success");
            let imageHtml = "";
            if (ans.isImage) {
              imageHtml =
                '<a target="_blank" href="' +
                fcom.makeUrl("image", "buyerAttachedFile", [
                  "ORIGINAL",
                  ans.fileId,
                ]) +
                '"><img src="' +
                fcom.makeUrl("image", "buyerAttachedFile", [
                  "THUMB",
                  ans.fileId,
                ]) +
                '" alt="Shop Banner"></a>';
            } else {
              imageHtml = `<svg class='svg' width='64' height='64'>
              <use xlink:href='${fcom.makeUrl()}images/retina/sprite.svg#ri-file-text-line'></use></svg>`;
            }
            $.mbsmessage(ans.msg, true, "alert--success");
            var fileHtml =
              '<li class="uploaded-media-item fileJs--' +
              ans.fileId +
              '"><div class="uploaded-file">' +
              '<div class="uploaded-file-thumb ">' +
              imageHtml +
              '<button class="file-remove btn-close text-reset" type="button" onClick="removeTempFile(' +
              ans.fileId +
              ')"></button></div>' +
              '<div class="uploaded-media-tags">' +
              fileName +
              "</div></div></li>";
            $(".uploadedFilesJs").append(fileHtml);
          } else {
            $.mbsmessage(ans.msg, true, "alert--danger");
          }
        },
        error: function (xhr, ajaxOptions, thrownError) {
          alert(
            thrownError + "\r\n" + xhr.statusText + "\r\n" + xhr.responseText
          );
        },
      });
    }
  };

  removeTempFile = function (fileId = 0) {
    if (!confirm(langLbl.confirmDelete)) {
      return;
    }
    fcom.updateWithAjax(
      fcom.makeUrl("Buyer", "removeTempFile", [fileId]),
      "",
      function (t) {
        $(".uploadedFilesJs .fileJs--" + fileId).remove();
      }
    );
  };

  payOrderProductReqForm = function (order_id,op_id) {
    var data = 'order_id=' + order_id+'&op_id='+op_id;
    fcom.ajax(fcom.makeUrl("Account", "payOrderProductReqForm"), data, function (t) {
      if (isJson(t)) {
        var ans = $.parseJSON(t);
        //location.href = decodeURIComponent(ans.redirectUrl);
        $.mbsmessage(ans.msg, true, "alert--danger");
    } else {
        $("#exampleModal").html(t);
        $("#exampleModal").modal("show");
    }
    
    });
  };
  setUpOrderPayment = function (frm) {
    if (!$(frm).validate()) return;
    var data = fcom.frmData(frm);
    fcom.updateWithAjax(
      fcom.makeUrl("Account", "setUpOrderPayment"),
      data,
      function (t) {
        if (t.redirectUrl) {
          window.location = t.redirectUrl;
        }
      }
    );
  };

  setUpOrderPaymentRequest = function (id) {
    if(typeof id == 'undefined' || id == ''){
      return false;
    }
    var data= 'id='+id;
    fcom.updateWithAjax(
      fcom.makeUrl("Account", "setUpOrderPayment"),
      data,
      function (t) {
        if (t.redirectUrl) {
          window.location = t.redirectUrl;
        }
      }
    );
  };

})();
