<?php
defined('SYSTEM_INIT') or die('Invalid Usage.');
$this->includeTemplate('_partial/buyerDashboardNavigation.php');
?>
<main id="main-area" class="main">
    <div class="content content-wrapper">
        <div class="content-header">
            <div class="content-header-title">
                <?php $this->includeTemplate('_partial/dashboardTop.php'); ?>
                <h2 class="content-header-heading">
                    <?php echo Labels::getLabel('LBL_Dashboard', $siteLangId); ?>
                </h2>
            </div>
            <div class="content-header-toolbar">
                <div class="links-inline">
                    <a class="btn btn-outline-gray qwer"
                        href="<?php echo UrlHelper::generateUrl('Account', 'wishlist'); ?>">
                        <svg class="svg" width="16" height="16">
                            <use
                                xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite.svg#favorites">
                            </use>
                        </svg>
                        <?php echo Labels::getLabel('LBL_Favorites', $siteLangId); ?>
                    </a>
                    <a class="btn btn-outline-gray qwer"
                        href="<?php echo UrlHelper::generateUrl('Account', 'myAddresses'); ?>">
                        <svg class="svg" width="16" height="16">
                            <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite.svg#address">
                            </use>
                        </svg>
                        <?php echo Labels::getLabel('LBL_Manage_Addresses', $siteLangId); ?>
                    </a>
                </div>
            </div>
        </div>
        <div class="content-body">
            <div class="js-widget-scroll widget-scroll">
                <div class="widget widget-stats">
                    <div class="card">
                        <div class="card-head">
                            <a class="card-title" href="<?php echo UrlHelper::generateUrl('account', 'credits'); ?>">
                                <?php echo Labels::getLabel('LBL_Credits', $siteLangId); ?>
                            </a>
                            <i class="icn">
                                <svg class="svg" width="16" height="16">
                                    <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#credits">
                                    </use>
                                </svg>
                            </i>
                        </div>
                        <div class="card-body">
                            <div class="stats">
                                <ul class="stats-number">
                                    <li class="stats-number-item">
                                        <span class="total">
                                            <?php echo Labels::getLabel('LBL_Total_Credits', $siteLangId); ?>
                                        </span>
                                        <span class="total-numbers">
                                            <?php echo CommonHelper::displayMoneyFormat($userBalance); ?>
                                        </span>
                                    </li>
                                    <li class="stats-number-item">
                                        <span class="total">
                                            <?php echo Labels::getLabel('LBL_Credits_earned_today', $siteLangId); ?>
                                        </span>
                                        <span class="total-numbers">
                                            <?php echo CommonHelper::displayMoneyFormat($txnsSummary['total_earned']); ?>
                                        </span>
                                    </li>
                                </ul>

                            </div>
                        </div>

                    </div>
                </div>
                <div class="widget widget-stats">
                    <div class="card ">
                        <div class="card-head">
                            <a class="card-title" href="<?php echo UrlHelper::generateUrl('buyer', 'rentalOrders'); ?>">
                                <?php echo Labels::getLabel('LBL_Rental_Orders', $siteLangId); ?>
                            </a>
                            <i class="icn">
                                <svg class="svg">
                                    <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#order">
                                    </use>
                                </svg>
                            </i>
                        </div>
                        <div class="card-body">
                            <div class="stats">
                                <ul class="stats-number">
                                    <li class="stats-number-item">
                                        <a class="stats-number-btn"
                                            href="<?php echo UrlHelper::generateUrl('buyer', 'rentalOrders'); ?>">
                                            <span class="total">
                                                <?php echo Labels::getLabel('LBL_Total_Orders', $siteLangId); ?>
                                            </span>
                                            <span class="total-numbers">
                                                <?php echo $rentalOrdersCount; ?>
                                            </span>
                                        </a>
                                    </li>
                                    <li class="stats-number-item">
                                        <a class="stats-number-btn"
                                            onClick="redirectOrderfunc('<?php echo UrlHelper::generateUrl('buyer', 'rentalOrders'); ?>', <?php echo Stats::INPROCESS_SALES; ?>);event.stopPropagation();"
                                            href="javaScript:void(0)" class="stats-list">
                                            <span class="total">
                                                <?php echo Labels::getLabel('LBL_Pending_Orders', $siteLangId); ?>
                                            </span>
                                            <span class="total-numbers">
                                                <?php echo $pendingRentalOrderCount; ?>
                                            </span>
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
                <?php if (FatApp::getConfig("CONF_ALLOW_SALE", FatUtility::VAR_INT, 0)) { ?>
                    <div class="widget widget-stats">
                        <div class="card ">
                            <div class="card-head">
                                <a class="card-title" href="<?php echo UrlHelper::generateUrl('buyer', 'orders'); ?>">
                                    <?php echo Labels::getLabel('LBL_Sale_Orders', $siteLangId); ?>
                                </a>
                                <i class="icn">
                                    <svg class="svg">
                                        <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#order">
                                        </use>
                                    </svg>
                                </i>
                            </div>
                            <div class="card-body">
                                <div class="stats">
                                    <ul class="stats-number">
                                        <li class="stats-number-item">
                                            <a class="stats-number-btn"
                                                href="<?php echo UrlHelper::generateUrl('buyer', 'orders'); ?>"
                                                class="stats-list">
                                                <span class="total">
                                                    <?php echo Labels::getLabel('LBL_Total_Orders', $siteLangId); ?>
                                                </span>
                                                <span class="total-numbers">
                                                    <?php echo $ordersCount; ?>
                                                </span>
                                            </a>
                                        </li>
                                        <li class="stats-number-item">
                                            <a class="stats-number-btn"
                                                onClick="redirectOrderfunc('<?php echo UrlHelper::generateUrl('buyer', 'orders'); ?>', <?php echo Stats::INPROCESS_SALES; ?>);event.stopPropagation();"
                                                href="javaScript:void(0)" class="stats-list">
                                                <span class="total">
                                                    <?php echo Labels::getLabel('LBL_Pending_Orders', $siteLangId); ?>
                                                </span>
                                                <span class="total-numbers">
                                                    <?php echo $pendingOrderCount; ?>
                                                </span>
                                            </a>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php } ?>
                <div class="widget widget-stats">
                    <div class="card">
                        <div class="card-head">
                            <a class="card-title" href="<?php echo UrlHelper::generateUrl('buyer', 'rewardPoints'); ?>">
                                <?php echo Labels::getLabel('LBL_Reward_Points', $siteLangId); ?>
                            </a>
                            <i class="icn">
                                <svg class="svg" width="16" height="16">
                                    <use
                                        xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#rewards-change">
                                    </use>
                                </svg>
                            </i>
                        </div>
                        <div class="card-body">
                            <div class="stats">
                                <ul class="stats-number">
                                    <li class="stats-number-item">
                                        <span class="total">
                                            <?php echo Labels::getLabel('LBL_Current_Reward_Points', $siteLangId); ?>
                                        </span>
                                        <span class="total-numbers">
                                            <?php echo $totalRewardPoints; ?>
                                        </span>
                                    </li>
                                    <li class="stats-number-item">
                                        <span class="total">
                                            <?php echo Labels::getLabel('LBL_Currency_Value', $siteLangId); ?>
                                        </span>
                                        <span class="total-numbers">
                                            <?php echo CommonHelper::displayMoneyFormat(CommonHelper::convertRewardPointToCurrency($totalRewardPoints)); ?>
                                        </span>
                                    </li>
                                </ul>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-6  mb-4">
                    <div class="card">
                        <div class="card-head">
                            <h5 class="card-title">
                                <?php echo Labels::getLabel('LBL_Latest_Rental_Orders', $siteLangId); ?>
                            </h5>
                            <div class="action">
                                <?php if (count($orders) > 0) { ?>
                                    <a href="<?php echo UrlHelper::generateUrl('buyer', 'rentalOrders'); ?>"
                                        class="link-underline">
                                        <?php echo Labels::getLabel('Lbl_View_All', $siteLangId); ?>
                                    </a>
                                <?php } ?>
                            </div>
                        </div>
                        <div class="card-table">
                            <div class="scroll scroll-x js-scrollable table-wrap">
                                <table class="table table-justified">
                                    <thead>
                                        <tr class="">
                                            <th width="70%">
                                                <?php echo Labels::getLabel('LBL_Order_Particulars', $siteLangId); ?>
                                            </th>
                                            <th width="20%">
                                                <?php echo Labels::getLabel('LBL_Payment_Info', $siteLangId); ?>
                                            </th>
                                            <th width="10%"></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                        if (count($renralOrders) > 0) {
                                            $canCancelOrder = true;
                                            $canReturnRefund = true;
                                            foreach ($renralOrders as $orderId => $row) {
                                                $orderDetailUrl = UrlHelper::generateUrl('Buyer', 'viewOrder', array($row['order_id'], $row['op_id']));

                                                $canCancelOrder = (in_array($row["op_status_id"], (array) Orders::getBuyerAllowedOrderCancellationStatuses()));
                                                $canReturnRefund = (in_array($row["op_status_id"], (array) Orders::getBuyerAllowedOrderReturnStatuses()));


                                                $isValidForReview = false;
                                                if (in_array($row["op_status_id"], SelProdReview::getBuyerAllowedOrderReviewStatuses())) {
                                                    $isValidForReview = true;
                                                }
                                                $canSubmitFeedback = Orders::canSubmitFeedback($row['order_user_id'], $row['order_id'], $row['op_selprod_id']);

                                                if (!FatApp::getConfig('CONF_ALLOW_RENTAL_ORDER_CANCEL_FROM_BUYER_END', FatUtility::VAR_INT, 0)) {
                                                    $canCancelOrder = false;
                                                }
                                                ?>
                                                <tr>
                                                    <td>
                                                        <div class="product-profile">
                                                            <?php
                                                            $prodOrBatchUrl = '';
                                                            if ($row['op_is_batch']) {
                                                                $prodOrBatchUrl = UrlHelper::generateUrl('Products', 'batch', array($row['op_selprod_id']));
                                                                $prodOrBatchImgUrl = UrlHelper::getCachedUrl(UrlHelper::generateUrl('image', 'BatchProduct', array($row['op_selprod_id'], $siteLangId, "SMALL"), CONF_WEBROOT_URL), CONF_IMG_CACHE_TIME, '.jpg');
                                                            } else {
                                                                if (Product::verifyProductIsValid($row['op_selprod_id']) == true) {
                                                                    $prodOrBatchUrl = UrlHelper::generateUrl('Products', 'view', array($row['op_selprod_id']));
                                                                }
                                                                $prodOrBatchImgUrl = UrlHelper::getCachedUrl(UrlHelper::generateUrl('image', 'product', array($row['selprod_product_id'], "SMALL", $row['op_selprod_id'], 0, $siteLangId), CONF_WEBROOT_URL), CONF_IMG_CACHE_TIME, '.jpg');

                                                                if ($row['opd_product_type'] == SellerProduct::PRODUCT_TYPE_ADDON) {
                                                                    $prodOrBatchImgUrl = UrlHelper::getCachedUrl(UrlHelper::generateFileUrl('image', 'addonProduct', array($row['op_selprod_id'], "THUMB", 0, $siteLangId), CONF_WEBROOT_URL), CONF_IMG_CACHE_TIME, '.jpg');
                                                                }
                                                            }
                                                            ?>

                                                            <a class="product-profile-thumbnail" <?php echo HtmlHelper::profileImgAttr(); ?>
                                                                href="<?php echo !empty($prodOrBatchUrl) ? $prodOrBatchUrl : 'javascript:void(0)'; ?>">
                                                                <img src="<?php echo $prodOrBatchImgUrl; ?>"
                                                                    title="<?php echo $row['op_product_name']; ?>"
                                                                    alt="<?php echo $row['op_product_name']; ?>"></a>


                                                            <div class="product-profile-data">
                                                                <date class="date">
                                                                    <?php echo FatDate::format($row['order_date_added']); ?>
                                                                </date>
                                                                <div class="product-profile-title">
                                                                    <?php
                                                                    $prodName = '';
                                                                    if ($row['op_selprod_title'] != '') {
                                                                        $prodName .= $row['op_selprod_title'] . '<br/>';
                                                                    } else {
                                                                        $prodName .= $row['op_product_name'];
                                                                    }

                                                                    ?> <a
                                                                        title="<?php echo $row['op_product_name']; ?>"
                                                                        href="<?php echo !empty($prodOrBatchUrl) ? $prodOrBatchUrl : 'javascript:void(0)'; ?>">
                                                                        <?php echo $prodName; ?>
                                                                    </a>
                                                                </div>

                                                                <?php if ($row['op_selprod_options'] != '') { ?>
                                                                    <div class="item__specification">
                                                                        <?php echo $row['op_selprod_options']; ?>
                                                                    </div>
                                                                <?php } ?>
                                                                <?php
                                                                if ($row['totOrders'] > 1) {
                                                                    echo Labels::getLabel('LBL_Part_combined_order', $siteLangId) . ' <a title="' . Labels::getLabel('LBL_View_Order_Detail', $siteLangId) . '" href="' . UrlHelper::generateUrl('Buyer', 'viewOrder', array($row['order_id'])) . '">' . $row['order_id'] . '</a>';
                                                                }
                                                                ?>
                                                            </div>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <div class="item__specification">
                                                            <span class="item__price">
                                                                <?php echo CommonHelper::displayMoneyFormat(CommonHelper::orderProductAmount($row) + $row['addon_amount']); ?>
                                                            </span>
                                                            <br>
                                                            <span
                                                                class="badge badge-inline <?php echo $classArr[$row['orderstatus_color_class']]; ?>">
                                                                <?php
                                                                echo $row['orderstatus_name'];
                                                                ?>
                                                            </span>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <ul class="actions">
                                                            <li class="actions-item">
                                                                <a class="actions-link"
                                                                    title="<?php echo Labels::getLabel('LBL_View_Order', $siteLangId); ?>"
                                                                    href="<?php echo !empty($orderDetailUrl) ? $orderDetailUrl : 'javascript:void(0)'; ?>"><i
                                                                        class="fa fa-eye"></i></a>
                                                            </li>
                                                            <?php if ($canCancelOrder && $row['opd_product_type'] != SellerProduct::PRODUCT_TYPE_ADDON) { ?>
                                                                <li class="actions-item">
                                                                    <a class="actions-link"
                                                                        href="<?php echo UrlHelper::generateUrl('buyer', 'orderCancellationRequest', array($row['op_id'])); ?>"
                                                                        title="<?php echo Labels::getLabel('LBL_Cancel_Order', $siteLangId); ?>"><i
                                                                            class="fas fa-times"></i></a>
                                                                </li>
                                                            <?php } ?>
                                                            <?php if ($canSubmitFeedback && $isValidForReview && $row['opd_product_type'] != SellerProduct::PRODUCT_TYPE_ADDON) { ?>
                                                                <li class="actions-item">
                                                                    <a class="actions-link"
                                                                        href="<?php echo UrlHelper::generateUrl('Buyer', 'orderFeedback', array($row['op_id'])); ?>"
                                                                        title="<?php echo Labels::getLabel('LBL_Feedback', $siteLangId); ?>"><i
                                                                            class="fa fa-star"></i></a>
                                                                </li>
                                                            <?php } ?>
                                                            <?php if ($canReturnRefund && $row['opd_sold_or_rented'] == applicationConstants::PRODUCT_FOR_SALE && $row['opd_product_type'] != SellerProduct::PRODUCT_TYPE_ADDON) { ?>
                                                                <li class="actions-item">
                                                                    <a class="actions-link"
                                                                        href="<?php echo UrlHelper::generateUrl('Buyer', 'orderReturnRequest', array($row['op_id'])); ?>"
                                                                        title="<?php echo Labels::getLabel('LBL_Refund', $siteLangId); ?>"><i
                                                                            class="fas fa-dollar-sign"></i></a>
                                                                </li>
                                                            <?php } ?>
                                                        </ul>
                                                    </td>
                                                </tr>
                                                <?php
                                            }
                                        } else {
                                            ?>
                                            <tr>
                                                <td colspan="4">
                                                    <?php $this->includeTemplate('_partial/no-record-found.php', array('siteLangId' => $siteLangId), false); ?>
                                                </td>
                                            </tr>
                                        <?php } ?>
                                    </tbody>

                                </table>
                            </div>
                        </div>
                    </div>
                </div>


                <?php if (FatApp::getConfig("CONF_ALLOW_SALE", FatUtility::VAR_INT, 0)) { ?>
                    <div class="col-lg-6  mb-4">
                        <div class="card">
                            <div class="card-head">
                                <h5 class="card-title">
                                    <?php echo Labels::getLabel('LBL_Latest_Sale_Orders', $siteLangId); ?>
                                </h5>
                                <div class="action">
                                    <?php if (count($orders) > 0) { ?>
                                        <a href="<?php echo UrlHelper::generateUrl('buyer', 'orders'); ?>"
                                            class="link-underline">
                                            <?php echo Labels::getLabel('Lbl_View_All', $siteLangId); ?>
                                        </a>
                                    <?php } ?>
                                </div>
                            </div>
                            <div class="card-table ">
                                <div class="scroll scroll-x js-scrollable table-wrap">
                                    <table class="table table-justified">
                                        <thead>
                                            <tr class="">
                                                <th width="70%">
                                                    <?php echo Labels::getLabel('LBL_Order_Particulars', $siteLangId); ?>
                                                </th>
                                                <th width="20%">
                                                    <?php echo Labels::getLabel('LBL_Payment_Info', $siteLangId); ?>
                                                </th>
                                                <th width="10%"></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php
                                            if (count($orders) > 0) {
                                                $canCancelOrder = true;
                                                $canReturnRefund = true;
                                                foreach ($orders as $orderId => $row) {
                                                    $orderDetailUrl = UrlHelper::generateUrl('Buyer', 'viewOrder', array($row['order_id'], $row['op_id']));
                                                    $canCancelOrder = (in_array($row["op_status_id"], (array) Orders::getBuyerAllowedOrderCancellationStatuses()));
                                                    $canReturnRefund = (in_array($row["op_status_id"], (array) Orders::getBuyerAllowedOrderReturnStatuses()));
                                                    $datediff = time() - strtotime($row['order_date_added']);

                                                    if ($row['opd_sold_or_rented'] == applicationConstants::ORDER_TYPE_RENT) {
                                                        $daysSpent = ceil($datediff / (60 * 60)); // Cancel and Return Age in Hours
                                                    } else {
                                                        $daysSpent = round($datediff / (60 * 60 * 24)); // Cancel and Return Age in Days
                                                    }

                                                    if (empty($row['cancellation_age']) || $row['cancellation_age'] < $daysSpent) {
                                                        $canCancelOrder = false;
                                                    }
                                                    if ($row['return_age'] < $daysSpent) {
                                                        $canReturnRefund = false;
                                                    }

                                                    $isValidForReview = false;
                                                    if (in_array($row["op_status_id"], SelProdReview::getBuyerAllowedOrderReviewStatuses())) {
                                                        $isValidForReview = true;
                                                    }
                                                    $canSubmitFeedback = Orders::canSubmitFeedback($row['order_user_id'], $row['order_id'], $row['op_selprod_id']);

                                                    if (!FatApp::getConfig('CONF_ALLOW_RENTAL_ORDER_CANCEL_FROM_BUYER_END', FatUtility::VAR_INT, 0)) {
                                                        $canCancelOrder = false;
                                                    }
                                                    ?>
                                                    <tr>
                                                        <td>
                                                            <div class="product-profile">
                                                                <?php
                                                                $prodOrBatchUrl = '';
                                                                if ($row['op_is_batch']) {
                                                                    $prodOrBatchUrl = UrlHelper::generateUrl('Products', 'batch', array($row['op_selprod_id']));
                                                                    $prodOrBatchImgUrl = UrlHelper::getCachedUrl(UrlHelper::generateUrl('image', 'BatchProduct', array($row['op_selprod_id'], $siteLangId, "SMALL"), CONF_WEBROOT_URL), CONF_IMG_CACHE_TIME, '.jpg');
                                                                } else {
                                                                    if (Product::verifyProductIsValid($row['op_selprod_id']) == true) {
                                                                        $prodOrBatchUrl = UrlHelper::generateUrl('Products', 'view', array($row['op_selprod_id']));
                                                                    }
                                                                    $prodOrBatchImgUrl = UrlHelper::getCachedUrl(UrlHelper::generateUrl('image', 'product', array($row['selprod_product_id'], "SMALL", $row['op_selprod_id'], 0, $siteLangId), CONF_WEBROOT_URL), CONF_IMG_CACHE_TIME, '.jpg');

                                                                    if ($row['opd_product_type'] == SellerProduct::PRODUCT_TYPE_ADDON) {
                                                                        $prodOrBatchImgUrl = UrlHelper::getCachedUrl(UrlHelper::generateFileUrl('image', 'addonProduct', array($row['op_selprod_id'], "THUMB", 0, $siteLangId), CONF_WEBROOT_URL), CONF_IMG_CACHE_TIME, '.jpg');
                                                                    }
                                                                }
                                                                ?>
                                                                <a class="product-profile-thumbnail" <?php echo HtmlHelper::profileImgAttr(); ?> 
                                                                    href="<?php echo !empty($prodOrBatchUrl) ? $prodOrBatchUrl : 'javascript:void(0)'; ?>"><img
                                                                        src="<?php echo $prodOrBatchImgUrl; ?>"
                                                                        title="<?php echo $row['op_product_name']; ?>"
                                                                        alt="<?php echo $row['op_product_name']; ?>"></a>


                                                                <div class="product-profile-data">
                                                                    <date class="date">
                                                                        <?php echo FatDate::format($row['order_date_added']); ?>
                                                                    </date>
                                                                    <div class="product-profile-title">
                                                                        <?php
                                                                        $prodName = '';
                                                                        if ($row['op_selprod_title'] != '') {
                                                                            $prodName .= $row['op_selprod_title'] . '<br/>';
                                                                        } else {
                                                                            $prodName .= $row['op_product_name'];
                                                                        }

                                                                        ?> <a
                                                                            title="<?php echo $row['op_product_name']; ?>"
                                                                            href="<?php echo !empty($prodOrBatchUrl) ? $prodOrBatchUrl : 'javascript:void(0)'; ?>">
                                                                            <?php echo $prodName; ?>
                                                                        </a>
                                                                    </div>
                                                                    <!-- <div class="product-profile-brand"><span><?php /* echo Labels::getLabel('Lbl_Brand', $siteLangId)?>:</span> <?php echo CommonHelper::displayNotApplicable($siteLangId, $row['op_brand_name']); */ ?></div> -->
                                                                    <?php if ($row['op_selprod_options'] != '') { ?>
                                                                        <div class="item__specification">
                                                                            <?php echo $row['op_selprod_options']; ?>
                                                                        </div>
                                                                    <?php } ?>
                                                                    <?php
                                                                    if ($row['totOrders'] > 1) {
                                                                        echo Labels::getLabel('LBL_Part_combined_order', $siteLangId) . ' <a class="fsdsdf" title="' . Labels::getLabel('LBL_View_Order_Detail', $siteLangId) . '" href="' . UrlHelper::generateUrl('Buyer', 'viewOrder', array($row['order_id'])) . '">' . $row['order_id'] . '</a>';
                                                                    }
                                                                    ?>
                                                                </div>
                                                            </div>
                                                        </td>
                                                        <td>
                                                            <div class="item__specification">
                                                                <span class="item__price">
                                                                    <?php echo CommonHelper::displayMoneyFormat(CommonHelper::orderProductAmount($row)); ?>
                                                                </span>
                                                                <br>
                                                                <span
                                                                    class="badge badge-inline <?php echo $classArr[$row['orderstatus_color_class']]; ?>">
                                                                    <?php
                                                                    echo $row['orderstatus_name'];
                                                                    ?>
                                                                </span>
                                                            </div>
                                                        </td>
                                                        <td>
                                                            <ul class="actions">
                                                                <li class="actions-item">
                                                                    <a class="actions-link"
                                                                        title="<?php echo Labels::getLabel('LBL_View_Order', $siteLangId); ?>"
                                                                        href="<?php echo !empty($orderDetailUrl) ? $orderDetailUrl : 'javascript:void(0)'; ?>"><i
                                                                            class="fa fa-eye"></i></a>
                                                                </li>
                                                                <?php if ($canCancelOrder && $row['opd_product_type'] != SellerProduct::PRODUCT_TYPE_ADDON) { ?>
                                                                    <li class="actions-item">
                                                                        <a class="actions-link"
                                                                            href="<?php echo UrlHelper::generateUrl('buyer', 'orderCancellationRequest', array($row['op_id'])); ?>"
                                                                            title="<?php echo Labels::getLabel('LBL_Cancel_Order', $siteLangId); ?>"><i
                                                                                class="fas fa-times"></i></a>
                                                                    </li>
                                                                <?php } ?>
                                                                <?php if ($canSubmitFeedback && $isValidForReview && $row['opd_product_type'] != SellerProduct::PRODUCT_TYPE_ADDON) { ?>
                                                                    <li class="actions-item">
                                                                        <a class="actions-link"
                                                                            href="<?php echo UrlHelper::generateUrl('Buyer', 'orderFeedback', array($row['op_id'])); ?>"
                                                                            title="<?php echo Labels::getLabel('LBL_Feedback', $siteLangId); ?>"><i
                                                                                class="fa fa-star"></i></a>
                                                                    </li>
                                                                <?php } ?>
                                                                <?php if ($canReturnRefund && $row['opd_sold_or_rented'] == applicationConstants::PRODUCT_FOR_SALE && $row['opd_product_type'] != SellerProduct::PRODUCT_TYPE_ADDON) { ?>
                                                                    <li class="actions-item">
                                                                        <a class="actions-link"
                                                                            href="<?php echo UrlHelper::generateUrl('Buyer', 'orderReturnRequest', array($row['op_id'])); ?>"
                                                                            title="<?php echo Labels::getLabel('LBL_Refund', $siteLangId); ?>"><i
                                                                                class="fas fa-dollar-sign"></i></a>
                                                                    </li>
                                                                <?php } ?>
                                                            </ul>
                                                        </td>
                                                    </tr>
                                                    <?php
                                                }
                                            } else {
                                                ?>
                                                <tr>
                                                    <td colspan="4">
                                                        <?php $this->includeTemplate('_partial/no-record-found.php', array('siteLangId' => $siteLangId), false); ?>
                                                    </td>
                                                </tr>
                                            <?php } ?>
                                        </tbody>

                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php }
                $class = (FatApp::getConfig("CONF_ALLOW_SALE", FatUtility::VAR_INT, 0)) ? '12' : '6'; ?>
                <div class="col-lg-<?php echo $class; ?>  mb-4">
                    <div class="card">
                        <div class="card-head">
                            <h5 class="card-title ">
                                <?php echo Labels::getLabel('LBL_Latest_Offers', $siteLangId); ?>
                            </h5>
                            <div class="action">
                                <?php if (count($offers) > 0) { ?> <a
                                        href="<?php echo UrlHelper::generateUrl('buyer', 'offers'); ?>"
                                        class="link-underline">
                                        <?php echo Labels::getLabel('Lbl_View_All', $siteLangId); ?>
                                    </a>
                                <?php } ?>
                            </div>
                        </div>
                        <div class="card-table">
                            <div class="scroll scroll-x js-scrollable table-wrap">
                                <table class="table">
                                    <thead>
                                        <tr class="">
                                            <th colspan="2" width="60%">
                                                <?php echo Labels::getLabel('LBL_Offer_Particulars', $siteLangId); ?>
                                            </th>
                                            <th width="20%">
                                                <?php echo Labels::getLabel('LBL_Expires_On', $siteLangId); ?>
                                            </th>
                                            <th width="20%">
                                                <?php echo Labels::getLabel('LBL_Min_order', $siteLangId); ?>
                                            </th>
                                        </tr>
                                    </thead>
                                    <tbody>

                                        <?php
                                        if (count($offers) > 0) {
                                            foreach ($offers as $row) {
                                                $discountValue = ($row['coupon_discount_in_percent'] == ApplicationConstants::PERCENTAGE) ? $row['coupon_discount_value'] . ' %' : CommonHelper::displayMoneyFormat($row['coupon_discount_value']);
                                                ?>
                                                <tr>
                                                    <td>
                                                        <figure class="product-profile-thumbnail" <?php echo HtmlHelper::profileImgAttr(); ?>><img
                                                                src="<?php echo UrlHelper::generateFullUrl('Image', 'coupon', array($row['coupon_id'], $siteLangId, 'NORMAL')) ?>"
                                                                alt="<?php echo ($row['coupon_title'] == '') ? $row['coupon_identifier'] : $row['coupon_title']; ?>">
                                                        </figure>
                                                    </td>
                                                    <td>
                                                        <div class="product-profile-data">
                                                            <div class="product-profile-title">
                                                                <?php echo $discountValue; ?>
                                                                <?php echo Labels::getLabel('LBL_OFF', $siteLangId); ?>
                                                            </div>
                                                            <div class="product-profile-title">
                                                                <?php echo ($row['coupon_title'] == '') ? $row['coupon_identifier'] : $row['coupon_title']; ?>
                                                            </div>
                                                            <span class="coupon-code">
                                                                <?php echo $row['coupon_code']; ?>
                                                            </span>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <?php echo FatDate::format($row['coupon_end_date']); ?>
                                                    </td>
                                                    <td>
                                                        <?php echo CommonHelper::displayMoneyFormat($row['coupon_min_order_value']); ?>
                                                    </td>
                                                </tr>
                                                <?php
                                            }
                                        } else {
                                            ?>
                                            <tr>
                                                <td colspan="4">
                                                    <?php $this->includeTemplate('_partial/no-record-found.php', array('siteLangId' => $siteLangId), false); ?>
                                                </td>
                                            </tr>
                                        <?php } ?>
                                    </tbody>

                                </table>
                            </div>
                        </div>
                        <?php // $this->includeTemplate('_partial/userDashboardMessages.php');
                        ?>
                    </div>
                </div>
            </div>
            <?php if (FatApp::getConfig("CONF_ALLOW_SALE", FatUtility::VAR_INT, 0)) { ?>
                <div class="row ">
                    <div class="col-lg-6  mb-4">
                        <div class="card">
                            <div class="card-head">
                                <h5 class="card-title ">
                                    <?php echo Labels::getLabel('LBL_Return_requests', $siteLangId); ?>
                                </h5>
                                <?php if (count($returnRequests) > 0) { ?>
                                    <div class="action">
                                        <a href="<?php echo UrlHelper::generateUrl('buyer', 'orderReturnRequests'); ?>"
                                            class="link-underline">
                                            <?php echo Labels::getLabel('Lbl_View_All', $siteLangId); ?>
                                        </a>
                                    </div>
                                <?php } ?>
                            </div>
                            <div class="card-table ">
                                <div class="scroll scroll-x js-scrollable table-wrap">
                                    <table class="table table-justified">
                                        <thead>

                                            <tr class="">
                                                <th width="60%">
                                                    <?php echo Labels::getLabel('LBL_Order_Particulars', $siteLangId); ?>
                                                </th>
                                                <th width="10%">
                                                    <?php echo Labels::getLabel('LBL_Qty', $siteLangId); ?>
                                                </th>
                                                <th width="20%">
                                                    <?php echo Labels::getLabel('LBL_Status', $siteLangId); ?>
                                                </th>
                                                <?php
                                                if (count($returnRequests) > 0) {
                                                    ?>
                                                    <th width="10%"></th>
                                                <?php } ?>
                                            </tr>
                                        </thead>

                                        <tbody>
                                            <?php
                                            if (count($returnRequests) > 0) {
                                                foreach ($returnRequests as $row) {
                                                    $orderDetailUrl = UrlHelper::generateUrl('buyer', 'viewOrder', array($row['order_id'], $row['op_id']));
                                                    $prodOrBatchUrl = '';
                                                    if ($row['op_is_batch']) {
                                                        $prodOrBatchUrl = UrlHelper::generateUrl('Products', 'batch', array($row['op_selprod_id']));
                                                    } else {
                                                        if (Product::verifyProductIsValid($row['op_selprod_id']) == true) {
                                                            $prodOrBatchUrl = UrlHelper::generateUrl('Products', 'view', array($row['op_selprod_id']));
                                                        }
                                                    }
                                                    ?>
                                                    <tr>
                                                        <td>
                                                            <div class="product-profile-data">
                                                                <div class="request__date">
                                                                    <?php echo FatDate::format($row['orrequest_date']); ?>
                                                                </div>
                                                                <div class="product-profile-title">
                                                                    <a title="<?php echo Labels::getLabel('LBL_Invoice_number', $siteLangId); ?>"
                                                                        href="<?php echo UrlHelper::generateUrl('Buyer', 'viewOrder', array($row['order_id'], $row['op_id'])); ?>"
                                                                        href="<?php echo !empty($orderDetailUrl) ? $orderDetailUrl : 'javascript:void(0)'; ?>">
                                                                        <?php echo $row['op_invoice_number']; ?>
                                                                    </a>
                                                                </div>
                                                                <div class="product-profile-title">
                                                                    <?php if ($row['op_selprod_title'] != '') { ?> <a
                                                                            title="<?php echo $row['op_selprod_title']; ?>"
                                                                            href="<?php echo !empty($prodOrBatchUrl) ? $prodOrBatchUrl : 'javascript:void(0)'; ?>">
                                                                            <?php echo $row['op_selprod_title']; ?>
                                                                        </a>
                                                                    <?php } else { ?> <a
                                                                            title="<?php echo $row['op_product_name']; ?>"
                                                                            href="<?php echo !empty($prodOrBatchUrl) ? $prodOrBatchUrl : 'javascript:void(0)'; ?>">
                                                                            <?php echo $row['op_product_name']; ?>
                                                                        </a>
                                                                    <?php } ?>
                                                                </div>
                                                            </div>
                                                        </td>
                                                        <td>
                                                            <div class="request__qty">
                                                                <?php echo $row['orrequest_qty']; ?>
                                                            </div>
                                                        </td>
                                                        <td>
                                                            <span
                                                                class="badge badge-inline <?php echo $OrderRetReqStatusClassArr[$row['orrequest_status']]; ?>">
                                                                <?php echo $OrderReturnRequestStatusArr[$row['orrequest_status']]; ?>
                                                            </span>
                                                        </td>
                                                        <td>
                                                            <ul class="actions">
                                                                <li class="actions-item">
                                                                    <a class="actions-link"
                                                                        title="<?php echo Labels::getLabel('LBL_View_Request', $siteLangId); ?>"
                                                                        href="<?php echo UrlHelper::generateUrl('Buyer', 'ViewOrderReturnRequest', array($row['orrequest_id'])); ?>">
                                                                        <i class="fa fa-eye"></i>
                                                                    </a>
                                                                </li>
                                                            </ul>
                                                        </td>
                                                    </tr>
                                                    <?php
                                                }
                                            } else {
                                                ?>
                                                <tr>
                                                    <td colspan="4">
                                                        <?php $this->includeTemplate('_partial/no-record-found.php', array('siteLangId' => $siteLangId), false); ?>
                                                    </td>
                                                </tr>
                                            <?php } ?>
                                        </tbody>

                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-6  mb-4">
                        <!-- <div class="card">
                    <?php // $this->includeTemplate('_partial/userDashboardMessages.php');
                        ?>
                        </div> -->
                        <div class="card">
                            <div class="card-head">
                                <h5 class="card-title">
                                    <?php echo Labels::getLabel('LBL_Cancellation_requests', $siteLangId); ?>
                                </h5>
                                <?php if (count($cancellationRequests) > 0) { ?>
                                    <div class="action">
                                        <a href="<?php echo UrlHelper::generateUrl('buyer', 'orderCancellationRequests'); ?>"
                                            class="link-underline">
                                            <?php echo Labels::getLabel('Lbl_View_All', $siteLangId); ?>
                                        </a>
                                    </div>
                                <?php } ?>
                            </div>
                            <div class="card-table">
                                <div class="scroll scroll-x js-scrollable table-wrap">
                                    <table class="table table-justified">
                                        <thead>
                                            <tr class="">
                                                <th width="40%">
                                                    <?php echo Labels::getLabel('LBL_Order_Particulars', $siteLangId); ?>
                                                </th>
                                                <th width="50%">
                                                    <?php echo Labels::getLabel('LBL_Details', $siteLangId); ?>
                                                </th>
                                                <th width="10%">
                                                    <?php echo Labels::getLabel('LBL_Status', $siteLangId); ?>
                                                </th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php
                                            if (count($cancellationRequests) > 0) {
                                                foreach ($cancellationRequests as $row) {
                                                    $orderDetailUrl = UrlHelper::generateUrl('buyer', 'viewOrder', array($row['order_id'], $row['op_id']));
                                                    $prodOrBatchUrl = '';
                                                    if ($row['op_is_batch']) {
                                                        $prodOrBatchUrl = UrlHelper::generateUrl('Products', 'batch', array($row['op_selprod_id']));
                                                    } else {
                                                        if (Product::verifyProductIsValid($row['op_selprod_id']) == true) {
                                                            $prodOrBatchUrl = UrlHelper::generateUrl('Products', 'view', array($row['op_selprod_id']));
                                                        }
                                                    }
                                                    ?>
                                                    <tr>
                                                        <td>
                                                            <div class="product-profile-data">
                                                                <div class="request__date">
                                                                    <?php echo FatDate::format($row['ocrequest_date']); ?>
                                                                </div>
                                                                <div class="product-profile-title">
                                                                    <a title="<?php echo Labels::getLabel('Lbl_Invoice_number', $siteLangId) ?>"
                                                                        href="<?php echo !empty($orderDetailUrl) ? $orderDetailUrl : 'javascript:void(0)'; ?>">
                                                                        <?php echo $row['op_invoice_number']; ?>
                                                                    </a>
                                                                </div>
                                                                <div class="product-profile-title">
                                                                    <?php if ($row['op_selprod_title'] != '') { ?> <a
                                                                            title="<?php echo $row['op_selprod_title']; ?>"
                                                                            href="<?php echo !empty($prodOrBatchUrl) ? $prodOrBatchUrl : 'javascript:void(0)'; ?>">
                                                                            <?php echo $row['op_selprod_title']; ?>
                                                                        </a>
                                                                    <?php } else { ?> <a
                                                                            title="<?php echo $row['op_product_name']; ?>"
                                                                            href="<?php echo !empty($prodOrBatchUrl) ? $prodOrBatchUrl : 'javascript:void(0)'; ?>">
                                                                            <?php echo $row['op_product_name']; ?>
                                                                        </a>
                                                                    <?php } ?>
                                                                </div>
                                                            </div>
                                                        </td>
                                                        <td>
                                                            <div class="request__reason">
                                                                <?php echo Labels::getLabel('Lbl_Reason', $siteLangId) ?>:
                                                                <?php echo $row['ocreason_title']; ?>
                                                            </div>
                                                            <div class="request__comments">
                                                                <?php echo Labels::getLabel('Lbl_Comments', $siteLangId) ?>:
                                                                <?php echo $row['ocrequest_message']; ?>
                                                            </div>
                                                        </td>
                                                        <td>
                                                            <span
                                                                class="badge badge-inline <?php echo $cancelReqStatusClassArr[$row['ocrequest_status']]; ?>">
                                                                <?php echo $OrderCancelRequestStatusArr[$row['ocrequest_status']]; ?>
                                                            </span>
                                                        </td>
                                                    </tr>
                                                    <?php
                                                }
                                            } else {
                                                ?>
                                                <tr>
                                                    <td colspan="3">
                                                        <?php $this->includeTemplate('_partial/no-record-found.php', array('siteLangId' => $siteLangId), false); ?>
                                                    </td>
                                                </tr>
                                            <?php } ?>
                                        </tbody>

                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php } ?>
        </div>
    </div>
</main>

<style>
    .js-widget-scroll{
        display: flex;
        flex-wrap: wrap;
    }
    .widget-scroll .widget-stats{
        flex:1 1 calc(32% - 10px);
    }
</style>