<?php defined('SYSTEM_INIT') or die('Invalid Usage.');
$brandList = [];
if (!empty($allBrands)) {
    $firstCharacter = '';
    foreach ($allBrands as $brands) {
        $str = substr(strtolower($brands['brand_name']), 0, 1);
        if (is_numeric($str)) {
            $str = '0-9';
        }
        $brandList[$str][$brands['brand_id']] = $brands['brand_name'];
    }
}
?>
<main id="main" class="main">
    <div class="bg-brand pt-3 pb-3">
        <div class="container">
            <div class="row align-items-center justify-content-center">
                <div class="col-md-8">
                    <div class="section-head section-head-white justify-content-center mb-0">
                        <div class="section-heading">
                            <h2>
                                <?php echo Labels::getLabel('LBL_All_Top_Brands', $siteLangId); ?>
                            </h2>
                            <div class="breadcrumbs breadcrumbs-white  breadcrumbs-center">
                                <?php $this->includeTemplate('_partial/custom/header-breadcrumb.php'); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <section class="section" data-collection="collection-name">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-8">
                    <div class="brands-listing">
                        <?php
                        foreach ($brandList as $category => $brandCat) {
                            ?>
                            <div class="brands-listing-item ">
                                <h4 class="brands-listing-title">
                                    <?php echo strtoupper($category) ?>
                                </h4>
                                <ul class="brands-map">
                                    <?php
                                    foreach ($brandCat as $brand_id => $brand) {
                                        $fileData = AttachedFile::getAttachment(AttachedFile::FILETYPE_BRAND_FEATURED_IMAGE, $brand_id, 0, 0, false);
                                        $aspectRatioArr = AttachedFile::getRatioTypeArray($siteLangId);
                                        $ratio = "";
                                        if (isset($fileData['afile_aspect_ratio']) && $fileData['afile_aspect_ratio'] > 0 && isset($aspectRatioArr[$fileData['afile_aspect_ratio']])) {
                                            $ratio = $aspectRatioArr[$fileData['afile_aspect_ratio']];
                                        } ?>

                                        <li class="brands-map-item">
                                            <a class="brands-map-link"
                                                href="<?php echo UrlHelper::generateUrl('Brands', 'view', array($brand_id)); ?>"
                                                title="<?php echo $brand; ?>">
                                                <img class="brands-map-img"
                                                    src="<?php echo UrlHelper::getCachedUrl(UrlHelper::generateFileUrl('image', 'brand', array($brand_id, $siteLangId, 'THUMB')), CONF_IMG_CACHE_TIME, '.jpg'); ?>"
                                                    alt="<?php echo (!empty($fileData['afile_attribute_alt'])) ? $fileData['afile_attribute_alt'] : $brand; ?>"
                                                    title="<?php echo (!empty($fileData['afile_attribute_alt'])) ? $fileData['afile_attribute_alt'] : $brand; ?>"
                                                    loading="lazy">
                                                <?php echo $brand; ?><i class="chevron-right"></i>
                                            </a>
                                        </li>
                                        <?php
                                    }
                                    ?>
                                </ul>
                            </div>
                            <?php
                        }
                        ?>
                    </div>
                </div>
            </div>
    </section>
</main>