<?php
defined('SYSTEM_INIT') or die('Invalid Usage.');
$frmSrch->setFormTagAttribute('onSubmit', 'searchVerificationFlds(this); return false;');
$frmSrch->setFormTagAttribute('class', 'form form-search');
$frmSrch->developerTags['colClassPrefix'] = 'col-md-';

$keywordFld = $frmSrch->getField('keyword');
$keywordFld->developerTags['col'] = 8;

$submitBtnFld = $frmSrch->getField('btn_submit');
$submitBtnFld->setFieldTagAttribute('class', 'btn-block');
$submitBtnFld->developerTags['col'] = 2;

$cancelBtnFld = $frmSrch->getField('btn_clear');
$cancelBtnFld->setFieldTagAttribute('class', 'btn-block');
$cancelBtnFld->developerTags['col'] = 2;
?>
<?php $this->includeTemplate('_partial/seller/sellerDashboardNavigation.php'); ?>
<main id="main-area" class="main" role="main">
    <div class="content content-wrapper content-space">
        <div class="content-header">
            <div class="content-header-title">
                <?php $this->includeTemplate('_partial/dashboardTop.php'); ?>
                <h2 class="content-header-heading">
                    <a class="btn btn-back" title="<?php echo Labels::getLabel('LBL_Back', $siteLangId); ?>" href="<?php echo UrlHelper::generateUrl('AttachVerificationFields', 'index'); ?>">
                        <svg class="svg" width="24" height="24">
                            <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite.svg#back">
                            </use>
                        </svg>
                    </a>
                    <?php echo Labels::getLabel('LBL_Verification_Fields_List', $siteLangId); ?>
                </h2>
            </div>
        </div>
        <div class="content-form">
            <?php
            $submitFld = $frmSrch->getField('btn_submit');
            $submitFld->setFieldTagAttribute('class', 'btn btn-brand btn-search btn-block ');
            $fldClear = $frmSrch->getField('btn_clear');
            $fldClear->setFieldTagAttribute('class', 'btn btn-gray btn-clear');
            echo $frmSrch->getFormHtml();
            ?>
        </div>
        <div class="content-body">

            <div class="card">
                <div class="card-table">
                    <div id="verificationListing"></div>
                </div>
            </div>
        </div>
    </div>
</main>
<script>
    $(document).ready(function() {
        searchVerificationFlds(document.frmSearch);
    });
    (function() {
        var dv = '#verificationListing';

        searchVerificationFlds = function(frm) {
            var data = fcom.frmData(frm);
            $(dv).html(fcom.getLoader());
            fcom.ajax(fcom.makeUrl('AttachVerificationFields', 'verificationFldSearchListing'), data, function(res) {
                $(dv).html(res);
            });
        };

        goToSearchPage = function(page) {
            if (typeof page == undefined || page == null) {
                page = 1;
            }
            var frm = document.frmSrchPaging;
            $(frm.page).val(page);
            searchVerificationFlds(frm);
        }

        clearSearch = function() {
            document.frmSearch.reset();
            searchVerificationFlds(document.frmSearch);
        };
    })();
</script>