<?php defined('SYSTEM_INIT') or die('Invalid Usage.'); ?>
<?php $this->includeTemplate('_partial/seller/sellerDashboardNavigation.php'); ?>

<main id="main-area" class="main" role="main">
    <div class="content content-wrapper content-space">
        <div class="content-header">
            <div class="content-header-title">
                <?php $this->includeTemplate('_partial/dashboardTop.php'); ?>
                <h2 class="content-header-heading">
                    <?php echo Labels::getLabel('LBL_Link_Rental_Addons', $siteLangId); ?><i class="fa fa-info-circle"
                        data-bs-toggle="tooltip" data-placement="right"
                        title="<?php echo Labels::getLabel('LBL_Attach_addons_to_the_rented_products.', $siteLangId); ?>"></i>
                </h2>
            </div>
        </div>
        <div class="content-form">
            <?php
            $searchForm->setFormTagAttribute('id', 'frmSearchAddonProduct');
            $searchForm->setFormTagAttribute('class', 'form form-search');
            $searchForm->setFormTagAttribute('onsubmit', 'searchProducts(this); return(false);');
            $searchForm->getField('keyword')->addFieldTagAttribute('placeholder', Labels::getLabel('LBL_Search_By_Addon_Name', $siteLangId));
            $searchForm->developerTags['colClassPrefix'] = 'col-md-';

            $keywordFld = $searchForm->getField('keyword');
            $keywordFld->developerTags['col'] = 8;

            $submitFld = $searchForm->getField('btn_submit');
            $submitFld->setFieldTagAttribute('class', 'btn btn-brand btn-search btn-block');
            $submitFld->developerTags['col'] = 2;

            $fldClear = $searchForm->getField('btn_clear');
            $fldClear->developerTags['col'] = 2;
            $fldClear->setFieldTagAttribute('onclick', 'clearSearch()');
            $fldClear->setFieldTagAttribute('class', 'btn btn-gray btn-clear');
            echo $searchForm->getFormHtml();
            ?>
        </div>
        <div class="content-body">

            <div class="card">
                <div class="card-head">
                    <?php if ($canEdit) { ?>
                        <form class="form" method="post" name="attachAddonForm"
                            onsubmit="saveAddonWithProducts(this); return(false);" autocomplete="off">
                            <div class="row">
                                <div class="col-sm-4">
                                    <div class="field-set">
                                        <div class="caption-wraper"> <label
                                                class="form-label"><?php echo Labels::getLabel('LBL_Search_Rental_Addons', $siteLangId); ?></label>
                                        </div>
                                        <div class="field-wraper">
                                            <div class="field_cover">
                                                <?php if ($addonId > 0) {
                                                    echo SellerProduct::getAddonDisplayTitle($addonId, $siteLangId);
                                                } else { ?>
                                                    <input name="addon_product_name" id="addon_product_name" type="text"
                                                        placeholder="<?php echo Labels::getLabel('LBL_Search_Rental_Addons', $siteLangId); ?>"  autocomplete="off" />
                                                <?php } ?>
                                                <input name="addon_product_id" id="addon_product_id" type="hidden"
                                                    value="<?php echo $addonId; ?>" />
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-sm-4">
                                    <div class="field-set">
                                        <div class="caption-wraper"> <label
                                                class="form-label"><?php echo Labels::getLabel('LBL_Search_Product', $siteLangId); ?></label>
                                        </div>

                                        <input id="filterText" type="text"
                                            placeholder="<?php echo Labels::getLabel('LBL_Search_Product', $siteLangId); ?>"
                                            id="openWindow" />
                                        <div class="search-card-pro search-card-pro--js">
                                            <div class="selectAll">
                                                <input name="select_all" type="checkbox" id="chbAll" class="k-checkbox"
                                                    onchange="chbAllOnChange()" />
                                                <label class="k-checkbox-label"
                                                    for="chbAll"><?php echo Labels::getLabel('LBL_Select_All', $siteLangId); ?></label>
                                                <span id="result">0
                                                    <?php echo Labels::getLabel('LBL_Products_Selected', $siteLangId); ?></span>
                                            </div>
                                            <div id="treeview"></div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-sm-2">
                                    <div class="field-set">
                                        <div class="caption-wraper"> <label class="form-label"></label></div>
                                        <div class="field-wraper">
                                            <div class="field_cover">
                                                <input type="submit" class="btn btn-brand btn-block"
                                                    value="<?php echo Labels::getLabel('LBL_Save', $siteLangId); ?>" />
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-sm-2">
                                    <div class="field-set">
                                        <div class="caption-wraper"> <label class="form-label"></label>
                                        </div>
                                        <div class="field-wraper">
                                            <div class="field_cover">
                                                <input type="button" class="btn btn-gray btn-clear"
                                                    value="<?php echo Labels::getLabel('LBL_Clear', $siteLangId); ?>"
                                                    onclick="clearForm()" />
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>
                    <?php } ?>
                </div>
                <div class="card-table">
                    <div id="addon-products-listing-js"></div>
                </div>
            </div>
        </div>
    </div>
</main>

<script>
    <?php if ($addonId > 0) { ?>
        var RELOAD_AFTER_SAVE = 1;
    <?php } else { ?>
        var RELOAD_AFTER_SAVE = 0;
    <?php } ?>



    $(document).on('keyup', "input[name='addon_product_name']", function () {
        var currObj = $(this);
        if ('' != currObj.val()) {
            currObj.siblings('ul.dropdown-menu').remove();
            currObj.autocomplete({
                'source': function (request, response) {
                    $('input[name="addon_product_id"]').val(0);
                    $.ajax({
                        url: fcom.makeUrl('AttachAddonPoducts', 'addonProductsAutoComplete', [<?php echo SellerProduct::PRODUCT_TYPE_ADDON . ',' . true; ?>]),
                        data: {
                            fIsAjax: 1,
                            keyword: currObj.val()
                        },
                        dataType: 'json',
                        type: 'post',
                        success: function (json) {
                            response($.map(json, function (item) {
                                return {
                                    label: item['value'],
                                    value: item['value'],
                                    id: item['id']
                                };
                            }));
                        },
                    });
                },
                select: function (event, ui) {
                    $('input[name="addon_product_id"]').val(ui.item.id);
                }
            });
        } else {
            $('input[name="addon_product_id"]').val('');
        }
    });

    var myDataSource = new yomultiselect.data.HierarchicalDataSource({
        data: []
    });

    $("#treeview").yomultiselectTreeView({
        loadOnDemand: false,
        checkboxes: {
            checkChildren: true
        },
        dataSource: myDataSource,
        check: onCheck,
        expand: onExpand
    });
    $(".selectAll").css("display", "none");

    function checkUncheckAllNodes(nodes, checked) {
        for (var i = 0; i < nodes.length; i++) {
            nodes[i].set("checked", checked);
            if (nodes[i].hasChildren) {
                checkUncheckAllNodes(nodes[i].children.view(), checked);
            }
        }
    }

    function chbAllOnChange() {
        var checkedNodes = [];
        var treeView = $("#treeview").data("yomultiselectTreeView");
        var isAllChecked = $('#chbAll').prop("checked");
        checkUncheckAllNodes(treeView.dataSource.view(), isAllChecked)

        if (isAllChecked) {
            setMessage($('#treeview input[type="checkbox"]').length);
        } else {
            setMessage(0);
        }
    }

    function getCheckedNodes(nodes, checkedNodes) {
        var node;
        for (var i = 0; i < nodes.length; i++) {
            node = nodes[i];
            if (node.checked && node.id > 0) {
                checkedNodes.push(node.id);
            }

            if (node.hasChildren) {
                getCheckedNodes(node.children.view(), checkedNodes);
            }
        }
    }

    function onCheck() {
        var checkedNodes = [];
        var treeView = $("#treeview").data("yomultiselectTreeView");
        getCheckedNodes(treeView.dataSource.view(), checkedNodes);
        setMessage(checkedNodes.length);
    }

    function onExpand(e) {
        if ($("#filterText").val() == "") {
            $(e.node).find("li").show();
        }
    }

    function setMessage(checkedNodes) {
        var message;
        if (checkedNodes > 0) {
            message = checkedNodes + " <?php echo Labels::getLabel('LBL_Products_Selected', $siteLangId); ?>";
        } else {
            message = "0 <?php echo Labels::getLabel('LBL_Products_Selected', $siteLangId); ?>";
        }

        $("#result").html(message);
    }

    $("#filterText").keyup(function (e) {
        var filterText = $(this).val();
        if (filterText !== "") {
            var treeView = $("#treeview").data("yomultiselectTreeView");
            $.ajax({
                url: fcom.makeUrl('AttachAddonPoducts', 'sellerProducts'),
                data: {
                    fIsAjax: 1,
                    keyword: filterText
                },
                dataType: 'json',
                type: 'post',
                success: function (json) {
                    if (json.length > 0) {
                        $(".selectAll").css("visibility", "visible");
                        $(".selectAll").css("display", "block");
                    } else {
                        $(".selectAll").css("display", "none");
                    }
                    treeView.dataSource.data(json);
                }
            });

        } else {
            var treeView = $("#treeview").data("yomultiselectTreeView");
            treeView.dataSource.data([]);
            $(".selectAll").css("display", "none");
        }
    });

    function clearForm() {
        document.attachAddonForm.reset();
        $('input[name="addon_product_id"]').val(0);
        window.location.href = fcom.makeUrl('AttachAddonPoducts', 'index');
    }
</script>
<script>
    $(document).ready(function () {
        $('body').on('click', 'span.k-in', function () {
            $(this).parents('li').find('input[type="checkbox"]').first().trigger('click');
        });
    });
</script>