<?php
defined('SYSTEM_INIT') or die('Invalid Usage.'); ?>
<div class="modal-dialog modal-dialog-centered" role="document" id="pick-up-modal">
    <div class="modal-content">
        <div class="modal-header">
            <h5 class="modal-title">
                <?php echo Labels::getLabel('LBL_Pick_Up', $siteLangId); ?>
            </h5>
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">

            </button>
        </div>
        <div class="modal-body">
            <?php
            if (!empty($addresses)) {
                ?>
                <div class="pick-section">
                    <div class="pickup-option">
                        <ul class="my-addresses">
                            <?php foreach ($addresses as $key => $address) { ?>
                                <li class="my-addresses-item">
                                    <label class="my-addresses-body">
                                        <span class="radio">
                                            <input name="pickup_address" type="radio" value="<?php echo $address['addr_id']; ?>"
                                                <?php if ($selectedAddr == $address['addr_id'] || $key == 0) {
                                                    echo "checked='checked'";
                                                } ?>>
                                        </span>
                                        <address class="delivery-address js-addr-<?php echo $address['addr_id']; ?>">
                                            <p>
                                                <?php echo $address['addr_name'] . ', ' . $address['addr_address1']; ?>
                                                <?php
                                                if (strlen($address['addr_address2']) > 0) {
                                                    echo ", " . $address['addr_address2'];
                                                    ?>
                                                <?php } ?>

                                                <?php echo ", " . $address['addr_city'] . ", " . $address['state_name']; ?>

                                                <?php echo $address['country_name'] . ", " . $address['addr_zip']; ?>
                                            </p>
                                            <?php if (strlen($address['addr_phone']) > 0) { ?>
                                                <p class="phone-txt">
                                                    <svg class="svg" width="16" height="16">
                                                        <use
                                                            xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#mobile">
                                                        </use>
                                                    </svg>
                                                    <?php echo $address['addr_dial_code'] . ' ' . $address['addr_phone']; ?>
                                                </p>
                                            <?php } ?>
                                        </address>
                                    </label>

                                </li>
                            <?php } ?>
                        </ul>
                    </div>

                </div>
            <?php } else { ?>
                <h5>
                    <?php echo Labels::getLabel('LBL_No_Pick_Up_address_added', $siteLangId); ?>
                </h5>
            <?php } ?>
        </div>
        <div class="modal-footer"> <button class="btn btn-brand btn-wide " type="button"
                onclick="setPickupAddress('<?php echo $srNo; ?>');">
                <?php echo Labels::getLabel('LBL_Continue', $siteLangId); ?>
            </button>
        </div>
    </div>
</div>