<?php defined('SYSTEM_INIT') or die('Invalid Usage.'); ?>
<?php $this->includeTemplate('_partial/dashboardNavigation.php'); ?>
<main id="main-area" class="main">
    <div class="content content-wrapper">
        <div class="content-header">
            <div class="content-header-title">
                <?php $this->includeTemplate('_partial/dashboardTop.php'); ?>
                <h2 class="content-header-heading">
                    <a class="btn btn-back" title="<?php echo Labels::getLabel('LBL_Back_to_messages', $siteLangId); ?>"
                        href="<?php echo UrlHelper::generateUrl('Account', 'messages'); ?>">
                        <svg class="svg" width="24" height="24">
                            <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite.svg#back">
                            </use>
                        </svg>
                    </a>
                    <?php echo Labels::getLabel('LBL_Messages', $siteLangId); ?>
                </h2>
            </div>
            <div class="content-header-toolbar">
                <div class="links-inline">
                    <?php if ($threadDetails["thread_type"] == THREAD::THREAD_TYPE_RFQ) {
                        $rfqAction = ($threadDetails['rfq_user_id'] == $loggedUserId) ? "requestView" : "view";
                        ?>
                        <a href="<?php echo UrlHelper::generateUrl('RequestForQuotes', $rfqAction, [$threadDetails['rfq_id']]); ?>"
                            class="btn btn-outline-gray qwer text-uppercase">
                            <?php echo Labels::getLabel('LBL_VIEW_RFQ', $siteLangId); ?>
                        </a>
                    <?php } ?>
                </div>
            </div>
        </div>
        <div class="content-body">
            <div class="card">
                <div class="card-table">
                    <div class="scroll scroll-x js-scrollable table-wrap">
                        <table class="table table-justified">
                            <thead>
                                <tr class="">
                                    <th>
                                        <?php echo Labels::getLabel('LBL_Date', $siteLangId); ?>
                                    </th>
                                    <th>
                                        <?php if ($threadDetails["thread_type"] == THREAD::THREAD_TYPE_ORDER_PRODUCT) {
                                            echo Labels::getLabel('LBL_Order_id', $siteLangId);
                                        } elseif ($threadDetails["thread_type"] == THREAD::THREAD_TYPE_SHOP) {
                                            echo Labels::getLabel('LBL_Shop_name', $siteLangId);
                                        } elseif ($threadDetails["thread_type"] == THREAD::THREAD_TYPE_PRODUCT) {
                                            echo Labels::getLabel('LBL_Product_name', $siteLangId);
                                        }
                                        if (isset($threadDetails["selprod_title"]) && $threadDetails["thread_type"] == THREAD::THREAD_TYPE_RFQ) {
                                            echo Labels::getLabel('LBL_Product_name', $siteLangId);
                                        }
                                        ?>

                                    </th>
                                    <th>
                                        <?php echo Labels::getLabel('LBL_Subject', $siteLangId); ?>
                                    </th>
                                    <th>
                                        <?php if ($threadDetails["thread_type"] == THREAD::THREAD_TYPE_ORDER_PRODUCT) {
                                            echo Labels::getLabel('LBL_Amount', $siteLangId);
                                        } elseif ($threadDetails["thread_type"] == THREAD::THREAD_TYPE_PRODUCT) {
                                            echo Labels::getLabel('LBL_Rental_Price', $siteLangId);
                                        } ?>
                                    </th>
                                    <th>
                                        <?php if ($threadDetails["thread_type"] == THREAD::THREAD_TYPE_ORDER_PRODUCT) {
                                            echo Labels::getLabel('LBL_Status', $siteLangId);
                                        } ?>
                                    </th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>
                                        <?php echo FatDate::format($threadDetails["thread_start_date"], false); ?>
                                    </td>
                                    <td>
                                        <div class="product-profile-data">
                                            <?php if ($threadDetails["thread_type"] == THREAD::THREAD_TYPE_ORDER_PRODUCT) { ?>
                                                <span class="product-profile-title">
                                                    <?php echo $threadDetails["op_invoice_number"]; ?>
                                                </span>
                                            <?php } elseif ($threadDetails["thread_type"] == THREAD::THREAD_TYPE_SHOP) { ?>
                                                <span class="product-profile-title">
                                                    <?php echo html_entity_decode($threadDetails["shop_name"]); ?>
                                                </span>
                                            <?php } elseif ($threadDetails["thread_type"] == THREAD::THREAD_TYPE_PRODUCT) { ?>
                                                <span class="product-profile-title">
                                                    <?php echo html_entity_decode($threadDetails["selprod_title"]); ?>
                                                </span>
                                            <?php }
                                            if (isset($threadDetails["selprod_title"]) && $threadDetails["thread_type"] == THREAD::THREAD_TYPE_RFQ) {
                                                echo html_entity_decode($threadDetails["selprod_title"]);
                                            }
                                            ?>
                                        </div>
                                    </td>
                                    <td>
                                        <?php echo $threadDetails["thread_subject"]; ?>
                                    </td>
                                    <td>
                                        <span class="item__price">
                                            <?php if ($threadDetails["thread_type"] == THREAD::THREAD_TYPE_ORDER_PRODUCT) { ?>
                                                <p>
                                                    <?php echo CommonHelper::displayMoneyFormat($threadDetails['op_unit_price']); ?>
                                                </p>
                                                <?php
                                            } elseif ($threadDetails["thread_type"] == THREAD::THREAD_TYPE_SHOP) {
                                            } elseif ($threadDetails["thread_type"] == THREAD::THREAD_TYPE_PRODUCT) { ?>
                                                <p>
                                                    <?php echo CommonHelper::displayMoneyFormat($threadDetails['sprodata_rental_price']); ?>
                                                </p>
                                            <?php } ?>
                                        </span>
                                    </td>
                                    <td>
                                        <?php if ($threadDetails["thread_type"] == THREAD::THREAD_TYPE_ORDER_PRODUCT) {
                                            echo $threadDetails["orderstatus_name"];
                                        } ?>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            <div class="card">
                <div class="card-body">
                    <?php echo $frmSrch->getFormHtml(); ?>

                    <div>
                        <ul class="messages-list" id="messageListing"></ul>
                    </div>
                    <div id="loadMoreBtnDiv"></div>

                    <?php if ($canEditMessages) { ?>

                        <ul class="messages-list">
                            <li class="messages-list-item">
                                <div class="msg_db">
                                    <?php
                                    if (is_array($shopDetails) && !empty($shopDetails) && $shopDetails['shop_name'] != '' && $shopDetails['shop_id'] > 0) {
                                        $userImgUpdatedOn = $shopDetails['shop_updated_on'];
                                        $uploadedTime = AttachedFile::setTimeParam($userImgUpdatedOn);
                                        ?>
                                        <img src="<?php echo UrlHelper::getCachedUrl(UrlHelper::generateFileUrl('Image', 'shopLogo', array($shopDetails['shop_id'], $siteLangId, 'thumb')) . $uploadedTime, CONF_IMG_CACHE_TIME, '.jpg'); ?>"
                                            alt="<?php echo $shopDetails['shop_name']; ?>">
                                    <?php } else {
                                        $userImgUpdatedOn = User::getAttributesById($loggedUserId, 'user_updated_on');
                                        $uploadedTime = AttachedFile::setTimeParam($userImgUpdatedOn);
                                        ?>
                                        <img src="<?php echo UrlHelper::getCachedUrl(UrlHelper::generateFileUrl('Image', 'user', array($loggedUserId, 'thumb', true)) . $uploadedTime, CONF_IMG_CACHE_TIME, '.jpg'); ?>"
                                            alt="<?php echo $loggedUserName; ?>">
                                    <?php } ?>
                                </div>
                                <div class="msg__desc">
                                    <span class="msg__title">
                                        <?php if (isset($shopDetails) && !empty($shopDetails) && $shopDetails['shop_name'] != '') {
                                            $loggedUserName = $shopDetails['shop_name'] . ' (' . $loggedUserName . ')';
                                        }
                                        echo $loggedUserName; ?>
                                    </span>
                                    <?php
                                    $frm->setFormTagAttribute('onSubmit', 'sendMessage(this); return false;');
                                    $frm->setFormTagAttribute('class', 'form');
                                    $frm->developerTags['colClassPrefix'] = 'col-lg-12 col-md-12 col-sm-';
                                    $frm->developerTags['fld_default_col'] = 12;
                                    $submitFld = $frm->getField('btn_submit');
                                    $submitFld->setFieldTagAttribute('class', "btn btn-brand");
                                    echo $frm->getFormHtml(); ?>
                                </div>
                            </li>
                        </ul>

                    <?php } ?>
                </div>
            </div>
        </div>
    </div>
</main>