<?php defined('SYSTEM_INIT') or die('Invalid Usage.');
$this->includeTemplate('_partial/dashboardNavigation.php'); ?>
<main id="main-area" class="main">
    <div class="content content-wrapper">
        <div class="content-header">
            <div class="content-header-title"> <?php $this->includeTemplate('_partial/dashboardTop.php'); ?>
                <h2 class="content-header-heading"><?php echo Labels::getLabel('LBL_Account_Settings', $siteLangId); ?>
                </h2>
            </div>
            <?php if (0 == $userParentId) { ?>
                <div class="content-header-toolbar">
                    <div class="links-inline">
                        <button type="button" class="btn btn-outline-gray qwer" onclick="truncateDataRequestPopup()">
                            <svg class="svg" width="18" height="18">
                                <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite.svg#remove-data">
                                </use>
                            </svg>
                            <?php echo Labels::getLabel('LBL_Request_to_remove_my_data', $siteLangId); ?></button>

                        <button type="button" class="btn btn-outline-gray qwer" onclick="requestData()">
                            <svg class="svg" width="18" height="18">
                                <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite.svg#request-data">
                                </use>
                            </svg>
                            <?php echo Labels::getLabel('LBL_Request_My_Data', $siteLangId); ?></button>
                        <?php if ($showSellerActivateButton) { ?>
                            <a href="<?php echo UrlHelper::generateUrl('Seller'); ?>" class="btn btn-outline-gray qwer panel__head_action" title="<?php echo Labels::getLabel('LBL_Activate_Seller_Account', $siteLangId); ?>">
                                <svg class="svg" width="18" height="18">
                                    <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite.svg#activate-seller-account">
                                    </use>
                                </svg> <?php echo Labels::getLabel('LBL_Activate_Seller_Account', $siteLangId); ?>
                            </a>
                        <?php } ?>
                    </div>
                </div>
            <?php } ?>
        </div>
        <div class="content-body">
            <div class="card card-tabs">
                <div class="card-head"> <?php if ($userParentId == 0) { ?>
                        <ul class="nav nav-tabs tabs-grcustom navTabsJs tabs-js">
                            <li class="nav-item is-active" id="tab-myaccount">
                                <button type="button" class="nav-link" onClick="profileInfoForm()">
                                    <?php echo Labels::getLabel('LBL_My_Account', $siteLangId); ?>
                                </button>
                            </li>
                            <?php if (User::isAffiliate()) { ?>
                                <li class="nav-item " id="tab-paymentinfo">
                                    <button type="button" class="nav-link" onClick="affiliatePaymentInfoForm()"><?php echo Labels::getLabel('LBL_Payment_Info', $siteLangId); ?></button>
                                </li>
                            <?php }
                                            if (!User::isAffiliate()) { ?>
                                <li class="nav-item " id="tab-bankaccount">
                                    <button type="button" class="nav-link" onClick="bankInfoForm()"><?php echo Labels::getLabel('LBL_Bank_Account', $siteLangId); ?></button>
                                </li>
                            <?php } ?>
                            <?php
                                            foreach ($payouts as $type => $name) { ?>
                                <li class="nav-item " id="tab-<?php echo $type; ?>">
                                    <button type="button" class="nav-link" onClick="pluginForm('<?php echo $type; ?>')">
                                        <?php echo $name; ?>
                                    </button>
                                </li>
                            <?php } ?>
                            <li class="nav-item " id="gdpr-block--js">
                                <button type="button" class="nav-link" onClick="getGdprData();">
                                    <?php echo Labels::getLabel('LBL_GDPR_Tool', $siteLangId); ?>
                                </button>
                            </li>
                        </ul>
                    <?php } ?>
                </div>
                <div class="card-body">
                    <div id="profileInfoFrmBlock">
                        <?php echo Labels::getLabel('LBL_Loading..', $siteLangId); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</main>