<?php defined('SYSTEM_INIT') or die('Invalid Usage.');
$addressFrm->setFormTagAttribute('id', 'addressFrm');
$addressFrm->setFormTagAttribute('class', 'form');
$addressFrm->developerTags['colClassPrefix'] = 'col-sm-4 col-md-';
$addressFrm->developerTags['fld_default_col'] = 4;
$addressFrm->setFormTagAttribute('onsubmit', 'setupAddress(this); return(false);');

$countryFld = $addressFrm->getField('addr_country_id');
$countryFld->setFieldTagAttribute('id', 'addr_country_id');
$countryFld->setFieldTagAttribute('onChange', 'getCountryStates(this.value,' . $stateId . ',\'#addr_state_id\')');

$stateFld = $addressFrm->getField('addr_state_id');
$stateFld->setFieldTagAttribute('id', 'addr_state_id');

$zipcodeFld = $addressFrm->getField('addr_zip');
$zipcodeFld->setFieldTagAttribute('id', 'addr_zip');

if (CommonHelper::isDistanceShippingEnabled()) {
    $mapFld = $addressFrm->getField('addr_map');
    $mapFld->developerTags['col'] = 12;
    $mapFld->developerTags['noCaptionTag'] = true;
}
$cancelFld = $addressFrm->getField('btn_cancel');
$cancelFld->setFieldTagAttribute('onclick', 'searchAddresses()');
$cancelFld->setFieldTagAttribute('class', 'btn btn-gray btn-clear');
$cancelFld->developerTags['col'] = 2;
$cancelFld->developerTags['noCaptionTag'] = true;

$submitFld = $addressFrm->getField('btn_submit');
$submitFld->setFieldTagAttribute('class', 'btn btn-brand btn-search btn-block');
$submitFld->developerTags['col'] = 2;
$submitFld->developerTags['noCaptionTag'] = true;
?>
<!-- <div class="tabs">
    <ul>
        <li>
            <button onClick="searchAddresses()"><?php echo Labels::getLabel('LBL_My_Addresses', $siteLangId); ?></button>
        </li>
<?php //if ($addr_id > 0) { 
?>
        <li class="is-active">
            <button onClick="addAddressForm(<?php echo $addr_id; ?>)">
            <?php echo Labels::getLabel('LBL_Update_Address', $siteLangId); ?>
            </button>
        </li>
<?php //} else { 
?>
        <li class="is-active">
            <button onClick="addAddressForm(0)">
                <?php echo Labels::getLabel('LBL_Add_new_address', $siteLangId); ?>
            </button>
        </li>
<?php //} 
?>
    </ul>
</div> -->
<div class="container--addresses"> <?php echo $addressFrm->getFormHtml(); ?> </div>

<script language="javascript">
    $(document).ready(function() {
        <?php if (CommonHelper::isDistanceShippingEnabled()) { ?>
            var lat = (!$('#lat').val()) ? '<?php echo FatApp::getConfig('CONF_GEO_DEFAULT_LAT', FatUtility::VAR_FLOAT, 0); ?>' : $('#lat').val();
            var lng = (!$('#lng').val()) ? '<?php echo FatApp::getConfig('CONF_GEO_DEFAULT_LNG', FatUtility::VAR_FLOAT, 0); ?>' : $('#lng').val();
            initAutocomplete();
            initMap(lat, lng);
        <?php } ?>
        getCountryStates($("#addr_country_id").val(), <?php echo $stateId; ?>, '#addr_state_id');
        stylePhoneNumberFld("input[name='addr_phone']", false, 'addr_dial_code', 'addr_country_iso');
    });
</script>
<?php
if (isset($countryIso) && !empty($countryIso)) { ?>
    <script>
        langLbl.defaultCountryCode = '<?php echo $countryIso; ?>';
    </script>
<?php } ?>
<?php
if (isset($isAlreadyExistsAddress)) { ?>
    <script>
        var isAlreadyExistsAddress = <?php echo (int) $isAlreadyExistsAddress; ?>;
    </script>
<?php } ?>