<?php if (CommonHelper::demoUrl() && 'subscriptioncheckout' != strtolower($controllerName)) {
    $this->includeTemplate('restore-system/top-header.php');
} ?>

<?php if ($controllerName != 'SubscriptionCheckout') { ?>
        <div class="wrapper">
            <header id="header-dashboard" class="header-dashboard no-print">
                <?php if ((User::canViewSupplierTab() && User::canViewBuyerTab()) || (User::canViewSupplierTab() && User::canViewAdvertiserTab() && $userPrivilege->canViewPromotions(0, true)) || (User::canViewBuyerTab() && User::canViewAdvertiserTab()) || User::canViewBuyerTab() || User::canViewSupplierTab() || User::canViewAdvertiserTab()) { ?>
                        <div class="header-logo dashboard-user">
                            <?php
                            if (CommonHelper::isThemePreview() && isset($_SESSION['preview_theme'])) {
                                $logoUrl = UrlHelper::generateUrl('home', 'index');
                            } else {
                                $logoUrl = UrlHelper::generateUrl();
                            }
                            ?>
                            <?php
                            $fileData = AttachedFile::getAttachment(AttachedFile::FILETYPE_FRONT_LOGO, 0, 0, $siteLangId, true);
                            $aspectRatioArr = AttachedFile::getRatioTypeArray($siteLangId, true);

                            $sizeType = 'CUSTOM';
                            if ($fileData['afile_aspect_ratio'] == AttachedFile::RATIO_TYPE_RECTANGULAR) {
                                $sizeType = '16X9';
                            } elseif ($fileData['afile_aspect_ratio'] == AttachedFile::RATIO_TYPE_SQUARE) {
                                $sizeType = '1X1';
                            }

                            $uploadedTime = AttachedFile::setTimeParam($fileData['afile_updated_at']);
                            $siteLogo = UrlHelper::getCachedUrl(UrlHelper::generateFullFileUrl('Image', 'siteLogo', array($siteLangId, $sizeType), CONF_WEBROOT_FRONT_URL) . $uploadedTime, CONF_IMG_CACHE_TIME, '.jpg');


                            $ratio = '';
                            if (isset($fileData['afile_aspect_ratio']) && $fileData['afile_aspect_ratio'] > 0 && isset($aspectRatioArr[$fileData['afile_aspect_ratio']])) {
                                $ratio = $aspectRatioArr[$fileData['afile_aspect_ratio']];
                            }
                            ?>

                            <a class="logo-dashboard" href="<?php echo $logoUrl; ?>">
                                <img fetchpriority="high" decoding="async" data-nimg="1" data-ratio="<?php echo $ratio; ?>" src="<?php echo $siteLogo; ?>" alt="<?php echo FatApp::getConfig('CONF_WEBSITE_NAME_' . $siteLangId) ?>" title="<?php echo FatApp::getConfig('CONF_WEBSITE_NAME_' . $siteLangId) ?>">
                            </a>


                            <button class="btn dropdown-toggle-custom dropdown-toggle no-after" type="button" id="dashboardDropdown" data-bs-toggle="dropdown" data-bs-auto-close="outside"     aria-expanded="false">
                                <?php echo ($activeTab == 'S') ? Labels::getLabel('Lbl_Seller', $siteLangId) : (($activeTab == 'B') ? Labels::getLabel('Lbl_Buyer', $siteLangId) : (($activeTab == 'Ad') ? Labels::getLabel('Lbl_Advertiser', $siteLangId) : '')) ?>
                                <i class="dropdown-toggle-custom-arrow"></i>
                            </button>

                            <ul class="dropdown-menu dropdown-menu-anim">
                                <?php if (User::canViewSupplierTab()) { ?>
                                        <li class="dropdown-menu-item <?php echo ($activeTab == 'S') ? 'is-active' : ''; ?>">
                                            <a class="dropdown-menu-link" href="<?php echo UrlHelper::generateUrl('Seller'); ?>"><?php echo Labels::getLabel('Lbl_Seller', $siteLangId); ?></a>
                                        </li>
                                <?php } ?>
                                <?php if (User::canViewBuyerTab()) { ?>
                                        <li class="dropdown-menu-item <?php echo ($activeTab == 'B') ? 'is-active' : ''; ?>">
                                            <a class="dropdown-menu-link" href="<?php echo UrlHelper::generateUrl('Buyer'); ?>"><?php echo Labels::getLabel('Lbl_Buyer', $siteLangId); ?></a>
                                        </li>
                                <?php } ?>
                                <?php if (User::canViewAdvertiserTab() && $userPrivilege->canViewPromotions(0, true)) { ?>
                                        <li class="dropdown-menu-item <?php echo ($activeTab == 'Ad') ? 'is-active' : ''; ?>">
                                            <a class="dropdown-menu-link" href="<?php echo UrlHelper::generateUrl('Advertiser'); ?>"><?php echo Labels::getLabel('Lbl_Advertiser', $siteLangId); ?></a>
                                        </li>
                                <?php } ?>
                            </ul>

                        </div>
                <?php } ?>
                <ul class="header-actions">
                    <?php
                    $getOrgUrl = (CONF_DEVELOPMENT_MODE) ? true : false;
                    $userActiveTab = false;
                    if (User::canViewSupplierTab() && (isset($_SESSION[UserAuthentication::SESSION_ELEMENT_NAME]['activeTab']) && $_SESSION[UserAuthentication::SESSION_ELEMENT_NAME]['activeTab'] == 'S')) {
                        $userActiveTab = true;
                        $dashboardUrl = UrlHelper::generateUrl('Seller');
                        $dashboardOrgUrl = UrlHelper::generateUrl('Seller', '', array(), '', null, false, $getOrgUrl);
                    } elseif (User::canViewBuyerTab() && (isset($_SESSION[UserAuthentication::SESSION_ELEMENT_NAME]['activeTab']) && $_SESSION[UserAuthentication::SESSION_ELEMENT_NAME]['activeTab'] == 'B')) {
                        $userActiveTab = true;
                        $dashboardUrl = UrlHelper::generateUrl('Buyer');
                        $dashboardOrgUrl = UrlHelper::generateUrl('Buyer', '', array(), '', null, false, $getOrgUrl);
                    } elseif (User::canViewAdvertiserTab() && (isset($_SESSION[UserAuthentication::SESSION_ELEMENT_NAME]['activeTab']) && $_SESSION[UserAuthentication::SESSION_ELEMENT_NAME]['activeTab'] == 'Ad')) {
                        $userActiveTab = true;
                        $dashboardUrl = UrlHelper::generateUrl('Advertiser');
                        $dashboardOrgUrl = UrlHelper::generateUrl('Advertiser', '', array(), '', null, false, $getOrgUrl);
                    } elseif (User::canViewAffiliateTab() && (isset($_SESSION[UserAuthentication::SESSION_ELEMENT_NAME]['activeTab']) && $_SESSION[UserAuthentication::SESSION_ELEMENT_NAME]['activeTab'] == 'AFFILIATE')) {
                        $userActiveTab = true;
                        $dashboardUrl = UrlHelper::generateUrl('Affiliate');
                        $dashboardOrgUrl = UrlHelper::generateUrl('Affiliate', '', array(), '', null, false, $getOrgUrl);
                    }

                    if (!$userActiveTab) {
                        $dashboardUrl = UrlHelper::generateUrl('Account');
                        $dashboardOrgUrl = UrlHelper::generateUrl('Account', '', array(), '', null, false, $getOrgUrl);
                    }
                    ?>
                    <?php if ($userPrivilege->canViewMessages(0, true) && $activeTab != 'Ad') { ?>
                            <li class="header-actions-item">
                                <a class="header-actions-link" data-org-url="<?php echo UrlHelper::generateUrl('Account', 'Messages', array(), '', null, false, $getOrgUrl); ?>" href="<?php echo UrlHelper::generateUrl('Account', 'Messages'); ?>" title="<?php echo Labels::getLabel('LBL_Messages', $siteLangId); ?>">
                                    <svg class="svg" width="20" height="20">
                                        <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/top-bar.svg#notification">
                                        </use>
                                    </svg>
                                    <?php if (!empty($todayUnreadMessageCount)) { ?>
                                            <span class="counts"><span class="heartbit"></span><?php echo CommonHelper::displayBadgeCount($todayUnreadMessageCount, 9); ?></span>
                                    <?php } ?>
                                </a>
                            </li>
                    <?php } ?>
                    <?php 
                     if(empty($isOnlyAdvertiser)){
                    ?>
                    <!-- [ USER RFQ NOTIFICATIONS SECTION -->
                    <li class="header-actions-item dropdown">
                        <button class="header-actions-link dropdown-toggle no-after" data-bs-toggle="dropdown" data-bs-auto-close="outside"     aria-expanded="false" <?php if ($unreadNotificationCount > 0) { ?> onclick="loadNotifications();" <?php } ?> title="<?php echo Labels::getLabel('LBL_RFQ_Notifications', $siteLangId); ?>">
                            <svg class="svg bell-shake-delay" width="20" height="20">
                                <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/top-bar.svg#bell">
                                </use>
                            </svg>
                            <?php if (!empty($unreadNotificationCount)) { ?>
                                    <span class="counts">
                                        <span class="heartbit"></span>
                                        <?php echo CommonHelper::displayBadgeCount($unreadNotificationCount, 9); ?>
                                    </span>
                            <?php } ?>
                        </button>
                        <div class="dropdown-menu dropdown-menu-anim" id="notificationList-header"></div>
                    </li>
                    <?php } ?>
                    <!-- ] -->
                    <li class="header-actions-item dropdown item-desktop">
                        <?php $this->includeTemplate('_partial/headUserDashboardAccount.php', array('isUserDashboard' => $isUserDashboard, 'dashboardUrl' => $dashboardUrl, 'dashboardOrgUrl' => $dashboardOrgUrl)); ?>
                    </li>
                </ul>
            </header>
    <?php } ?>