<div class="wrapper">
    <!--Default header start here-->
    <header class="header no-print" id="Default">
        <div class="header-top">
            <div class="container">
                <div class="d-flex align-items-center justify-content-between">
                    <div class="header-top-left">
                        <div class="dropdown location">
                            <?php if (trim(FatApp::getConfig('CONF_GOOGLEMAP_API_KEY', FatUtility::VAR_STRING, '')) != '') { ?>
                            <button class="dropdown-toggle no-after" onClick="accessLocation(true)">
                                <svg class="svg" width="12" height="12">
                                    <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#location">
                                    </use>
                                </svg>
                                <!-- <span class="hide-sm">
                                                <?php echo Labels::getLabel("LBL_Your_Location", $siteLangId); ?>-</span> -->
                                <span class="curent-zip-code" id="js-curent-zip-code">
                                    <?php echo isset($_COOKIE["_ykGeoAddress"]) ? $_COOKIE["_ykGeoAddress"] : Labels::getLabel("LBL_Location", $siteLangId); ?>
                                </span>

                            </button>
                            <?php } ?>
                        </div>

                    </div>
                    <?php if (FatApp::getConfig('CONF_ENABLE_TEXT_IN_TOP_HEADER', FatUtility::VAR_INT, 0)) { ?>
                    <div class="header-top-center">
                        <div class="slogan">
                            <span><?php echo nl2br(html_entity_decode(FatApp::getConfig('CONF_TEXT_IN_TOP_HEADER_' . $siteLangId, FatUtility::VAR_STRING, ""))); ?></span>
                        </div>
                    </div>
                    <?php } ?>
                    <div class="header-top-right">
                        <ul class="curtate">
                            <li class="curtate-item">
                                <svg class="svg" width="12" height="12">
                                    <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#phone">
                                    </use>
                                </svg>

                                <?php echo FatApp::getConfig('CONF_SITE_PHONE_CODE', FatUtility::VAR_STRING, '') . ' ' . FatApp::getConfig('CONF_SITE_PHONE', FatUtility::VAR_STRING, ""); ?>
                            </li>
                            <?php /* [  HEADER LANGUAGE AND CURRENCY UPDATE SECTION */ ?>
                            <?php $this->includeTemplate('_partial/headerLanguageArea.php'); ?>
                            <?php /* ] */ ?>
                        </ul>

                    </div>
                </div>
            </div>
        </div>
        <div class="header-main">
            <div class="container">
                <div class="d-flex justify-content-between align-items-center">
                    <button class="navs_toggle"><span></span></button>
                    <div class="header-main-left">
                        <?php
                        if (CommonHelper::isThemePreview() && isset($_SESSION['preview_theme'])) {
                            $logoUrl = UrlHelper::generateUrl('home', 'index');
                        } else {
                            $logoUrl = UrlHelper::generateUrl();
                        }
                        ?>

                        <div class="logo_wrapper">
                            <?php
                            $fileData = AttachedFile::getAttachment(AttachedFile::FILETYPE_FRONT_LOGO, 0, 0, $siteLangId, true);
                            $aspectRatioArr = AttachedFile::getRatioTypeArray($siteLangId, true);
                            $sizeType = 'CUSTOM';
                            if ($fileData['afile_aspect_ratio'] == AttachedFile::RATIO_TYPE_RECTANGULAR) {
                                $sizeType = '16X9';
                            } elseif ($fileData['afile_aspect_ratio'] == AttachedFile::RATIO_TYPE_SQUARE) {
                                $sizeType = '1X1';
                            }

                            $uploadedTime = AttachedFile::setTimeParam($fileData['afile_updated_at']);
                            $siteLogo = UrlHelper::getCachedUrl(UrlHelper::generateFullFileUrl('Image', 'siteLogo', array($siteLangId, $sizeType), CONF_WEBROOT_FRONT_URL) . $uploadedTime, CONF_IMG_CACHE_TIME, '.jpg');
                            ?>
                            <a href="<?php echo $logoUrl; ?>">
                                <img fetchpriority="high" decoding="async" data-nimg="1"
                                    <?php if ($fileData['afile_aspect_ratio'] > 0) { ?>
                                    data-ratio="<?php echo $aspectRatioArr[$fileData['afile_aspect_ratio']]; ?>"
                                    <?php } ?> src="<?php echo $siteLogo; ?>"
                                    alt="<?php echo FatApp::getConfig('CONF_WEBSITE_NAME_' . $siteLangId, FatUtility::VAR_STRING, '') ?>"
                                    title="<?php echo FatApp::getConfig('CONF_WEBSITE_NAME_' . $siteLangId, FatUtility::VAR_STRING, '') ?>">
                            </a>
                        </div>
                        <?php Navigation::headerNavigation(); //$this->includeTemplate('_partial/headerNavigation.php'); 
                        ?>
                    </div>
                    <div class="header-main-right">
                        <ul class="short-links">
                            <li class="short-links-item">
                                <button class="short-links-link" data-trigger="main-search-bar">

                                    <svg class="svg" width="16" height="16">
                                        <use
                                            xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#search_flow">
                                        </use>
                                    </svg>
                                </button>
                            </li>
                            <?php $this->includeTemplate('_partial/headerUserArea.php'); ?>
                            <?php $this->includeTemplate('_partial/headerWishListAndCartSummary.php'); ?>
                        </ul>

                    </div>
                </div>
            </div>
        </div>
        <?php $this->includeTemplate('_partial/header/site-search-form.php', ['searchForm' => Common::getSiteSearchForm(), 'siteLangId' => $siteLangId], false); ?>

    </header>
    <div class="search-overlay"></div>
    <!--header end here-->