<?php
$controller = strtolower($controller);
$action = strtolower($action);
?>
<ul class="dashboard-menu">
    <?php
    if (
        $userPrivilege->canViewShop(UserAuthentication::getLoggedUserId(), true)
    ) {
        ?>
        <!-- SHOP  -->
        <li class="dashboard-menu-item">
            <?php
            $isControllerActive = in_array($controller, [
                'seller',
            ]);
            $isActionActive = in_array($action, [
                'shop'
            ]);
            ?>
            <button
                class="dashboard-menu-btn dropdown-toggle-custom <?php echo ($isControllerActive && $isActionActive ? '' : 'collapsed'); ?>"
                type="button" data-bs-toggle="collapse" data-bs-target="#Shop"
                aria-expanded="<?php echo ($isControllerActive && $isActionActive ? 'true' : 'false'); ?>"
                aria-controls="collapseOne" title="">
                <span class="dashboard-menu-icon">
                    <svg class="svg" width="18" height="18">
                        <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite-sidebar.svg#shop">
                        </use>
                    </svg>
                </span>
                <span class="dashboard-menu-head">
                    <?php echo Labels::getLabel("LBL_SHOP", $siteLangId); ?>
                </span>
                <i class="dashboard-menu-arrow dropdown-toggle-custom-arrow"></i>
            </button>
            <?php if ($userPrivilege->canViewShop(UserAuthentication::getLoggedUserId(), true)) { ?>
                <ul class="menu-sub menu-sub-accordion collapse <?php echo ($isControllerActive && $isActionActive ? 'show' : ''); ?>"
                    id="Shop" aria-labelledby="" data-parent="#dashboard-menu">
                    <li class="menu-sub-item <?php echo ($controller == 'seller' && $action == 'shop') ? 'is-active' : ''; ?>">
                        <a class="menu-sub-link" title="<?php echo Labels::getLabel('LBL_Manage_Shop', $siteLangId); ?>"
                            href="<?php echo UrlHelper::generateUrl('Seller', 'shop'); ?>">
                            <span class="menu-sub-icon"><svg class="svg" width="16" height="16">
                                    <use
                                        xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite-sidebar.svg#manage-shop">
                                    </use>
                                </svg>
                            </span>
                            <span class="menu-sub-head"><?php echo Labels::getLabel('LBL_Manage_Shop', $siteLangId); ?></span>
                        </a>
                    </li>
                </ul>
            <?php } ?>
        </li>
    <?php } ?>

    <!-- RENTAL PRODUCTS & PROMOTIONS -->
    <?php if (
        $userPrivilege->canViewProducts(UserAuthentication::getLoggedUserId(), true) ||
        $userPrivilege->canViewAddons(UserAuthentication::getLoggedUserId(), true) ||
        $userPrivilege->canViewUnavailbleDates(UserAuthentication::getLoggedUserId(), true) ||
        $userPrivilege->canViewSpecialPrice(UserAuthentication::getLoggedUserId(), true) ||
        // $userPrivilege->canViewDurationDiscount(UserAuthentication::getLoggedUserId(), true) ||
        $userPrivilege->canViewAddons(UserAuthentication::getLoggedUserId(), true) ||
        $userPrivilege->canViewVerificationFields(UserAuthentication::getLoggedUserId(), true)
    ) { ?>
        <li class="dashboard-menu-item">
            <?php
            $isControllerActive = in_array($controller, [
                'sellerinventories',
                'addonproducts',
                'seller',
                'attachaddonpoducts',
                'attachverificationfields',
            ]);
            $isActionActive = in_array($action, [
                'customcatalogproductform',
                'customproductform',
                'catalog',
                'products',
                'customcatalogproducts',
                'addonproducts',
                'productrentalunavailabledates',
                'rentalspecialprice',
                // 'sellerproductdurationdiscounts',
            ]);
            ?>
            <button
                class="dashboard-menu-btn dropdown-toggle-custom <?php echo ($isControllerActive && $isActionActive ? '' : 'collapsed'); ?>"
                type="button" data-bs-toggle="collapse" data-bs-target="#Rental_Products_Promotions"
                aria-expanded="<?php echo ($isControllerActive && $isActionActive ? 'true' : 'false'); ?>"
                aria-controls="collapseOne" title="">
                <span class="dashboard-menu-icon">
                    <svg class="svg" width="18" height="18">
                        <use
                            xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite-sidebar.svg#promotion">
                        </use>
                    </svg>
                </span>
                <span class="dashboard-menu-head">
                    <?php echo Labels::getLabel("LBL_RENTAL_PRODUCTS_&_PROMOTIONS", $siteLangId); ?>
                </span>
                <i class="dashboard-menu-arrow dropdown-toggle-custom-arrow"></i>
            </button>

            <ul class="menu-sub menu-sub-accordion collapse <?php echo ($isControllerActive && $isActionActive ? 'show' : ''); ?>"
                id="Rental_Products_Promotions" aria-labelledby="" data-parent="#dashboard-menu">

                <?php if ($userPrivilege->canViewProducts(UserAuthentication::getLoggedUserId(), true)) { ?>
                    <li
                        class="menu-sub-item  <?php echo ($controller == 'sellerinventories' && ($action == 'customcatalogproductform' || $action == 'customproductform' || $action == 'catalog' || $action == 'products' || $action == 'customcatalogproducts')) ? 'is-active' : ''; ?>">
                        <a class="menu-sub-link" title="<?php echo Labels::getLabel('LBL_Inventory', $siteLangId); ?>"
                            href="<?php echo UrlHelper::generateUrl('SellerInventories', 'products'); ?>">
                            <span class="menu-sub-icon">
                                <svg class="svg" width="16" height="16">
                                    <use
                                        xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite-sidebar.svg#inventory">
                                    </use>
                                </svg>
                            </span>
                            <span class="menu-sub-head"><?php echo Labels::getLabel('LBL_Inventory', $siteLangId); ?></span>
                        </a>
                    </li>

                    <?php if (FatApp::getConfig('CONF_ALLOW_RENTAL_SERVICES', FatUtility::VAR_INT, 0) > 0 && $userPrivilege->canViewAddons(UserAuthentication::getLoggedUserId(), true)) { ?>
                        <li class="menu-sub-item <?php echo ($controller == 'addonproducts') ? 'is-active' : ''; ?>">
                            <a class="menu-sub-link" title="<?php echo Labels::getLabel('LBL_Addons', $siteLangId); ?>"
                                href="<?php echo UrlHelper::generateUrl('addonProducts'); ?>">
                                <span class="menu-sub-icon">
                                    <svg class="svg" width="16" height="16">
                                        <use
                                            xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite-sidebar.svg#add-ons">
                                        </use>
                                    </svg>
                                </span>
                                <span class="menu-sub-head"><?php echo Labels::getLabel('LBL_Addons', $siteLangId); ?></span>
                            </a>
                        </li>
                    <?php }
                } ?>
                <?php if ($userPrivilege->canViewUnavailbleDates(UserAuthentication::getLoggedUserId(), true)) { ?>
                    <li
                        class="menu-sub-item <?php echo ($controller == 'sellerinventories' && $action == 'productrentalunavailabledates') ? 'is-active' : ''; ?>">
                        <a class="menu-sub-link" title="<?php echo Labels::getLabel('LBL_Unavailable_Dates', $siteLangId); ?>"
                            href="<?php echo UrlHelper::generateUrl('SellerInventories', 'productRentalUnavailableDates'); ?>">
                            <span class="menu-sub-icon"><svg class="svg" width="16" height="16">
                                    <use
                                        xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite-sidebar.svg#unavailable-dates">
                                    </use>
                                </svg>
                            </span>
                            <span
                                class="menu-sub-head"><?php echo Labels::getLabel('LBL_Unavailable_Dates', $siteLangId); ?></span>
                        </a>
                    </li>
                <?php } ?>
                <?php if ($userPrivilege->canViewSpecialPrice(UserAuthentication::getLoggedUserId(), true)) { ?>
                    <li
                        class="menu-sub-item <?php echo ($controller == 'seller' && $action == 'rentalspecialprice') ? 'is-active' : ''; ?>">
                        <a class="menu-sub-link" title="<?php echo Labels::getLabel('LBL_Special_Price', $siteLangId); ?>"
                            href="<?php echo UrlHelper::generateUrl('Seller', 'rentalSpecialPrice'); ?>">
                            <span class="menu-sub-icon"><svg class="svg" width="16" height="16">
                                    <use
                                        xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite-sidebar.svg#special-price">
                                    </use>
                                </svg>
                            </span>
                            <span class="menu-sub-head"><?php echo Labels::getLabel('LBL_Special_Price', $siteLangId); ?></span>
                        </a>
                    </li>
                <?php } ?>

                <?php /*if ($userPrivilege->canViewDurationDiscount(UserAuthentication::getLoggedUserId(), true)) { ?>
                    <li
                        class="menu-sub-item <?php echo ($controller == 'sellerinventories' && $action == 'sellerproductdurationdiscounts') ? 'is-active' : ''; ?>">
                        <a class="menu-sub-link" title="<?php echo Labels::getLabel('LBL_Duration_Discounts', $siteLangId); ?>"
                            href="<?php echo UrlHelper::generateUrl('SellerInventories', 'sellerProductDurationDiscounts'); ?>">
                            <span class="menu-sub-icon"><svg class="svg" width="16" height="16">
                                    <use
                                        xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite-sidebar.svg#duration-discount">
                                    </use>
                                </svg>
                            </span>
                            <span
                                class="menu-sub-head"><?php echo Labels::getLabel('LBL_Duration_Discounts', $siteLangId); ?></span>
                        </a>
                    </li>
                <?php }*/ ?>
                <?php if ($userPrivilege->canViewAddons(UserAuthentication::getLoggedUserId(), true) && FatApp::getConfig('CONF_ALLOW_RENTAL_SERVICES', FatUtility::VAR_INT, 0) == 1) { ?>
                    <li class="menu-sub-item <?php echo ($controller == 'attachaddonpoducts') ? 'is-active' : ''; ?>">
                        <a class="menu-sub-link" title="<?php echo Labels::getLabel('LBL_Link_Rental_Addons', $siteLangId); ?>"
                            href="<?php echo UrlHelper::generateUrl('attachAddonPoducts'); ?>">
                            <span class="menu-sub-icon">
                                <svg class="svg" width="16" height="16">
                                    <use
                                        xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite-sidebar.svg#rental-add-ons">
                                    </use>
                                </svg>
                            </span>
                            <span
                                class="menu-sub-head"><?php echo Labels::getLabel('LBL_Link_Rental_Addons', $siteLangId); ?></span>
                        </a>
                    </li>
                <?php } ?>

                <?php if (FatApp::getConfig("CONF_ENABLE_DOCUMENT_VERIFICATION", FatUtility::VAR_INT, 1) && User::canAddCustomProduct() && $userPrivilege->canViewVerificationFields(UserAuthentication::getLoggedUserId(), true)) { ?>
                    <li
                        class="menu-sub-item <?php echo ($controller == 'attachverificationfields' && $action == 'index') ? 'is-active' : ''; ?>">
                        <a class="menu-sub-link"
                            title="<?php echo Labels::getLabel('LBL_Link_Verification_Fields', $siteLangId); ?>"
                            href="<?php echo UrlHelper::generateUrl('AttachVerificationFields', 'index'); ?>">
                            <span class="menu-sub-icon">
                                <svg class="svg" width="16" height="16">
                                    <use
                                        xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite-sidebar.svg#verification-fields">
                                    </use>
                                </svg>
                            </span>
                            <span
                                class="menu-sub-head"><?php echo Labels::getLabel('LBL_Link_Verification_Fields', $siteLangId); ?></span>
                        </a>
                    </li>
                <?php } ?>
            </ul>
        </li>
    <?php } ?>


    <!-- SALE PRODUCTS & PROMOTIONS -->
    <?php if (ALLOW_SALE) { ?>

        <?php if (
            $userPrivilege->canViewProducts(UserAuthentication::getLoggedUserId(), true) ||
            $userPrivilege->canViewSpecialPrice(UserAuthentication::getLoggedUserId(), true) ||
            $userPrivilege->canViewVolumeDiscount(UserAuthentication::getLoggedUserId(), true)

        ) { ?>

            <li class="dashboard-menu-item">
                <?php
                $isControllerActive = in_array($controller, [
                    'seller',
                    'sellerinventories',
                ]);
                $isActionActive = in_array($action, [
                    'specialprice',
                    'volumediscount',
                ]);
                ?>
                <button
                    class="dashboard-menu-btn dropdown-toggle-custom <?php echo ($isControllerActive && $isActionActive ? '' : 'collapsed'); ?>"
                    type="button" data-bs-toggle="collapse" data-bs-target="#Sale_Products_Promotions"
                    aria-expanded="<?php echo ($isControllerActive && $isActionActive ? 'true' : 'false'); ?>"
                    aria-controls="collapseOne" title="">
                    <span class="dashboard-menu-icon">
                        <svg class="svg" width="18" height="18">
                            <use
                                xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite-sidebar.svg#promotion">
                            </use>
                        </svg>
                    </span>
                    <span class="dashboard-menu-head">
                        <?php echo Labels::getLabel("LBL_SALE_PRODUCTS_&_PROMOTIONS", $siteLangId); ?>
                    </span>
                    <i class="dashboard-menu-arrow dropdown-toggle-custom-arrow"></i>
                </button>

                <ul class="menu-sub menu-sub-accordion collapse <?php echo ($isControllerActive && $isActionActive ? 'show' : ''); ?>"
                    id="Sale_Products_Promotions" aria-labelledby="" data-parent="#dashboard-menu">
                    <?php if ($userPrivilege->canViewProducts(UserAuthentication::getLoggedUserId(), true)) { ?>
                        <li
                            class="menu-sub-item <?php echo ($controller == 'sellerinventories' && ($action == 'sales')) ? 'is-active' : ''; ?>">
                            <a class="menu-sub-link" title="<?php echo Labels::getLabel('LBL_Inventory', $siteLangId); ?>"
                                href="<?php echo UrlHelper::generateUrl('SellerInventories', 'sales'); ?>">
                                <span class="menu-sub-icon">
                                    <svg class="svg" width="16" height="16">
                                        <use
                                            xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite-sidebar.svg#inventory">
                                        </use>
                                    </svg>
                                </span>
                                <span class="menu-sub-head"><?php echo Labels::getLabel('LBL_Inventory', $siteLangId); ?></span>
                            </a>
                        </li>
                    <?php } ?>

                    <?php if ($userPrivilege->canViewSpecialPrice(UserAuthentication::getLoggedUserId(), true)) { ?>
                        <li
                            class="menu-sub-item <?php echo ($controller == 'seller' && $action == 'specialprice') ? 'is-active' : ''; ?>">
                            <a class="menu-sub-link" title="<?php echo Labels::getLabel('LBL_Special_Price', $siteLangId); ?>"
                                href="<?php echo UrlHelper::generateUrl('Seller', 'specialPrice'); ?>">
                                <span class="menu-sub-icon"><svg class="svg" width="16" height="16">
                                        <use
                                            xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite-sidebar.svg#special-price">
                                        </use>
                                    </svg>
                                </span>
                                <span class="menu-sub-head"><?php echo Labels::getLabel('LBL_Special_Price', $siteLangId); ?></span>
                            </a>
                        </li>
                    <?php } ?>
                    <?php if (ALLOW_SALE && $userPrivilege->canViewVolumeDiscount(UserAuthentication::getLoggedUserId(), true)) { ?>
                        <li
                            class="menu-sub-item <?php echo ($controller == 'sellerinventories' && $action == 'volumediscount') ? 'is-active' : ''; ?>">
                            <a class="menu-sub-link" title="<?php echo Labels::getLabel('LBL_Volume_Discount', $siteLangId); ?>"
                                href="<?php echo UrlHelper::generateUrl('sellerInventories', 'volumeDiscount'); ?>">
                                <span class="menu-sub-icon"><svg class="svg" width="16" height="16">
                                        <use
                                            xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite-sidebar.svg#volume-discount">
                                        </use>
                                    </svg>
                                </span>
                                <span
                                    class="menu-sub-head"><?php echo Labels::getLabel('LBL_Volume_Discount', $siteLangId); ?></span>
                            </a>
                        </li>
                    <?php } ?>
                </ul>
            </li>
        <?php }
    } ?>

    <!-- MORE PRODUCT OPTIONS -->

    <?php if (
        $userPrivilege->canViewBuyTogetherProducts(UserAuthentication::getLoggedUserId(), true) ||
        $userPrivilege->canViewRelatedProducts(UserAuthentication::getLoggedUserId(), true) ||
        $userPrivilege->canViewProductTags(UserAuthentication::getLoggedUserId(), true) ||
        $userPrivilege->canViewProductOptions(UserAuthentication::getLoggedUserId(), true) ||
        $userPrivilege->canViewTaxCategory(UserAuthentication::getLoggedUserId(), true) ||
        $userPrivilege->canViewSellerRequests(UserAuthentication::getLoggedUserId(), true) ||
        $userPrivilege->canViewAdvertisementFeed(UserAuthentication::getLoggedUserId(), true)

    ) { ?>

        <li class="dashboard-menu-item">
            <?php
            $isControllerActive = in_array($controller, [
                'seller',
                'sellerinventories',
                'sellerrequests',
            ]);
            $isActionActive = in_array($action, [
                'taxcategories',
                'taxrules',
                'options',
                'producttags',
                'relatedproducts',
                'upsellproducts',
            ]);
            ?>
            <button
                class="dashboard-menu-btn dropdown-toggle-custom <?php echo ($isControllerActive && $isActionActive ? '' : 'collapsed'); ?>"
                type="button" data-bs-toggle="collapse" data-bs-target="#More_Options"
                aria-expanded="<?php echo ($isControllerActive && $isActionActive ? 'true' : 'false'); ?>"
                aria-controls="collapseOne" title="">
                <span class="dashboard-menu-icon">
                    <svg class="svg" width="18" height="18">
                        <use
                            xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite-sidebar.svg#more-option">
                        </use>
                    </svg>
                </span>
                <span class="dashboard-menu-head">
                    <?php echo Labels::getLabel("LBL_MORE_OPTIONS", $siteLangId); ?>
                </span>
                <i class="dashboard-menu-arrow dropdown-toggle-custom-arrow"></i>
            </button>

            <ul class="menu-sub menu-sub-accordion collapse <?php echo ($isControllerActive && $isActionActive ? 'show' : ''); ?>"
                id="More_Options" aria-labelledby="" data-parent="#dashboard-menu">

                <?php if (ALLOW_SALE && $userPrivilege->canViewBuyTogetherProducts(UserAuthentication::getLoggedUserId(), true)) { ?>
                    <li
                        class="menu-sub-item <?php echo ($controller == 'sellerinventories' && $action == 'upsellproducts') ? 'is-active' : ''; ?>">
                        <a class="menu-sub-link"
                            title="<?php echo Labels::getLabel('LBL_Buy_Together_Products', $siteLangId); ?>"
                            href="<?php echo UrlHelper::generateUrl('sellerInventories', 'upsellProducts'); ?>">
                            <span class="menu-sub-icon"><svg class="svg" width="16" height="16">
                                    <use
                                        xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite-sidebar.svg#buy-together-products">
                                    </use>
                                </svg>
                            </span><span
                                class="menu-sub-head"><?php echo Labels::getLabel('LBL_Buy_Together_Products', $siteLangId); ?></span>
                        </a>
                    </li>
                <?php } ?>

                <?php if ($userPrivilege->canViewRelatedProducts(UserAuthentication::getLoggedUserId(), true)) { ?>
                    <li
                        class="menu-sub-item <?php echo ($controller == 'sellerinventories' && $action == 'relatedproducts') ? 'is-active' : ''; ?>">
                        <a class="menu-sub-link" title="<?php echo Labels::getLabel('LBL_Related_Products', $siteLangId); ?>"
                            href="<?php echo UrlHelper::generateUrl('sellerInventories', 'RelatedProducts'); ?>">
                            <span class="menu-sub-icon"><svg class="svg" width="16" height="16">
                                    <use
                                        xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite-sidebar.svg#related-products">
                                    </use>
                                </svg>
                            </span><span
                                class="menu-sub-head"><?php echo Labels::getLabel('LBL_Related_Products', $siteLangId); ?></span>
                        </a>
                    </li>
                <?php } ?>


                <?php if (User::canAddCustomProduct() && $userPrivilege->canViewProductTags(UserAuthentication::getLoggedUserId(), true)) { ?>
                    <li
                        class="menu-sub-item  <?php echo ($controller == 'seller' && $action == 'producttags') ? 'is-active' : ''; ?>">
                        <a class="menu-sub-link" title="<?php echo Labels::getLabel('LBL_Tags', $siteLangId); ?>"
                            href="<?php echo UrlHelper::generateUrl('Seller', 'productTags'); ?>">
                            <span class="menu-sub-icon"><svg class="svg" width="16" height="16">
                                    <use
                                        xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite-sidebar.svg#product-tags">
                                    </use>
                                </svg>
                            </span><span
                                class="menu-sub-head"><?php echo Labels::getLabel('LBL_Tags', $siteLangId); ?></span></a>
                    </li>
                <?php } ?>

                <?php
                $canAddCustomProd = FatApp::getConfig('CONF_ENABLED_SELLER_CUSTOM_PRODUCT', FatUtility::VAR_INT, 0);
                if (0 < $canAddCustomProd && $userPrivilege->canViewProductOptions(UserAuthentication::getLoggedUserId(), true)) {
                    ?>
                    <li
                        class="menu-sub-item <?php echo ($controller == 'seller' && $action == 'options') ? 'is-active' : ''; ?>">
                        <a class="menu-sub-link" title="<?php echo Labels::getLabel('LBL_Options', $siteLangId); ?>"
                            href="<?php echo UrlHelper::generateUrl('Seller', 'options'); ?>">
                            <span class="menu-sub-icon"><svg class="svg" width="16" height="16">
                                    <use
                                        xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite-sidebar.svg#options">
                                    </use>
                                </svg>
                            </span><span
                                class="menu-sub-head"><?php echo Labels::getLabel('LBL_Options', $siteLangId); ?></span></a>
                    </li>
                <?php } ?>

                <?php
                if (FatApp::getConfig('CONF_ENABLED_SELLER_CUSTOM_PRODUCT', FatUtility::VAR_INT, 0) && $userPrivilege->canViewTaxCategory(UserAuthentication::getLoggedUserId(), true)) { ?>
                    <li
                        class="menu-sub-item <?php echo ($controller == 'seller' && ($action == 'taxcategories' || $action == 'taxrules')) ? 'is-active' : ''; ?>">
                        <a class="menu-sub-link" title="<?php echo Labels::getLabel('LBL_Tax_Categories', $siteLangId); ?>"
                            href="<?php echo UrlHelper::generateUrl('Seller', 'taxCategories'); ?>">
                            <span class="menu-sub-icon"><svg class="svg" width="16" height="16">
                                    <use
                                        xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite-sidebar.svg#tax-categories">
                                    </use>
                                </svg>
                            </span><span
                                class="menu-sub-head"><?php echo Labels::getLabel('LBL_Tax_Categories', $siteLangId); ?></span></a>
                    </li>
                    <?php
                } ?>

                <?php if ($userPrivilege->canViewSellerRequests(UserAuthentication::getLoggedUserId(), true) && $isRequsetCount) { ?>
                    <li
                        class="menu-sub-item <?php echo ($controller == 'sellerrequests' && $action == 'index') ? 'is-active' : ''; ?>">
                        <a class="menu-sub-link" title="<?php echo Labels::getLabel('LBL_Requests', $siteLangId); ?>"
                            href="<?php echo UrlHelper::generateUrl('SellerRequests'); ?>">
                            <span class="menu-sub-icon"><svg class="svg" width="16" height="16">
                                    <use
                                        xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite-sidebar.svg#requests">
                                    </use>
                                </svg>
                            </span><span
                                class="menu-sub-head"><?php echo Labels::getLabel('LBL_Requests', $siteLangId); ?></span></a>
                    </li>
                <?php } ?>

                <?php
                $obj = new Plugin();
                $pluginData = $obj->getDefaultPluginData(Plugin::TYPE_ADVERTISEMENT_FEED, null, $siteLangId);
                if (false !== $pluginData && !empty($pluginData) && 0 < $pluginData['plugin_active'] && $userPrivilege->canViewAdvertisementFeed(UserAuthentication::getLoggedUserId(), true)) {
                    ?>
                    <li
                        class="menu-sub-item <?php echo ($controller == strtolower($pluginData['plugin_code'])) ? 'is-active' : ''; ?>">
                        <a class="menu-sub-link" title="<?php echo $pluginData['plugin_name']; ?>"
                            href="<?php echo UrlHelper::generateUrl($pluginData['plugin_code']); ?>">
                            <span class="menu-sub-icon">
                                <svg class="svg" width="16" height="16">
                                    <use
                                        xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite-sidebar.svg#dash-promotions">
                                    </use>
                                </svg>
                            </span>
                            <span class="menu-sub-head"><?php echo $pluginData['plugin_name']; ?></span>
                        </a>
                    </li>
                <?php } ?>

            </ul>
        </li>

    <?php } ?>


    <?php
    if (
        $userPrivilege->canViewSales(UserAuthentication::getLoggedUserId(), true) ||
        $userPrivilege->canViewOrderCancelRules(UserAuthentication::getLoggedUserId(), true) ||
        $userPrivilege->canViewCancellationRequests(UserAuthentication::getLoggedUserId(), true) ||
        $userPrivilege->canViewReturnRequests(UserAuthentication::getLoggedUserId(), true) ||
        $userPrivilege->canViewUpcomingProductReturns(UserAuthentication::getLoggedUserId(), true) ||
        (FatApp::getConfig('CONF_ENABLE_RENTAL_PRODUCT_LATE_CHARGES_MODULE', FatUtility::VAR_INT, 0) && $userPrivilege->canViewLateChargesManagement(UserAuthentication::getLoggedUserId(), true))
    ) {
        ?>
        <!-- RENTAL ORDERS -->

        <li class="dashboard-menu-item">
            <?php
            $isControllerActive = in_array($controller, [
                'sellerorders',
                'seller',
                'ordercancelrules',
                'latecharges',
                'productreturns',
            ]);
            $isActionActive = in_array($action, [
                'rentals',
                'latechargeshistory',
                'rentalordercancellationrequests',
                'cancelpenaltyhistory',
                'rentalorderreturnrequests',
                'upcomingproductreturns',
                'overdueproductreturns',
            ]);
            ?>
            <button
                class="dashboard-menu-btn dropdown-toggle-custom <?php echo ($isControllerActive && $isActionActive ? '' : 'collapsed'); ?>"
                type="button" data-bs-toggle="collapse" data-bs-target="#Rental_Orders"
                aria-expanded="<?php echo ($isControllerActive && $isActionActive ? 'true' : 'false'); ?>"
                aria-controls="collapseOne" title="">
                <span class="dashboard-menu-icon">
                    <svg class="svg" width="18" height="18">
                        <use
                            xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite-sidebar.svg#rental-orders">
                        </use>
                    </svg>
                </span>
                <span class="dashboard-menu-head">
                    <?php echo Labels::getLabel("LBL_RENTAL_ORDERS", $siteLangId); ?>
                </span>
                <i class="dashboard-menu-arrow dropdown-toggle-custom-arrow"></i>
            </button>

            <ul class="menu-sub menu-sub-accordion collapse <?php echo ($isControllerActive && $isActionActive ? 'show' : ''); ?>"
                id="Rental_Orders" aria-labelledby="" data-parent="#dashboard-menu">

                <?php if ($userPrivilege->canViewSales(UserAuthentication::getLoggedUserId(), true)) { ?>
                    <li
                        class="menu-sub-item <?php echo ($controller == 'sellerorders' && ($action == 'rentals')) ? 'is-active' : ''; ?>">
                        <a class="menu-sub-link" title="<?php echo Labels::getLabel('LBL_Orders', $siteLangId); ?>"
                            href="<?php echo UrlHelper::generateUrl('sellerOrders', 'rentals'); ?>">
                            <span class="menu-sub-icon"><svg class="svg" width="16" height="16">
                                    <use
                                        xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite-sidebar.svg#order-rental">
                                    </use>
                                </svg>
                            </span>
                            <span class="menu-sub-head"><?php echo Labels::getLabel('LBL_Orders', $siteLangId); ?></span>
                        </a>
                    </li>
                    <?php if ($userPrivilege->canViewLateChargesManagement(UserAuthentication::getLoggedUserId(), true)) { ?>
                        <li
                            class="menu-sub-item <?php echo ($controller == 'sellerorders' && (strtolower($action) == 'latechargeshistory')) ? 'is-active' : ''; ?>">
                            <a class="menu-sub-link"
                                title="<?php echo Labels::getLabel('LBL_Late_Charges_History', $siteLangId); ?>"
                                href="<?php echo UrlHelper::generateUrl('sellerOrders', 'lateChargesHistory'); ?>">
                                <span class="menu-sub-icon"><svg class="svg" width="16" height="16">
                                        <use
                                            xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite-sidebar.svg#late-charges-management">
                                        </use>
                                    </svg>
                                </span>
                                <span
                                    class="menu-sub-head"><?php echo Labels::getLabel('LBL_Late_Charges_History', $siteLangId); ?></span>
                            </a>
                        </li>
                    <?php } ?>
                <?php } ?>
                <?php if ($userPrivilege->canViewCancellationRequests(UserAuthentication::getLoggedUserId(), true)) { ?>
                    <li
                        class="menu-sub-item <?php echo ($controller == 'seller' && $action == 'rentalordercancellationrequests') ? 'is-active' : '' ?>">
                        <a class="menu-sub-link"
                            title="<?php echo Labels::getLabel('LBL_Cancellation_Requests', $siteLangId); ?>"
                            href="<?php echo UrlHelper::generateUrl('Seller', 'rentalOrderCancellationRequests'); ?>">
                            <span class="menu-sub-icon">
                                <svg class="svg" width="16" height="16">
                                    <use
                                        xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite-sidebar.svg#order-cancel-request">
                                    </use>
                                </svg>
                            </span><span
                                class="menu-sub-head"><?php echo Labels::getLabel("LBL_Cancellation_Requests", $siteLangId); ?></span>
                        </a>
                    </li>

                    <li
                        class="menu-sub-item <?php echo ($controller == 'sellerorders' && (strtolower($action) == 'cancelpenaltyhistory')) ? 'is-active' : ''; ?>">
                        <a class="menu-sub-link"
                            title="<?php echo Labels::getLabel('LBL_Late_Charges_History', $siteLangId); ?>"
                            href="<?php echo UrlHelper::generateUrl('sellerOrders', 'cancelPenaltyHistory'); ?>">
                            <span class="menu-sub-icon"><svg class="svg" width="16" height="16">
                                    <use
                                        xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite-sidebar.svg#order-cancel-request">
                                    </use>
                                </svg>
                            </span>
                            <span
                                class="menu-sub-head"><?php echo Labels::getLabel('LBL_Cancellation_Penalty_History', $siteLangId); ?></span>
                        </a>
                    </li>
                <?php } ?>
                <?php if ($userPrivilege->canViewReturnRequests(UserAuthentication::getLoggedUserId(), true)) { ?>
                    <li
                        class="menu-sub-item <?php echo ($controller == 'seller' && ($action == 'rentalorderreturnrequests')) ? 'is-active' : ''; ?>">
                        <a class="menu-sub-link" title="<?php echo Labels::getLabel('LBL_Return_Requests', $siteLangId); ?>"
                            href="<?php echo UrlHelper::generateUrl('Seller', 'rentalOrderReturnRequests'); ?>">
                            <span class="menu-sub-icon"><svg class="svg" width="16" height="16">
                                    <use
                                        xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite-sidebar.svg#order-return-request">
                                    </use>
                                </svg>
                            </span>
                            <span
                                class="menu-sub-head"><?php echo Labels::getLabel("LBL_Return_Requests", $siteLangId); ?></span>
                        </a>
                    </li>
                <?php } ?>
                <?php if (FatApp::getConfig('CONF_ALLOW_PENALTY_ON_RENTAL_ORDER_CANCEL_FROM_BUYER', FatUtility::VAR_INT, 0)) { ?>
                    <?php if ($userPrivilege->canViewOrderCancelRules(UserAuthentication::getLoggedUserId(), true)) { ?>
                        <li class="menu-sub-item <?php echo ($controller == 'ordercancelrules') ? 'is-active' : ''; ?>">
                            <a class="menu-sub-link"
                                title="<?php echo Labels::getLabel('LBL_Cancellation_Penalty_Rules', $siteLangId); ?>"
                                href="<?php echo UrlHelper::generateUrl('orderCancelRules'); ?>">
                                <span class="menu-sub-icon"><svg class="svg" width="16" height="16">
                                        <use
                                            xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite-sidebar.svg#cancellation-penalty-rules">
                                        </use>
                                    </svg>
                                </span>
                                <span
                                    class="menu-sub-head"><?php echo Labels::getLabel("LBL_Cancellation_Penalty_Rules", $siteLangId); ?></span>
                            </a>
                        </li>
                    <?php }
                } ?>
                <?php
                $isModuleActiveOnShop = Shop::getAttributesByUserId(UserAuthentication::getLoggedUserId(), 'shop_is_enable_late_charges');
                if (FatApp::getConfig('CONF_ENABLE_RENTAL_PRODUCT_LATE_CHARGES_MODULE', FatUtility::VAR_INT, 0) && $userPrivilege->canViewLateChargesManagement(UserAuthentication::getLoggedUserId(), true) && $isModuleActiveOnShop) { ?>
                    <li class="menu-sub-item <?php echo ($controller == 'latecharges') ? 'is-active' : ''; ?>">
                        <a class="menu-sub-link"
                            title="<?php echo Labels::getLabel('LBL_Late_Charges_Management', $siteLangId); ?>"
                            href="<?php echo UrlHelper::generateUrl('lateCharges'); ?>">
                            <span class="menu-sub-icon"><svg class="svg" width="16" height="16">
                                    <use
                                        xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite-sidebar.svg#late-charges-management">
                                    </use>
                                </svg>
                            </span>
                            <span
                                class="menu-sub-head"><?php echo Labels::getLabel("LBL_Late_Charges_Management", $siteLangId); ?></span>
                        </a>
                    </li>
                <?php } ?>
                <?php if ($userPrivilege->canViewUpcomingProductReturns(UserAuthentication::getLoggedUserId(), true)) { ?>
                    <li
                        class="menu-sub-item <?php echo ($controller == 'productreturns' && ($action == 'upcomingproductreturns' || $action == 'overdueproductreturns')) ? 'is-active' : ''; ?>">
                        <a class="menu-sub-link"
                            title="<?php echo Labels::getLabel('LBL_Upcoming/Overdue_Returns', $siteLangId); ?>"
                            href="<?php echo UrlHelper::generateUrl('ProductReturns', 'upcomingProductReturns'); ?>">
                            <span class="menu-sub-icon">
                                <svg class="svg" width="16" height="16">
                                    <use
                                        xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite-sidebar.svg#upcoming-overdue-returns">
                                    </use>
                                </svg>
                            </span>
                            <span class="menu-sub-head">
                                <?php echo Labels::getLabel('LBL_Upcoming/Overdue_Returns', $siteLangId); ?>
                            </span>
                        </a>
                    </li>
                <?php } ?>
            </ul>
        </li>
    <?php } ?>

    <?php
    if (($userPrivilege->canViewOfferManagement(UserAuthentication::getLoggedUserId(), true))) {
        ?>
        <!-- RFQ -->
        <li class="dashboard-menu-item">

            <?php
            $isControllerActive = in_array($controller, [
                'requestforquotes',
            ]);
            $isActionActive = in_array($action, [
                'productquotes',
                'acceptedoffers',
                'rejectedoffers',
                'rfqorder'
            ]);
            ?>
            <button
                class="dashboard-menu-btn dropdown-toggle-custom <?php echo ($isControllerActive && $isActionActive ? '' : 'collapsed'); ?>"
                type="button" data-bs-toggle="collapse" data-bs-target="#Request_for_quotes"
                aria-expanded="<?php echo ($isControllerActive && $isActionActive ? 'true' : 'false'); ?>"
                aria-controls="collapseOne" title="">
                <span class="dashboard-menu-icon">
                    <svg class="svg" width="18" height="18">
                        <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite-sidebar.svg#rfq">
                        </use>
                    </svg>
                </span>
                <span class="dashboard-menu-head">
                    <?php echo Labels::getLabel("LBL_REQUEST_FOR_QUOTES", $siteLangId); ?>
                </span>
                <i class="dashboard-menu-arrow dropdown-toggle-custom-arrow"></i>
            </button>

            <ul class="menu-sub menu-sub-accordion collapse <?php echo ($isControllerActive && $isActionActive ? 'show' : ''); ?>"
                id="Request_for_quotes" aria-labelledby="" data-parent="#dashboard-menu">

                <li
                    class="menu-sub-item <?php echo ($controller == 'requestforquotes' && $action == 'productquotes') ? 'is-active' : ''; ?>">
                    <a class="menu-sub-link" title="<?php echo Labels::getLabel('LBL_In-progress', $siteLangId); ?>"
                        href="<?php echo UrlHelper::generateUrl('RequestForQuotes', 'productQuotes'); ?>">
                        <span class="menu-sub-icon">
                            <svg class="svg" width="16" height="16">
                                <use
                                    xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite-sidebar.svg#sale-order">
                                </use>
                            </svg>
                        </span><span
                            class="menu-sub-head"><?php echo Labels::getLabel('LBL_In-progress', $siteLangId); ?></span></a>
                </li>

                <li
                    class="menu-sub-item <?php echo ($controller == 'requestforquotes' && $action == 'acceptedoffers') ? 'is-active' : ''; ?>">
                    <a class="menu-sub-link" title="<?php echo Labels::getLabel('LBL_Accepted', $siteLangId); ?>"
                        href="<?php echo UrlHelper::generateUrl('RequestForQuotes', 'AcceptedOffers'); ?>">
                        <span class="menu-sub-icon"><svg class="svg" width="16" height="16">
                                <use
                                    xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite-sidebar.svg#RFQ-accepted">
                                </use>
                            </svg>
                        </span><span
                            class="menu-sub-head"><?php echo Labels::getLabel('LBL_Accepted', $siteLangId); ?></span></a>
                </li>
                <li
                    class="menu-sub-item <?php echo ($controller == 'requestforquotes' && $action == 'rejectedoffers') ? 'is-active' : ''; ?>">
                    <a class="menu-sub-link" title="<?php echo Labels::getLabel('LBL_Rejected', $siteLangId); ?>"
                        href="<?php echo UrlHelper::generateUrl('RequestForQuotes', 'rejectedOffers'); ?>">
                        <span class="menu-sub-icon"><svg class="svg" width="16" height="16">
                                <use
                                    xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite-sidebar.svg#RFQ-rejected">
                                </use>
                            </svg>
                        </span><span
                            class="menu-sub-head"><?php echo Labels::getLabel('LBL_Rejected', $siteLangId); ?></span></a>
                </li>
                <?php if ($userPrivilege->canViewSales(UserAuthentication::getLoggedUserId(), true)) { ?>
                    <li
                        class="menu-sub-item <?php echo ($controller == 'requestforquotes' && ($action == 'rfqorder' || $action == 'vieworder')) ? 'is-active' : ''; ?>">
                        <a class="menu-sub-link" title="<?php echo Labels::getLabel('LBL_RFQ_Orders', $siteLangId); ?>"
                            href="<?php echo UrlHelper::generateUrl('RequestForQuotes', 'rfqOrder'); ?>">
                            <span class="menu-sub-icon"><svg class="svg" width="16" height="16">
                                    <use
                                        xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite-sidebar.svg#RFQ-order">
                                    </use>
                                </svg>
                            </span><span
                                class="menu-sub-head"><?php echo Labels::getLabel('LBL_Orders', $siteLangId); ?></span></a>
                    </li>
                <?php } ?>
            </ul>
        </li>
    <?php } ?>


    <?php if (FatApp::getConfig("CONF_ALLOW_SALE", FatUtility::VAR_INT, 0)) { ?>
        <?php
        if (
            $userPrivilege->canViewSales(UserAuthentication::getLoggedUserId(), true) ||
            $userPrivilege->canViewCancellationRequests(UserAuthentication::getLoggedUserId(), true) ||
            $userPrivilege->canViewReturnRequests(UserAuthentication::getLoggedUserId(), true)
        ) {
            ?>
            <li class="dashboard-menu-item">
                <?php
                $isControllerActive = in_array($controller, [
                    'seller',
                ]);
                $isActionActive = in_array($action, [
                    'ordercancellationrequests',
                    'orderreturnrequests',
                    'sales',
                ]);
                ?>
                <button
                    class="dashboard-menu-btn dropdown-toggle-custom <?php echo ($isControllerActive && $isActionActive ? '' : 'collapsed'); ?>"
                    type="button" data-bs-toggle="collapse" data-bs-target="#Sale_orders"
                    aria-expanded="<?php echo ($isControllerActive && $isActionActive ? 'true' : 'false'); ?>"
                    aria-controls="collapseOne" title="">
                    <span class="dashboard-menu-icon">
                        <svg class="svg" width="18" height="18">
                            <use
                                xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite-sidebar.svg#sale-order">
                            </use>
                        </svg>
                    </span>
                    <span class="dashboard-menu-head">
                        <?php echo Labels::getLabel("LBL_Sale_Orders", $siteLangId); ?>
                    </span>
                    <i class="dashboard-menu-arrow dropdown-toggle-custom-arrow"></i>
                </button>
                <ul class="menu-sub menu-sub-accordion collapse <?php echo ($isControllerActive && $isActionActive ? 'show' : ''); ?>"
                    id="Sale_orders" aria-labelledby="" data-parent="#dashboard-menu">

                    <?php if ($userPrivilege->canViewSales(UserAuthentication::getLoggedUserId(), true)) { ?>
                        <li
                            class="menu-sub-item <?php echo ($controller == 'seller' && ($action == 'sales')) ? 'is-active' : ''; ?>">
                            <a class="menu-sub-link" title="<?php echo Labels::getLabel('LBL_Orders', $siteLangId); ?>"
                                href="<?php echo UrlHelper::generateUrl('Seller', 'Sales'); ?>">
                                <span class="menu-sub-icon"><svg class="svg" width="16" height="16">
                                        <use
                                            xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite-sidebar.svg#order-sales">
                                        </use>
                                    </svg>
                                </span><span
                                    class="menu-sub-head"><?php echo Labels::getLabel('LBL_Orders', $siteLangId); ?></span></a>
                        </li>
                    <?php } ?>
                    <?php if ($userPrivilege->canViewCancellationRequests(UserAuthentication::getLoggedUserId(), true)) { ?>
                        <li
                            class="menu-sub-item <?php echo ($controller == 'seller' && $action == 'ordercancellationrequests') ? 'is-active' : '' ?>">
                            <a class="menu-sub-link"
                                title="<?php echo Labels::getLabel('LBL_Order_Cancellation_Requests', $siteLangId); ?>"
                                href="<?php echo UrlHelper::generateUrl('Seller', 'orderCancellationRequests'); ?>">
                                <span class="menu-sub-icon"><svg class="svg" width="16" height="16">
                                        <use
                                            xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite-sidebar.svg#order-cancel-request">
                                        </use>
                                    </svg>
                                </span><span
                                    class="menu-sub-head"><?php echo Labels::getLabel("LBL_Order_Cancellation_Requests", $siteLangId); ?></span></a>
                        </li>
                    <?php } ?>
                    <?php if ($userPrivilege->canViewReturnRequests(UserAuthentication::getLoggedUserId(), true)) { ?>
                        <li
                            class="menu-sub-item <?php echo ($controller == 'seller' && ($action == 'orderreturnrequests')) ? 'is-active' : ''; ?>">
                            <a class="menu-sub-link" title="<?php echo Labels::getLabel('LBL_Return_Requests', $siteLangId); ?>"
                                href="<?php echo UrlHelper::generateUrl('Seller', 'orderReturnRequests'); ?>">
                                <span class="menu-sub-icon"><svg class="svg" width="16" height="16">
                                        <use
                                            xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite-sidebar.svg#order-return-request">
                                        </use>
                                    </svg>
                                </span><span
                                    class="menu-sub-head"><?php echo Labels::getLabel("LBL_Return_Requests", $siteLangId); ?></span></a>
                        </li>
                    <?php } ?>
                </ul>
            </li>
        <?php } ?>

    <?php } ?>
    <?php
    $fulFillmentType = Shop::getAttributesByUserId($userParentId, 'shop_fulfillment_type', false);
    if ( /* FatApp::getConfig('CONF_ENABLED_SELLER_CUSTOM_PRODUCT', FatUtility::VAR_INT, 0) && */
        ($userPrivilege->canViewShippingProfiles(UserAuthentication::getLoggedUserId(), true) ||
            $userPrivilege->canViewShippingPackages(UserAuthentication::getLoggedUserId(), true) ||
            ($userPrivilege->canViewLinkPickupSection(UserAuthentication::getLoggedUserId(), true)) && $fulFillmentType != Shipping::FULFILMENT_SHIP)
    ) {
        ?>
        <li class="dashboard-menu-item">
            <?php
            $isControllerActive = in_array($controller, [
                'shippingprofile',
                'shippingpackages',
                'linkpickupaddress',
            ]);
            $isActionActive = in_array($action, [
                'index',
            ]);
            ?>
            <button
                class="dashboard-menu-btn dropdown-toggle-custom <?php echo ($isControllerActive && $isActionActive ? '' : 'collapsed'); ?>"
                type="button" data-bs-toggle="collapse" data-bs-target="#Shipping_fullfillment"
                aria-expanded="<?php echo ($isControllerActive && $isActionActive ? 'true' : 'false'); ?>"
                aria-controls="collapseOne" title="">
                <span class="dashboard-menu-icon">
                    <svg class="svg" width="18" height="18">
                        <use
                            xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite-sidebar.svg#shipping">
                        </use>
                    </svg>
                </span>
                <span class="dashboard-menu-head">
                    <?php echo Labels::getLabel("LBL_SHIPPING_&_FULLFILMENT", $siteLangId); ?>
                </span>
                <i class="dashboard-menu-arrow dropdown-toggle-custom-arrow"></i>
            </button>
            <ul class="menu-sub menu-sub-accordion collapse <?php echo ($isControllerActive && $isActionActive ? 'show' : ''); ?>"
                id="Shipping_fullfillment" aria-labelledby="" data-parent="#dashboard-menu">
                <?php if ($userPrivilege->canViewShippingProfiles(UserAuthentication::getLoggedUserId(), true) /* && !FatApp::getConfig('CONF_SHIPPED_BY_ADMIN_ONLY', FatUtility::VAR_INT, 0) */) { ?>
                    <li class="menu-sub-item  <?php echo ($controller == 'shippingprofile') ? 'is-active' : ''; ?>">
                        <a class="menu-sub-link" title="<?php echo Labels::getLabel('LBL_Shipping_Profiles', $siteLangId); ?>"
                            href="<?php echo UrlHelper::generateUrl('shippingProfile'); ?>">
                            <span class="menu-sub-icon">
                                <svg class="svg" width="16" height="16">
                                    <use
                                        xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite-sidebar.svg#shipping-profile">
                                    </use>
                                </svg>
                            </span><span
                                class="menu-sub-head"><?php echo Labels::getLabel('LBL_Shipping_Profiles', $siteLangId); ?></span></a>
                    </li>
                <?php } ?>
                <?php if ($userPrivilege->canViewShippingPackages(UserAuthentication::getLoggedUserId(), true) && FatApp::getConfig("CONF_PRODUCT_DIMENSIONS_ENABLE", FatUtility::VAR_INT, 1)) { ?>
                    <li class="menu-sub-item <?php echo ($controller == 'shippingpackages') ? 'is-active' : ''; ?>">
                        <a class="menu-sub-link" title="<?php echo Labels::getLabel('LBL_Shipping_Packages', $siteLangId); ?>"
                            href="<?php echo UrlHelper::generateUrl('shippingPackages'); ?>">
                            <span class="menu-sub-icon">
                                <svg class="svg" width="16" height="16">
                                    <use
                                        xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite-sidebar.svg#shipping-package">
                                    </use>
                                </svg>
                            </span><span
                                class="menu-sub-head"><?php echo Labels::getLabel('LBL_Shipping_Packages', $siteLangId); ?></span></a>
                    </li>
                <?php } ?>
                <?php
                $fulFillmentType = Shop::getAttributesByUserId($userParentId, 'shop_fulfillment_type', false);
                if ($userPrivilege->canViewLinkPickupSection(UserAuthentication::getLoggedUserId(), true) && $fulFillmentType != Shipping::FULFILMENT_SHIP) { ?>
                    <li
                        class="menu-sub-item <?php echo ($controller == 'linkpickupaddress' && $action == 'index') ? 'is-active' : ''; ?>">
                        <a class="menu-sub-link"
                            title="<?php echo Labels::getLabel('LBL_Link_Products_with_Pickup_Address', $siteLangId); ?>"
                            href="<?php echo UrlHelper::generateUrl('LinkPickupAddress', 'index'); ?>">
                            <span class="menu-sub-icon">
                                <svg class="svg" width="16" height="16">
                                    <use
                                        xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite-sidebar.svg#link-products-pickup-add">
                                    </use>
                                </svg>
                            </span><span
                                class="menu-sub-head"><?php echo Labels::getLabel('LBL_Link_Products_with_Pickup_Address', $siteLangId); ?></span></a>
                    </li>
                <?php } ?>
            </ul>
        </li>
    <?php } ?>

    <?php
    if (
        $userPrivilege->canViewMetaTags(UserAuthentication::getLoggedUserId(), true) ||
        $userPrivilege->canViewUrlRewriting(UserAuthentication::getLoggedUserId(), true)
    ) {
        ?>
        <li class="dashboard-menu-item">
            <?php
            $isControllerActive = in_array($controller, [
                'seller',
            ]);
            $isActionActive = in_array($action, [
                'productseo',
                'producturlrewriting',
            ]);
            ?>
            <button
                class="dashboard-menu-btn dropdown-toggle-custom <?php echo ($isControllerActive && $isActionActive ? '' : 'collapsed'); ?>"
                type="button" data-bs-toggle="collapse" data-bs-target="#Seo"
                aria-expanded="<?php echo ($isControllerActive && $isActionActive ? 'true' : 'false'); ?>"
                aria-controls="collapseOne" title="">
                <span class="dashboard-menu-icon">
                    <svg class="svg" width="18" height="18">Seo
                        <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite-sidebar.svg#seo">
                        </use>
                    </svg>
                </span>
                <span class="dashboard-menu-head">
                    <?php echo Labels::getLabel("LBL_SEO", $siteLangId); ?>
                </span>
                <i class="dashboard-menu-arrow dropdown-toggle-custom-arrow"></i>
            </button>
            <ul class="menu-sub menu-sub-accordion collapse <?php echo ($isControllerActive && $isActionActive ? 'show' : ''); ?>"
                id="Seo" aria-labelledby="" data-parent="#dashboard-menu">
                <?php if ($userPrivilege->canViewMetaTags(UserAuthentication::getLoggedUserId(), true)) { ?>
                    <li
                        class="menu-sub-item <?php echo ($controller == 'seller' && $action == 'productseo') ? 'is-active' : ''; ?>">
                        <a class="menu-sub-link" title="<?php echo Labels::getLabel('LBL_Meta_Tags', $siteLangId); ?>"
                            href="<?php echo UrlHelper::generateUrl('seller', 'productSeo'); ?>">
                            <span class="menu-sub-icon"><svg class="svg" width="16" height="16">
                                    <use
                                        xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite-sidebar.svg#meta-tags">
                                    </use>
                                </svg>
                            </span>
                            <span class="menu-sub-head"><?php echo Labels::getLabel('LBL_Meta_Tags', $siteLangId); ?></span>
                        </a>
                    </li>
                <?php } ?>
                <?php if ($userPrivilege->canViewUrlRewriting(UserAuthentication::getLoggedUserId(), true)) { ?>
                    <li
                        class="menu-sub-item <?php echo ($controller == 'seller' && $action == 'producturlrewriting') ? 'is-active' : ''; ?>">
                        <a class="menu-sub-link" title="<?php echo Labels::getLabel('LBL_URL_Rewriting', $siteLangId); ?>"
                            href="<?php echo UrlHelper::generateUrl('seller', 'productUrlRewriting'); ?>">
                            <span class="menu-sub-icon"><svg class="svg" width="16" height="16">
                                    <use
                                        xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite-sidebar.svg#URL-rewriting">
                                    </use>
                                </svg>
                            </span><span
                                class="menu-sub-head"><?php echo Labels::getLabel('LBL_URL_Rewriting', $siteLangId); ?></span></a>
                    </li>
                <?php } ?>
            </ul>
        </li>
    <?php } ?>

    <?php
    if (
        $userPrivilege->canViewSalesReport(UserAuthentication::getLoggedUserId(), true) ||
        $userPrivilege->canViewPerformanceReport(UserAuthentication::getLoggedUserId(), true) ||
        $userPrivilege->canViewInventoryReport(UserAuthentication::getLoggedUserId(), true)
    ) {
        ?>
        <li class="dashboard-menu-item">
            <?php
            $isControllerActive = in_array($controller, [
                'reports',
            ]);
            $isActionActive = in_array($action, [
                'rentalreport',
                'salesreport',
                'productsperformance',
                'productsinventory',
                'productsinventorystockstatus'
            ]);
            ?>
            <button
                class="dashboard-menu-btn dropdown-toggle-custom <?php echo ($isControllerActive && $isActionActive ? '' : 'collapsed'); ?>"
                type="button" data-bs-toggle="collapse" data-bs-target="#Reports"
                aria-expanded="<?php echo ($isControllerActive && $isActionActive ? 'true' : 'false'); ?>"
                aria-controls="collapseOne" title="">
                <span class="dashboard-menu-icon">
                    <svg class="svg" width="18" height="18">
                        <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite-sidebar.svg#reports">
                        </use>
                    </svg>
                </span>
                <span class="dashboard-menu-head">
                    <?php echo Labels::getLabel("LBL_Reports", $siteLangId); ?>
                </span>
                <i class="dashboard-menu-arrow dropdown-toggle-custom-arrow"></i>
            </button>

            <ul class="menu-sub menu-sub-accordion collapse <?php echo ($isControllerActive && $isActionActive ? 'show' : ''); ?>"
                id="Reports" aria-labelledby="" data-parent="#dashboard-menu">

                <?php if ($userPrivilege->canViewSalesReport(UserAuthentication::getLoggedUserId(), true)) { ?>
                    <li
                        class="menu-sub-item <?php echo ($controller == 'reports' && $action == 'rentalreport') ? 'is-active' : ''; ?>">
                        <a class="menu-sub-link" title="<?php echo Labels::getLabel('LBL_Rental_Report', $siteLangId); ?>"
                            href="<?php echo UrlHelper::generateUrl('Reports', 'rentalReport'); ?>">
                            <span class="menu-sub-icon"><svg class="svg" width="16" height="16">
                                    <use
                                        xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite-sidebar.svg#rental-report">
                                    </use>
                                </svg>
                            </span>
                            <span class="menu-sub-head"><?php echo Labels::getLabel('LBL_Rental_Report', $siteLangId); ?></span>
                        </a>
                    </li>
                    <?php if (FatApp::getConfig("CONF_ALLOW_SALE", FatUtility::VAR_INT, 0)) { ?>
                        <li
                            class="menu-sub-item <?php echo ($controller == 'reports' && $action == 'salesreport') ? 'is-active' : ''; ?>">
                            <a class="menu-sub-link" title="<?php echo Labels::getLabel('LBL_Sales_Report', $siteLangId); ?>"
                                href="<?php echo UrlHelper::generateUrl('Reports', 'SalesReport'); ?>">
                                <span class="menu-sub-icon"><svg class="svg" width="16" height="16">
                                        <use
                                            xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite-sidebar.svg#sales-report">
                                        </use>
                                    </svg>
                                </span><span
                                    class="menu-sub-head"><?php echo Labels::getLabel('LBL_Sales_Report', $siteLangId); ?></span>
                            </a>
                        </li>
                    <?php }
                } ?>
                <?php if ($userPrivilege->canViewPerformanceReport(UserAuthentication::getLoggedUserId(), true)) { ?>
                    <li
                        class="menu-sub-item <?php echo ($controller == 'reports' && $action == 'productsperformance') ? 'is-active' : ''; ?>">
                        <a class="menu-sub-link"
                            title="<?php echo Labels::getLabel('LBL_PRODUCTS_PERFORMANCE_REPORT', $siteLangId); ?>"
                            href="<?php echo UrlHelper::generateUrl('Reports', 'ProductsPerformance'); ?>">
                            <span class="menu-sub-icon"><svg class="svg" width="16" height="16">
                                    <use
                                        xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite-sidebar.svg#product-performance-report">
                                    </use>
                                </svg>
                            </span><span
                                class="menu-sub-head"><?php echo Labels::getLabel('LBL_PRODUCTS_PERFORMANCE_REPORT', $siteLangId); ?></span></a>
                    </li>
                <?php } ?>
                <?php if ($userPrivilege->canViewInventoryReport(UserAuthentication::getLoggedUserId(), true)) { ?>
                    <li
                        class="menu-sub-item <?php echo ($controller == 'reports' && $action == 'productsinventory') ? 'is-active' : ''; ?>">
                        <a class="menu-sub-link" title="<?php echo Labels::getLabel('LBL_Products_Inventory', $siteLangId); ?>"
                            href="<?php echo UrlHelper::generateUrl('Reports', 'productsInventory'); ?>">
                            <span class="menu-sub-icon"><svg class="svg" width="16" height="16">
                                    <use
                                        xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite-sidebar.svg#products-inventory">
                                    </use>
                                </svg>
                            </span><span
                                class="menu-sub-head"><?php echo Labels::getLabel('LBL_Products_Inventory', $siteLangId); ?></span></a>
                    </li>
                    <?php /*
                                                                                   <li class="menu-sub-item <?php echo ($controller == 'reports' && $action == 'productsinventorystockstatus') ? 'is-active' : ''; ?>">
               <a class="menu-sub-link"
                   title="<?php echo Labels::getLabel('LBL_Products_Inventory_Stock_Status', $siteLangId); ?>"
                   href="<?php echo UrlHelper::generateUrl('Reports', 'productsInventoryStockStatus'); ?>">
                   <span class="menu-sub-icon"><svg class="svg" width="16" height="16">
                           <use
                               xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite-sidebar.svg#product-inventory-stock">
                           </use>
                       </svg>
                   </span><span
                       class="menu-sub-head"><?php echo Labels::getLabel('LBL_Products_Inventory_Stock_Status', $siteLangId); ?></span></a>
       </li>
       */ ?>
                <?php } ?>
            </ul>
        </li>
    <?php } ?>

    <li class="dashboard-menu-item">

        <?php
        $isControllerActive = in_array($controller, [
            'account',
            'seller',
        ]);
        $isActionActive = in_array($action, [
            'profileinfo',
            'users',
            'userpermissions',
            'messages',
            'viewmessages',
            'credits',
            'changeemailpassword',
        ]);
        ?>
        <button
            class="dashboard-menu-btn dropdown-toggle-custom <?php echo ($isControllerActive && $isActionActive ? '' : 'collapsed'); ?>"
            type="button" data-bs-toggle="collapse" data-bs-target="#Profile"
            aria-expanded="<?php echo ($isControllerActive && $isActionActive ? 'true' : 'false'); ?>"
            aria-controls="collapseOne" title="">
            <span class="dashboard-menu-icon">
                <svg class="svg" width="18" height="18">
                    <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite-sidebar.svg#profile">
                    </use>
                </svg>
            </span>
            <span class="dashboard-menu-head">
                <?php echo Labels::getLabel("LBL_Profile", $siteLangId); ?>
            </span>
            <i class="dashboard-menu-arrow dropdown-toggle-custom-arrow"></i>
        </button>

        <ul class="menu-sub menu-sub-accordion collapse <?php echo ($isControllerActive && $isActionActive ? 'show' : ''); ?>"
            id="Profile" aria-labelledby="" data-parent="#dashboard-menu">

            <li
                class="menu-sub-item <?php echo ($controller == 'account' && $action == 'profileinfo') ? 'is-active' : ''; ?>">
                <a class="menu-sub-link" title="<?php echo Labels::getLabel('LBL_My_Account', $siteLangId); ?>"
                    href="<?php echo UrlHelper::generateUrl('Account', 'ProfileInfo'); ?>">
                    <span class="menu-sub-icon"><svg class="svg" width="16" height="16">
                            <use
                                xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite-sidebar.svg#my-account">
                            </use>
                        </svg>
                    </span><span
                        class="menu-sub-head"><?php echo Labels::getLabel("LBL_My_Account", $siteLangId); ?></span></a>
            </li>
            <?php if ($userParentId == UserAuthentication::getLoggedUserId()) { ?>
                <li
                    class="menu-sub-item <?php echo ($controller == 'seller' && ($action == 'users' || $action == 'userpermissions')) ? 'is-active' : ''; ?>">
                    <a class="menu-sub-link" title="<?php echo Labels::getLabel('LBL_Sub_Users', $siteLangId); ?>"
                        href="<?php echo UrlHelper::generateUrl('Seller', 'Users'); ?>">
                        <span class="menu-sub-icon"><svg class="svg" width="16" height="16">
                                <use
                                    xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite-sidebar.svg#sub-users">
                                </use>
                            </svg>
                        </span><span
                            class="menu-sub-head"><?php echo Labels::getLabel("LBL_Sub_Users", $siteLangId); ?></span></a>
                </li>
            <?php } ?>
            <?php if ($userPrivilege->canViewMessages(UserAuthentication::getLoggedUserId(), true)) { ?>
                <li
                    class="menu-sub-item <?php echo ($controller == 'account' && ($action == 'messages' || strtolower($action) == 'viewmessages')) ? 'is-active' : ''; ?>">
                    <a class="menu-sub-link" title="<?php echo Labels::getLabel('LBL_Messages', $siteLangId); ?>"
                        href="<?php echo UrlHelper::generateUrl('Account', 'Messages'); ?>">
                        <span class="menu-sub-icon"><svg class="svg" width="16" height="16">
                                <use
                                    xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite-sidebar.svg#messages">
                                </use>
                            </svg>
                        </span><span class="menu-sub-head"><?php echo Labels::getLabel("LBL_Messages", $siteLangId); ?>
                            <?php if ($todayUnreadMessageCount > 0) { ?>
                                <span
                                    class="msg-count"><?php echo ($todayUnreadMessageCount < 9) ? $todayUnreadMessageCount : '9+'; ?></span>
                            <?php } ?></span></a>
                </li>
            <?php } ?>
            <?php if ($userParentId == UserAuthentication::getLoggedUserId()) { ?>
                <li
                    class="menu-sub-item <?php echo ($controller == 'account' && $action == 'credits') ? 'is-active' : ''; ?>">
                    <a class="menu-sub-link" title="<?php echo Labels::getLabel('LBL_My_Credits', $siteLangId); ?>"
                        href="<?php echo UrlHelper::generateUrl('Account', 'credits'); ?>">
                        <span class="menu-sub-icon"><svg class="svg" width="16" height="16">
                                <use
                                    xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite-sidebar.svg#my-credits">
                                </use>
                            </svg>
                        </span><span
                            class="menu-sub-head"><?php echo Labels::getLabel('LBL_My_Credits', $siteLangId); ?></span></a>
                </li>
            <?php } ?>
            <li
                class="menu-sub-item <?php echo ($controller == 'account' && $action == 'changeemailpassword') ? 'is-active' : ''; ?>">
                <a class="menu-sub-link" title="<?php echo Labels::getLabel('LBL_UPDATE_CREDENTIALS', $siteLangId); ?>"
                    href="<?php echo UrlHelper::generateUrl('Account', 'changeEmailPassword'); ?>">
                    <span class="menu-sub-icon"><svg class="svg" width="16" height="16">
                            <use
                                xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite-sidebar.svg#update-credentials">
                            </use>
                        </svg>
                    </span><span
                        class="menu-sub-head"><?php echo Labels::getLabel('LBL_UPDATE_CREDENTIALS', $siteLangId); ?></span></a>
            </li>
        </ul>
    </li>

    <?php if (FatApp::getConfig('CONF_ENABLE_SELLER_SUBSCRIPTION_MODULE') && $userPrivilege->canViewSubscription(UserAuthentication::getLoggedUserId(), true)) { ?>
        <li class="dashboard-menu-item">

            <?php
            $isControllerActive = in_array($controller, [
                'seller',
            ]);
            $isActionActive = in_array($action, [
                'subscriptions',
                'packages',
                'selleroffers',
            ]);
            ?>
            <button
                class="dashboard-menu-btn dropdown-toggle-custom <?php echo ($isControllerActive && $isActionActive ? '' : 'collapsed'); ?>"
                type="button" data-bs-toggle="collapse" data-bs-target="#Subscription"
                aria-expanded="<?php echo ($isControllerActive && $isActionActive ? 'true' : 'false'); ?>"
                aria-controls="collapseOne" title="">
                <span class="dashboard-menu-icon">
                    <svg class="svg" width="18" height="18">
                        <use
                            xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite-sidebar.svg#Subscription">
                        </use>
                    </svg>
                </span>
                <span class="dashboard-menu-head">
                    <?php echo Labels::getLabel("LBL_Subscription", $siteLangId); ?>
                </span>
                <i class="dashboard-menu-arrow dropdown-toggle-custom-arrow"></i>
            </button>
            <ul class="menu-sub menu-sub-accordion collapse <?php echo ($isControllerActive && $isActionActive ? 'show' : ''); ?>"
                id="Subscription" aria-labelledby="" data-parent="#dashboard-menu">
                <li
                    class="menu-sub-item <?php echo ($controller == 'seller' && ($action == 'subscriptions' || $action == 'viewsubscriptionorder')) ? 'is-active' : ''; ?>">
                    <a class="menu-sub-link" title="<?php echo Labels::getLabel('LBL_My_Subscriptions', $siteLangId); ?>"
                        href="<?php echo UrlHelper::generateUrl('Seller', 'subscriptions'); ?>">
                        <span class="menu-sub-icon"><svg class="svg" width="16" height="16">
                                <use
                                    xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite-sidebar.svg#my-subscriptions">
                                </use>
                            </svg>
                        </span><span
                            class="menu-sub-head"><?php echo Labels::getLabel("LBL_My_Subscriptions", $siteLangId); ?></span></a>
                </li>
                <li
                    class="menu-sub-item <?php echo ($controller == 'seller' && ($action == 'packages')) ? 'is-active' : ''; ?>">
                    <a class="menu-sub-link"
                        title="<?php echo Labels::getLabel('LBL_Subscription_Packages', $siteLangId); ?>"
                        href="<?php echo UrlHelper::generateUrl('seller', 'Packages'); ?>">
                        <span class="menu-sub-icon"><svg class="svg" width="16" height="16">
                                <use
                                    xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite-sidebar.svg#subscription-packages">
                                </use>
                            </svg>
                        </span><span
                            class="menu-sub-head"><?php echo Labels::getLabel('LBL_Subscription_Packages', $siteLangId); ?></span></a>
                </li>
                <li
                    class="menu-sub-item <?php echo ($controller == 'seller' && ($action == 'selleroffers')) ? 'is-active' : ''; ?>">
                    <a class="menu-sub-link" title="<?php echo Labels::getLabel('LBL_Subscription_Offers', $siteLangId); ?>"
                        href="<?php echo UrlHelper::generateUrl('seller', 'SellerOffers'); ?>">
                        <span class="menu-sub-icon"><svg class="svg" width="16" height="16">
                                <use
                                    xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite-sidebar.svg#subscription-offers">
                                </use>
                            </svg>
                        </span><span
                            class="menu-sub-head"><?php echo Labels::getLabel('LBL_Subscription_Offers', $siteLangId); ?></span></a>
                </li>
            </ul>
        </li>
    <?php } ?>


    <?php if ($userPrivilege->canViewImportExport(UserAuthentication::getLoggedUserId(), true)) { ?>
        <?php if (FatApp::getConfig('CONF_ENABLE_IMPORT_EXPORT', FatUtility::VAR_INT, 0)) { ?>
            <li
                class="dashboard-menu-item <?php echo ($controller == 'importexport' && ($action == 'index')) ? 'is-active' : ''; ?>">
                <a class="dashboard-menu-btn" title="<?php echo Labels::getLabel('LBL_Import_Export', $siteLangId); ?>"
                    href="<?php echo UrlHelper::generateUrl('ImportExport', 'index'); ?>"><span
                        class="dashboard-menu-icon shop"><svg class="svg" width="16" height="16">
                            <use
                                xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite-sidebar.svg#import-export">
                            </use>
                        </svg>
                    </span><span
                        class="dashboard-menu-head"><?php echo Labels::getLabel('LBL_Import_Export', $siteLangId); ?></span></a>
            </li>
        <?php } ?>
    <?php } ?>

    <?php $this->includeTemplate('_partial/dashboardLanguageArea.php'); ?>
</ul>