<?php
defined('SYSTEM_INIT') or die('Invalid Usage');

$pagination = '';

if ($pageCount <= 1) {
    return $pagination;
}

/*Number of links to display*/
$linksToDisp = isset($linksToDisp) ? $linksToDisp : 2;

/* Current page number */
$pageNumber = $page;

/*arguments mixed(array/string(comma separated)) // function arguments*/
$arguments = (isset($arguments)) ? $arguments : null;

/*padArgListTo boolean(T/F) // where to pad argument list (left/right) */
$padArgToLeft = (isset($padArgToLeft)) ? $padArgToLeft : true;

/*On clicking page link which js function need to call*/
$callBackJsFunc = isset($callBackJsFunc) ? $callBackJsFunc : 'goToSearchPage';


if (null != $arguments) {
    if (is_array($arguments)) {
        $args = implode(', ', $arguments);
    } elseif (is_string($arguments)) {
        $args = $arguments;
    }
    if ($padArgToLeft) {
        $callBackJsFunc = $callBackJsFunc . '(' . $args . ', xxpagexx);';
    } else {
        $callBackJsFunc = $callBackJsFunc . '(xxpagexx, ' . $args . ');';
    }
} else {
    $callBackJsFunc = $callBackJsFunc . '(xxpagexx);';
}

$pagination .= FatUtility::getPageString(
    '<li class="pagination-item"><button class="pagination-link" type="button" onclick="' . $callBackJsFunc . '">xxpagexx</button></li>',
    $pageCount,
    $pageNumber,
    ' <li class="pagination-item selected"><button type="button" class="pagination-link">xxpagexx</button></li>',
    ' ',
    $linksToDisp,
    ' <li class="pagination-item rewind"><button class="pagination-link" type="button" onclick="' . $callBackJsFunc . '"><svg class="svg" width="20" height="20">
    <use xlink:href="' . CONF_WEBROOT_URL . 'images/retina/sprite.svg#double-arrow-left"></use></svg></button></li>',
    ' <li class="pagination-item forward"><button  class="pagination-link" type="button" onclick="' . $callBackJsFunc . '"><svg class="svg" width="20" height="20">
    <use xlink:href="' . CONF_WEBROOT_URL . 'images/retina/sprite.svg#double-arrow-right"></use></svg></button></li>',
    ' <li class="pagination-item prev"><button  class="pagination-link" type="button" onclick="' . $callBackJsFunc . '"><svg class="svg" width="20" height="20">
    <use xlink:href="' . CONF_WEBROOT_URL . 'images/retina/sprite.svg#arrow-left"></use></svg></button></li>',
    ' <li class="pagination-item next"><button  class="pagination-link" type="button" onclick="' . $callBackJsFunc . '"><svg class="svg" width="20" height="20">
    <use xlink:href="' . CONF_WEBROOT_URL . 'images/retina/sprite.svg#arrow-right"></use></svg></button></li>'
);

$class = isset($removePageCentClass) ? "" : " pagination-center";

$ul = new HtmlElement(
    'ul',
    array(
        'class' => "pagination" . $class . " ",
    ),
    $pagination,
    true
);
echo '<div class="pagination-wrapper">';
echo $ul->getHtml();
?>
<?php if (isset($pageSize)) { ?>
<?php if ($pageCount == 1) { ?>
<div class="showing">
    <?php echo Labels::getLabel('LBL_Showing', $siteLangId); ?>
    <?php echo $recordCount; ?>
    <?php echo Labels::getLabel('LBL_Entries', $siteLangId); ?>
</div>
<?php } else { ?>
<div class="showing">
    <?php echo Labels::getLabel('LBL_Showing', $siteLangId); ?>
    <?php echo $startIdx = ($pageNumber - 1) * $pageSize + 1; ?>
    <?php echo Labels::getLabel('LBL_to', $siteLangId); ?>
    <?php echo ($recordCount < $startIdx + $pageSize - 1) ? $recordCount : $startIdx + $pageSize - 1; ?>
    <?php echo Labels::getLabel('LBL_of', $siteLangId); ?>
    <?php echo $recordCount; ?>
    <?php echo Labels::getLabel('LBL_Entries', $siteLangId); ?>
</div>
<?php } ?>
<?php } ?>
</div>