    <?php
    $getOrgUrl = (CONF_DEVELOPMENT_MODE) ? true : false;
    if (User::canViewSupplierTab() && (isset($_SESSION[UserAuthentication::SESSION_ELEMENT_NAME]['activeTab']) && $_SESSION[UserAuthentication::SESSION_ELEMENT_NAME]['activeTab'] == 'S')) {
        $dashboardUrl = UrlHelper::generateUrl('Seller');
        $dashboardOrgUrl = UrlHelper::generateUrl('Seller', '', array(), '', null, false, $getOrgUrl);
    } elseif (User::canViewBuyerTab() && (isset($_SESSION[UserAuthentication::SESSION_ELEMENT_NAME]['activeTab']) && $_SESSION[UserAuthentication::SESSION_ELEMENT_NAME]['activeTab'] == 'B')) {
        $dashboardUrl = UrlHelper::generateUrl('Buyer');
        $dashboardOrgUrl = UrlHelper::generateUrl('Buyer', '', array(), '', null, false, $getOrgUrl);
    } elseif (User::canViewAdvertiserTab() && (isset($_SESSION[UserAuthentication::SESSION_ELEMENT_NAME]['activeTab']) && $_SESSION[UserAuthentication::SESSION_ELEMENT_NAME]['activeTab'] == 'Ad')) {
        $dashboardUrl = UrlHelper::generateUrl('Advertiser');
        $dashboardOrgUrl = UrlHelper::generateUrl('Advertiser', '', array(), '', null, false, $getOrgUrl);
    }
    ?>
    <div class="mobile-actions">
        <div class="mobile-actions-item">
            <a class="mobile-actions-link" title="<?php echo Labels::getLabel('LBL_Home', $siteLangId); ?>"
                data-org-url="<?php echo UrlHelper::generateUrl('Home'); ?>"
                href="<?php echo UrlHelper::generateUrl('Home'); ?>">
                <svg class="svg" width="24" height="24">
                    <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/top-bar.svg#home"></use>
                </svg> <span class="txt"><?php echo Labels::getLabel('LBL_Home', $siteLangId); ?></span>
            </a>

        </div>
        <div class="mobile-actions-item">
            <a class="mobile-actions-link" title="<?php echo Labels::getLabel('LBL_Menu', $siteLangId); ?>"
                data-bs-toggle="offcanvas" data-bs-target="#offcanvas-sidebar" aria-controls="offcanvas-sidebar">
                <svg class="svg" width="24" height="24">
                    <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/top-bar.svg#menu"></use>
                </svg> <span class="txt"><?php echo Labels::getLabel('LBL_Menu', $siteLangId); ?></span>
            </a>

        </div>
        <div class="mobile-actions-item">
            <a class="mobile-actions-link" title="<?php echo Labels::getLabel('LBL_Account', $siteLangId); ?>"
                data-bs-toggle="offcanvas" data-bs-target="#offcanvas-account" aria-controls="offcanvas-sidebar">
                <svg class="svg" width="24" height="24">
                    <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/top-bar.svg#account"></use>
                </svg>
                <span class="txt"><?php echo Labels::getLabel('LBL_Account', $siteLangId); ?></span>
            </a>
        </div>
        <?php if (User::canViewSupplierTab() && (isset($_SESSION[UserAuthentication::SESSION_ELEMENT_NAME]['activeTab']) && $_SESSION[UserAuthentication::SESSION_ELEMENT_NAME]['activeTab'] == 'S')) { ?>
        <div class="mobile-actions-item">
            <a class="mobile-actions-link" title="<?php echo Labels::getLabel('LBL_Shop', $siteLangId); ?>"
                data-org-url="<?php echo UrlHelper::generateUrl('Seller', 'shop'); ?>"
                href="<?php echo UrlHelper::generateUrl('Seller', 'shop'); ?>">
                <svg class="svg" width="24" height="24">
                    <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/top-bar.svg#shop"></use>
                </svg>
                <span class="txt"><?php echo Labels::getLabel('LBL_Shop', $siteLangId); ?></span> </a>
        </div>
        <?php } ?>
    </div>
    <div class="offcanvas offcanvas-start offcanvas-sidebar" tabindex="-1" id="offcanvas-sidebar" aria-modal="true"
        role="dialog">
        <div class="offcanvas-header">
            <h5 id="navigation-menu"><?php echo Labels::getLabel('LBL_Menu', $siteLangId); ?></h5>
            <button type="button" class="btn-close text-reset" data-bs-dismiss="offcanvas" aria-label="Close"></button>
        </div>
        <div class="offcanvas-body">
            <?php
            if (User::canViewSupplierTab() && (isset($_SESSION[UserAuthentication::SESSION_ELEMENT_NAME]['activeTab']) && $_SESSION[UserAuthentication::SESSION_ELEMENT_NAME]['activeTab'] == 'S')) {
                $this->includeTemplate('_partial/sellerLeftNavigation.php');
            } elseif (User::canViewBuyerTab() && (isset($_SESSION[UserAuthentication::SESSION_ELEMENT_NAME]['activeTab']) && $_SESSION[UserAuthentication::SESSION_ELEMENT_NAME]['activeTab'] == 'B')) {
                $this->includeTemplate('_partial/buyerLeftNavigation.php');
            } elseif (User::canViewAdvertiserTab() && (isset($_SESSION[UserAuthentication::SESSION_ELEMENT_NAME]['activeTab']) && $_SESSION[UserAuthentication::SESSION_ELEMENT_NAME]['activeTab'] == 'Ad')) {
                $this->includeTemplate('_partial/advertiserLeftNavigation.php');
            }
            ?>
            <!--  sidebar menu here -->
        </div>
    </div>