<?php
$getOrgUrl = (CONF_DEVELOPMENT_MODE) ? true : false;
global $dashboardOrgUrl;
$userActiveTab = false;

if (!empty($isUserLogged)) {
    if (User::canViewSupplierTab() && (isset($_SESSION[UserAuthentication::SESSION_ELEMENT_NAME]['activeTab']) && $_SESSION[UserAuthentication::SESSION_ELEMENT_NAME]['activeTab'] == 'S')) {
        $userActiveTab = true;
        $dashboardUrl = UrlHelper::generateUrl('Seller');
        $dashboardOrgUrl = UrlHelper::generateUrl('Seller', '', array(), '', null, false, $getOrgUrl);
    } elseif (User::canViewBuyerTab() && (isset($_SESSION[UserAuthentication::SESSION_ELEMENT_NAME]['activeTab']) && $_SESSION[UserAuthentication::SESSION_ELEMENT_NAME]['activeTab'] == 'B')) {
        $userActiveTab = true;
        $dashboardUrl = UrlHelper::generateUrl('Buyer');
        $dashboardOrgUrl = UrlHelper::generateUrl('Buyer', '', array(), '', null, false, $getOrgUrl);
    } elseif (User::canViewAdvertiserTab() && (isset($_SESSION[UserAuthentication::SESSION_ELEMENT_NAME]['activeTab']) && $_SESSION[UserAuthentication::SESSION_ELEMENT_NAME]['activeTab'] == 'Ad')) {
        $userActiveTab = true;
        $dashboardUrl = UrlHelper::generateUrl('Advertiser');
        $dashboardOrgUrl = UrlHelper::generateUrl('Advertiser', '', array(), '', null, false, $getOrgUrl);
    } elseif (User::canViewAffiliateTab() && (isset($_SESSION[UserAuthentication::SESSION_ELEMENT_NAME]['activeTab']) && $_SESSION[UserAuthentication::SESSION_ELEMENT_NAME]['activeTab'] == 'AFFILIATE')) {
        $userActiveTab = true;
        $dashboardUrl = UrlHelper::generateUrl('Affiliate');
        $dashboardOrgUrl = UrlHelper::generateUrl('Affiliate', '', array(), '', null, false, $getOrgUrl);
    }
    if (!$userActiveTab) {
        $dashboardUrl = UrlHelper::generateUrl('Account');
        $dashboardOrgUrl = UrlHelper::generateUrl('Account', '', array(), '', null, false, $getOrgUrl);
    }
    ?>

<!-- offcanvas  -->
<div class="offcanvas offcanvas-start offcanvas-account" tabindex="-1" id="offcanvas-account" aria-modal="true"
    role="dialog">
    <div class="offcanvas-header">
        <h5 class="offcanvas-title">
            <?php echo Labels::getLabel('LBL_Profile', $siteLangId) ?>
        </h5>
        <button type="button" class="btn-close text-reset" data-bs-dismiss="offcanvas" aria-label="Close"></button>
    </div>
    <div class="offcanvas-body p-0">
        <div class="profile">
            <div class="profile-image">
                <img class="profile-avatar" width="80" height="80" src="<?php echo $profilePicUrl ?>" alt="">
            </div>
            <div class="profile-data">
                <h6 class="profile-name">
                    <?php echo $userName; ?>
                </h6>
                <p class="profile-email">
                    <?php echo $userEmail; ?>
                </p>
                <?php if (!empty($user_phone)) { ?>
                <p class="profile-phone">
                    <?php echo $user_dial_code . $user_phone ?>
                </p>
                <?php } ?>
            </div>
        </div>

        <ul class="account-nav">
            <li class="account-nav-item">
                <a class="account-nav-link" href="<?php echo $dashboardOrgUrl; ?>">
                    <?php echo Labels::getLabel("LBL_DASHBOARD", $siteLangId); ?>
                    <i class="icon icon-arrow-right"></i>
                </a>
            </li>
            <li class="account-nav-item">
                <a class="account-nav-link"
                    href="<?php echo UrlHelper::generateUrl('', '', [], CONF_WEBROOT_FRONT_URL); ?>">
                    <?php echo Labels::getLabel("LBL_HOME", $siteLangId); ?>
                    <i class="icon icon-arrow-right"></i>
                </a>
            </li>
            <?php if ($isShopActive && $shop_id > 0 && $activeTab == 'S') { ?>
            <li class="account-nav-item">
                <a class="account-nav-link"
                    href="<?php echo UrlHelper::generateUrl('Shops', 'view', array($shop_id), CONF_WEBROOT_FRONT_URL); ?>">
                    <?php echo Labels::getLabel("LBL_SHOP", $siteLangId); ?>
                    <i class="icon icon-arrow-right"></i>
                </a>
            </li>
            <?php } ?>
            <li class="account-nav-item">
                <a class="account-nav-link"
                    href="<?php echo UrlHelper::generateUrl('account', 'profileInfo', [], CONF_WEBROOT_FRONT_URL); ?>">
                    <?php echo Labels::getLabel("LBL_PROFILE", $siteLangId); ?>
                    <i class="icon icon-arrow-right"></i>
                </a>
            </li>
            <li class="account-nav-item">
                <a class="account-nav-link"
                    href="<?php echo UrlHelper::generateUrl('Account', 'changeEmailPassword'); ?>">
                    <?php echo Labels::getLabel("LBL_UPDATE_CREDENTIALS", $siteLangId); ?>
                    <i class="icon icon-arrow-right"></i>
                </a>
            </li>
        </ul>
    </div>
    <div class="offcanvas-foot p-4">
        <a class="btn btn-logout" href="<?php echo UrlHelper::generateUrl('GuestUser', 'logout'); ?>">
            <?php echo Labels::getLabel("LBL_Logout", $siteLangId); ?>
        </a>
    </div>
</div>
<?php
}
?>

<div class="offcanvas offcanvas-bottom offcanvas-gps-location" tabindex="-1" id="offcanvas-gps-location"
    aria-modal="true" role="dialog">
    <div class="offcanvas-header">
        <h5 class="offcanvas-title">
            <?php echo Labels::getLabel("LBL_Change_location", $siteLangId); ?>
        </h5>
        <button type="button" class="btn-close text-reset" data-bs-dismiss="offcanvas" aria-label="Close"></button>
    </div>
    <div class="offcanvas-body">
        <div class="geo-location-mobile">
            <div class="geo-location_inner">
                <div class="geo-location_dropdown-menu">
                    <div class="geo-location_body">
                        <input
                            class="location-input form-control omni-search geo-location_input location_input pac-target-input"
                            autocomplete="off" id="ga-autoComplete-mobile"
                            title="<?php echo Labels::getLabel("LBL_Location", $siteLangId); ?>"
                            placeholder="<?php echo Labels::getLabel("LBL_Location", $siteLangId); ?>" type="text"
                            name="location"
                            value="<?php echo (isset($_COOKIE['_ykGeoAddress'])) ? $_COOKIE['_ykGeoAddress'] : ""; ?>">

                        <div class="or">
                            <span>
                                <?php echo Labels::getLabel('Lbl_OR', $siteLangId); ?>
                            </span>
                        </div>
                        <button type="button" onclick="loadGeoLocation()" class="btn btn-brand btn-block btn-detect">

                            <svg class="svg" width="18" height="18">
                                <use
                                    xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/<?php echo ACTIVE_THEME; ?>/retina/sprite-header.svg#location-detect">
                                </use>
                            </svg>

                            <span class="txt">
                                <?php echo Labels::getLabel("LBL_Detect_my_current_location", $siteLangId); ?>
                            </span>
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="offcanvas offcanvas-end offcanvas-filters" tabindex="-1" id="offcanvas-filters" aria-modal="true"
    role="dialog">
    <div class="offcanvas-header">
        <h5 id="search-filters"><?php echo Labels::getLabel('LBL_FILTERS', $siteLangId); ?></h5>
        <button type="button" class="btn-close text-reset" data-bs-dismiss="offcanvas" aria-label="Close"></button>
    </div>
    <div class="offcanvas-body">
        <div class="filters productFilters-js"></div>
    </div>
</div>