<?php
defined('SYSTEM_INIT') or die('Invalid Usage.');
if (isset($collection['products']) && count($collection['products'])) {
    ?>
    <section class="section" data-collection="collection-name"
        style="background-color:var(--secondary-color);color:var(--secondary-color-inverse);">
        <div class="container">
            <div class="section-head section-head-white">
                <div class="section-heading">
                    <h2>
                        <?php echo ($collection['collection_name'] != '') ? $collection['collection_name'] : ''; ?>
                    </h2>
                </div>
                <?php if ($collection['totProducts'] > 6) { ?>
                    <div class="section-head-action"><a
                            href="<?php echo UrlHelper::generateUrl('Collections', 'View', array($collection['collection_id'])); ?>"
                            class="link-underline">
                            <?php echo Labels::getLabel('LBL_View_More', $siteLangId); ?>
                        </a> </div>
                <?php } ?>
            </div>
            <div class="js-collection-corner collection-corner product-listing"
                dir="<?php echo CommonHelper::getLayoutDirection(); ?>">
                <?php
                $displayProductNotAvailableLable = false;
                if (trim(FatApp::getConfig('CONF_GOOGLEMAP_API_KEY', FatUtility::VAR_STRING, '')) != '') {
                    $displayProductNotAvailableLable = true;
                }
                foreach ($collection['products'] as $product) {
                    ?>
                    <?php include('product-layout-1-list.php'); ?>
                <?php } ?>
            </div>
        </div>
    </section>
<?php } ?>