<?php defined('SYSTEM_INIT') or die('Invalid Usage.'); ?>
<?php if (isset($collection['products']) && count($collection['products']) > 0) { ?>
<section class="section" data-collection="collection-name">
    <div class="container">
        <div class="section-head">
            <div class="section-heading">
                <h2>
                    <?php echo ($collection['collection_name'] != '') ? $collection['collection_name'] : ''; ?>
                </h2>
            </div>
            <?php if ($collection['totProducts'] > $collection['collection_primary_records']) { ?>
            <div class="section-head-action"><a
                    href="<?php echo UrlHelper::generateUrl('Collections', 'View', array($collection['collection_id'])); ?>"
                    class="link-underline">
                    <?php echo Labels::getLabel('LBL_View_More', $siteLangId); ?>
                </a> </div>
            <?php } ?>
        </div>
        <div class="product-listing" data-view="6" dir="<?php echo CommonHelper::getLayoutDirection(); ?>">
            <?php foreach ($collection['products'] as $product) { ?>
            <div class="items">
                <?php
                        $displayProductNotAvailableLable = false;
                        if (trim(FatApp::getConfig('CONF_GOOGLEMAP_API_KEY', FatUtility::VAR_STRING, '')) != '') {
                            $displayProductNotAvailableLable = true;
                        }
                        include ('product-layout-1-list.php'); ?>
            </div>
            <?php } ?>
        </div>
    </div>
</section>
<hr class="m-0">
<?php }