<?php if (isset($collection['brands']) && count($collection['brands']) > 0) { ?>
    <section class="section collection-brand" data-collection="collection-name"
        id="brand_layout2_<?php echo $collection['collection_id']; ?>">
        <div class="container">
            <div class="section-head section-head-center">
                <div class="section-heading">
                    <h5>
                        <?php echo $collection['collection_description']; ?>
                    </h5>
                    <h2>
                        <?php echo $collection['collection_name']; ?>
                    </h2>
                </div>
            </div>
        </div>
        <div class="container">
            <div class="js-carousel" dir="<?php echo CommonHelper::getLayoutDirection(); ?>" data-slides="5,3,3,2,2"
                data-arrows="true" data-slickdots="true" id="slider_<?php echo $collection['collection_id']; ?>"
                data-slickinfinite="false">
                <?php foreach ($collection['brands'] as $brand) { ?>
                    <div class="js-carousel-item">
                        <div class="brand">
                            <div class="brand__card">
                                <div class="brand__card--body">
                                    <div class="brand-media">
                                        <a
                                            href="<?php echo UrlHelper::generateUrl('brands', 'View', array($brand['brand_id'])); ?>">
                                            <picture class="product-img" data-ratio="3:4">
                                                <source type="image/webp"
                                                    srcset="<?php echo UrlHelper::getCachedUrl(UrlHelper::generateFileUrl('image', 'brandFeaturedImage', array($brand['brand_id'], $siteLangId, 'DESKTOP')), CONF_IMG_CACHE_TIME, '.jpg'); ?>">
                                                <img data-aspect-ratio="3:4" alt="<?php echo $brand['brand_name']; ?>"
                                                    title="<?php echo $brand['brand_name']; ?>"
                                                    src="<?php echo UrlHelper::getCachedUrl(UrlHelper::generateFileUrl('image', 'brandFeaturedImage', array($brand['brand_id'], $siteLangId, 'DESKTOP')), CONF_IMG_CACHE_TIME, '.jpg'); ?>">
                                            </picture>
                                        </a>
                                    </div>
                                </div>
                                <div class="brand__card--foot">
                                    <div class="brand-logo-media">
                                        <a
                                            href="<?php echo UrlHelper::generateUrl('brands', 'View', array($brand['brand_id'])); ?>">
                                            <img data-aspect-ratio="1:1"
                                                src="<?php echo UrlHelper::getCachedUrl(UrlHelper::generateFileUrl('image', 'brand', array($brand['brand_id'], $siteLangId, 'BRAND_LAYOUT_2')), CONF_IMG_CACHE_TIME, '.jpg'); ?>"
                                                alt="<?php echo $brand['brand_name']; ?>"
                                                title="<?php echo $brand['brand_name']; ?>">
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php } ?>
            </div>

        </div>
    </section>
<?php } ?>