<?php
$controller = strtolower($controller);
$action = strtolower($action);
?>
<ul class="dashboard-menu">
    <li class="dashboard-menu-item">
        <?php
        $isControllerActive = in_array($controller, [
            'buyer',
        ]);
        $listAction = [
            'rentalorders',
            'rentalordercancellationrequests',
            'rentalorderreturnrequests',
            'latechargeshistory'
        ];
        if ($isRentalOrder && $isRFQOrder == false) {
            $listAction[] = 'vieworder';
        }
        $isActionActive = in_array($action, $listAction);
        ?>
        <button
            class="dashboard-menu-btn dropdown-toggle-custom <?php echo ($isControllerActive && $isActionActive ? '' : 'collapsed'); ?>"
            type="button" data-bs-toggle="collapse" data-bs-target="#Rental_Orders"
            aria-expanded="<?php echo ($isControllerActive && $isActionActive ? 'true' : 'false'); ?>"
            aria-controls="collapseOne" title="">
            <span class="dashboard-menu-icon">
                <svg class="svg" width="18" height="18">
                    <use
                        xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite-sidebar.svg#rental-orders">
                    </use>
                </svg>
            </span>
            <span class="dashboard-menu-head">
                <?php echo Labels::getLabel("LBL_Rental_Orders", $siteLangId); ?>
            </span>
            <i class="dashboard-menu-arrow dropdown-toggle-custom-arrow"></i>
        </button>
        <ul class="menu-sub menu-sub-accordion collapse <?php echo ($isControllerActive && $isActionActive ? 'show' : ''); ?>"
            id="Rental_Orders" aria-labelledby="" data-parent="#dashboard-menu">
            <li
                class="menu-sub-item  <?php echo ($controller == 'buyer' && ($action == 'rentalorders' || ($action == 'vieworder' && $isRFQOrder == false))) ? 'is-active' : ''; ?>">
                <a class="menu-sub-link" title="<?php echo Labels::getLabel("LBL_Orders", $siteLangId); ?>"
                    href="<?php echo UrlHelper::generateUrl('Buyer', 'rentalOrders'); ?>">
                    <span class="menu-sub-icon">
                        <svg class="svg" width="16" height="16">
                            <use
                                xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sidebar.svg#order-rental">
                            </use>
                        </svg>
                    </span>
                    <span class="menu-sub-head"><?php echo Labels::getLabel("LBL_Orders", $siteLangId); ?>
                    </span>
                </a>

            </li>
            <li
                class="menu-sub-item <?php echo ($controller == 'buyer' && $action == 'rentalordercancellationrequests') ? 'is-active' : ''; ?>">
                <a class="menu-sub-link"
                    title="<?php echo Labels::getLabel("LBL_Cancellation_Requests", $siteLangId); ?>"
                    href="<?php echo UrlHelper::generateUrl('Buyer', 'rentalOrderCancellationRequests'); ?>">
                    <span class="menu-sub-icon">
                        <svg class="svg" width="16" height="16">
                            <use
                                xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sidebar.svg#order-cancel-request">
                            </use>
                        </svg>
                    </span>
                    <span class="menu-sub-head">
                        <?php echo Labels::getLabel("LBL_Cancellation_Requests", $siteLangId); ?></span>
                </a>

            </li>
            <li
                class="menu-sub-item <?php echo ($controller == 'buyer' && ($action == 'rentalorderreturnrequests')) ? 'is-active' : ''; ?>">

                <a class="menu-sub-link" title="<?php echo Labels::getLabel("LBL_Return_Requests", $siteLangId); ?>"
                    href="<?php echo UrlHelper::generateUrl('Buyer', 'rentalOrderReturnRequests'); ?>">
                    <span class="menu-sub-icon">
                        <svg class="svg" width="16" height="16">
                            <use
                                xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sidebar.svg#order-return-request">
                            </use>
                        </svg>
                    </span>
                    <span
                        class="menu-sub-head"><?php echo Labels::getLabel("LBL_Return_Requests", $siteLangId); ?></span>
                </a>

            </li>
            <li
                class="menu-sub-item <?php echo ($controller == 'buyer' && ($action == 'latechargeshistory')) ? 'is-active' : ''; ?>">
                <a class="menu-sub-link"
                    title="<?php echo Labels::getLabel("LBL_Late_Charges_History", $siteLangId); ?>"
                    href="<?php echo UrlHelper::generateUrl('Buyer', 'lateChargesHistory'); ?>">
                    <span class="menu-sub-icon">
                        <svg class="svg" width="16" height="16">
                            <use
                                xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sidebar.svg#late-charges-management">
                            </use>
                        </svg>
                    </span>
                    <span
                        class="menu-sub-head"><?php echo Labels::getLabel("LBL_Late_Charges_History", $siteLangId); ?></span>
                </a>
            </li>
        </ul>
    </li>

    <!-- RFQ -->
    <li class="dashboard-menu-item">
        <?php
        $isControllerActive = in_array($controller, [
            'requestforquotes',
            'buyer',
        ]);
        
        $listAction = [
            'quotedrequests',
            'acceptedbuyeroffers',
            'rejectedbuyeroffers',
            'orders',
        ];
        if ($isRFQOrder == true) {
            $listAction[] = 'vieworder';
        }
        $isActionActive = in_array($action, $listAction);
        ?>
        <button
            class="dashboard-menu-btn dropdown-toggle-custom <?php echo ($isControllerActive && $isActionActive ? '' : 'collapsed'); ?>"
            type="button" data-bs-toggle="collapse" data-bs-target="#Request_For_Quotes"
            aria-expanded="<?php echo ($isControllerActive && $isActionActive ? 'true' : 'false'); ?>"
            aria-controls="collapseOne" title="">
            <span class="dashboard-menu-icon">
                <svg class="svg" width="18" height="18">
                    <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite-sidebar.svg#rfq">
                    </use>
                </svg>
            </span>
            <span class="dashboard-menu-head">
                <?php echo Labels::getLabel("LBL_REQUEST_FOR_QUOTES", $siteLangId); ?>
            </span>
            <i class="dashboard-menu-arrow dropdown-toggle-custom-arrow"></i>
        </button>

        <ul class="menu-sub menu-sub-accordion collapse <?php echo ($isControllerActive && $isActionActive ? 'show' : ''); ?>"
            id="Request_For_Quotes" aria-labelledby="" data-parent="#dashboard-menu">
            <li
                class="menu-sub-item  <?php echo ($controller == 'requestforquotes' && $action == 'quotedrequests') ? 'is-active' : ''; ?>">
                <a class="menu-sub-link" title="<?php echo Labels::getLabel("LBL_In-progress", $siteLangId); ?>"
                    href="<?php echo UrlHelper::generateUrl('RequestForQuotes', 'quotedRequests'); ?>">
                    <span class="menu-sub-icon">
                        <svg class="svg" width="16" height="16">
                            <use
                                xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sidebar.svg#RFQ-in-progress">
                            </use>
                        </svg>
                    </span>
                    <span class="menu-sub-head">
                        <?php echo Labels::getLabel("LBL_In-progress", $siteLangId); ?>
                    </span>
                </a>
            </li>
            <!-- <li class="dashboard-menu-item <?php echo ($controller == 'requestforquotes' && $action == 'reQuotedRequests') ? 'is-active' : ''; ?>">
                            <div class="dashboard-menu-item__inner">
                                <a class="dashboard-menu-btn" title="<?php echo Labels::getLabel("LBL_Re-quote_on_RFQ", $siteLangId); ?>" href="<?php echo UrlHelper::generateUrl('RequestForQuotes', 'reQuotedRequests'); ?>" >
                                    <span class="dashboard-menu-icon shop">
                                        <svg  class="svg" id="my_requote_requests" height="512pt" viewBox="0 0 512 512" width="512pt" xmlns="http://www.w3.org/2000/svg">
                                        <path d="m143.9375 382.8125c18.640625-14.515625 30.664062-37.148438 30.664062-62.546875 0-43.707031-35.5625-79.265625-79.269531-79.265625s-79.265625 35.558594-79.265625 79.265625c0 25.398437 12.023438 48.03125 30.660156 62.546875-26.304687 15.648438-46.726562 45.203125-46.726562 82.054688v32.132812c0 8.285156 6.714844 15 15 15h160.667969c8.28125 0 15-6.714844 15-15v-32.132812c0-36.84375-20.417969-66.402344-46.730469-82.054688zm-97.871094-62.546875c0-27.164063 22.101563-49.265625 49.269532-49.265625 27.164062 0 49.265624 22.101562 49.265624 49.265625 0 27.167969-22.101562 49.269531-49.265624 49.269531-27.167969 0-49.269532-22.101562-49.269532-49.269531zm114.601563 161.734375h-130.667969v-17.132812c0-36.085938 29.195312-65.332032 65.332031-65.332032 36.085938 0 65.332031 29.195313 65.332031 65.332032v17.132812zm0 0"/>
                                        <path d="m448.800781 0h-192.800781c-34.90625 0-63.199219 28.242188-63.199219 63.199219v289.199219c0 12.269531 14.070313 19.445312 24 12l60.265625-45.199219h171.734375c34.90625 0 63.199219-28.242188 63.199219-63.199219v-192.800781c0-34.90625-28.242188-63.199219-63.199219-63.199219zm33.199219 256c0 18.351562-14.839844 33.199219-33.199219 33.199219h-176.734375c-3.246094 0-6.402344 1.054687-9 3l-40.265625 30.199219v-259.199219c0-18.351563 14.839844-33.199219 33.199219-33.199219h192.800781c18.351563 0 33.199219 14.839844 33.199219 33.199219zm0 0"/>
                                        <path d="m432.734375 80.332031h-160.667969c-8.285156 0-15 6.71875-15 15 0 8.285157 6.714844 15 15 15h160.667969c8.28125 0 15-6.714843 15-15 0-8.28125-6.714844-15-15-15zm0 0"/>
                                        <path d="m432.734375 144.601562h-160.667969c-8.285156 0-15 6.714844-15 15 0 8.28125 6.714844 15 15 15h160.667969c8.28125 0 15-6.71875 15-15 0-8.285156-6.714844-15-15-15zm0 0"/>
                                        <path d="m352.398438 208.867188h-80.332032c-8.285156 0-15 6.714843-15 15 0 8.285156 6.714844 15 15 15h80.332032c8.285156 0 15-6.714844 15-15 0-8.285157-6.714844-15-15-15zm0 0"/>
                                        </svg>
                                    </span>
                                    <span class="dashboard-menu-head"><?php echo Labels::getLabel("LBL_Re-quote_on_RFQ", $siteLangId); ?></span>
                                </a>
                            </div>
                        </li> -->
            <li
                class="menu-sub-item <?php echo ($controller == 'requestforquotes' && $action == 'acceptedbuyeroffers') ? 'is-active' : ''; ?>">
                <a class="menu-sub-link" title="<?php echo Labels::getLabel('LBL_Accepted', $siteLangId); ?>"
                    href="<?php echo UrlHelper::generateUrl('RequestForQuotes', 'AcceptedBuyerOffers'); ?>">
                    <span class="menu-sub-icon">
                        <svg class="svg" width="16" height="16">
                            <use
                                xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sidebar.svg#RFQ-accepted">
                            </use>
                        </svg>
                    </span><span class="menu-sub-head">
                        <?php echo Labels::getLabel('LBL_Accepted', $siteLangId); ?>
                    </span>
                </a>
            </li>

            <li
                class="menu-sub-item <?php echo ($controller == 'requestforquotes' && $action == 'rejectedbuyeroffers') ? 'is-active' : ''; ?>">
                <a class="menu-sub-link" title="<?php echo Labels::getLabel('LBL_Rejected', $siteLangId); ?>"
                    href="<?php echo UrlHelper::generateUrl('RequestForQuotes', 'rejectedBuyerOffers'); ?>">
                    <span class="menu-sub-icon">
                        <svg class="svg" width="16" height="16">
                            <use
                                xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sidebar.svg#RFQ-rejected">
                            </use>
                        </svg>
                    </span>
                    <span class="menu-sub-head">
                        <?php echo Labels::getLabel('LBL_Rejected', $siteLangId); ?>
                    </span>
                </a>
            </li>

            <li class="menu-sub-item <?php echo (($controller == 'requestforquotes' && $action == 'orders') || ($isRFQOrder == true && $controller == 'buyer' && $action == 'vieworder')) ? 'is-active' : ''; ?>">
                <a class="menu-sub-link" title="<?php echo Labels::getLabel("LBL_Orders", $siteLangId); ?>"
                    href="<?php echo UrlHelper::generateUrl('RequestForQuotes', 'Orders'); ?>">
                    <span class="menu-sub-icon">
                        <svg class="svg" width="16" height="16">
                            <use
                                xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sidebar.svg#RFQ-order">
                            </use>
                        </svg>
                    </span>
                    <span class="menu-sub-head">
                        <?php echo Labels::getLabel("LBL_Orders", $siteLangId); ?>
                    </span>
                </a>
            </li>
        </ul>
    </li>


    <!---- SALE ORDERS -->
    <?php if (FatApp::getConfig("CONF_ALLOW_SALE", FatUtility::VAR_INT, 0)) { ?>

    <li class="dashboard-menu-item">
        <?php
        $isControllerActive = in_array($controller, [
            'buyer',
        ]);
        $listAction = [
            'orders',
            'ordercancellationrequests',
            'orderreturnrequests',
        ];
        if (!$isRentalOrder && $isRFQOrder == false) {
            $listAction[] = 'vieworder';
        }
        $isActionActive = in_array($action, $listAction);
        ?>
        <button
            class="dashboard-menu-btn dropdown-toggle-custom <?php echo ($isControllerActive && $isActionActive ? '' : 'collapsed'); ?>"
            type="button" data-bs-toggle="collapse" data-bs-target="#Sale_Orders"
            aria-expanded="<?php echo ($isControllerActive && $isActionActive ? 'true' : 'false'); ?>"
            aria-controls="collapseOne" title="">
            <span class="dashboard-menu-icon">
                <svg class="svg" width="18" height="18">
                    <use
                        xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite-sidebar.svg#sale-order">
                    </use>
                </svg>
            </span>
            <span class="dashboard-menu-head">
                <?php echo Labels::getLabel("LBL_Sale_Orders", $siteLangId); ?>
            </span>
            <i class="dashboard-menu-arrow dropdown-toggle-custom-arrow"></i>
        </button>

        <ul class="menu-sub menu-sub-accordion collapse <?php echo ($isControllerActive && $isActionActive ? 'show' : ''); ?>"
            id="Sale_Orders" aria-labelledby="" data-parent="#dashboard-menu">
            <li
                class="menu-sub-item  <?php echo ($controller == 'buyer' && ($action == 'orders' || ($action == 'vieworder' && $isRFQOrder == false))) ? 'is-active' : ''; ?>">
                <a class="menu-sub-link" title="<?php echo Labels::getLabel("LBL_Orders", $siteLangId); ?>"
                    href="<?php echo UrlHelper::generateUrl('Buyer', 'Orders'); ?>">
                    <span class="menu-sub-icon">
                        <svg class="svg" width="16" height="16">
                            <use
                                xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sidebar.svg#order-sales">
                            </use>
                        </svg>
                    </span>
                    <span class="menu-sub-head">
                        <?php echo Labels::getLabel("LBL_Orders", $siteLangId); ?>
                    </span>
                </a>
            </li>
            <li
                class="menu-sub-item <?php echo ($controller == 'buyer' && $action == 'ordercancellationrequests') ? 'is-active' : ''; ?>">
                <a class="menu-sub-link"
                    title="<?php echo Labels::getLabel("LBL_Cancellation_Requests", $siteLangId); ?>"
                    href="<?php echo UrlHelper::generateUrl('Buyer', 'orderCancellationRequests'); ?>">
                    <span class="menu-sub-icon">
                        <svg class="svg" width="16" height="16">
                            <use
                                xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sidebar.svg#order-cancel-request">
                            </use>
                        </svg>
                    </span>
                    <span class="menu-sub-head">
                        <?php echo Labels::getLabel("LBL_Cancellation_Requests", $siteLangId); ?>
                    </span>
                </a>
            </li>
            <li
                class="menu-sub-item <?php echo ($controller == 'buyer' && ($action == 'orderreturnrequests')) ? 'is-active' : ''; ?>">
                <a class="menu-sub-link" title="<?php echo Labels::getLabel("LBL_Return_Requests", $siteLangId); ?>"
                    href="<?php echo UrlHelper::generateUrl('Buyer', 'orderReturnRequests'); ?>">
                    <span class="menu-sub-icon">
                        <svg class="svg" width="16" height="16">
                            <use
                                xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sidebar.svg#order-return-request">
                            </use>
                        </svg>
                    </span>
                    <span class="menu-sub-head">
                        <?php echo Labels::getLabel("LBL_Return_Requests", $siteLangId); ?>
                    </span>
                </a>
            </li>
        </ul>
    </li>

    <?php }


    if (User::canViewBuyerTab()) { ?>

    <li class="dashboard-menu-item">
        <?php
        $isControllerActive = in_array($controller, [
            'buyer',
        ]);
        $isActionActive = in_array($action, [
            'offers',
            'rewardpoints',
            'shareearn'
        ]);
        ?>
        <button
            class="dashboard-menu-btn dropdown-toggle-custom <?php echo ($isControllerActive && $isActionActive ? '' : 'collapsed'); ?>"
            type="button" data-bs-toggle="collapse" data-bs-target="#Offers_Rewards"
            aria-expanded="<?php echo ($isControllerActive && $isActionActive ? 'true' : 'false'); ?>"
            aria-controls="collapseOne" title="">
            <span class="dashboard-menu-icon">
                <svg class="svg" width="18" height="18">
                    <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite-sidebar.svg#offers">
                    </use>
                </svg>
            </span>
            <span class="dashboard-menu-head">
                <?php echo Labels::getLabel("LBL_Offers_&_Rewards", $siteLangId); ?>
            </span>
            <i class="dashboard-menu-arrow dropdown-toggle-custom-arrow"></i>
        </button>

        <ul class="menu-sub menu-sub-accordion collapse <?php echo ($isControllerActive && $isActionActive ? 'show' : ''); ?>"
            id="Offers_Rewards" aria-labelledby="" data-parent="#dashboard-menu">

            <li class="menu-sub-item <?php echo ($controller == 'buyer' && $action == 'offers') ? 'is-active' : ''; ?>">
                <a class="menu-sub-link" title="<?php echo Labels::getLabel("LBL_My_Offers", $siteLangId); ?>"
                    href="<?php echo UrlHelper::generateUrl('Buyer', 'offers'); ?>">
                    <span class="menu-sub-icon">
                        <svg class="svg" width="16" height="16">
                            <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sidebar.svg#offers">
                            </use>
                        </svg>
                    </span>
                    <span class="menu-sub-head">
                        <?php echo Labels::getLabel("LBL_My_Offers", $siteLangId); ?>
                    </span>
                </a>
            </li>
            <li
                class="menu-sub-item <?php echo ($controller == 'buyer' && $action == 'rewardpoints') ? 'is-active' : ''; ?>">
                <a class="menu-sub-link" title="<?php echo Labels::getLabel("LBL_Reward_Points", $siteLangId); ?>"
                    href="<?php echo UrlHelper::generateUrl('Buyer', 'rewardPoints'); ?>">
                    <span class="menu-sub-icon">
                        <svg class="svg" width="16" height="16">
                            <use
                                xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sidebar.svg#reward-points">
                            </use>
                        </svg>
                    </span>
                    <span class="menu-sub-head">
                        <?php echo Labels::getLabel("LBL_Reward_Points", $siteLangId); ?>
                    </span>
                </a>
            </li>
            <?php if (FatApp::getConfig('CONF_ENABLE_REFERRER_MODULE', FatUtility::VAR_INT, 1)) { ?>
            <li
                class="menu-sub-item <?php echo ($controller == 'buyer' && $action == 'shareearn') ? 'is-active' : ''; ?>">
                <a class="menu-sub-link" title="<?php echo Labels::getLabel("LBL_Share_and_Earn", $siteLangId); ?>"
                    href="<?php echo UrlHelper::generateUrl('Buyer', 'shareEarn'); ?>">
                    <span class="menu-sub-icon">
                        <svg class="svg" width="16" height="16">
                            <use
                                xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sidebar.svg#share-earn">
                            </use>
                        </svg>
                    </span>
                    <span class="menu-sub-head">
                        <?php echo Labels::getLabel("LBL_Share_and_Earn", $siteLangId); ?>
                    </span>
                </a>
            </li>
            <?php } ?>
        </ul>
    </li>

    <?php } ?>


    <li class="dashboard-menu-item">
        <?php
        $isControllerActive = in_array($controller, [
            'account',
            'savedproductssearch'
        ]);
        $isActionActive = in_array($action, [
            'messages',
            'viewmessages',
            'credits',
            'cards',
            'wishlist'
        ]);
        ?>
        <button
            class="dashboard-menu-btn dropdown-toggle-custom <?php echo ($isControllerActive && $isActionActive ? '' : 'collapsed'); ?>"
            type="button" data-bs-toggle="collapse" data-bs-target="#General"
            aria-expanded="<?php echo ($isControllerActive && $isActionActive ? 'true' : 'false'); ?>"
            aria-controls="collapseOne" title="">
            <span class="dashboard-menu-icon">
                <svg class="svg" width="18" height="18">
                    <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite-sidebar.svg#general">
                    </use>
                </svg>
            </span>
            <span class="dashboard-menu-head">
                <?php echo Labels::getLabel("LBL_General", $siteLangId); ?>
            </span>
            <i class="dashboard-menu-arrow dropdown-toggle-custom-arrow"></i>
        </button>

        <ul class="menu-sub menu-sub-accordion collapse <?php echo ($isControllerActive && $isActionActive ? 'show' : ''); ?>"
            id="General" aria-labelledby="" data-parent="#dashboard-menu">
            <li
                class="menu-sub-item <?php echo ($controller == 'account' && ($action == 'messages' || strtolower($action) == 'viewmessages')) ? 'is-active' : ''; ?>">
                <a class="menu-sub-link" title="<?php echo Labels::getLabel("LBL_Messages", $siteLangId); ?>"
                    href="<?php echo UrlHelper::generateUrl('Account', 'Messages'); ?>">
                    <span class="menu-sub-icon">
                        <svg class="svg" width="16" height="16">
                            <use
                                xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sidebar.svg#messages">
                            </use>
                        </svg>
                    </span>
                    <span class="menu-sub-head">
                        <?php echo Labels::getLabel("LBL_Messages", $siteLangId); ?>
                        <?php if ($todayUnreadMessageCount > 0) { ?>
                        <span class="msg-count">
                            <?php echo ($todayUnreadMessageCount < 9) ? $todayUnreadMessageCount : '9+'; ?>
                        </span>
                        <?php } ?>
                    </span>
                </a>
            </li>
            <li
                class="menu-sub-item <?php echo ($controller == 'account' && $action == 'credits') ? 'is-active' : ''; ?>">
                <a class="menu-sub-link" title="<?php echo Labels::getLabel("LBL_My_Credits", $siteLangId); ?>"
                    href="<?php echo UrlHelper::generateUrl('Account', 'credits'); ?>">
                    <span class="menu-sub-icon">
                        <svg class="svg" width="16" height="16">
                            <use
                                xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sidebar.svg#my-credits">
                            </use>
                        </svg>
                    </span>
                    <span class="menu-sub-head">
                        <?php echo Labels::getLabel('LBL_My_Credits', $siteLangId); ?>
                    </span>
                </a>
            </li>
            <?php
            $kingPin = FatApp::getConfig('CONF_DEFAULT_PLUGIN_' . Plugin::TYPE_SPLIT_PAYMENT_METHOD, FatUtility::VAR_INT, 0);
            if (0 < $kingPin) {
                ?>
            <li
                class="menu-sub-item <?php echo ($controller == 'account' && $action == 'cards') ? 'is-active' : ''; ?>">
                <a class="menu-sub-link" title="<?php echo Labels::getLabel("LBL_MY_CARDS", $siteLangId); ?>"
                    href="<?php echo UrlHelper::generateUrl('Account', 'cards'); ?>">
                    <span class="menu-sub-icon">
                        <svg class="svg" width="16" height="16">
                            <use
                                xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sidebar.svg#my-credits">
                            </use>
                        </svg>
                    </span>
                    <span class="menu-sub-head">
                        <?php echo Labels::getLabel('LBL_MY_CARDS', $siteLangId); ?>
                    </span>
                </a>
            </li>
            <?php } ?>
            <li
                class="menu-sub-item <?php echo ($controller == 'account' && $action == 'wishlist') ? 'is-active' : ''; ?>">
                <?php
                $label = Labels::getLabel("LBL_FAVORITES", $siteLangId);
                $favVar = FatApp::getConfig('CONF_ADD_FAVORITES_TO_WISHLIST', FatUtility::VAR_INT, 1);
                $favVar = 0;
                if (0 < $favVar) {
                    $label = Labels::getLabel("LBL_WISHLIST", $siteLangId);
                }
                ?>
                <a class="menu-sub-link" title="<?php echo $label; ?>"
                    href="<?php echo UrlHelper::generateUrl('Account', 'wishlist'); ?>">
                    <span class="menu-sub-icon">
                        <svg class="svg" width="16" height="16">
                            <use
                                xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sidebar.svg#favorites">
                            </use>
                        </svg>
                    </span>
                    <span class="menu-sub-head">
                        <?php echo $label; ?>
                    </span>
                </a>
            </li>
            <!-- <li class="dashboard-menu-item <?php echo ($controller == 'savedproductssearch' && $action == 'listing') ? 'is-active' : ''; ?>">
                <div class="dashboard-menu-item__inner">
                    <a class="dashboard-menu-btn" title="<?php echo Labels::getLabel("LBL_Saved_Searches", $siteLangId); ?>" href="<?php echo UrlHelper::generateUrl('SavedProductsSearch', 'listing'); ?>">
                        <span class="dashboard-menu-icon shop">
                            <svg class="svg" width="16" height="16">
                            <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sidebar.svg#dash-saved-searches"></use>
                            </svg>
                        </span>
                        <span class="dashboard-menu-head"><?php echo Labels::getLabel('LBL_Saved_Searches', $siteLangId); ?></span>
                    </a>
                </div>
            </li> -->
        </ul>
    </li>

    <li class="dashboard-menu-item">
        <?php
        $isControllerActive = in_array($controller, [
            'account',
        ]);
        $isActionActive = in_array($action, [
            'profileinfo',
            'myaddresses',
            'changeemailpassword'
        ]);
        ?>
        <button
            class="dashboard-menu-btn dropdown-toggle-custom <?php echo ($isControllerActive && $isActionActive ? '' : 'collapsed'); ?>"
            type="button" data-bs-toggle="collapse" data-bs-target="#Profile"
            aria-expanded="<?php echo ($isControllerActive && $isActionActive ? 'true' : 'false'); ?>"
            aria-controls="collapseOne" title="">
            <span class="dashboard-menu-icon">
                <svg class="svg" width="18" height="18">
                    <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite-sidebar.svg#profile">
                    </use>
                </svg>
            </span>
            <span class="dashboard-menu-head">
                <?php echo Labels::getLabel("LBL_Profile", $siteLangId); ?>
            </span>
            <i class="dashboard-menu-arrow dropdown-toggle-custom-arrow"></i>
        </button>
        <ul class="menu-sub menu-sub-accordion collapse <?php echo ($isControllerActive && $isActionActive ? 'show' : ''); ?>"
            id="Profile" aria-labelledby="" data-parent="#dashboard-menu">
            <li
                class="menu-sub-item <?php echo ($controller == 'account' && $action == 'profileinfo') ? 'is-active' : ''; ?>">
                <a class="menu-sub-link" title="<?php echo Labels::getLabel("LBL_Account_Settings", $siteLangId); ?>"
                    href="<?php echo UrlHelper::generateUrl('Account', 'ProfileInfo'); ?>">
                    <span class="menu-sub-icon">
                        <svg class="svg" width="16" height="16">
                            <use
                                xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sidebar.svg#account-settings">
                            </use>
                        </svg>
                    </span>
                    <span
                        class="menu-sub-head"><?php echo Labels::getLabel("LBL_Account_Settings", $siteLangId); ?></span>
                </a>
            </li>
            <li
                class="menu-sub-item <?php echo ($controller == 'account' && $action == 'myaddresses') ? 'is-active' : ''; ?>">
                <a class="menu-sub-link" title="<?php echo Labels::getLabel("LBL_Manage_Addresses", $siteLangId); ?>"
                    href="<?php echo UrlHelper::generateUrl('Account', 'myAddresses'); ?>">
                    <span class="menu-sub-icon">
                        <svg class="svg" width="16" height="16">
                            <use
                                xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sidebar.svg#manage-address">
                            </use>
                        </svg>
                    </span>
                    <span
                        class="menu-sub-head"><?php echo Labels::getLabel("LBL_Manage_Addresses", $siteLangId); ?></span>
                </a>
            </li>
            <li
                class="menu-sub-item <?php echo ($controller == 'account' && $action == 'changeemailpassword') ? 'is-active' : ''; ?>">
                <a class="menu-sub-link" title="<?php echo Labels::getLabel("LBL_UPDATE_CREDENTIALS", $siteLangId); ?>"
                    href="<?php echo UrlHelper::generateUrl('Account', 'changeEmailPassword'); ?>">
                    <span class="menu-sub-icon">
                        <svg class="svg" width="16" height="16">
                            <use
                                xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sidebar.svg#update-credentials">
                            </use>
                        </svg>
                    </span>
                    <span
                        class="menu-sub-head"><?php echo Labels::getLabel('LBL_UPDATE_CREDENTIALS', $siteLangId); ?></span>
                </a>
            </li>
        </ul>
    </li>
    <?php $this->includeTemplate('_partial/dashboardLanguageArea.php'); ?>
</ul>