<div class="header-blog-top">
    <div class="container">
        <div class="header-blog-inner">
            <div class="header-blog-start">
                <?php
                $fileData = AttachedFile::getAttachment(AttachedFile::FILETYPE_FRONT_LOGO, 0, 0, $siteLangId, true);
                $aspectRatioArr = AttachedFile::getRatioTypeArray($siteLangId, true);
                $sizeType = 'CUSTOM';
                if ($fileData['afile_aspect_ratio'] == AttachedFile::RATIO_TYPE_RECTANGULAR) {
                    $sizeType = '16X9';
                } elseif ($fileData['afile_aspect_ratio'] == AttachedFile::RATIO_TYPE_SQUARE) {
                    $sizeType = '1X1';
                }

                $uploadedTime = AttachedFile::setTimeParam($fileData['afile_updated_at']);
                $siteLogo = UrlHelper::getCachedUrl(UrlHelper::generateFullFileUrl('Image', 'siteLogo', array($siteLangId, $sizeType), CONF_WEBROOT_FRONT_URL) . $uploadedTime, CONF_IMG_CACHE_TIME, '.jpg');

                ?>
                <a class="logo" href="<?php echo UrlHelper::generateUrl('Blog'); ?>">
                    <img fetchpriority="high" decoding="async" data-nimg="1"
                        <?php if ($fileData['afile_aspect_ratio'] > 0) { ?>
                        data-ratio="<?php echo $aspectRatioArr[$fileData['afile_aspect_ratio']]; ?>" <?php } ?>
                        src="<?php echo $siteLogo; ?>"
                        alt="<?php echo FatApp::getConfig('CONF_WEBSITE_NAME_' . $siteLangId); ?>"
                        title="<?php echo FatApp::getConfig('CONF_WEBSITE_NAME_' . $siteLangId) ?>">
                </a>
            </div>
            <div class="header-blog-center">
                <div class="main-search">
                    <?php $srchFrm->setFormTagAttribute('onSubmit', 'submitBlogSearch(this); return(false);');
                    $srchFrm->setFormTagAttribute('class', 'form form-search-blog');
                    $srchFrm->developerTags['colClassPrefix'] = 'col-lg-12  ';
                    $srchFrm->developerTags['fld_default_col'] = 12;
                    $keywordFld = $srchFrm->getField('keyword');
                    $keywordFld->setFieldTagAttribute('class', 'search-keyword search--keyword--js no--focus');
                    $keywordFld->setFieldTagAttribute('placeholder', Labels::getLabel('LBL_Search_In_Blogs...', $siteLangId));
                    $submitFld = $srchFrm->getField('btnProductSrchSubmit');
                    $submitFld->setFieldTagAttribute('class', ' search-btn submit--js');
                    echo $srchFrm->getFormTag();
                    echo $srchFrm->getFieldHTML('keyword');
                    echo $srchFrm->getFieldHTML('btnProductSrchSubmit');
                    echo $srchFrm->getExternalJS(); ?>
                    </form>

                </div>
            </div>
            <div class="header-blog-end">
                <div class="backto">
                    <a class="link-arrow"
                        href="<?php echo UrlHelper::generateUrl(); ?>"><?php echo Labels::getLabel('LBL_Shop', $siteLangId) . ' ' . FatApp::getConfig('CONF_WEBSITE_NAME_' . $siteLangId);  ?>
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="last-bar">
    <div class="container">
        <?php if (!empty($categoriesArr)) {
            $noOfCharAllowedInNav = 60;
            $navLinkCount = 0;
            foreach ($categoriesArr as $cat) {
                if (!$cat) {
                    break;
                }
                $noOfCharAllowedInNav = $noOfCharAllowedInNav - mb_strlen($cat);
                if ($noOfCharAllowedInNav < 0) {
                    break;
                }
                $navLinkCount++;
            } ?>

        <div class="navigation-wrapper">
            <ul class="navigation <?php echo ($navLinkCount > 4) ? 'justify-content-between' : ''; ?>">
                <?php $mainNavigation = array_slice($categoriesArr, 0, $navLinkCount, true);
                    foreach ($mainNavigation as $id => $cat) {
                        $catSelected = '';
                        if ($id == $CategoryId) {
                            $catSelected = 'is-active';
                        } ?>
                <li class="navigation-item <?php echo $catSelected; ?>">
                    <a class="navigation-link" aria-label=""
                        href="<?php echo UrlHelper::generateUrl('Blog', 'category', array($id)); ?>"><?php echo $cat; ?>
                    </a>
                </li>
                <?php } ?>
            </ul>
        </div>
        <?php } ?>
    </div>
</div>