<?php if (!empty($volumeDiscountRows)) { ?>
<div class="price-seller wholesale-price">
    <h6 class="block-title">
        <?php echo Labels::getLabel('LBL_Wholesale_Price_(Piece)', $siteLangId); ?>:
    </h6>
    <ul class="wholesale-price-list list-bullet list-bullet-tick"> 
        <?php
            foreach ($volumeDiscountRows as $volumeDiscountRow) {
                $volumeDiscount = $product['theprice'] * ($volumeDiscountRow['voldiscount_percentage'] / 100);
                $price = ($product['theprice'] - $volumeDiscount);
                ?>
        <li class="wholesale-price-item wholesale-rent-amount" class="duration-list--js"
            id="volumne_<?php echo $volumeDiscountRow['voldiscount_min_qty']; ?>"
            data-qty="<?php echo $volumeDiscountRow['voldiscount_min_qty']; ?>">
            <span class="wholesale-price-qty">
                <?php echo ($volumeDiscountRow['voldiscount_min_qty']); ?>
                <?php echo Labels::getLabel('LBL_Or_more', $siteLangId); ?>
                <span class="item__price">
                    (<?php echo $volumeDiscountRow['voldiscount_percentage'] . '%'; ?>)
                </span>
            </span>
            <span class="wholesale-price-qty item__price">
                <?php echo CommonHelper::displayMoneyFormat($price); ?>
                /
                <?php echo Labels::getLabel('LBL_Product', $siteLangId); ?></span>
        </li>
        <?php } ?>
    </ul>
</div>
<?php } ?>
<style>
    .wholesale-price-highlighted.wholesale-rent-amount{
        color: #1dc9b7;
        border-color: transparent;
        background: none;
    }
</style>