<sidebar class="collection-sidebar">
    <?php if (array_key_exists('brand_id', $postedData) && $postedData['brand_id'] > 0) {
        ?>
    <div class="brand-information">
        <div class="brand-logo">
            <?php
                $fileData = AttachedFile::getAttachment(AttachedFile::FILETYPE_BRAND_LOGO, $postedData['brand_id'], 0, 0, false);
                $aspectRatioArr = AttachedFile::getRatioTypeArray($siteLangId);
                ?>
            <img <?php if ($fileData['afile_aspect_ratio'] > 0) { ?>
                data-ratio="<?php echo $aspectRatioArr[$fileData['afile_aspect_ratio']]; ?>" <?php } ?>
                src="<?php echo UrlHelper::getCachedUrl(UrlHelper::generateFileUrl('image', 'brand', array($postedData['brand_id'], $siteLangId, 'COLLECTION_PAGE')), CONF_IMG_CACHE_TIME, '.jpg'); ?>"
                alt="<?php echo (!empty($fileData['afile_attribute_alt'])) ? $fileData['afile_attribute_alt'] : $pageTitle; ?>"
                title="<?php echo (!empty($fileData['afile_attribute_alt'])) ? $fileData['afile_attribute_alt'] : $pageTitle; ?>">
        </div>
    </div>
    <?php }
    ?>
    <div class="filters">
        <!-- [ -->
        <?php if (isset($shop) && !empty($shop)) { ?>
        <div class="shop-information">
            <?php if (0 < FatApp::getConfig("CONF_ALLOW_REVIEWS", FatUtility::VAR_INT, 0)) { ?>
            <div class="products__rating">
                <i class="icn">
                    <svg class="svg" width="20" height="20">
                        <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#star-yellow"></use>
                    </svg>
                </i>
                <span class="rate">
                    <?php
                            echo round($shopRating, 1); //, ' ', Labels::getLabel('Lbl_Out_of', $siteLangId), ' ', '5';
                            if ($shopTotalReviews) {
                                ?>
                    <!-- - <a href="<?php echo UrlHelper::generateUrl('Reviews', 'shop', array($shop['shop_id'])); ?>">
                                <?php echo $shopTotalReviews, ' ', Labels::getLabel('Lbl_Reviews', $siteLangId); ?></a> -->
                    <?php } ?>
                </span>
            </div>
            <?php } ?>
            <div class="shop-logo">
                <?php
                    $fileData = AttachedFile::getAttachment(AttachedFile::FILETYPE_SHOP_LOGO, $shop['shop_id'], 0, 0, false);
                    $aspectRatioArr = AttachedFile::getRatioTypeArray($siteLangId);
                    ?>
                <img <?php if ($fileData['afile_aspect_ratio'] > 0) { ?>
                    data-ratio="<?php echo $aspectRatioArr[$fileData['afile_aspect_ratio']]; ?>" <?php } ?>
                    src="<?php echo UrlHelper::generateUrl('image', 'shopLogo', array($shop['shop_id'], $siteLangId, 'SMALL')); ?>"
                    alt="<?php echo $shop['shop_name']; ?>">
            </div>

            <div class="shop-info">
                <div class="shop-name">
                    <h5>
                        <?php echo $shop['shop_name']; ?>
                    </h5>
                    <span class="location">
                        <i class="icn icn-location">
                            <svg class="svg" height="16" width="12">
                                <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#location">
                                </use>
                            </svg>
                        </i>
                        <?php echo $shop['shop_state_name'] . ', ' . $shop['shop_country_name']; ?>
                    </span>
                    <span class="blk-txt">
                        <?php echo Labels::getLabel('LBL_Shop_Opened_On', $siteLangId); ?>
                        <strong>
                            <?php
                                $date = new DateTime($shop['user_regdate']);
                                echo $date->format('M d, Y');
                                ?>
                        </strong>
                    </span>
                </div>

                <div class="shop-btn-group">

                    <!-- Button trigger modal -->

                    <button data-toggle="tooltip" class="no-after share-icon" data-bs-toggle="modal"
                        data-bs-target="#shareModal">

                        <svg class="svg" width="24" height="24">
                            <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#share">
                            </use>
                        </svg>

                    </button>

                    <!-- Modal -->
                    <div class="modal fade" id="shareModal" tabindex="-1" role="dialog" aria-labelledby="shareModal"
                        aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered" role="document">
                            <div class="modal-content">
                                <div class="modal-header border-bottom-0">
                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <div class="share-wrap">
                                        <h6>
                                            <?php echo Labels::getLabel('LBL_Share_this_via', $siteLangId); ?>
                                        </h6>
                                        <ul class="social-sharing">
                                            <li class="social-facebook">
                                                <a class="st-custom-button" data-network="facebook"
                                                    data-url="<?php echo UrlHelper::generateFullUrl('Products', 'view', array($shop['shop_id'])); ?>/">
                                                    <i class="icn"><svg class="svg" width="20" height="20">
                                                            <use
                                                                xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#fb">
                                                            </use>
                                                        </svg></i>
                                                </a>
                                            </li>
                                            <li class="social-twitter">
                                                <a class="st-custom-button" data-network="twitter">
                                                    <i class="icn"><svg class="svg" width="20" height="20">
                                                            <use
                                                                xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#twitter">
                                                            </use>
                                                        </svg></i>
                                                </a>
                                            </li>
                                            <li class="social-pintrest">
                                                <a class="st-custom-button" data-network="pinterest">
                                                    <i class="icn"><svg class="svg" width="20" height="20">
                                                            <use
                                                                xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#pt">
                                                            </use>
                                                        </svg></i>
                                                </a>
                                            </li>
                                            <li class="social-email">
                                                <a class="st-custom-button" data-network="email">
                                                    <i class="icn"><svg class="svg" width="20" height="20">
                                                            <use
                                                                xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#envelope">
                                                            </use>
                                                        </svg></i>
                                                </a>
                                            </li>
                                        </ul>
                                        <h6 class="mt-5">
                                            <?php echo Labels::getLabel('LBL_Share_this_via', $siteLangId); ?>
                                        </h6>
                                        <div class="clipboard">
                                            <span class="copy-input clipboardTextJs">
                                                <?php echo UrlHelper::generateFullUrl('Products', 'view', array($shop['shop_id'])); ?>
                                            </span>
                                            <button class="copy-btn" type="button" onclick="copyText(this, true)"
                                                data-bs-toggle="tooltip" data-placement="top" title=""
                                                data-bs-original-title="Copy to clipboard">
                                                <svg class="svg" width="18" height="18">
                                                    <use
                                                        xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#copy-to-all">
                                                    </use>
                                                </svg>
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php
                        $showAddToFavorite = true;
                        if (UserAuthentication::isUserLogged() && (!User::isBuyer())) {
                            $showAddToFavorite = false;
                        }
                        ?>
                    <?php if ($showAddToFavorite) { ?>
                    <button
                        title="<?php echo ($shop['is_favorite']) ? Labels::getLabel('Lbl_Unfavorite_Shop', $siteLangId) : Labels::getLabel('Lbl_Favorite_Shop', $siteLangId); ?>"
                        onclick="toggleShopFavorite(<?php echo $shop['shop_id']; ?>);"
                        class="btn btn-brand <?php echo ($shop['is_favorite']) ? 'is-active' : ''; ?>"
                        id="shop_<?php echo $shop['shop_id']; ?>"><i class="icn"><svg class="svg" width="20"
                                height="20">
                                <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#heart"></use>
                            </svg></i></button>
                    <?php } ?>
                    <?php
                        $showMoreButtons = true;
                        if (isset($userParentId) && $userParentId == $shop['shop_user_id']) {
                            $showMoreButtons = false;
                        }
                        ?>
                    <?php
                        if ($showMoreButtons) {
                            $shopRepData = ShopReport::getReportDetail($shop['shop_id'], UserAuthentication::getLoggedUserId(true), 'sreport_id');
                            if (false === UserAuthentication::isUserLogged() || empty($shopRepData)) {
                                ?>
                    <a href="<?php echo UrlHelper::generateUrl('Shops', 'ReportSpam', array($shop['shop_id'])); ?>"
                        title="<?php echo Labels::getLabel('Lbl_Report_Spam', $siteLangId); ?>" class="btn btn-brand"><i
                            class="icn"><svg class="svg" width="20" height="20">
                                <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#report"></use>
                            </svg></i></a>
                    <?php } ?>
                    <?php if (!UserAuthentication::isUserLogged() || (UserAuthentication::isUserLogged() && ((User::isBuyer()) || (User::isSeller())))) { ?>
                    <a href="<?php echo UrlHelper::generateUrl('shops', 'sendMessage', array($shop['shop_id'])); ?>"
                        title="<?php echo Labels::getLabel('Lbl_Send_Message', $siteLangId); ?>"
                        class="btn btn-brand"><i class="icn"><svg class="svg" width="20" height="20">
                                <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#icon-msg">
                                </use>
                            </svg></i></a>
                    <?php } ?>
                    <?php } ?>
                </div>
                <?php if ($socialPlatforms) { ?>
                <div class="social-profiles">
                    <p><strong>
                            <?php echo Labels::getLabel('LBL_Follow_Us', $siteLangId); ?>
                        </strong> </p>
                    <ul class="social-icons">
                        <?php foreach ($socialPlatforms as $row) { ?>
                        <li>
                            <a <?php if ($row['splatform_url'] != '') { ?> target="_blank" <?php } ?>
                                href="<?php echo ($row['splatform_url'] != '') ? $row['splatform_url'] : 'javascript:void(0)'; ?>">
                                <svg class="svg" width="24" height="24">
                                    <use
                                        xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#<?php echo $row['splatform_icon_class']; ?>">
                                    </use>
                                </svg>
                            </a>
                        </li>
                        <?php } ?>
                    </ul>
                </div>
                <?php } ?>
            </div>
        </div>
        <?php } ?>
        <!-- ] -->

        <h2 class="text-uppercase">
            <?php echo Labels::getLabel('LBL_FILTERS', $siteLangId); ?>
        </h2>
        <div class="filters__ele productFilters-js"></div>
    </div>
</sidebar>