<?php
if (isset($collection['testimonials']) && count($collection['testimonials']) > 0) { ?>
<section class="section collection-testimonial" data-collection="collection-name"
    style="background-color:rgba(var(--brand-color-alpha),0.2)">
    <div class="container">
        <div class="section-head section-head-center">
            <div class="section-heading">
                <h2>
                    <?php echo $collection['collection_name']; ?>
                </h2>
                <h5>
                    <?php echo $collection['collection_description']; ?>
                </h5>
            </div>
        </div>
        <div class="testimonial-wrapper js--single" dir="<?php echo CommonHelper::getLayoutDirection(); ?>">
            <?php foreach ($collection['testimonials'] as $testimonial) { ?>
            <div class="">
                <div class="testimonial">
                    <div class="testimonial__quotes">
                        <img alt="<?php echo $testimonial['testimonial_title']; ?>"
                            src="<?php echo CONF_WEBROOT_URL; ?>images/<?php echo ACTIVE_THEME; ?>/retina/quotes-test.svg">
                    </div>
                    <div class="testimonial__body">
                        <?php
                                echo $testimonial['testimonial_title'] . '<br />';
                                echo CommonHelper::truncateCharacters($testimonial['testimonial_text'], 250, '', '', true);
								if($testimonial['testimonial_text'] != '') {
									echo (strlen($testimonial['testimonial_text']) > 150) ? '...' : "";
								}
                                ?>
                    </div>
                    <div class="testimonial__foot">
                        <div class="user">
                            <div class="user__media">
                                <img alt="<?php echo $testimonial['testimonial_user_name']; ?>"
                                    src="<?php echo UrlHelper::generateUrl('Image', 'testimonial', array($testimonial['testimonial_id'], $siteLangId, 'THUMB')); ?>" />
                            </div>
                            <div class="user__detail">
                                <h5>
                                    <?php echo $testimonial['testimonial_user_name']; ?>
                                </h5>
                                <span>
                                    <?php echo $testimonial['testimonial_author_city']; ?>
                                </span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php } ?>
        </div>
        <div class="flex-center mt-btn">
            <a href="<?php echo UrlHelper::generateUrl('testimonials'); ?>"
                class="btn btn-outline-brand btn-round btn-arrow-right">
                <?php echo Labels::getLabel('LBL_VIEW_ALL', $siteLangId); ?>
            </a>
        </div>
    </div>
</section>
<?php } ?>
<script>
$('.js--single').slick({
    dots: true,
    arrows: false,
    infinite: true,
    speed: 300,
    slidesToShow: 2,
    slidesToScroll: 1,
    centerMode: false,
    rtl: ('rtl' == langLbl.layoutDirection),
    responsive: [{
            breakpoint: 1200,
            settings: {
                slidesToShow: 2,
            }
        },
        {
            breakpoint: 800,
            settings: {
                slidesToShow: 1,
            }
        },
    ]
});
</script>