<?php if (isset($collection['cbs']) && count($collection['cbs']) > 0) { ?>
    <section class="section how-we-work">
        <div class="container">
            <div class="section-head section-head-center">
                <div class="section-heading">
                    <h2><?php echo $collection['collection_name']; ?></h2>
                    <h5><?php echo $collection['collection_description']; ?></h5>
                </div>
            </div>
            <div class="row align-items-center">
                <div class="col-lg-6">
                    <div class="work-media">
                        <img alt="<?php echo $collection['collection_name']; ?>"
                            src="<?php echo UrlHelper::generateFullUrl('Image', 'collectionReal', array($collection['collection_id'], $siteLangId, 'ORIGINAL')); ?>">
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="work-list">
                        <ul>
                            <?php foreach ($collection['cbs'] as $block) { ?>
                                <li>
                                    <h4><?php echo $block['cbs_name']; ?></h4>
									<?php if($block['cbslang_description'] != '') { ?>
                                    <p><?php echo html_entity_decode($block['cbslang_description']); ?></p>
									<?php } ?>
                                </li>
                            <?php } ?>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php } ?>