<?php if (isset($collection['blogs']) && count($collection['blogs']) > 0) { ?>
    <section class="section collection-blog" data-collection="collection-name">
        <div class="container">
            <div class="section-head section-head-center">
                <div class="section-heading">
                    <?php echo ($collection['collection_name'] != '') ? ' <h2>' . $collection['collection_name'] . '</h2>' : ''; ?>
                    <?php echo ($collection['collection_description'] != '') ? ' <h5>' . $collection['collection_description'] . '</h5>' : ''; ?>
                </div>
            </div>
            <div class="blogs">
                <?php foreach ($collection['blogs'] as $blog) { ?>
                    <a class="blogs-item"
                        href="<?php echo UrlHelper::generateUrl('Blog', 'postDetail', array($blog['post_id'])); ?>">
                        <div class="blogs-media">
                            <img src="<?php echo UrlHelper::generateFullUrl('Image', 'blogPostFront', array($blog['post_id'], $siteLangId, 'AUTOFEATURED', 0, 0, true)); ?>"
                                alt="<?php echo (!empty($fileRow['afile_attribute_alt'])) ? $fileRow['afile_attribute_alt'] : $blog['post_title']; ?>"
                                title="<?php echo (!empty($fileRow['afile_attribute_title'])) ? $fileRow['afile_attribute_title'] : $blog['post_title']; ?>" />
                        </div>
                        <div class="blogs-content">
                            <div class="blogs-detail">
                                <span class="blogs-date">
                                    <?php echo date('jS F Y', strtotime($blog['post_updated_on'])); ?><span
                                        class="slash">|</span>
                                    <?php echo $blog['post_author_name']; ?>
                                </span>
                                <span class="blogs-title"
                                    href="<?php echo UrlHelper::generateUrl('Blog', 'postDetail', array($blog['post_id'])); ?>">
                                    <?php
                                    $title = !empty($blog['post_title']) ? $blog['post_title'] : $blog['post_identifier'];
                                    echo mb_strimwidth($title, 0, applicationConstants::BLOG_TITLE_CHARACTER_LENGTH, '...');
                                    ?>
                                </span>
                                <p>
                                    <?php 
									if($blog['post_short_description'] != '') {
										echo FatUtility::decodeHtmlEntities($blog['post_short_description']);
									}										
									?>
                                </p>
                            </div>

                        </div>

                    </a>
                <?php } ?>
            </div>
            <div class="flex-center mt-btn">
                <a class="btn btn-outline-brand btn-round btn-arrow-right"
                    href="<?php echo UrlHelper::generateUrl('Blog'); ?>">
                    <?php echo Labels::getLabel('LBL_VIEW_ALL', $siteLangId); ?>
                </a>
            </div>
        </div>
    </section>
<?php } ?>