<?php

class applicationConstants
{

    public const YES = 1;
    public const NO = 0;

    public const DAILY = 0;
    public const WEEKLY = 1;
    public const MONTHLY = 2;

    public const ON = 1;
    public const OFF = 0;

    public const SUCCESS = 1;
    public const FAILURE = 0;

    public const ACTIVE = 1;
    public const INACTIVE = 0;

    public const WEIGHT_GRAM = 1;
    public const WEIGHT_KILOGRAM = 2;
    public const WEIGHT_POUND = 3;

    public const LENGTH_CENTIMETER = 1;
    public const LENGTH_METER = 2;
    public const LENGTH_INCH = 3;

    public const NEWS_LETTER_SYSTEM_MAILCHIMP = 1;
    public const NEWS_LETTER_SYSTEM_AWEBER = 2;

    public const LINK_TARGET_CURRENT_WINDOW = "_self";
    public const LINK_TARGET_BLANK_WINDOW = "_blank";

    public const PERCENTAGE = 1;
    public const FLAT = 2;

    public const PUBLISHED = 1;
    public const DRAFT = 0;

    public const BLOG_CONTRIBUTION_PENDING = 0;
    public const BLOG_CONTRIBUTION_APPROVED = 1;
    public const BLOG_CONTRIBUTION_POSTED = 2;
    public const BLOG_CONTRIBUTION_REJECTED = 3;

    public const GENDER_MALE = 1;
    public const GENDER_FEMALE = 2;
    public const GENDER_OTHER = 3;

    public const DISCOUNT_COUPON = 1;
    public const DISCOUNT_REWARD_POINTS = 2;

    public const SCREEN_DESKTOP = 1;
    public const SCREEN_IPAD = 2;
    public const SCREEN_MOBILE = 3;

    public const CHECKOUT_PRODUCT = 1;
    public const CHECKOUT_SUBSCRIPTION = 2;
    public const CHECKOUT_PPC = 3;
    public const CHECKOUT_ADD_MONEY_TO_WALLET = 4;

    public const SMTP_TLS = 'tls';
    public const SMTP_SSL = 'ssl';

    public const LAYOUT_LTR = 'ltr';
    public const LAYOUT_RTL = 'rtl';

    public const SYSTEM_CATALOG = 0;
    public const CUSTOM_CATALOG = 1;

    public const DIGITAL_DOWNLOAD_FILE = 0;
    public const DIGITAL_DOWNLOAD_LINK = 1;
    public const DASHBOARD_PAGE_SIZE = 3;
    public const PAGE_SIZE = 20;

    public const ALLOWED_HTML_TAGS_FOR_APP = '<b><strong><i><u><small><br><p><h1><h2><h3><h4><h5><h6><div><a>';

    public const MOBILE_SCREEN_WIDTH = 768;

    public const URL_TYPE_EXTERNAL = 1;
    public const URL_TYPE_SHOP = 2;
    public const URL_TYPE_PRODUCT = 3;
    public const URL_TYPE_CATEGORY = 4;
    public const URL_TYPE_BRAND = 5;
    public const URL_TYPE_COLLECTION = 6;
    public const URL_TYPE_CONTACT_US = 7;
    public const URL_TYPE_SIGN_IN = 8;
    public const URL_TYPE_REGISTER = 9;
    public const URL_TYPE_CMS = 10;
    public const URL_TYPE_BLOG = 11;

    public const SMS_CHARACTER_LENGTH = 160;
    public const DEFAULT_STRING_LENGTH = 70;
    public const BLOG_TITLE_CHARACTER_LENGTH = 70; /* Used for home page collection.*/
    public const BLOG_DESCRIPTION_CHARACTER_LENGTH = 90; /* Used for home page collection.*/

    public const BASED_ON_DELIVERY_LOCATION = 1;
    public const BASED_ON_RADIUS = 2;
    public const BASED_ON_CURRENT_LOCATION = 3;

    public const LOCATION_COUNTRY = 0;
    public const LOCATION_STATE = 1;
    public const LOCATION_ZIP = 2;

    public const CLASS_INFO = 'badge-info';
    public const CLASS_SUCCESS = 'badge-success';
    public const CLASS_DANGER = 'badge-danger';
    public const CLASS_WARNING = 'badge-warning';
    
    public const PRODUCT_FOR_SALE = 1;
    public const PRODUCT_FOR_RENT = 2;
    public const PRODUCT_FOR_EXTEND_RENTAL = 3;
    
    public const RENT_TYPE_HOUR = 1;
    public const RENT_TYPE_DAY = 2;
    public const RENT_TYPE_WEEK = 3;
    public const RENT_TYPE_MONTH = 4;
    public const PRODUCT_IS_SELF_PICKUP = 1;
    
    public const ORDER_TYPE_SALE = 1;
    public const ORDER_TYPE_RENT = 2;
    
    public const THEME_DEFAULT = 1;
	public const THEME_FASHION = 2;
    public const THEME_HEAVY_EQUIPMENT = 3;
    public const THEME_AUTOMOBILE = 4;
    
    public const CURRENCY_SEPARATOR_DECIMAL = '.';
    public const CURRENCY_SEPARATOR_COMMA = ',';
    public const USER_TYPE_BUYER = 1;
    public const USER_TYPE_SELLER = 2;
    
	
    public static function getActiveTheme()
    {
        if (defined('ACTIVE_THEME_ID')) {
            return ACTIVE_THEME_ID;
        }else{
            return FatApp::getConfig('CONF_ACTIVE_THEME_ID', FatUtility::VAR_INT, 1);
        }

    }

    public static function getWeightUnitsArr($langId, $unitOnly = false)
    {
        $langId = FatUtility::int($langId);
        if ($langId < 1) {
            $langId = FatApp::getConfig('CONF_ADMIN_DEFAULT_LANG');
        }

        if (true == $unitOnly) {
            return array(
                static::WEIGHT_GRAM => 'GM',
                static::WEIGHT_KILOGRAM => 'KG',
                static::WEIGHT_POUND => 'PN',
            );
        }

        return array(
            static::WEIGHT_GRAM => Labels::getLabel('LBL_Gram', $langId),
            static::WEIGHT_KILOGRAM => Labels::getLabel('LBL_Kilogram', $langId),
            static::WEIGHT_POUND => Labels::getLabel('LBL_Pound', $langId),
        );
    }

    public static function bannerTypeArr()
    {
        $bannerTypeArr = Language::getAllNames();
        return array(0 => Labels::getLabel('LBL_All_Languages', CommonHelper::getLangId())) + $bannerTypeArr;
    }

    public static function digitalDownloadTypeArr($langId)
    {
        $langId = FatUtility::int($langId);
        if ($langId < 1) {
            $langId = FatApp::getConfig('CONF_ADMIN_DEFAULT_LANG');
        }
        return array(
            static::DIGITAL_DOWNLOAD_FILE => Labels::getLabel('LBL_Digital_download_file', $langId),
            static::DIGITAL_DOWNLOAD_LINK => Labels::getLabel('LBL_Digital_download_link', $langId),
        );
    }

    public static function getOrderTypeArr($langId)
    {
        $langId = FatUtility::int($langId);
        if ($langId < 1) {
            $langId = FatApp::getConfig('CONF_ADMIN_DEFAULT_LANG');
        }
        return array(
            static::ORDER_TYPE_SALE => Labels::getLabel('LBL_Sale', $langId),
            static::ORDER_TYPE_RENT => Labels::getLabel('LBL_Rent', $langId),
        );
    }

    public static function getLengthUnitsArr($langId, $unitOnly = false)
    {
        $langId = FatUtility::int($langId);
        if ($langId < 1) {
            $langId = FatApp::getConfig('CONF_ADMIN_DEFAULT_LANG');
        }

        if (true == $unitOnly) {
            return array(
                static::LENGTH_CENTIMETER => 'CM',
                static::LENGTH_METER => 'M',
                static::LENGTH_INCH => 'IN',
            );
        }

        return array(
            static::LENGTH_CENTIMETER => Labels::getLabel('LBL_CentiMeter', $langId),
            static::LENGTH_METER => Labels::getLabel('LBL_Meter', $langId),
            static::LENGTH_INCH => Labels::getLabel('LBL_Inch', $langId),
        );
    }

    public static function getYesNoArr($langId)
    {
        $langId = FatUtility::int($langId);
        if ($langId < 1) {
            $langId = FatApp::getConfig('CONF_ADMIN_DEFAULT_LANG');
        }

        return array(
            static::YES => Labels::getLabel('LBL_Yes', $langId),
            static::NO => Labels::getLabel('LBL_No', $langId)
        );
    }

    public static function getYesNoClassArr()
    {
        return array(
            static::YES => applicationConstants::CLASS_SUCCESS,
            static::NO => applicationConstants::CLASS_DANGER
        );
    }

    public static function getActiveInactiveArr($langId)
    {
        $langId = FatUtility::int($langId);
        if ($langId < 1) {
            $langId = FatApp::getConfig('CONF_ADMIN_DEFAULT_LANG');
        }

        return array(
            static::ACTIVE => Labels::getLabel('LBL_Active', $langId),
            static::INACTIVE => Labels::getLabel('LBL_In-active', $langId)
        );
    }

    public static function getActiveInactiveClassArr()
    {
        return array(
            static::ACTIVE => static::CLASS_SUCCESS,
            static::INACTIVE => static::CLASS_DANGER
        );
    }

    public static function getBooleanArr($langId)
    {
        $langId = FatUtility::int($langId);
        if ($langId < 1) {
            $langId = FatApp::getConfig('CONF_ADMIN_DEFAULT_LANG');
        }

        return array(
            1 => Labels::getLabel('LBL_True', $langId),
            0 => Labels::getLabel('LBL_False', $langId)
        );
    }

    public static function getOnOffArr($langId)
    {
        $langId = FatUtility::int($langId);
        if ($langId < 1) {
            $langId = FatApp::getConfig('CONF_ADMIN_DEFAULT_LANG');
        }

        return array(
            static::ON => Labels::getLabel('LBL_On', $langId),
            static::OFF => Labels::getLabel('LBL_Off', $langId)
        );
    }

    public static function getNewsLetterSystemArr($langId)
    {
        $langId = FatUtility::int($langId);
        if ($langId < 1) {
            $langId = FatApp::getConfig('CONF_ADMIN_DEFAULT_LANG');
        }

        return array(
            static::NEWS_LETTER_SYSTEM_MAILCHIMP => Labels::getLabel('LBL_Mailchimp', $langId),
            static::NEWS_LETTER_SYSTEM_AWEBER => Labels::getLabel('LBL_Aweber', $langId),
        );
    }

    public static function getLinkTargetsArr($langId)
    {
        $langId = FatUtility::int($langId);
        if ($langId < 1) {
            $langId = FatApp::getConfig('CONF_ADMIN_DEFAULT_LANG');
        }
        return array(
            static::LINK_TARGET_CURRENT_WINDOW => Labels::getLabel('LBL_Same_Window', $langId),
            static::LINK_TARGET_BLANK_WINDOW => Labels::getLabel('LBL_New_Window', $langId)
        );
    }

    /* static function getUserTypesArr($langId){
      $langId = FatUtility::int($langId);
      if($langId < 1){
      $langId = FatApp::getConfig('CONF_ADMIN_DEFAULT_LANG');
      }
      return array(
      1=>Labels::getLabel('LBL_Seller', $langId),
      2=>Labels::getLabel('LBL_Buyer', $langId)
      );
      } */

    public static function getPercentageFlatArr($langId)
    {
        $langId = FatUtility::int($langId);
        if ($langId < 1) {
            $langId = FatApp::getConfig('CONF_ADMIN_DEFAULT_LANG');
        }
        return array(
            static::PERCENTAGE => Labels::getLabel('LBL_Percentage', $langId),
            static::FLAT => Labels::getLabel('LBL_Flat', $langId)
        );
    }

    public static function allowedMimeTypes()
    {
        return array('text/plain', 'image/png', 'image/jpeg', 'image/jpg', 'image/gif', 'image/bmp', 'image/tiff', 'image/svg+xml', 'application/zip', 'application/x-zip', 'application/x-zip-compressed', 'application/rar', 'application/x-rar', 'application/x-rar-compressed', 'application/octet-stream', 'audio/mpeg', 'video/quicktime', 'application/pdf', 'application/vnd.openxmlformats-officedocument.wordprocessingml.document', 'application/msword', 'text/plain', 'image/x-icon', 'video/mp4', 'image/webp');
    }

    public static function allowedFileExtensions()
    {
        return array('zip', 'txt', 'png', 'jpeg', 'jpg', 'gif', 'bmp', 'ico', 'tiff', 'tif', 'svg', 'svgz', 'rar', 'msi', 'cab', 'mp3', 'qt', 'mov', 'pdf', 'psd', 'ai', 'eps', 'ps', 'doc', 'docx', 'mp4', 'webp');
    }
	
	public static function allowedImageFileExtensions()
    {
        return ['png', 'jpeg', 'jpg', 'gif'];
    }

    public static function getBlogPostStatusArr($langId)
    {
        $langId = FatUtility::int($langId);
        if ($langId < 1) {
            $langId = FatApp::getConfig('CONF_ADMIN_DEFAULT_LANG');
        }

        return array(
            static::DRAFT => Labels::getLabel('LBL_Draft', $langId),
            static::PUBLISHED => Labels::getLabel('LBL_Published', $langId),
        );
    }

    public static function getBlogContributionStatusArr($langId)
    {
        $langId = FatUtility::int($langId);
        if ($langId < 1) {
            $langId = FatApp::getConfig('CONF_ADMIN_DEFAULT_LANG');
        }

        return array(
            static::BLOG_CONTRIBUTION_PENDING => Labels::getLabel('LBL_Pending', $langId),
            static::BLOG_CONTRIBUTION_APPROVED => Labels::getLabel('LBL_Approved', $langId),
            static::BLOG_CONTRIBUTION_POSTED => Labels::getLabel('LBL_Posted', $langId),
            static::BLOG_CONTRIBUTION_REJECTED => Labels::getLabel('LBL_Rejected', $langId),
        );
    }

    public static function getBlogCommentStatusArr($langId)
    {
        $langId = FatUtility::int($langId);
        if ($langId < 1) {
            $langId = FatApp::getConfig('CONF_ADMIN_DEFAULT_LANG');
        }

        return array(
            static::INACTIVE => Labels::getLabel('LBL_Pending', $langId),
            static::ACTIVE => Labels::getLabel('LBL_Approved', $langId)
        );
    }

    public static function getGenderArr($langId)
    {
        $langId = FatUtility::int($langId);
        if ($langId < 1) {
            $langId = FatApp::getConfig('CONF_ADMIN_DEFAULT_LANG');
        }
        return array(
            static::GENDER_MALE => Labels::getLabel('LBL_Male', $langId),
            static::GENDER_FEMALE => Labels::getLabel('LBL_Female', $langId),
            static::GENDER_OTHER => Labels::getLabel('LBL_Other', $langId),
        );
    }

    public static function getDisplaysArr($langId)
    {
        $langId = FatUtility::int($langId);
        if ($langId < 1) {
            $langId = FatApp::getConfig('CONF_ADMIN_DEFAULT_LANG');
        }

        return array(
            static::SCREEN_DESKTOP => Labels::getLabel('LBL_Desktop', $langId),
            static::SCREEN_IPAD => Labels::getLabel('LBL_Ipad', $langId),
            static::SCREEN_MOBILE => Labels::getLabel('LBL_Mobile', $langId)
        );
    }

    public static function getExcludePaymentGatewayArr()
    {
        return array(
            static::CHECKOUT_PRODUCT => array(''),
            static::CHECKOUT_SUBSCRIPTION => array(
                'CashOnDelivery',
                'TransferBank',
                'PayAtStore'
            ),
            static::CHECKOUT_PPC => array(
                'CashOnDelivery',
                'TransferBank',
                'PayAtStore'
            ),
            static::CHECKOUT_ADD_MONEY_TO_WALLET => array(
                'CashOnDelivery',
                'TransferBank',
                'PayAtStore'
            )
        );
    }

    public static function getCatalogTypeArr($langId)
    {
        return array(
            static::CUSTOM_CATALOG => Labels::getLabel('LBL_Custom_Products', $langId),
            static::SYSTEM_CATALOG => Labels::getLabel('LBL_Catalog_Products', $langId)
        );
    }

    public static function getCatalogTypeArrForFrontEnd($langId)
    {
        return array(
            static::SYSTEM_CATALOG => Labels::getLabel('LBL_Marketplace_Products', $langId),
            static::CUSTOM_CATALOG => Labels::getLabel('LBL_My_Private_Products', $langId)
        );
    }

    public static function getShopBannerSize()
    {
        return array(
            Shop::TEMPLATE_ONE => '2000*500',
            Shop::TEMPLATE_TWO => '1300*600',
            Shop::TEMPLATE_THREE => '1350*410',
            Shop::TEMPLATE_FOUR => '1350*410',
            Shop::TEMPLATE_FIVE => '1350*570'
        );
    }

    public static function getSmtpSecureArr($langId)
    {
        return array(
            static::SMTP_TLS => Labels::getLabel('LBL_tls', $langId),
            static::SMTP_SSL => Labels::getLabel('LBL_ssl', $langId),
        );
    }

    public static function getSmtpSecureSettingsArr()
    {
        return array(
            static::SMTP_TLS => 'tls',
            static::SMTP_SSL => 'ssl',
        );
    }

    public static function getLayoutDirections($langId)
    {
        return array(
            static::LAYOUT_LTR => Labels::getLabel('LBL_Left_To_Right', $langId),
            static::LAYOUT_RTL => Labels::getLabel('LBL_Right_To_Left', $langId),
        );
    }

    public static function getMonthsArr($langId)
    {
        return array(
            '01' => Labels::getLabel('LBL_January', $langId),
            '02' => Labels::getLabel('LBL_Februry', $langId),
            '03' => Labels::getLabel('LBL_March', $langId),
            '04' => Labels::getLabel('LBL_April', $langId),
            '05' => Labels::getLabel('LBL_May', $langId),
            '06' => Labels::getLabel('LBL_June', $langId),
            '07' => Labels::getLabel('LBL_July', $langId),
            '08' => Labels::getLabel('LBL_August', $langId),
            '09' => Labels::getLabel('LBL_September', $langId),
            '10' => Labels::getLabel('LBL_October', $langId),
            '11' => Labels::getLabel('LBL_November', $langId),
            '12' => Labels::getLabel('LBL_December', $langId),
        );
    }

    public static function getProductListingSettings($langId)
    {
        return array(
            static::BASED_ON_DELIVERY_LOCATION => Labels::getLabel('LBL_BASED_ON_DELIVERY_LOCATION', $langId),
            static::BASED_ON_RADIUS => Labels::getLabel('LBL_BASED_ON_RADIUS', $langId),
            static::BASED_ON_CURRENT_LOCATION => Labels::getLabel('LBL_BASED_ON_CURRENT_LOCATION', $langId),
        );
    }

    public static function getLocationLevels($langId)
    {
        return array(
            static::LOCATION_COUNTRY => Labels::getLabel('LBL_COUNTRY_LEVEL', $langId),
            static::LOCATION_STATE => Labels::getLabel('LBL_STATE_LEVEL', $langId),
            static::LOCATION_ZIP => Labels::getLabel('LBL_POSTAL_CODE_LEVEL', $langId),
        );
    }

    public static function getClassArr()
    {
        return array(
            0 => applicationConstants::CLASS_INFO,
            1 => applicationConstants::CLASS_SUCCESS,
            2 => applicationConstants::CLASS_DANGER,
            3 => applicationConstants::CLASS_WARNING
        );
    }

    public static function getClassArrForOrderStatus()
    {
        return array(
            0 => 'info',
            1 => 'success',
            2 => 'danger',
            3 => 'warning'
        );
    }

    public static function getClassColor(string $class): string
    {
        switch ($class) {
            case applicationConstants::CLASS_INFO:
                return '#5578eb';
                break;
            case applicationConstants::CLASS_SUCCESS:
                return '#1dc9b7';
                break;
            case applicationConstants::CLASS_DANGER:
                return '#fd397a';
                break;
            case applicationConstants::CLASS_WARNING:
                return '#ffb822';
                break;

            default:
                return '#000000';
                break;
        }
    }

    public static function rentalTypeArr($langId)
    {
        $langId = FatUtility::int($langId);
        if ($langId < 1) {
            $langId = FatApp::getConfig('CONF_ADMIN_DEFAULT_LANG');
        }
        return array(
            static::RENT_TYPE_HOUR => Labels::getLabel('LBL_Hour', $langId),
            static::RENT_TYPE_DAY => Labels::getLabel('LBL_Day', $langId),
            static::RENT_TYPE_WEEK => Labels::getLabel('LBL_Week', $langId),
            static::RENT_TYPE_MONTH => Labels::getLabel('LBL_Month', $langId),
        );
    }
	
    public static function minRentalDurationTypeArr($langId)
    {
        $langId = FatUtility::int($langId);
        if ($langId < 1) {
            $langId = FatApp::getConfig('CONF_ADMIN_DEFAULT_LANG');
        }
        return array(
            static::RENT_TYPE_HOUR => Labels::getLabel('LBL_Hour', $langId),
            static::RENT_TYPE_DAY => Labels::getLabel('LBL_Day', $langId)
        );
    }

    public static function getProductTypesArr(int $langId)
    {
        $langId = FatUtility::int($langId);
        if ($langId < 1) {
            $langId = FatApp::getConfig('CONF_ADMIN_DEFAULT_LANG');
        }

        return array(
            static::PRODUCT_FOR_SALE => Labels::getLabel('LBL_Sale', $langId),
            static::PRODUCT_FOR_RENT => Labels::getLabel('LBL_Rent', $langId)
        );
    }

    public static function getNavigationCharLimit()
    {
        return [
            static::THEME_DEFAULT => [
                'main_nav' => 500,
                'other_nav' => 5,
            ],
            static::THEME_FASHION => [
                'main_nav' => 500,
                'other_nav' => 5,
            ],
            static::THEME_HEAVY_EQUIPMENT => [
                'main_nav' => 500,
                'other_nav' => 10,
            ]
        ];
    }

    public static function currencySeparatorArr($langId)
    {
        return array(
            static::CURRENCY_SEPARATOR_DECIMAL => Labels::getLabel('LBL_Decimal_(_._)', $langId),
            static::CURRENCY_SEPARATOR_COMMA => Labels::getLabel('LBL_Comma_(_,_)', $langId)
        );
    }
	
	public static function getActiveRentalDurations()
	{
		$durationType = FatApp::getConfig('CONF_DURATION_TYPES', FatUtility::VAR_STRING, '');
		if($durationType == '') {
			return [static::RENT_TYPE_DAY];
		}
		
		return unserialize($durationType);
	}

    public static function checkActiveRentalDurations($type)
    {
        static $cachedDurationTypes = null;
        if ($cachedDurationTypes === null) {
            $durationType = FatApp::getConfig('CONF_DURATION_TYPES', FatUtility::VAR_STRING, '');
            $cachedDurationTypes = $durationType === '' 
                ? [static::RENT_TYPE_DAY] 
                : unserialize($durationType);
        }
        return in_array($type, $cachedDurationTypes);
    }
	
	public static function isProdMulRentalPricesActivated() 
	{
		$res = FatApp::getConfig('CONF_ACTIVE_PRODUCT_MULTIPLE_RENTAL_PRICES', FatUtility::VAR_INT, 0);
		if(intval($res) == 1) {
			return true;
		}
		return false;
	}

    public static function getSpecialPrice($data){

            if(self::checkActiveRentalDurations(ProductRental::DURATION_TYPE_HOUR) && !empty($data['splprice_hour_price']) && $data['splprice_hour_price'] > 0){
                return $data['splprice_hour_price'];
            }else if(self::checkActiveRentalDurations(ProductRental::DURATION_TYPE_DAY) && !empty($data['splprice_day_price']) && $data['splprice_day_price'] > 0){
                return $data['splprice_day_price'];
            }else if(self::checkActiveRentalDurations(ProductRental::DURATION_TYPE_WEEK) && !empty($data['splprice_week_price']) && $data['splprice_week_price'] > 0){
                return $data['splprice_week_price'];
            }else if(self::checkActiveRentalDurations(ProductRental::DURATION_TYPE_MONTH) && !empty($data['splprice_month_price']) && $data['splprice_month_price'] > 0){
                return $data['splprice_month_price'];
            }
            return 0;
    }

    public static function updateSpecialPrice(&$data){

        if(self::checkActiveRentalDurations(ProductRental::DURATION_TYPE_HOUR) && !empty($data['sprodata_hour_rental_price']) && $data['sprodata_hour_rental_price'] > 0){
            $data['sprodata_duration_type'] = ProductRental::DURATION_TYPE_HOUR;
            $data['rent_price'] = $data['sprodata_hour_rental_price'];
            $data['theprice'] = $data['sprodata_hour_rental_price'];
        }else if(self::checkActiveRentalDurations(ProductRental::DURATION_TYPE_DAY) && !empty($data['sprodata_day_rental_price']) && $data['sprodata_day_rental_price'] > 0){
            $data['sprodata_duration_type'] = ProductRental::DURATION_TYPE_DAY;
            $data['rent_price'] = $data['sprodata_day_rental_price'];
            $data['theprice'] = $data['sprodata_day_rental_price'];
        }else if(self::checkActiveRentalDurations(ProductRental::DURATION_TYPE_WEEK) && !empty($data['sprodata_week_rental_price']) && $data['sprodata_week_rental_price'] > 0){
            $data['sprodata_duration_type'] = ProductRental::DURATION_TYPE_WEEK;
            $data['rent_price'] = $data['sprodata_week_rental_price'];
            $data['theprice'] = $data['sprodata_week_rental_price'];
        }else if(self::checkActiveRentalDurations(ProductRental::DURATION_TYPE_MONTH) && !empty($data['sprodata_month_rental_price']) && $data['sprodata_month_rental_price'] > 0){
            $data['sprodata_duration_type'] = ProductRental::DURATION_TYPE_MONTH;
            $data['rent_price'] = $data['sprodata_month_rental_price'];
            $data['theprice'] = $data['sprodata_month_rental_price'];
        }

        if(!empty($data['special_price_found'])){
            switch ($data['sprodata_duration_type']) {
                case ProductRental::DURATION_TYPE_HOUR:
                    if(self::checkActiveRentalDurations(ProductRental::DURATION_TYPE_HOUR) && !empty($data['splprice_hour_price']) && $data['splprice_hour_price'] > 0){
                        $data['sprodata_duration_type'] = ProductRental::DURATION_TYPE_HOUR;
                        $data['rent_price'] = $data['sprodata_hour_rental_price'];
                        $data['theprice'] = $data['splprice_hour_price'];
                    }
                  break;
                case ProductRental::DURATION_TYPE_DAY:
                    if(self::checkActiveRentalDurations(ProductRental::DURATION_TYPE_DAY) && !empty($data['splprice_day_price']) && $data['splprice_day_price'] > 0){
                        $data['sprodata_duration_type'] = ProductRental::DURATION_TYPE_DAY;
                        $data['rent_price'] = $data['sprodata_day_rental_price'];
                        $data['theprice'] = $data['splprice_day_price'];
                    }
                  break;
                case ProductRental::DURATION_TYPE_WEEK:
                    if(self::checkActiveRentalDurations(ProductRental::DURATION_TYPE_WEEK) && !empty($data['splprice_week_price']) && $data['splprice_week_price'] > 0){
                        $data['sprodata_duration_type'] = ProductRental::DURATION_TYPE_WEEK;
                        $data['rent_price'] = $data['sprodata_week_rental_price'];
                        $data['theprice'] = $data['splprice_week_price'];
                    }
                  break;
                case ProductRental::DURATION_TYPE_MONTH:
                    if(self::checkActiveRentalDurations(ProductRental::DURATION_TYPE_MONTH) && !empty($data['splprice_month_price']) && $data['splprice_month_price'] > 0){
                        $data['sprodata_duration_type'] = ProductRental::DURATION_TYPE_MONTH;
                        $data['rent_price'] = $data['sprodata_month_rental_price'];
                        $data['theprice'] = $data['splprice_month_price'];
                    }
                  break;
              }
        }

    }

    public static function purifyDescription($description) 
	{
        // Remove all <script> tags
        $description = preg_replace('#<script(.*?)>(.*?)</script>#is', '', $description);
    
        // Remove all <iframe> tags (commonly used for embedding malicious content)
      //  $description = preg_replace('#<iframe(.*?)>(.*?)</iframe>#is', '', $description);
    
        // Remove all <object>, <embed>, and <applet> tags (used for embedding harmful content)
      //  $description = preg_replace('#<(object|embed|applet)(.*?)>(.*?)</(object|embed|applet)>#is', '', $description);
    
        // Remove all event attributes like onclick, onmouseover, etc.
        $description = preg_replace('#(<[^>]+) on\w+=".*?"#is', '$1', $description);
    
        // Remove style attributes that could be used for malicious intent
       // $description = preg_replace('#(<[^>]+) style=".*?"#is', '$1', $description);
    
        // Return the purified description
        return $description;
    }

    public static function isFlexiPaymentOrder($orderCartData):bool  {
        //$orderCartData = '{"order_id":"O1740053581","op_id":"1936","oppl_id":0}';
        $d = json_decode($orderCartData,true);
        if(isset($d['is_flexi_payment'])){
            return true;
        }
        return false;
    }
    
    public static function getFlexiOrderDetails($orderCartData)  {
        $d = json_decode($orderCartData,true);
        if(!empty($d['is_flexi_payment'])){
            return $d;
        }
        return null;
    }

}
