<?php

class Statistics
{

    public static function sellerSalesGraph($loggedUserId = 0)
    {
		$sales_earnings_chart_data = array();
        if (empty($loggedUserId) && UserAuthentication::isUserLogged()) {
            $loggedUserId = UserAuthentication::getLoggedUserId();
        }

		if ($loggedUserId > 0) {
			$dashboardStats = Stats::getUserSales($loggedUserId, STATS::SELLER_DASHBOARD_SALES_MONTH);
			foreach ($dashboardStats as $saleskey => $salesval) {
				$sales_earnings_chart_data[$saleskey] = round(($salesval ?? 0), 2);
			}
		}
		
        $dashboardInfo['sales_earnings_chart_data'] = $sales_earnings_chart_data;
        if ('ltr' == mb_strtolower(CommonHelper::getLayoutDirection())) {
            $dashboardInfo['sales_earnings_chart_data'] = array_reverse($sales_earnings_chart_data);
        }
		
        return $dashboardInfo;
    }

    public static function sellerRentalGraph($loggedUserId = 0)
    {
		$rentalEarningData = array();
        if (empty($loggedUserId) && UserAuthentication::isUserLogged()) {
            $loggedUserId = UserAuthentication::getLoggedUserId();
        }

		if ($loggedUserId > 0) {
			$dashboardStats = Stats::getUserRental($loggedUserId, STATS::SELLER_DASHBOARD_SALES_MONTH);
			foreach ($dashboardStats as $key => $val) {
				$rentalEarningData[$key] = round(($val ?? 0), 2); 
			}
		}

		$dashboardInfo['rental_earnings_chart_data'] = $rentalEarningData;
        if ('ltr' == mb_strtolower(CommonHelper::getLayoutDirection())) {
            $dashboardInfo['rental_earnings_chart_data'] = array_reverse($rentalEarningData);
        }
		
		return $dashboardInfo;
    }

}
