<?php

trait SingleCatalogForm
{
    use SingleCatalogFormHelper;
	
	protected $newTabLangId;
	
    public function getSingleCatalogForm($langId, $productId = 0)
    {
        $langId = FatApp::getPostedData('langId', FatUtility::VAR_INT, 0);
        if (1 > $langId) {
            $langId = $this->siteLangId;
        }

        $frm = $this->getCatalogSingleForm($langId, false);
        // $frm = $this->getCatalogForm($langId, false);
        $frm = $this->scfAddShippingFields($frm, $langId);

        $imgFrm = $this->scfGetImageForm();

        /** File Specification Form */
        $fileSpecFrm = $this->scfGetSpecFileUploadForm();
        $fileSpecFrmVals['filespec_product_id'] = $productId;
        $fileSpecFrmVals['file_type'] = AttachedFile::FILETYPE_PRODUCT_SPECIFICATION_FILE;

        /** Shipping [ */
        $shippingFrm = $this->getProductShippingFrm($productId);
        $shippedByUserId = $this->userParentId;
        if (FatApp::getConfig('CONF_SHIPPED_BY_ADMIN_ONLY', FatUtility::VAR_INT, 0)) {
            $shippedByUserId = 0;
        }

        // $prodShippingDetails = Product::getProductShippingDetails($productId, $this->siteLangId, $shippedByUserId);
        $productData['ps_free'] = (isset($prodShippingDetails['ps_free'])) ? $prodShippingDetails['ps_free'] : 0;
        /** Shipping ] */
        $productOptions = $prodOptValCombArr = [];
        if (0 < $productId) {
            $productRow = Product::getAttributesById($productId, ['product_seller_id']);
            if ($productRow && $productRow['product_seller_id'] != $this->userParentId) {
                FatUtility::dieWithError(Labels::getLabel('MSG_Invalid_Access', $this->siteLangId));
            }
            $imgFrm->fill(['file_type' => AttachedFile::FILETYPE_PRODUCT_IMAGE, 'product_id' => $productId]);

            $siteDefaultLangId = FatApp::getConfig('conf_default_site_lang', FatUtility::VAR_INT, 1);
            $languages = Language::getAllNames();

            $prodData = Product::getAttributesById($productId);
            $productLangData = Product::getAttributesByLangId($langId, $productId);


            if (!empty($productLangData)) {
                $prodData['product_name'] = $productLangData['product_name'];
                $prodData['product_youtube_video'] = $productLangData['product_youtube_video'];
                $prodData['product_description'] = $productLangData['product_description'];
            }
            $autoFillLangData = FatApp::getPostedData('autoFillLangData', FatUtility::VAR_INT, 0);
            if (0 < $autoFillLangData) {
                $updateLangDataobj = new TranslateLangData(Product::DB_TBL_LANG);
                $translatedData = $updateLangDataobj->getTranslatedData($productId, $langId);

                if (false === $translatedData) {
                    Message::addErrorMessage($updateLangDataobj->getError());
                    FatUtility::dieWithError(Message::getHtml());
                }
                $langData = current($translatedData);
                $prodData['product_name'] = $langData['product_name'];
                $prodData['product_description'] = $langData['product_description'];
            }

            $taxData = array();
            $tax = Tax::getTaxCatObjByProductId($productId, $this->siteLangId);
            if ($prodData && $prodData['product_seller_id'] > 0) {
                $tax->addCondition('ptt_seller_user_id', '=', $prodData['product_seller_id']);
            } else {
                $tax->addCondition('ptt_seller_user_id', '=', 0);
            }

            $activatedTaxServiceId = Tax::getActivatedServiceId();

            $tax->addFld(['ptt_taxcat_id', 'ptt_taxcat_id_rent']);
            if ($activatedTaxServiceId) {
                $tax->addFld(array('concat(IFNULL(t_l.taxcat_name,t.taxcat_identifier), " (",t.taxcat_code,")")as taxcat_name', 'concat(IFNULL(t_lrent.taxcat_name,trent.taxcat_identifier), " (",trent.taxcat_code,")")as taxcat_name_rent'));
            } else {
                $tax->addFld(array('IFNULL(t_l.taxcat_name,t.taxcat_identifier)as taxcat_name', 'IFNULL(t_lrent.taxcat_name,trent.taxcat_identifier)as taxcat_name_rent'));
            }

            $tax->doNotCalculateRecords();
            $tax->setPageSize(1);
            $tax->addOrder('ptt_seller_user_id', 'ASC');

            $rs = $tax->getResultSet();
            $taxData = FatApp::getDb()->fetch($rs);

            if (!empty($taxData)) {
                $prodData['ptt_taxcat_id'] = $taxData['ptt_taxcat_id'];
                $prodData['ptt_taxcat_id_rent'] = $taxData['ptt_taxcat_id_rent'];
                //$prodData['taxcat_name'] = $taxData['taxcat_name'];
                //$prodData['taxcat_name_rent'] = $taxData['taxcat_name_rent'];
            }

            $srch = Product::getSearchObject($langId);
            $srch->joinTable(Brand::DB_TBL, 'LEFT OUTER JOIN', 'tp.product_brand_id = brand.brand_id', 'brand');
            $srch->joinTable(Brand::DB_TBL_LANG, 'LEFT OUTER JOIN', 'brandlang_brand_id = brand.brand_id AND brandlang_lang_id = ' . $langId);
            $srch->addMultipleFields(array('product_brand_id', 'IFNULL(brand_name,brand_identifier) as brand_name', 'IFNULL(brand.brand_active,1) AS brand_active', 'IFNULL(brand.brand_deleted,0) AS brand_deleted'));
            $srch->addCondition('product_id', '=', $productId);
            $srch->addHaving('brand_active', '=', applicationConstants::YES);
            $srch->addHaving('brand_deleted', '=', applicationConstants::NO);
            $rs = $srch->getResultSet();
            $brandData = FatApp::getDb()->fetch($rs);
            
            if (!empty($brandData) && $brandData['product_brand_id'] > 0) {
                $fld = $frm->getField('product_brand_id');
                $fld->options = [$prodData['product_brand_id'] => $brandData[Brand::tblFld('name')] ?? $brandData[Brand::tblFld('identifier')]];
            }

            $prod = new Product();
            $productCategories = $prod->getProductCategories($productId);
            if (!empty($productCategories)) {
                $selectedCat = array_keys($productCategories);
                $prodCat = new ProductCategory();
                $selectedCatName = $prodCat->getParentTreeStructure($selectedCat[0], 0, '', $langId);
                $prodData['ptc_prodcat_id'] = $selectedCat[0];
                $fld = $frm->getField('ptc_prodcat_id');
                $fld->options = [$selectedCat[0] => html_entity_decode($selectedCatName)];

            }

            $prodSpecificsDetails = Product::getProductSpecificsDetails($productId);
            $prodData['product_warranty'] = $prodSpecificsDetails['product_warranty'] ?? '';

            $productTags = Product::getProductTags($productId, $langId, true);
            $tagData = [];
            $i = 0;
            foreach ($productTags as $key => $val) {
                $tagData[$i]['id'] = $key;
                $tagData[$i]['value'] = $val;
                $i++;
            }

            /* [ GET ATTACHED PROFILE ID */
            $profSrch = ShippingProfileProduct::getSearchObject();
            $profSrch->addCondition('shippro_product_id', '=', $productId);
            $profSrch->addCondition('shippro_user_id', '=', $shippedByUserId);
            $proRs = $profSrch->getResultSet();
            $profileData = FatApp::getDb()->fetch($proRs);
            if (!empty($profileData)) {
                $prodData['shipping_profile'] = $profileData['profile_id'];
            }
            /* ] */
            $prodData['product_tags'] = json_encode($tagData);

			$productOptions = Product::getProductOptions($productId, $langId, true);
			$prodOptValCombArr = CommonHelper::combinationOfElementsOfArr($productOptions, 'optionValues', ' | ');
			
        } else {
            $tempProductId = time() . UserAuthentication::getLoggedUserId();
            $prodData = [
                'temp_record_id' => $tempProductId,
                'product_id' => 0
            ];

            $imgFrm->fill(['file_type' => AttachedFile::FILETYPE_PRODUCT_IMAGE_TEMP, 'product_id' => $tempProductId]);
            $fileSpecFrmVals['filespec_temp_record_id'] = $tempProductId;
            $fileSpecFrmVals['file_type'] = AttachedFile::FILETYPE_PRODUCT_SPECIFICATION_FILE_TEMP;
        }
        $frm->fill($prodData);

        $fileSpecFrmVals['lang_id'] = $langId;
        $fileSpecFrmVals['is_image'] = $langId;
        $fileSpecFrm->fill($fileSpecFrmVals);

        $allowForSale = FatApp::getConfig("CONF_ALLOW_SALE", FatUtility::VAR_INT, 0);
		$canEditTags = $this->userPrivilege->canEditProductTags(UserAuthentication::getLoggedUserId(), true);
		
        $this->_template->addJs(array('js/select2.js'));
        $this->_template->addCss(array('css/select2.min.css', 'css/tagify.min.css'));
        
		$this->set('productOptions', $productOptions);
		$this->set('prodOptValCombArr', $prodOptValCombArr);
        $this->set('canEditTags', $canEditTags);
        $this->set('frm', $frm);
        $this->set('imgFrm', $imgFrm);
        $this->set('fileSpecFrm', $fileSpecFrm);
        $this->set('langId', $langId);
        $this->set('allowForSale', $allowForSale);
        $this->set('imageSize', imagesSizes::productImageSizeArr()[applicationConstants::getActiveTheme()]);
    }

    public function scfSetupProductShipping($productId, $post)
    {
        if (1 > $productId) {
            Message::addErrorMessage(Labels::getLabel('LBL_INVALID_REQUEST', $this->siteLangId));
            return false;
        }
        $shipBy = $this->userParentId;
        $shipProProdData = [];
        if (FatApp::getConfig('CONF_SHIPPED_BY_ADMIN_ONLY', FatUtility::VAR_INT, 0)) {
            $shipBy = 0;
            $shippingProfile = ShippingProfile::getProfileArr($this->siteLangId, $this->userParentId, true, true, true);
            $shippingProfileId = array_key_first($shippingProfile);

            $isShippingProfileLinked = ShippingProfileProduct::isShippingProfileLinked($productId);
            if (!$isShippingProfileLinked) {
                $shipProProdData = array(
                    'shippro_shipprofile_id' => $shippingProfileId,
                    'shippro_product_id' => $productId,
                    'shippro_user_id' => $shipBy
                );
            }
        } else {
            if (isset($post['shipping_profile']) && $post['shipping_profile'] > 0) {
                $shipProProdData = array(
                    'shippro_shipprofile_id' => $post['shipping_profile'],
                    'shippro_product_id' => $productId,
                    'shippro_user_id' => $shipBy
                );
            }
        }

        if (!empty($shipProProdData)) {
            $spObj = new ShippingProfileProduct();
            if (!$spObj->addProduct($shipProProdData)) {
                Message::addErrorMessage($spObj->getError());
                FatUtility::dieJsonError(Message::getHtml());
            }
            $db = FatApp::getDb();
            $data = array('psbs_product_id' => $shipProProdData['shippro_product_id'], 'psbs_user_id' => $this->userParentId);
            $db->insertFromArray(Product::DB_PRODUCT_SHIPPED_BY_SELLER, $data);
        }
        return true;
    }

    public function scfSetupCustomProductSpecifics($productId, $post)
    {
        if (1 > $productId) {
            return true;
        }

        $productSpecifics = new ProductSpecifics($productId);
        $productSpecifics->assignValues($post + ['ps_product_id' => $productId]);
        $data = $productSpecifics->getFlds();
        if (!$productSpecifics->addNew(array(), $data)) {
            Message::addErrorMessage($productSpecifics->getError());
            FatUtility::dieWithError(Message::getHtml());
        }
        return true;
    }

    public function scfSetupSpecifications($prodObj, $specifications, $langId, $autoUpdateOtherLangsData = 0)
    {
        if (empty($specifications)) {
            return true;
        }
        foreach ($specifications as $specification) {
            $data['prodspec_identifier'] = $specification['identifier'];
            $data['prodspec_is_file'] = 0;
            $data['prodspec_name'] = $specification['name'];
            $data['prodspec_value'] = $specification['value'];
            $data['prodspec_group'] = $specification['group'];
            if (!$prodObj->saveScfProductSpecifications($specification['id'], $langId, $data)) {
                Message::addErrorMessage($prodObj->getError());
                return false;
            }

            $specId = $prodObj->prodSpecId;
            if (1 === $autoUpdateOtherLangsData) {
                $languages = Language::getAllNames(false);
                unset($languages[$langId]);
                $success = true;
                foreach ($languages as $toLangId => $langData) {
                    $translateLangobj = new TranslateLangData(ProdSpecification::DB_TBL);
                    $translatedData = $translateLangobj->directTranslate($specification, $toLangId);
                    if (isset($translatedData[$toLangId]) && !empty($translatedData[$toLangId])) {
                        $translatedData = $translatedData[$toLangId];
                        $languageData['prodspec_name'] = $translatedData['name'];
                        $languageData['prodspec_value'] = $translatedData['value'];
                        $languageData['prodspec_group'] = $translatedData['group'];
                        if (!$prodObj->saveScfProductSpecifications($specId, $toLangId, $languageData)) {
                            Message::addErrorMessage($prodObj->getError());
                            $success = false;
                            break;
                        }
                    }
                }
                if (true != $success) {
                    return false;
                }
            }
        }
        return true;
    }

    private function scfMoveSpecificationTempFile($tempFileId, $productId, $specId)
    {
        $criteria = array(
            'afile_id' => $tempFileId,
            'afile_type' => AttachedFile::FILETYPE_PRODUCT_SPECIFICATION_FILE_TEMP,
        );
        $tempFiles = AttachedFileTemp::getTempImagesWithCriteria($criteria);
        if (!empty($tempFiles)) {
            foreach ($tempFiles as $tempFile) {
                $oldAttchment = AttachedFile::getAttachment(AttachedFile::FILETYPE_PRODUCT_SPECIFICATION_FILE, $tempFile['afile_record_id'], $specId, $tempFile['afile_lang_id']);
                $fileId = $tempFile['afile_id'];
                unset($tempFile['afile_id']);
                $tempFile['afile_record_subid'] = $specId;
                $tempFile['afile_record_id'] = $productId;
                $tempFile['afile_type'] = AttachedFile::FILETYPE_PRODUCT_SPECIFICATION_FILE;
                $tempFile['afile_updated_at'] = date('Y-m-d H:i:s');
                $fileHandler = new AttachedFile();
                $fileHandler->assignValues($tempFile);
                if (!$fileHandler->save()) {
                    Message::addErrorMessage($fileHandler->getError());
                    return false;
                }
                if (!empty($oldAttchment)) {
                    $whr = ['smt' => 'afile_id = ?', 'vals' => array($oldAttchment['afile_id'])];
                    FatApp::getDb()->deleteRecords(AttachedFile::DB_TBL, $whr);
                }

                $whr = ['smt' => 'afile_id = ?', 'vals' => array($tempFileId)];
                FatApp::getDb()->deleteRecords(AttachedFileTemp::DB_TBL, $whr);
            }
        }
    }
    public function scfSetupFileSpecifications($prodObj, $fileSpecifications, $langId, $autoUpdateOtherLangsData = 0)
    {
        if (empty($fileSpecifications)) {
            return true;
        }

        foreach ($fileSpecifications as $specification) {
            $data['prodspec_identifier'] = $specification['identifier'];
            $data['prodspec_name'] = $specification['name'];
            $data['prodspec_value'] = '';
            $data['prodspec_group'] = '';
            if (!$prodObj->saveScfProductSpecifications($specification['id'], $langId, $data, applicationConstants::YES)) {
                Message::addErrorMessage($prodObj->getError());
                return false;
            }

            $specId = $prodObj->prodSpecId;

            $this->scfMoveSpecificationTempFile($specification['temp_file_id'], $prodObj->getMainTableRecordId(), $specId);

            if (1 === $autoUpdateOtherLangsData) {
                $languages = Language::getAllNames(false);
                unset($languages[$langId]);
                $success = true;
                foreach ($languages as $toLangId => $langData) {
                    $translateLangobj = new TranslateLangData(ProdSpecification::DB_TBL);
                    $translatedData = $translateLangobj->directTranslate($specification, $toLangId);
                    if (isset($translatedData[$toLangId]) && !empty($translatedData[$toLangId])) {
                        $translatedData = $translatedData[$toLangId];
                        $languageData['prodspec_name'] = $translatedData['name'];
                        if (!$prodObj->saveScfProductSpecifications($specId, $toLangId, $languageData)) {
                            Message::addErrorMessage($prodObj->getError());
                            $success = false;
                            break;
                        }
                    }
                }
                if (true != $success) {
                    return false;
                }
            }
        }
        return true;
    }

    private function scfSetupTags($prodObj, $tags, $langId)
    {

        if (!empty($tags)) {
            $productTags = json_decode($tags, true);
            foreach ($productTags as $tag) {
                if (!isset($tag['id'])) {
                    $tagObj = new Tag();
                    $tagObj->assignValues([
                        'tag_identifier' => $tag['value'],
                        'tag_user_id' => $this->userParentId
                    ]);
                    if (!$tagObj->save()) {
                        LibHelper::exitWithError($tagObj->getError(), true);
                    }
                    $tagId = $tagObj->getMainTableRecordId();

                    $data['tag_name'] = $tag['value'];
                    if (!$tagObj->updateLangData($langId, $data)) {
                        LibHelper::exitWithError($tagObj->getError(), true);
                    }
                } else {
                    $tagId = $tag['id'];
                }

                if (!$prodObj->addUpdateProductTag($tagId)) {
                    LibHelper::exitWithError($prodObj->getError(), true);
                }

                /* update product tags association and tag string in products lang table[ */
                Tag::updateTagStrings($tagId);
                /* ] */

            }
        }
        return true;
    }

    private function setupSingleFormLangData(object $obj, int $langId, array $post)
    {
        $langData = [
            'product_name' => $post['product_name'],
            'product_description' => applicationConstants::purifyDescription($post['product_description']),
            'product_youtube_video' => $post['product_youtube_video'],
        ];

        if (!$obj->updateLangData($langId, $langData)) {
            Message::addErrorMessage($obj->getError());
            FatUtility::dieWithError(Message::getHtml());
        }

        $languages = Language::getDropDownList(CommonHelper::getDefaultFormLangId());
        if (0 < count($languages)) {
            $recordId = $obj->getMainTableRecordId();
            foreach ($languages as $languageId => $langName) {
                if (!$obj::getAttributesByLangId($languageId, $recordId)) {
                    $this->newTabLangId = $languageId;
                    break;
                }
            }
        }

        $autoUpdateOtherLangsData = FatApp::getPostedData('auto_update_other_langs_data', FatUtility::VAR_INT, 0);
        if ($autoUpdateOtherLangsData == 1) {
            if (0 < $autoUpdateOtherLangsData && 0 < $langId) {
                $updateLangDataobj = new TranslateLangData($obj::DB_TBL_LANG);
                if (false === $updateLangDataobj->updateTranslatedData($obj->getMainTableRecordId(), $langId)) {
                    LibHelper::exitWithError($updateLangDataobj->getError(), true);
                }
            }
        }
        return true;
    }

    public function scfImages($recordId, $fileType = 0, $optionId = 0, $langId = 0)
    {
        $canEdit = User::canAddCustomProduct(true);
        if (!$canEdit) {
            FatUtility::dieWithError(Labels::getLabel('MSG_Invalid_Access', $this->siteLangId));
        }

        $recordId = FatUtility::int($recordId);
        $fileType = FatUtility::int($fileType);
        if (1 > $recordId) {
            FatUtility::dieWithError(Labels::getLabel('MSG_Invalid_Request', $this->siteLangId), true);
        }

        $languages = Language::getAllNames();
        if (count($languages) <= 1) {
            $langId = array_key_first($languages);
        }
        if ($fileType == AttachedFile::FILETYPE_PRODUCT_IMAGE_TEMP) {
            $images = AttachedFileTemp::getMultipleAttachments($fileType, $recordId, $optionId, $langId, (count($languages) <= 1) ? true : false, 0, 0, true, true);
			$isTempImg = 1;
        } else {
            $fileType = AttachedFile::FILETYPE_PRODUCT_IMAGE;
            if (!Product::getAttributesById($recordId, 'product_id')) {
                FatUtility::dieWithError(Labels::getLabel('MSG_Invalid_Request', $this->siteLangId), true);
            }
            $images = AttachedFile::getMultipleAttachments($fileType, $recordId, $optionId, $langId, (count($languages) <= 1) ? true : false, 0, 0, true, true);
			$isTempImg = 0;
        }

        $this->set('images', $images);
        $this->set('recordId', $recordId);
        $this->set('canEdit', $canEdit);
        $this->set('isTempImg', $isTempImg);
        $this->set('isDefaultLayout', FatApp::getPostedData('isDefaultLayout', FatUtility::VAR_INT, 0));

        $this->set('html', $this->_template->render(false, false, 'seller/single-catalog-form/images.php', true));
        $this->_template->render(false, false, 'json-success.php', true, false);
    }

    public function scfImageForm($productId = 0, $tempProductId = 0)
    {
        $prodOptions = $optionValAssArr = [];
        $post = FatApp::getPostedData();
        $langId = FatApp::getPostedData('langId', FatUtility::VAR_INT, 0);
        if (1 > $langId) {
            $langId = $this->siteLangId;
        }

        if (!empty($post['prodOptions'])) {
            $prodOptions = json_decode(stripslashes($post['prodOptions']));
            if (!empty($prodOptions)) {
                $optionsDetail = Option::getOptionsData($prodOptions);
                if (!empty($optionsDetail)) {
                    foreach ($optionsDetail as $optionDetail) {
                        if ($optionDetail['option_is_separate_images'] == 1) {
                            $optionValObj = new OptionValue();
                            $optionValues = $optionValObj->getAtttibutesByOptionId($optionDetail['option_id'], [], $langId);

                            foreach ($optionValues as $optionValue) {
                                $optionValueName = $optionValue['optionvalue_identifier'];
                                if (!empty($optionValue['optionvalue_name'])) {
                                    $optionValueName = $optionValue['optionvalue_name'];
                                }
                                $optionValAssArr[$optionValue['optionvalue_id']] = $optionValueName;
                            }
                        }
                    }
                }
            }
        }

        $frm = $this->scfGetImageForm($productId, 0, $optionValAssArr);
        if (1 > $productId) {
            $frm->fill(['file_type' => AttachedFile::FILETYPE_PRODUCT_IMAGE_TEMP, 'product_id' => $tempProductId]);
        } else {
            $frm->fill(['file_type' => AttachedFile::FILETYPE_PRODUCT_IMAGE, 'product_id' => $productId]);
        }
        $this->set('frm', $frm);
        $this->set('imageSize', imagesSizes::productImageSizeArr()[applicationConstants::getActiveTheme()]);
        $this->set('html', $this->_template->render(false, false, 'seller/single-catalog-form/image-form.php', true));
        $this->_template->render(false, false, 'json-success.php', true, false);
    }

    public function scfSetupCustomProductImages()
    {
        $this->userPrivilege->canEditProducts(UserAuthentication::getLoggedUserId());
        if (!User::canAddCustomProduct()) {
            FatUtility::dieJsonError(Labels::getLabel('MSG_Invalid_Access', $this->siteLangId));
        }
        if (!UserPrivilege::isUserHasValidSubsription($this->userParentId)) {
            FatUtility::dieJsonError(Labels::getLabel("MSG_Please_buy_subscription", $this->siteLangId));
        }

        $post = FatApp::getPostedData();

        if (empty($post)) {
            Message::addErrorMessage(Labels::getLabel('LBL_Invalid_Request_Or_File_not_supported', $this->siteLangId));
            FatUtility::dieJsonError(Message::getHtml());
        }
        $productId = FatUtility::int($post['product_id']);
        $optionId = FatUtility::int($post['option_id']);
        $fileType = FatUtility::int($post['file_type']);

        $languages = Language::getAllNames();
        if (count($languages) > 1) {
            $langId = FatUtility::int($post['lang_id']);
        } else {
            $langId = array_key_first($languages);
        }

        /* Validate product belongs to current logged seller[ */

        $isTempImage = false;
        if ($fileType == AttachedFile::FILETYPE_PRODUCT_IMAGE_TEMP) {
            $isTempImage = true;
        }

        if ($fileType == AttachedFile::FILETYPE_PRODUCT_IMAGE && $productId) {
            $productRow = Product::getAttributesById($productId, array('product_seller_id'));
            $optionValues = Product::getSeparateImageOptions($productId, $this->siteLangId);

            if ($productRow['product_seller_id'] != $this->userParentId || !array_key_exists($optionId, $optionValues)) {
                FatUtility::dieWithError(Labels::getLabel('MSG_Invalid_Access', $this->siteLangId));
            }
        }

        $this->validateImageSubscriptionLimit($productId, $optionId, $langId);

        if (!is_uploaded_file($_FILES['cropped_image']['tmp_name'])) {
            FatUtility::dieJsonError(Labels::getLabel("MSG_Please_select_a_file", $this->siteLangId));
        }

        if ($_FILES['cropped_image']['size'] > AttachedFile::IMAGE_MAX_SIZE_IN_BYTES_FOR_CROPPER) { /* in kbs */
            FatUtility::dieJsonError(Labels::getLabel('MSG_Maximum_Upload_Size_is', $this->siteLangId) . ' ' . AttachedFile::IMAGE_MAX_SIZE_IN_BYTES / 1024 . 'KB');
        }

        $fileHandlerObj = new AttachedFile();
        if ($fileType == AttachedFile::FILETYPE_PRODUCT_IMAGE_TEMP) {
            $fileHandlerObj = new AttachedFileTemp();
        }
        if (!$res = $fileHandlerObj->saveImage($_FILES['cropped_image']['tmp_name'], $fileType, $productId, $optionId, $_FILES['cropped_image']['name'], -1, false, $langId)) {
            FatUtility::dieJsonError($fileHandlerObj->getError());
        }
        if ($fileType == AttachedFile::FILETYPE_PRODUCT_IMAGE) {
            FatApp::getDb()->updateFromArray('tbl_products', array('product_updated_on' => date('Y-m-d H:i:s')), array('smt' => 'product_id = ?', 'vals' => array($productId)));
        }

        if (count($languages) > 1) {
            $this->set("isDefaultLayout", $langId == 0 && $optionId == 0);
        } else {
            $this->set("isDefaultLayout", $langId == CommonHelper::getDefaultFormLangId() && $optionId == 0);
        }

        $this->set("lang_id", $langId);
        $this->set("option_id", $optionId);
        $this->set("productId", $productId);
        $this->set("file_type", $fileType);
        $this->set("msg", Labels::getLabel('MSG_FILE_UPLOADED_SUCCESSFULLY', $this->siteLangId));
        $this->_template->render(false, false, 'json-success.php');
    }

    public function scfSetupCustomProductSpecFiles()
    {
        $this->userPrivilege->canEditProducts(UserAuthentication::getLoggedUserId());
        if (!User::canAddCustomProduct()) {
            FatUtility::dieJsonError(Labels::getLabel('MSG_Invalid_Access', $this->siteLangId));
        }
        if (!UserPrivilege::isUserHasValidSubsription($this->userParentId)) {
            FatUtility::dieJsonError(Labels::getLabel("MSG_Please_buy_subscription", $this->siteLangId));
        }

        $post = FatApp::getPostedData();

        if (empty($post)) {
            Message::addErrorMessage(Labels::getLabel('LBL_Invalid_Request_Or_File_not_supported', $this->siteLangId));
            FatUtility::dieJsonError(Message::getHtml());
        }
        $productId = FatUtility::int($post['filespec_product_id']);
        $tempProductId = FatUtility::int($post['filespec_temp_record_id']);
        $fileType = FatUtility::int($post['file_type']);

        $languages = Language::getAllNames();
        if (count($languages) > 1) {
            $langId = FatUtility::int($post['lang_id']);
        } else {
            $langId = array_key_first($languages);
        }


        /* $isTempImage = false;
        if ($fileType == AttachedFile::FILETYPE_PRODUCT_SPECIFICATION_FILE_TEMP) {
            $isTempImage = true;
        } */

        /* Validate product belongs to current logged seller[ */
        /* if ($fileType == AttachedFile::FILETYPE_PRODUCT_SPECIFICATION_FILE && $productId) {
            $productRow = Product::getAttributesById($productId, array('product_seller_id'));
            
            if ($productRow['product_seller_id'] != $this->userParentId) {
                FatUtility::dieWithError(Labels::getLabel('MSG_Invalid_Access', $this->siteLangId));
            }
        } */

        if (1 > $productId) {
            $productId = $tempProductId;
        }

        $prodSpecId = 0;

        $isFile = 0;
        $retFileTag = '';
        $fileHandlerObj = new AttachedFileTemp();
        if (isset($_FILES['cropped_image']) && is_uploaded_file($_FILES['cropped_image']['tmp_name'])) {
            if (!is_uploaded_file($_FILES['cropped_image']['tmp_name'])) {
                FatUtility::dieJsonError(Labels::getLabel("MSG_Please_select_a_file", $this->siteLangId));
            }

            if ($_FILES['cropped_image']['size'] > AttachedFile::IMAGE_MAX_SIZE_IN_BYTES_FOR_CROPPER) { /* in kbs */
                FatUtility::dieJsonError(Labels::getLabel('MSG_Maximum_Upload_Size_is', $this->siteLangId) . ' ' . AttachedFile::IMAGE_MAX_SIZE_IN_BYTES / 1024 . 'KB');
            }

            if (!$res = $fileHandlerObj->saveAttachment($_FILES['cropped_image']['tmp_name'], AttachedFile::FILETYPE_PRODUCT_SPECIFICATION_FILE_TEMP, $productId, $prodSpecId, $_FILES['cropped_image']['name'], -1, false, $langId, 0, 0, true)) {
                Message::addErrorMessage($fileHandlerObj->getError());
                FatUtility::dieJsonError(Message::getHtml());
            }
            $retFileTag = '<img class="img-thumbnail image-small" src="' . UrlHelper::generateUrl('Image', 'attachment', [$fileHandlerObj->getMainTableRecordId(), applicationConstants::YES, 100, 100]) . '">';
        } else if (isset($_FILES['file']) && is_uploaded_file($_FILES['file']['tmp_name'])) {
            $isFile = 1;
            if ($_FILES['file']['size'] > 10240000) {
                Message::addErrorMessage(Labels::getLabel('MSG_Please_upload_file_size_less_than_10MB', $this->siteLangId));
                FatUtility::dieJsonError(Message::getHtml());
            }
            if (!$res = $fileHandlerObj->saveAttachment($_FILES['file']['tmp_name'], AttachedFile::FILETYPE_PRODUCT_SPECIFICATION_FILE_TEMP, $productId, $prodSpecId, $_FILES['file']['name'], -1, false, $langId, 0, 0, true)) {
                Message::addErrorMessage($fileHandlerObj->getError());
                FatUtility::dieJsonError(Message::getHtml());
            }
            $retFileTag = '<a target="_blank" class="btn btn-link" href="' . UrlHelper::generateUrl('Image', 'attachment', [$fileHandlerObj->getMainTableRecordId(), applicationConstants::YES]) . '"><i class="fa fa-download" aria-hidden="true"></i></a>';
        }


        $this->set("file_htm_tag", $retFileTag);
        $this->set("spec_temp_id", $fileHandlerObj->getMainTableRecordId());
        $this->set("prodspec_is_file", $isFile);
        $this->set("msg", Labels::getLabel('MSG_FILE_UPLOADED_SUCCESSFULLY', $this->siteLangId));
        $this->_template->render(false, false, 'json-success.php', true, false);
    }

    public function scfSetImageOrder()
    {

    }

    private function scfGetImageForm($productId = 0, $lang_id = 0, $optionArr = [])
    {
        $frm = new Form('imageFrm');
        if (!empty($optionArr)) {
            $imgTypesArr = array(0 => Labels::getLabel('LBL_For_All_Options', $lang_id));
            $imgTypesArr = $imgTypesArr + $optionArr;
        } else {
            $imgTypesArr = $this->getSeparateImageOptions($productId, $this->siteLangId);
        }
        // $imgTypesArr = $this->getSeparateImageOptionsOfCustomProduct($preq_id, $lang_id);
        $frm->addSelectBox(Labels::getLabel('LBL_IMAGE_FILE_TYPE', $this->siteLangId), 'option_id', $imgTypesArr, 0, array(), '');
        $languagesAssocArr = Language::getAllNames();
        if (count($languagesAssocArr) > 1) {
            $frm->addSelectBox(Labels::getLabel('LBL_LANGUAGE', $this->siteLangId), 'lang_id', array(0 => Labels::getLabel('LBL_All_Languages', $this->siteLangId)) + $languagesAssocArr, '', array(), '');
        } else {
            $langId = array_key_first($languagesAssocArr);
            $frm->addHiddenField('', 'lang_id', $langId);
        }
        $frm->addFileUpload(Labels::getLabel('LBL_UPLOAD', $this->siteLangId), 'prod_image');
        $frm->addHtml('', 'images', '');
        $sizeArr = imagesSizes::productImageSizeArr()[applicationConstants::getActiveTheme()];
        $frm->addHiddenField('', 'min_width', $sizeArr['width']);
        $frm->addHiddenField('', 'min_height', $sizeArr['height']);
        $frm->addHiddenField('', 'product_id');
        $frm->addHiddenField('', 'file_type');

        return $frm;
    }

    private function scfGetSpecFileUploadForm()
    {
        $frm = new Form('specFileFrm');

        $frm->addHiddenField('', 'prodspec_is_file', 1);
        $frm->addHiddenField('', 'lang_id');
        $frm->addHiddenField('', 'filespec_product_id');
        $frm->addHiddenField('', 'filespec_temp_record_id');
        $frm->addHiddenField('', 'file_type');

        return $frm;
    }

    private function getCatalogForm($langId, $productId = 0, $isRequested = 0): object
    {
        $frm = new Form('frmProduct');
        $fld = $frm->addSelectBox(Labels::getLabel('LBL_LANGUAGE', $langId), 'lang_id', Language::getAllNames(), $langId, [], '');
        $fld->requirements()->setRequired();
        if (1 > $productId) {
            $fld->addFieldTagAttribute('disabled', 'disabled');
        }
        $frm->addRequiredField(Labels::getLabel('LBL_Product_Identifier', $langId), 'product_identifier');
        $frm->addRequiredField(Labels::getLabel('LBL_Product_Name', $langId), 'product_name');
        $frm->addHiddenField('', 'product_type', Product::PRODUCT_TYPE_PHYSICAL);
        $brandFld = $frm->addTextBox(Labels::getLabel('LBL_Brand', $langId), 'product_brand_id');
        if (FatApp::getConfig("CONF_PRODUCT_BRAND_MANDATORY", FatUtility::VAR_INT, 1)) {
            $brandFld->requirements()->setRequired();
        }

        $frm->addRequiredField(Labels::getLabel('LBL_Category', $langId), 'ptc_prodcat_id');
        $fldModel = $frm->addTextBox(Labels::getLabel('LBL_Model', $langId), 'product_model');
        if (FatApp::getConfig("CONF_PRODUCT_MODEL_MANDATORY", FatUtility::VAR_INT, 1)) {
            $fldModel->requirements()->setRequired();
        }

        $taxCatArr = Tax::getSaleTaxCatArr($langId);
        $frm->addSelectBox(Labels::getLabel('LBL_Tax_Category[Rent]', $langId), 'ptt_taxcat_id_rent', $taxCatArr)->requirements()->setRequired();
        $allowSale = FatApp::getConfig("CONF_ALLOW_SALE", FatUtility::VAR_INT, 0);
        if ($allowSale) {
            $frm->addSelectBox(Labels::getLabel('LBL_Tax_Category[Sale]', $langId), 'ptt_taxcat_id', $taxCatArr)->requirements()->setRequired();
        }

        if ($allowSale) {
            $fldMinSelPrice = $frm->addFloatField(Labels::getLabel('LBL_Minimum_Selling_Price', $langId) . ' [' . CommonHelper::getSystemDefaultCurrenyCode() . ']', 'product_min_selling_price', '');
            $fldMinSelPrice->requirements()->setPositive();
            $fldMinSelPrice->requirements()->setRange(0, 99999999.99);
        }

        $frm->addTextBox(Labels::getLabel('LBL_Product_Warranty', $langId), 'product_warranty');

        $frm->addHtmlEditor(Labels::getLabel('LBL_DESCRIPTION', $langId), 'product_description');
        $frm->addTextBox(Labels::getLabel('LBL_YOUTUBE_VIDEO_URL', $langId), 'product_youtube_video');
        $frm->addCheckBox(Labels::getLabel('LBL_MARK_AS_FEATURED', $langId), 'product_featured', applicationConstants::YES, array(), true, 0);
        $frm->addCheckBox(Labels::getLabel("LBL_ACTIVE", $langId), 'product_active', applicationConstants::YES, array(), true, 0);

        $languages = Language::getAllNames();

        $translatorSubscriptionKey = FatApp::getConfig('CONF_TRANSLATOR_SUBSCRIPTION_KEY', FatUtility::VAR_STRING, '');
        unset($languages[$langId]);
        if (!empty($translatorSubscriptionKey) && count($languages) > 0) {
            $frm->addCheckBox(Labels::getLabel('LBL_AUTO_UPDATE_OTHER_LANGS_DATA', $this->siteLangId), 'auto_update_other_langs_data', applicationConstants::YES, array(), false, 0);
        }

        if (!FatApp::getConfig('CONF_SHIPPED_BY_ADMIN_ONLY', FatUtility::VAR_INT, 0)) {
            $codFld = $frm->addCheckBox(Labels::getLabel('LBL_Enable_Cash_On_Delivery', $this->siteLangId), 'product_cod_enabled', 1, array(), false, 0);
            $paymentMethod = new PaymentMethods();
            if (!$paymentMethod->cashOnDeliveryIsActive()) {
                $codFld->addFieldTagAttribute('disabled', 'disabled');
                $codFld->htmlAfterField = '<br/><small>' . Labels::getLabel('LBL_COD_option_is_disabled_in_payment_gateway_settings', $this->siteLangId) . '</small>';
            }
        }

        $fld = $frm->addTextBox(Labels::getLabel('LBL_Add_Tag', $this->siteLangId), 'product_tags');

        $frm->addHiddenField('', 'product_id', $productId);
        $frm->addHiddenField('', 'temp_record_id');
        //$frm->addHiddenField('', 'product_brand_id');
        $frm->addHiddenField('', 'product_model_id');
        //$frm->addHiddenField('', 'ptc_prodcat_id');
        //$frm->addHiddenField('', 'ptt_taxcat_id');
        //$frm->addHiddenField('', 'ptt_taxcat_id_rent');
        $frm->addHiddenField('', 'specifications');
        $frm->addHiddenField('', 'filespecifications');
        $frm->addHiddenField('', 'num_attributes');
        $frm->addHiddenField('', 'text_attributes');
        $frm->addSubmitButton('', 'btn_submit', Labels::getLabel('LBL_Save_And_Next', $this->siteLangId));
        return $frm;
    }

    public function scfProdCatCustomFieldsForm()
    {
        $productId = FatApp::getPostedData('product_id', FatUtility::VAR_INT, 0);
        $catId = FatApp::getPostedData('cat_id', FatUtility::VAR_INT, 0);
        $langId = FatApp::getPostedData('lang_id', FatUtility::VAR_INT, 0);
        if (1 > $catId) {
            $this->set('have_custom_fields', 0);
            $this->_template->render(false, false, 'json-success.php', true, false);
        }

        $updatedProdCatAttr = [];

        /*$category = ProductCategory::getAttributesByLangId($langId, $catId);
        if (!is_array($category)) {
            $this->set('have_custom_fields', 0);
            $this->_template->render(false, false, 'json-success.php', true, false);
        }*/

        $attrData = ['product_id' => $productId];

        if (0 < $productId) {

            $numericAttributes = Product::getProductNumericAttributes($productId);
            $textualAttributes = Product::getProductTextualAttributes($productId, $langId);

            if (!empty($numericAttributes)) {
                foreach ($numericAttributes as $numericAttribute) {
                    $attrGrpId = $numericAttribute['prodnumattr_attrgrp_id'];
                    unset($numericAttribute['prodnumattr_product_id']);
                    unset($numericAttribute['prodnumattr_attrgrp_id']);
                    $attrData['num_attributes'][$attrGrpId] = $numericAttribute;
                }
            }
            if (!empty($textualAttributes)) {
                foreach ($textualAttributes as $textualAttribute) {
                    $attrGrpId = $textualAttribute['prodtxtattr_attrgrp_id'];
                    unset($textualAttribute['prodtxtattr_product_id']);
                    unset($textualAttribute['prodtxtattr_attrgrp_id']);
                    unset($textualAttribute['prodtxtattr_lang_id']);
                    $attrData['text_attributes'][$attrGrpId][$langId] = $textualAttribute;
                }
            }
        }

        $prodCatObj = new ProductCategory($catId);
        //$prodCatAttr = $prodCatObj->getAttrDetail($langId, 0, '', [$catId]);
        $prodCatAttr = $prodCatObj->getAttrDetail($langId, 0);

        /*echo "<pre>";
      print_r($prodCatAttr);
      echo "</pre>";
      exit;*/
        // foreach ($prodCatAttr as $attr) {
        //     $updatedProdCatAttr[$attr['attr_attrgrp_id']][$attr['attr_id']][$attr['attrlang_lang_id']] = $attr;
        // }
        $siteDefaultLangId = FatApp::getConfig('conf_default_site_lang', FatUtility::VAR_INT, 1);
        foreach ($prodCatAttr as $key => $attr) {
            if(($attr['attr_type'] == AttrGroupAttribute::ATTRTYPE_SELECT_BOX || $attr['attr_type'] == AttrGroupAttribute::ATTRTYPE_CHECKBOXES) && empty($attr['attr_options'])) {
                $attrObj = new AttrGroupAttribute($attr['attr_id']);
                $attrDetails = $attrObj->getDetail();
                if(!empty($attrDetails) && !empty($attrDetails[$siteDefaultLangId]['attr_options'])) {
                    $attr['attr_options'] = $prodCatAttr[$key]['attr_options'] = $attrDetails[$siteDefaultLangId]['attr_options'];
                } else if(!empty($attrDetails)) {
                    foreach($attrDetails as $attrDetail) {
                        if(!empty($attrDetail['attr_options'])) {
                            $attr['attr_options'] = $prodCatAttr[$key]['attr_options'] = $attrDetail['attr_options'];
                            continue;
                        }
                    }
                } 
            }
            if(empty($attr['attrlang_lang_id'])){
                $attr['attrlang_lang_id'] = $langId;
            }
            $updatedProdCatAttr[$attr['attr_attrgrp_id']][$attr['attr_id']][$attr['attrlang_lang_id']] = $attr;
        }
        $isCustomFields = $prodCatObj->isCategoryHasCustomFields($this->siteLangId);

        $prod = new Product();
        $prodCatAttr = $prod->formatAttributesData($prodCatAttr);
        $frm = $prod->getProdCatCustomFieldsForm($prodCatAttr, $langId, false, $attrData);
        $this->set('frm', $frm);

        $this->set('updatedProdCatAttr', $updatedProdCatAttr);
        $this->set('langId', $langId);
        $this->set('productId', $productId);
        $this->set('html', $this->_template->render(false, false, 'seller/single-catalog-form/custom-fields-form.php', true, false));
        $this->set('have_custom_fields', $isCustomFields);
        //$this->set('have_custom_fields', false);
        $this->_template->render(false, false, 'json-success.php', true, false);
    }

    private function scfSetupCustomFieldsData($prodObj, $post, $langId)
    {
        if (!empty($post['num_attributes'])) {
            for ($i = 1; $i <= 30; $i++) {
                $numeicKeysArr[] = 'prodnumattr_num_' . $i;
            }
            foreach ($post['num_attributes'] as $key => $attributes) {
                $updatedKeys = [];
                foreach ($attributes as $numericKey => $attr) {
                    $num_data_update_arr = array(
                        'prodnumattr_product_id' => $prodObj->getMainTableRecordId(),
                        'prodnumattr_attrgrp_id' => $key,
                        $numericKey => (is_array($attr)) ? implode(',', $attr) : $attr,
                    );
                    $updatedKeys[] = $numericKey;
                    if (!$prodObj->addUpdateNumericAttributes($num_data_update_arr)) {
                        Message::addErrorMessage($prodObj->getError());
                        FatUtility::dieWithError(Message::getHtml());
                    }
                }
                /* [ UPDATE MISSING FIELDS OR UNCHECKED CHECKBOXES VALUE */
                $missingKeys = array_diff($numeicKeysArr, $updatedKeys);
                if (!empty($missingKeys)) {
                    $num_data_update_arr = array(
                        'prodnumattr_product_id' => $prodObj->getMainTableRecordId(),
                        'prodnumattr_attrgrp_id' => $key
                    );

                    foreach ($missingKeys as $keyName) {
                        $num_data_update_arr[$keyName] = "";
                    }

                    if (!$prodObj->addUpdateNumericAttributes($num_data_update_arr)) {
                        Message::addErrorMessage($prodObj->getError());
                        FatUtility::dieWithError(Message::getHtml());
                    }
                }
                /* ] */
            }
        }

        if (!empty($post['text_attributes'])) {
            foreach ($post['text_attributes'] as $key => $textAttributes) {
                foreach ($textAttributes as $langId => $attributes) {
                    $text_data_update = array(
                        'prodtxtattr_product_id' => $prodObj->getMainTableRecordId(),
                        'prodtxtattr_attrgrp_id' => $key,
                        'prodtxtattr_lang_id' => $langId,
                    );
                    $text_data_update = array_merge($text_data_update, $attributes);

                    if (!$prodObj->addUpdateTextualAttributes($text_data_update)) {
                        Message::addErrorMessage($prodObj->getError());
                        FatUtility::dieWithError(Message::getHtml());
                    }
                }
            }
        }
        return true;
    }

    private function getCatalogSingleForm($langId, $isRequest = false): object
    {
        $frm = new Form('frmProduct');
        $fld = $frm->addSelectBox(Labels::getLabel('LBL_LANGUAGE', $langId), 'lang_id', Language::getAllNames(), $langId, [], '');
        $fld->requirements()->setRequired();

        $frm->addRequiredField(Labels::getLabel('LBL_Product_Identifier', $langId), 'product_identifier');
        $frm->addRequiredField(Labels::getLabel('LBL_Product_Name', $langId), 'product_name');
        $frm->addHiddenField('', 'product_type', Product::PRODUCT_TYPE_PHYSICAL);

        $brandFld = $frm->addSelectBox(Labels::getLabel('LBL_Brand', $langId), 'product_brand_id', []);
        if (FatApp::getConfig("CONF_PRODUCT_BRAND_MANDATORY", FatUtility::VAR_INT, 1)) {
            $brandFld->requirements()->setRequired();
        }
        $fld = $frm->addSelectBox(Labels::getLabel('LBL_Category', $langId), 'ptc_prodcat_id', []);
        $fld->requirements()->setRequired();

        $fldModel = $frm->addTextBox(Labels::getLabel('LBL_Model', $this->siteLangId), 'product_model');
        if (FatApp::getConfig("CONF_PRODUCT_MODEL_MANDATORY", FatUtility::VAR_INT, 1)) {
            $fldModel->requirements()->setRequired();
        }

        $taxCatArr = Tax::getSaleTaxCatArr($langId);
        $frm->addSelectBox(Labels::getLabel('LBL_Tax_Category[Rent]', $langId), 'ptt_taxcat_id_rent', $taxCatArr)->requirements()->setRequired();
        $allowSale = FatApp::getConfig("CONF_ALLOW_SALE", FatUtility::VAR_INT, 0);
        if ($allowSale) {
            $frm->addSelectBox(Labels::getLabel('LBL_Tax_Category[Sale]', $langId), 'ptt_taxcat_id', $taxCatArr)->requirements()->setRequired();
        }

        if ($allowSale) {
            $fldMinSelPrice = $frm->addFloatField(Labels::getLabel('LBL_Minimum_Selling_Price', $langId) . ' [' . CommonHelper::getSystemDefaultCurrenyCode() . ']', 'product_min_selling_price', '');
            $fldMinSelPrice->requirements()->setPositive();
            $fldMinSelPrice->requirements()->setRange(0, 99999999.99);
        }

        $frm->addTextBox(Labels::getLabel('LBL_Product_Warranty', $langId), 'product_warranty');

        $frm->addHtmlEditor(Labels::getLabel('LBL_DESCRIPTION', $langId), 'product_description');
        $frm->addTextBox(Labels::getLabel('LBL_YOUTUBE_VIDEO_URL', $langId), 'product_youtube_video');
        $frm->addCheckBox(Labels::getLabel('LBL_MARK_AS_FEATURED', $langId), 'product_featured', applicationConstants::YES, array(), false, 0);
        $frm->addCheckBox(Labels::getLabel("LBL_ACTIVE", $langId), 'product_active', applicationConstants::YES, array(), true, 0);

        $languages = Language::getAllNames();

        $translatorSubscriptionKey = FatApp::getConfig('CONF_TRANSLATOR_SUBSCRIPTION_KEY', FatUtility::VAR_STRING, '');
        unset($languages[$langId]);
        if (!empty($translatorSubscriptionKey) && count($languages) > 0) {
            $frm->addCheckBox(Labels::getLabel('LBL_AUTO_UPDATE_OTHER_LANGS_DATA', $this->siteLangId), 'auto_update_other_langs_data', applicationConstants::YES, array(), false, 0);
        }
        if(count($languages) > 0){
            $frm->addCheckBox(Labels::getLabel('LBL_AUTO_UPDATE_OTHER_LANGS_DATA', $this->siteLangId), 'auto_update_other_langs_data_prod_size_chart', applicationConstants::YES, array(), false, 0);
        }

        if (!FatApp::getConfig('CONF_SHIPPED_BY_ADMIN_ONLY', FatUtility::VAR_INT, 0)) {
            $codFld = $frm->addCheckBox(Labels::getLabel('LBL_Enable_Cash_On_Delivery', $this->siteLangId), 'product_cod_enabled', 1, array(), false, 0);
            $paymentMethod = new PaymentMethods();
            if (!$paymentMethod->cashOnDeliveryIsActive()) {
                $codFld->addFieldTagAttribute('disabled', 'disabled');
                $codFld->htmlAfterField = '<br/><small>' . Labels::getLabel('LBL_COD_option_is_disabled_in_payment_gateway_settings', $this->siteLangId) . '</small>';
            }
        }

        $frm->addSelectBox(Labels::getLabel('LBL_Varinats/Options', $this->siteLangId), 'option_groups', [], '', array('placeholder' => Labels::getLabel('LBL_Select_Varinats/Options', $this->siteLangId)));
        $fld = $frm->addTextBox(Labels::getLabel('LBL_Add_Tag', $this->siteLangId), 'product_tags');

        if (true == $isRequest) {
            $frm->addHiddenField('', 'preq_id');
        } else {
            $frm->addHiddenField('', 'product_id');
        }
        $frm->addHiddenField('', 'temp_record_id');

        //$frm->addHiddenField('', 'product_brand_id');
        //$frm->addHiddenField('', 'ptc_prodcat_id');
        //$frm->addHiddenField('', 'ptt_taxcat_id');
        //$frm->addHiddenField('', 'ptt_taxcat_id_rent');
        $frm->addHiddenField('', 'specifications');
        $frm->addHiddenField('', 'filespecifications');
        $frm->addHiddenField('', 'num_attributes');
        $frm->addHiddenField('', 'text_attributes');
        $frm->addSubmitButton('', 'btn_submit', Labels::getLabel('LBL_Save', $this->siteLangId));
        return $frm;
    }

    private function scfAddShippingFields($frm, $langId = 0)
    {
        if (1 > $langId) {
            $langId = $this->siteLangId;
        }

        if (!FatApp::getConfig('CONF_SHIPPED_BY_ADMIN_ONLY', FatUtility::VAR_INT, 0)) {
            $shipProfileArr = ShippingProfile::getProfileArr($langId, $this->userParentId, true, true);
            $frm->addSelectBox(Labels::getLabel('LBL_Shipping_Profile', $this->siteLangId), 'shipping_profile', $shipProfileArr)->requirements()->setRequired();
        }

        if (FatApp::getConfig("CONF_PRODUCT_DIMENSIONS_ENABLE", FatUtility::VAR_INT, 0)) {
            $shipPackArr = ShippingPackage::getAllNames();
            $frm->addSelectBox(Labels::getLabel('LBL_Shipping_Package', $this->siteLangId), 'product_ship_package', $shipPackArr)->requirements()->setRequired();
        }

        $weightUnitsArr = applicationConstants::getWeightUnitsArr($langId);
        $frm->addSelectBox(Labels::getLabel('LBL_Weight_Unit', $this->siteLangId), 'product_weight_unit', $weightUnitsArr)->requirements()->setRequired();

        $weightFld = $frm->addFloatField(Labels::getLabel('LBL_Weight', $this->siteLangId), 'product_weight', '0.00');
        $weightFld->requirements()->setRequired(true);
        $weightFld->requirements()->setFloatPositive();
        $weightFld->requirements()->setRange('0.01', '9999999999');
        return $frm;
    }

}