<?php

class SellerProductSearch extends SearchBase
{

    private $langId;
    

    public function __construct($langId = 0)
    {
        $this->langId = FatUtility::int($langId);
		parent::__construct(SellerProduct::DB_TBL, 'sp');

        if ($langId) {
            $this->joinTable(
                SellerProduct::DB_TBL_LANG, 'LEFT OUTER JOIN', 'sp_l.' . SellerProduct::DB_TBL_LANG_PREFIX . 'selprod_id = sp.' . SellerProduct::tblFld('id') . ' and
			sp_l.' . SellerProduct::DB_TBL_LANG_PREFIX . 'lang_id = ' . $langId, 'sp_l'
            );
        }

        $this->joinTable(SellerProduct::DB_TBL_SELLER_PROD_DATA, 'LEFT OUTER JOIN', 'spd.' . SellerProduct::DB_TBL_SELLER_PROD_DATA_PREFIX . 'selprod_id = sp.' . SellerProduct::tblFld('id'), 'spd');
  	

    }

    public function joinProducts()
    {
        $this->joinTable(Product::DB_TBL, 'INNER JOIN', 'sp.selprod_product_id = p.product_id AND product_active = 1 AND product_deleted = 0 AND product_approved = 1', 'p');
    }
	
    public function joinProductsLang($langId)
    {
        $this->joinTable(Product::DB_TBL_LANG, 'LEFT OUTER JOIN', 'productlang_product_id = p.product_id AND productlang_lang_id = ' . $langId, 'tp_l');
    }
	
	public function joinSellers()
    {
        $this->joinTable(User::DB_TBL, 'INNER JOIN', 'selprod_user_id = seller_user.user_id and seller_user.user_is_supplier = ' . applicationConstants::YES . ' AND seller_user.user_deleted = ' . applicationConstants::NO, 'seller_user');
		
        $this->joinTable(User::DB_TBL_CRED, 'INNER JOIN', 'credential_user_id = seller_user.user_id and credential_active = ' . applicationConstants::ACTIVE . ' and credential_verified = ' . applicationConstants::YES, 'seller_user_cred');
    }
	
	public function joinShops()
    {
        $this->joinTable(Shop::DB_TBL, 'INNER JOIN', 'seller_user.user_id = shop.shop_user_id AND shop.shop_active = ' . applicationConstants::ACTIVE.' AND shop.shop_supplier_display_status = ' . applicationConstants::ON, 'shop');
    }
	
	public function joinShopCountry()
    {
		$this->joinTable(Countries::DB_TBL, 'INNER JOIN', 'shop.shop_country_id = shop_country.country_id and shop_country.country_active = ' . applicationConstants::ACTIVE , 'shop_country');
	}
	
	public function joinShopState()
    {
		$this->joinTable(States::DB_TBL, 'INNER JOIN', 'shop.shop_state_id = shop_state.state_id and shop_state.state_active = ' . applicationConstants::ACTIVE, 'shop_state');
	}
	
	public function joinBrands()
    {
        $brandMandatrory = FatApp::getConfig("CONF_PRODUCT_BRAND_MANDATORY", FatUtility::VAR_INT, 0);
		$brandActiveCondition = $brandDeletedCondition = '';
		$join = 'LEFT OUTER JOIN';
		if(1 == $brandMandatrory) {
			$join = 'INNER JOIN';
			$brandActiveCondition = 'and brand.brand_active = ' . applicationConstants::ACTIVE;
			$brandDeletedCondition = 'and brand.brand_deleted = ' . applicationConstants::NO;
		}
		$this->joinTable(Brand::DB_TBL, $join, 'p.product_brand_id = brand.brand_id ' . $brandActiveCondition . ' ' . $brandDeletedCondition, 'brand');
    }
	
	public function joinBrandsLang($langId)
    {
        $this->joinTable(Brand::DB_TBL_LANG, 'LEFT OUTER JOIN', 'brand.brand_id = tb_l.brandlang_brand_id AND brandlang_lang_id = ' . $langId, 'tb_l');
    }
	
	public function joinProductToCategory()
    {
        $this->joinTable(Product::DB_TBL_PRODUCT_TO_CATEGORY, 'INNER JOIN', 'ptc.ptc_product_id = p.product_id', 'ptc');
		
		$categoryActiveCondition = 'and c.prodcat_active = ' . applicationConstants::ACTIVE;
		$categoryDeletedCondition = 'and c.prodcat_deleted = ' . applicationConstants::NO;
		
		$this->joinTable(ProductCategory::DB_TBL, 'INNER JOIN', 'c.prodcat_id = ptc.ptc_prodcat_id  AND prodcat_status = 1 ' . $categoryActiveCondition . ' ' . $categoryDeletedCondition, 'c');
	}
	
	public function joinProductToCategoryLang($langId)
    {
        $this->joinTable(ProductCategory::DB_TBL_LANG, 'LEFT OUTER JOIN', 'c_l.prodcatlang_prodcat_id = c.prodcat_id AND prodcatlang_lang_id = ' . $langId, 'c_l');
    }
	
	public function joinSellerSubscription()
    {
		$this->joinTable(Orders::DB_TBL, 'INNER JOIN', 'order_user_id = selprod_user_id AND order_type = '.ORDERS::ORDER_SUBSCRIPTION.' AND order_payment_status = 1', 'o');
		$validDateCondition = " and oss.ossubs_till_date >= '" . date('Y-m-d') . "'";
		$this->joinTable(OrderSubscription::DB_TBL, 'INNER JOIN', 'o.order_id = oss.ossubs_order_id and oss.ossubs_status_id =' . FatApp::getConfig('CONF_DEFAULT_SUBSCRIPTION_PAID_ORDER_STATUS') . $validDateCondition, 'oss');
	}
	
	public function joinSpecialPrice()
    {
		$now = FatDate::nowInTimezone(FatApp::getConfig('CONF_TIMEZONE'), 'Y-m-d');
		$this->joinTable(SellerProduct::DB_TBL_SELLER_PROD_SPCL_PRICE, 'LEFT OUTER JOIN', 'm.splprice_selprod_id = selprod_id AND \'' . $now . '\' BETWEEN m.splprice_start_date AND m.splprice_end_date AND m.splprice_type = ' . Product::PRODUCT_FOR_RENT, 'm');
	}
	
	public function getSellerSubscription(Array $sellerIdArr)
	{
		$sellerIdArr = array_unique($sellerIdArr);
		$validDateCondition = " and oss.ossubs_till_date >= '" . date('Y-m-d') . "'";
		
		$srch = new searchBase(Orders::DB_TBL, 'o');
		$srch->joinTable(OrderSubscription::DB_TBL, 'INNER JOIN', 'o.order_id = oss.ossubs_order_id and oss.ossubs_status_id =' . FatApp::getConfig('CONF_DEFAULT_SUBSCRIPTION_PAID_ORDER_STATUS') . $validDateCondition, 'oss');

		$srch->addCondition('o.order_type', '=', 'mysql_func_'. ORDERS::ORDER_SUBSCRIPTION, 'AND', true);
		$srch->addCondition('o.order_payment_status', '=', 'mysql_func_1', 'AND', true);
		$srch->doNotCalculateRecords();
		$srch->doNotLimitRecords();

		$srch->addMultipleFields(array('order_id', 'order_user_id'));
		$srch->addCondition('order_user_id', 'IN', $sellerIdArr);
		
		$rs = $srch->getResultSet();
        return FatApp::getDb()->fetchAll($rs, 'order_user_id');

	}

}