<?php

class ChecklistPoint extends MyAppModel
{

    public const DB_TBL = 'tbl_checklist_points';
    public const DB_TBL_PREFIX = 'cp_';
    public const DB_TBL_LANG = 'tbl_checklist_points_lang';
    public const DB_TBL_LANG_PREFIX = 'cpl_';
    public const CHECKLISTTYPE_TEXT = 1;
    public const CHECKLISTTYPE_CHECKBOXES = 2;
    public const CHECKLISTPRIFIX_STRING = 'checklist_points';
    public const ACTIVE = 1;
    public const INACTIVE = 0;

    private $db;

    public function __construct($id = 0)
    {
        parent::__construct(static::DB_TBL, static::DB_TBL_PREFIX . 'id', $id);
        $this->db = FatApp::getDb();
    }

    public static function getSearchObject(): object
    {
        $srch = new SearchBase(static::DB_TBL, 'cp');
        return $srch;
    }

    public static function getChecklistTypesArr(int $langId): array
    {
        if ($langId == 0) {
            trigger_error(Labels::getLabel('MSG_Language_Id_not_specified.', $langId), E_USER_ERROR);
        }
        return array(
            static::CHECKLISTTYPE_TEXT => Labels::getLabel('LBL_Text', $langId),
            static::CHECKLISTTYPE_CHECKBOXES => Labels::getLabel('LBL_Checkboxes', $langId),
        );
    }

    public static function getSearchObjectByLang(): object
    {
        $srch = new SearchBase(self::DB_TBL_LANG, 'lang');
        $srch->joinTable(self::DB_TBL, 'LEFT JOIN', 'lang.cplang_cp_id  = ' . self::DB_TBL_PREFIX . 'id', 'cp');

        return $srch;
    }

    public function getDetail(int $langId): array
    {
        if($this->mainTableRecordId < 1){
            return [];
        }

        $srch = self::getSearchObject();
        $srch->joinTable(self::DB_TBL_LANG, 'LEFT JOIN', 'lang.cplang_cp_id  = ' . self::DB_TBL_PREFIX . 'id AND cplang_lang_id  = ' . $langId, 'lang');
        $srch->addCondition('cp_record_id', '=', $this->mainTableRecordId);
        $srch->addMultipleFields(array('cp.cp_id', 'cp.cp_type', 'cp.cp_record_id', 'IFNULL(cp_name, cp_identifier) as cp_name', 'cp_options', 'cp_active'));
        $srch->addOrder('cp_active', 'DESC');
        $srch->doNotCalculateRecords();
        return $this->db->fetchAll($srch->getResultSet(), 'cp_id');
    }
    
}
