<?php defined('SYSTEM_INIT') or die('Invalid Usage.');
$statusArrData = [];
if(!empty($statusArr)){
    foreach($statusArr as $key => $value){
        $statusArrData[] = [
            'key'=>$key,
            'label'=>$value,
        ]; 
    }
}
if (!empty($rfqData)) {
    $rfqData['rfq_status'] = $statusArr[$rfqData['rfq_status']];
}
if (!empty($quotedOfferDetail)) {
    $quotedOfferDetail['counter_offer_status'] = $statusArr[$quotedOfferDetail['counter_offer_status']];
}

if (!empty($quotedOfferAttachments)) {
    $imageType = array('png', 'jpeg', 'jpg', 'gif', 'bmp', 'ico', 'tiff', 'tif','webp','avif');
    $i=0;
    foreach ($quotedOfferAttachments as $attachment) {
        $fileExt = pathinfo($attachment['afile_name'], PATHINFO_EXTENSION);
        $quotedOfferDetail['counter_offer_uploaded_documents'][$i] = [
            'downloadUrl' => UrlHelper::generateFullUrl('CounterOffer', 'downloadDigitalFile', [$attachment["afile_record_id"], $attachment['afile_id'], AttachedFile::FILETYPE_QUOTED_DOCUMENT], '/app-api/'.MOBILE_APP_API_VERSION.'/'),
            'viewUrl' => '',
            'ext' => $fileExt,
        ];
        if (in_array($fileExt, $imageType)) {
            $quotedOfferDetail['counter_offer_uploaded_documents'][$i]['viewUrl'] = UrlHelper::generateFullUrl('CounterOffer', 'downloadDigitalFile', [$attachment["afile_record_id"], $attachment['afile_id'], AttachedFile::FILETYPE_QUOTED_DOCUMENT, true, 0, 0, true], '/app-api/'.MOBILE_APP_API_VERSION.'/');
        }
        $i++;
    }
}

$uploadedTime = AttachedFile::setTimeParam($rfqData['product_updated_on']);
$rfqData['product_image_url'] = FatCache::getCachedUrl(CommonHelper::generateFullUrl('image', 'product', array($rfqData['selprod_product_id'], "CLAYOUT3", $rfqData['selprod_id'], 0, $siteLangId)) . $uploadedTime, CONF_IMG_CACHE_TIME, '.jpg');

$data = array(
    'shippingAddressDetail' => $shippingAddressDetail,
    'rfqData' => $rfqData,
    'reQuoteOfferDetail' => !empty($reQuoteOfferDetail)? $reQuoteOfferDetail : new stdClass(),
    'quotedOfferDetail' => !empty($quotedOfferDetail)? $quotedOfferDetail : new stdClass(),
    'attachments' => $attachments,
    'statusArr' => !empty($statusArrData) ? $statusArrData : (object)array(),
    'selProdOptions' => $selProdOptions,
    'siteLangId' => $siteLangId,
    'languages' => !empty($languages) ? $languages : (object)array(),
    'messageSent' => 0,
    'threadId' => 0,
    'messageId' => 0,
);

if (!empty($threadId)) {
    $data['messageSent'] = applicationConstants::ACTIVE;
    $data['threadId'] = $threadId;
}
if (!empty($messageId)) {
    $data['messageId'] = $messageId;
}

if (empty($rfqData)) {
    $status = applicationConstants::OFF;
}
