<?php defined('SYSTEM_INIT') or die('Invalid Usage.');

$productItems = [];
switch ($fulfillmentType) { 
    case Shipping::FULFILMENT_PICKUP:
        $billingAddress = $addresses;
        require_once(CONF_THEME_PATH . 'default/checkout/fulfillment-pickup-summary.php');
        break;
    case Shipping::FULFILMENT_SHIP:
        require_once(CONF_THEME_PATH . 'default/checkout/fulfillment-ship-summary.php');
        break;

    default:
        $msg = Labels::getLabel("MSG_INVALID_FULFILLMENT_TYPE", $siteLangId);
        FatUtility::dieJsonError($msg);
        break;
}

$productItems = array_values($productItems);
$data = [
    'fulfillmentType' => $fulfillmentType,
    'hasPhysicalProd' => $hasPhysicalProd,
    'addresses' => empty($addresses) ? (object) [] : $addresses,
    'billingAddress' => empty($billingAddress) ? (object) [] : $billingAddress,
    'cartSummary' => $cartSummary,
    'productItems' => $productItems,
    'isShippingPluginActive' => Plugin::isActiveByType(Plugin::TYPE_SHIPPING_SERVICES) ? applicationConstants::YES : applicationConstants::NO,
];

require_once(CONF_THEME_PATH . 'default/cart/price-detail.php');

if (empty($productItems)) {
    $status = applicationConstants::OFF;
}
