<?php defined('SYSTEM_INIT') or die('Invalid Usage.');

ksort($shippingRates);

foreach ($shippingRates as $shippedBy => $shippedByItemArr) {
    ksort($shippedByItemArr);
    $shopLevelTotalAmount = (isset($shippedByItemArr['shopTotalAmount'])) ? $shippedByItemArr['shopTotalAmount'] : 0;
    foreach ($shippedByItemArr as $shipLevel => $items) {
        $data = [];
        switch ($shipLevel) {
            case Shipping::LEVEL_ORDER:
            case Shipping::LEVEL_SHOP:
                if (isset($items['products']) && !empty($items['products'])) {
                    $productData = $items['products'];
                    $productInfo = current($productData);
                    if (!isset($productItems[$shippedBy]['title'])) {
                        $productItems[$shippedBy]['title'] = ($shipLevel == Shipping::LEVEL_SHOP) ? $productInfo['shop_name'] : FatApp::getConfig('CONF_WEBSITE_NAME_' . $siteLangId, null, '');
                    }

                    $shippingCharges = [];
                    if (isset($shippedByItemArr[$shipLevel]['rates'])) {
                        $shippingCharges = $shippedByItemArr[$shipLevel]['rates'];
                    }

                    $isFreeShipEnable = current($productData)['shop_is_free_ship_active'];
                    $isFreeShipAmount = current($productData)['shop_free_shipping_amount'];

                    $data['rates']['data'] = [];
                    if (count($shippingCharges) > 0) {
                        $name = current($shippingCharges)['code'];
                        $data['rates']['code'] =  $name;
                        foreach ($shippingCharges as $key => $shippingcharge) {
                            if (!empty($orderShippingData)) {
                                foreach ($orderShippingData as $shipdata) {
                                    if ($shipdata['opshipping_code'] == $name && ($key == $shipdata['opshipping_carrier_code'] . "|" . $shipdata['opshipping_label'] || $key == $shipdata['opshipping_rate_id'])) {
                                        $data['rates']['selected'] = $key;
                                        break;
                                    }
                                }
                            }

                            $shipAmount = $shippingcharge['cost'];
                            if ($isFreeShipEnable && $shopLevelTotalAmount >= $isFreeShipAmount) {
                                $shipAmount = 0;
                            }

                            $data['rates']['data'][] = [
                                'title' => $shippingcharge['title'],
                                'cost' => CommonHelper::displayMoneyFormat($shipAmount, false, false, false),
                                'id' => $shippingcharge['id'],
                                'carrier_code' => $shippingcharge['carrier_code'],
                                'shiprate_min_duration' => $shippingcharge['shiprate_min_duration'] . ' '.Labels::getLabel("LBL_Day(s)", $siteLangId),
                            ];
                        }
                    }

                    foreach ($productData as $product) {
                        $product['productUrl'] = UrlHelper::generateFullUrl('Products', 'View', array($product['selprod_id']));
                        $product['shopUrl'] = UrlHelper::generateFullUrl('Shops', 'View', array($product['shop_id']));
                        $product['imageUrl'] = UrlHelper::getCachedUrl(UrlHelper::generateFullFileUrl('image', 'product', array($product['product_id'], "THUMB", $product['selprod_id'], 0, $siteLangId)), CONF_IMG_CACHE_TIME, '.jpg');
                        $op_selprod_options = '';
                        if (!empty($product['options'])) {
                            $optionCounter = 1;
                            foreach ($product['options'] as $poLang) {
                                $op_selprod_options .= $poLang['option_name'] . ': ' . $poLang['optionvalue_name'];
                                if ($optionCounter != count($product['options'] )) {
                                    $op_selprod_options .= ' | ';
                                }
                                $optionCounter++;
                            }
                        }
                        $product['op_selprod_options'] = $op_selprod_options;
                        $data['products'][] = $product;
                    }
                    $data['shipLevel'] = $shipLevel;

                    $productItems[$shippedBy]['data'][] = $data;
                }
                break;
            case Shipping::LEVEL_PRODUCT:
                if (isset($items['products']) && !empty($items['products'])) {
                    foreach ($items['products'] as $selProdid => $product) {
                        $isFreeShipEnable = $product['shop_is_free_ship_active'];
                        $isFreeShipAmount = $product['shop_free_shipping_amount'];

                        if (!isset($productItems[$shippedBy]['title'])) {
                            $productItems[$shippedBy]['title'] = $product['shop_name'];
                        }
                        $rates = isset($shippedByItemArr[$shipLevel]['rates']) ? $shippedByItemArr[$shipLevel]['rates'] : [];
                        $sellerProductId = $product['selprod_id'];
                        if ($cart_type == applicationConstants::PRODUCT_FOR_RENT) {
                            $sellerProductId = $selProdid;
                        }
                        $priceListCount = !empty($rates) && isset($rates[$sellerProductId]) ? count($rates[$sellerProductId]) : 0;
                        $data['rates']['data'] = [];
                        if ($priceListCount > 0) {
                            $name = current($shippedByItemArr[$shipLevel]['rates'][$sellerProductId])['code'];
                            $data['rates']['code'] =  $name;
                            foreach ($shippedByItemArr[$shipLevel]['rates'][$sellerProductId] as $key => $shippingcharge) {
                                if (!empty($orderShippingData)) {
                                    foreach ($orderShippingData as $shipdata) {
                                        if ($shipdata['opshipping_code'] == $name && ($key == $shipdata['opshipping_carrier_code'] . "|" . $shipdata['opshipping_label'] || $key == $shipdata['opshipping_rate_id'])) {
                                            $data['rates']['selected'] = $key;
                                            break;
                                        }
                                    }
                                }
                                $shipAmount = $shippingcharge['cost'];
                                if ($isFreeShipEnable && $shopLevelTotalAmount >= $isFreeShipAmount) {
                                    $shipAmount = 0;
                                }
                                $data['rates']['data'][] = [
                                    'title' => $shippingcharge['title'],
                                    'cost' => CommonHelper::displayMoneyFormat($shipAmount, false, false, false),
                                    'id' => $shippingcharge['id'],
                                    'carrier_code' => $shippingcharge['carrier_code'],
                                    'shiprate_min_duration' => $shippingcharge['shiprate_min_duration'] . ' '.Labels::getLabel("LBL_Day(s)", $siteLangId),
                                    
                                ];
                            }
                        }
                        $product['productUrl'] = UrlHelper::generateFullUrl('Products', 'View', array($product['selprod_id']));
                        $product['shopUrl'] = UrlHelper::generateFullUrl('Shops', 'View', array($product['shop_id']));
                        $product['imageUrl'] = UrlHelper::getCachedUrl(UrlHelper::generateFullFileUrl('image', 'product', array($product['product_id'], "THUMB", $product['selprod_id'], 0, $siteLangId)), CONF_IMG_CACHE_TIME, '.jpg');
                        $op_selprod_options = '';
                        if (!empty($product['options'])) {
                            $optionCounter = 1;
                            foreach ($product['options'] as $poLang) {
                                $op_selprod_options .= $poLang['option_name'] . ': ' . $poLang['optionvalue_name'];
                                if ($optionCounter != count($product['options'] )) {
                                    $op_selprod_options .= ' | ';
                                }
                                $optionCounter++;
                            }
                        }
                        $product['op_selprod_options'] = $op_selprod_options;
                        $data['products'] = [$product];
                        $data['shipLevel'] = $shipLevel;

                        $productItems[$shippedBy]['data'][] = $data;
                    }
                }

                if (isset($items['digital_products']) && !empty($items['digital_products'])) {
                    foreach ($items['digital_products'] as $selProdid => $product) {
                        if (!isset($productItems[$shippedBy]['title'])) {
                            $productItems[$shippedBy]['title'] = $product['shop_name'];
                        }

                        $priceListCount = isset($shippedByItemArr[$shipLevel]['rates'][$product['selprod_id']]) ? count($shippedByItemArr[$shipLevel]['rates'][$product['selprod_id']]) : 0;
                        $data['rates']['data'] = [];
                        if ($priceListCount > 0) {
                            $name = current($shippedByItemArr[$shipLevel]['rates'][$product['selprod_id']])['code'];
                            $data['rates']['code'] =  $name;
                            foreach ($shippedByItemArr[$shipLevel]['rates'][$product['selprod_id']] as $key => $shippingcharge) {
                                if (!empty($orderShippingData)) {
                                    foreach ($orderShippingData as $shipdata) {
                                        if ($shipdata['opshipping_code'] == $name && ($key == $shipdata['opshipping_carrier_code'] . "|" . $shipdata['opshipping_label'] || $key == $shipdata['opshipping_rate_id'])) {
                                            $data['rates']['selected'] = $key;
                                            break;
                                        }
                                    }
                                }
                                $data['rates']['data'][] = [
                                    'title' => $shippingcharge['title'],
                                    'cost' => CommonHelper::displayMoneyFormat($shippingcharge['cost'], false, false, false),
                                    'id' => $shippingcharge['id'],
                                    'carrier_code' => $shippingcharge['carrier_code'],
                                ];
                            }
                        }

                        $product['productUrl'] = UrlHelper::generateFullUrl('Products', 'View', array($product['selprod_id']));
                        $product['shopUrl'] = UrlHelper::generateFullUrl('Shops', 'View', array($product['shop_id']));
                        $product['imageUrl'] = UrlHelper::getCachedUrl(UrlHelper::generateFullFileUrl('image', 'product', array($product['product_id'], "THUMB", $product['selprod_id'], 0, $siteLangId)), CONF_IMG_CACHE_TIME, '.jpg');
                        $data['products'] = [$product];
                        $data['shipLevel'] = $shipLevel;

                        $productItems[$shippedBy]['data'][] = $data;
                    }
                }
                break;
        }
    }
}
