<?php defined('SYSTEM_INIT') or die('Invalid Usage.');
$productsArr = [
    'notAvailable' => [],
    'available' => [],
    'saveForLater' => [],
];

$productsCount = count($products);
if (0 < $productsCount) {
    uasort($products, function ($a, $b) {
        return  $b['fulfillment_type'] - $a['fulfillment_type'];
    });

    foreach ($products as $key => &$product) {
        $product['productUrl'] = UrlHelper::generateFullUrl('Products', 'View', array($product['selprod_id']));
        $product['shopUrl'] = UrlHelper::generateFullUrl('Shops', 'View', array($product['shop_id']));
        $product['imageUrl'] = UrlHelper::getCachedUrl(UrlHelper::generateFullFileUrl('image', 'product', array($product['product_id'], "THUMB", $product['selprod_id'], 0, $siteLangId)), CONF_IMG_CACHE_TIME, '.jpg');

        $type = '';
        if ($product['fulfillment_type'] == Shipping::FULFILMENT_SHIP) {
            $type = 'notAvailable';
        } else {
            $type = 'available';
        }
        if (isset($product['addonsData']) && is_array($product['addonsData'])) {
            if (!empty($product['addonsData'])) {
                foreach ($product['addonsData'] as $addonKey=> $addonValue) {
                    $product['addonsData'][$addonKey]['sprodata_rental_security'] = $product['sprodata_rental_security'] * $product['quantity'];
                    // $product['addonsData'][$addonKey]['quantity'] = $product['quantity'];
                }
            }
            $product['addonsData'] = array_values($product['addonsData']);
        }
        $product['theprice'] = CommonHelper::displayMoneyFormat($product['theprice'], false, false, false);
        $product['selprod_price'] = CommonHelper::displayMoneyFormat($product['selprod_price'], false, false, false);
        $product['rent_price'] = CommonHelper::displayMoneyFormat($product['rent_price']??0, false, false, false);
        $product['key_md5'] = md5($product['key']);
        $op_selprod_options = '';
        if (!empty($product['options'])) {
            $optionCounter = 1;
            foreach ($product['options'] as $poLang) {
                $op_selprod_options .= $poLang['option_name'] . ': ' . $poLang['optionvalue_name'];
                if ($optionCounter != count($product['options'] )) {
                    $op_selprod_options .= ' | ';
                }
                $optionCounter++;
            }
        }
        $product['op_selprod_options'] = $op_selprod_options;
        $productsArr[$type][] = $product;
    }
}

foreach ($saveForLaterProducts as &$slProduct) {
    $slProductOptions = '';
    if (!empty($slProduct['options'])) {
        $optionCounter = 1;
        foreach ($slProduct['options'] as $poLang) {
            $slProductOptions .= $poLang['option_name'] . ': ' . $poLang['optionvalue_name'];
            if ($optionCounter != count($slProduct['options'] )) {
                $slProductOptions .= ' | ';
            }
            $optionCounter++;
        }
    }
    if (!empty($slProduct['optionsRows'])) {
        $optionsRows = [];
        foreach ($slProduct['optionsRows'] as $key => $poLang) {
            $optionsRows[$key] = $poLang;
            if (isset($poLang['values'])){
                foreach ($poLang['values'] as $valKey => $opRows) {
                    $optionsRows[$key]['values'][$valKey] = $opRows;
                    $thePrice = CommonHelper::displayMoneyFormat($opRows['theprice'], false, false, false);
                    $optionsRows[$key]['values'][$valKey]['theprice'] = $thePrice;
                }
            }
        }
        $slProduct['optionsRows'] = $optionsRows;
    }
    $slProduct['op_selprod_options'] = $slProductOptions;
    $slProduct['productUrl'] = UrlHelper::generateFullUrl('Products', 'View', array($slProduct['selprod_id']));
    $slProduct['imageUrl'] = UrlHelper::getCachedUrl(UrlHelper::generateFullFileUrl('image', 'product', array($slProduct['product_id'], "THUMB", $slProduct['selprod_id'], 0, $siteLangId)), CONF_IMG_CACHE_TIME, '.jpg');
    $productsArr['saveForLater'][] = $slProduct;
}

// $cartSummary['orderNetAmount'] = CommonHelper::displayMoneyFormat($cartSummary['orderNetAmount'], false, false, false);

$data = array(
    'products' => $productsArr,
    'cartSummary' => $cartSummary,
    'cartSelectedBillingAddress' => empty($cartSelectedBillingAddress) ? (object)array() : $cartSelectedBillingAddress,
    'cartSelectedShippingAddress' => empty($cartSelectedShippingAddress) ? (object)array() : $cartSelectedShippingAddress,
    'hasPhysicalProduct' => $hasPhysicalProduct,
    'isShippingSameAsBilling' => $isShippingSameAsBilling,
    'selectedBillingAddressId' => $selectedBillingAddressId,
    'selectedShippingAddressId' => $selectedShippingAddressId,
    'cartProductsCount' => $cartProductsCount,
    'shipProductsCount' => $shipProductsCount,
    'pickUpProductsCount' => $pickUpProductsCount,
);

$changeNetAmountFormat = true;

require_once(CONF_THEME_PATH . 'default/cart/price-detail.php');

if (empty(array_filter($productsArr))) {
    $status = applicationConstants::OFF;
}
