<?php defined('SYSTEM_INIT') or die('Invalid Usage.');


$frmOrderComments = [];
if(isset($orderStatusFrm)){
   
    if($op_status_id = $orderStatusFrm->getField('op_status_id')->options){
        if(!empty($op_status_id)){
            $op_status_idArr = [];
            foreach($op_status_id as $key=> $val){
                $op_status_idArr[] = ['value'=>$key,'label'=> $val]; 
            }
            $frmOrderComments['op_status_id'] = $op_status_idArr;
        }
    }
    
    
    if(!empty($orderStatusFrm->getField('op_return_fullfillment_type')->options) && $op_return_fullfillment_type = $orderStatusFrm->getField('op_return_fullfillment_type')->options){
        if(!empty($op_return_fullfillment_type)){
            $op_return_fullfillment_typeArr = [];
            foreach($op_return_fullfillment_type as $key=> $val){
                $op_return_fullfillment_typeArr[] = ['value'=>$key,'label'=> $val]; 
            }
            $frmOrderComments['op_return_fullfillment_type'] = $op_return_fullfillment_typeArr;
        }
    }
    
    
    if(!empty($orderStatusFrm->getField('return_qty')) && $return_qtyData = $orderStatusFrm->getField('return_qty')->requirements()->getRange()){
        if(!empty($return_qtyData[0])){
            $frmOrderComments['return_qty'] = ['min'=>$return_qtyData[0],'max'=> $return_qtyData[1]];
        }else{
            $frmOrderComments['return_qty'] = ['min'=>1,'max'=> 1];
        }
    }
    
    $frmOrderComments['shop_addresses'] = $shopAddresses;
}

$dateToRentalEndTxt = '';
if (true == $primaryOrder) {
    if ($childOrderDetail['opd_sold_or_rented'] == applicationConstants::ORDER_TYPE_RENT) {
        if (strtotime($childOrderDetail['opd_rental_start_date']) <= strtotime(date('Y-m-d 00:00:00')) && strtotime($childOrderDetail['opd_rental_end_date']) >= strtotime(date('Y-m-d 00:00:00')) && in_array($childOrderDetail['op_status_id'], OrderStatus::statusArrForRentalExpireNote())) {
            if(date('Y-m-d 00:00:00') == $childOrderDetail['opd_rental_end_date']){
                $dateToRentalEnd = 0;
            }else{
                $dateToRentalEnd = CommonHelper::getDifferenceBetweenDates(date('Y-m-d 00:00:00'), $childOrderDetail['opd_rental_end_date'], 0, ProductRental::DURATION_TYPE_DAY);
            }
            $dateToRentalEndTxt = sprintf(Labels::getLabel('LBL_%s_Day(s)_Remaining_to_end_Rental', $siteLangId), $dateToRentalEnd);

        } 
        if (strtotime($childOrderDetail['opd_rental_end_date']) < strtotime(date('Y-m-d H:i')) && in_array($childOrderDetail['op_status_id'], OrderStatus::statusArrForLateChargeNote())) { 
            $dateToRentalEndTxt = Labels::getLabel('LBL_Rental_Duration_Ended._Late_Charges_may_be_Apply', $siteLangId);
        }
    }
}


if (1 > $opId) {
    $childOrderDetail = array_values($childOrderDetail);
}

foreach($orderDetail['comments'] as $key => $val){
    foreach($orderDetail['comments'][$key] as $skey => $sVal){
        if (Shipping::FULFILMENT_PICKUP == $orderDetail['comments'][$key][$skey]['opshipping_fulfillment_type'] && $orderDetail['comments'][$key][$skey]['oshistory_orderstatus_id'] == OrderStatus::ORDER_DELIVERED) {
            $orderDetail['comments'][$key][$skey]['orderstatus_name'] = Labels::getLabel('LBL_Picked', $siteLangId);
        }    
        if(empty($orderDetail['comments'][$key][$skey]['orderstatus_name'])){
            $orderDetail['comments'][$key][$skey]['orderstatus_name'] = $orderDetail['comments'][$key][$skey]['oshistory_comments'];
        }
        
    }
    

    if (isset($statusAddressData[$val[0]['oshistory_id']])) {
        $orderDetail['comments'][$key][0]['dropOffAddress'] = $statusAddressData[$val[0]['oshistory_id']];
    }

    
    $attachedFileArr = [];    
    if (isset($statusAttachedFiles[$val[0]['oshistory_id']])) { 
        $attachedFiles = $statusAttachedFiles[$val[0]['oshistory_id']];
        foreach($attachedFiles as $attachedFile) {
            $attachedFileArr[] = [
                'name' => $attachedFile['afile_name'],
                'url' => UrlHelper::generateFullFileUrl('buyer', 'downloadBuyerAtatchedFile', array($attachedFile['afile_record_id'], 0, $attachedFile['afile_id']), '/app-api/'.MOBILE_APP_API_VERSION.'/'),
            ];   
        }
    }
    $orderDetail['comments'][$key][0]['attached_files'] = $attachedFileArr;
}

$postedCommentsArr = [];
$orderStatusList = array_values($orderStatusList);

if ($primaryOrder) {
    $fulfillmentType = $childOrderDetail['opshipping_fulfillment_type'];
} else {
    $fulfillmentType = current($childOrderDetail)['opshipping_fulfillment_type'];
}

$i=0;
foreach ($orderStatusList as $key => $opStatus) {
        $opStatusId = $opStatus['orderstatus_id'];
        if (!isset($orderDetail['comments'][$opStatusId])) {
            foreach ($orderStatusList as $keyChild => $opStatusChild) {
                $opStatusIdChild = $opStatusChild['orderstatus_id'];
                    if (isset($childOrderDetail['op_status_id']) && $childOrderDetail['op_status_id'] == OrderStatus::ORDER_CANCELLED) {
                        continue;
                    }
                    if ($keyChild > $key && isset($orderDetail['comments'][$opStatusIdChild])) {
                        $postedCommentsArr[$i] = array_merge(array('oshistory_id' => 0, 'oshistory_date_added' => $orderDetail['comments'][$opStatusIdChild][0]['oshistory_date_added'], 'opshipping_fulfillment_type' => $fulfillmentType),$opStatus);
                        $i++;
                        break;
                    }

                if ($keyChild == $key && $opStatusIdChild == OrderStatus::ORDER_PAYMENT_PENDING) {
                    $postedCommentsArr[$i] = array_merge(array('oshistory_id' => 0, 'oshistory_date_added' => $orderDetail['order_date_added'], 'opshipping_fulfillment_type' => $fulfillmentType),$opStatus);
                    $i++;
                    break;
                }
            }
        } else {
            foreach($orderDetail['comments'][$opStatusId] as $key => $val){
                $postedCommentsArr[$i] = $val;    
                $i++;
            }
            
        }
 
}
$orderDetail['comments'] = $postedCommentsArr;


$orderDetail['charges'] = !empty($orderDetail['charges']) ? $orderDetail['charges'] : (object)array();
$orderDetail['billingAddress'] = !empty($orderDetail['billingAddress']) ? $orderDetail['billingAddress'] : (object)array();
$orderDetail['shippingAddress'] = !empty($orderDetail['shippingAddress']) ? $orderDetail['shippingAddress'] : (object)array();
$orderDetail['order_net_amount'] = !empty($orderDetail['order_net_amount']) ? $orderDetail['order_net_amount'] : 0;
$orderDetail['pickupAddress'] =  isset($orderDetail['pickupAddress']) && !empty($orderDetail['pickupAddress']) ? $orderDetail['pickupAddress'] : (object)array();

if (!empty($orderDetail['charges'])) {
    $charges = array();
    $i = 0;
    foreach ($orderDetail['charges'] as $key => $value) {
        $charges[$key] = array_values($value);
        $i++;
    }
    $orderDetail['charges'] = $charges;
}

// echo $primaryOrder; die;
if ($primaryOrder) {
    $childArr[] = $childOrderDetail;
} else {
    $childArr = $childOrderDetail;
}

$orderDetail['pickupDetail'] = (object)array();
if (0 < $opId) {
    $opDetail = current($childArr);
    if (Shipping::FULFILMENT_PICKUP == $opDetail['opshipping_fulfillment_type']) {
        $orderDetail['pickupDetail'] =  [
            'opshipping_date' => $opDetail['opshipping_date'],
            'opshipping_time_slot_from' => $opDetail['opshipping_time_slot_from'],
            'opshipping_time_slot_to' => $opDetail['opshipping_time_slot_to'],
        ];
    }
}

$cartTotal = $shippingCharges = $totalVolumeDiscount = $totalOrderDiscountTotal = $totalTax = $totalSecurityAmount = $totalLateCharges =$totalDurationDiscount = $addonTotal = $roundingOff = 0;

$taxOptionsTotal = /* $shippingSummaryDetails = $taxSummaryDetails = */ array();

$defaultOrderStatus = FatApp::getConfig('CONF_DEFAULT_REVIEW_STATUS', FatUtility::VAR_INT, 0);
$reviewAllowed = FatApp::getConfig('CONF_ALLOW_REVIEWS', FatUtility::VAR_INT, 0);

$canCancelOrder = true;
$canReturnRefund = true;

foreach ($childArr as $index => $childOrder) {
    $orderNetTotal = CommonHelper::orderProductAmount($childOrder,'NETAMOUNT');
    if (isset($childOrder['order_is_rfq']) && $childOrder['order_is_rfq'] == applicationConstants::YES) {
        $orderNetTotal = $childOrder['order_net_amount'];
    }
    
    $services = (isset($attachedServicesArr[$childOrder['op_id']])) ? $attachedServicesArr[$childOrder['op_id']] : [];

    $colorClass = !empty($childOrder['orderstatus_color_class']) ? $childOrder['orderstatus_color_class'] : '';
    $childArr[$index]['orderstatus_color_code'] = applicationConstants::getClassColor($colorClass);
    $rating = isset($childArr[$index]['prod_rating']) ? $childArr[$index]['prod_rating'] : 0;
    $childArr[$index]['prod_rating'] =  (1 == $defaultOrderStatus || (isset($childArr[$index]['spreview_status']) && $childArr[$index]['spreview_status'] == 1)) ? $rating : 0;
    $childArr[$index]['reviewsAllowed'] =  $reviewAllowed;
    $childArr[$index]['product_image_url'] = UrlHelper::generateFullUrl('image', 'product', array($childOrder['selprod_product_id'], "THUMB", $childOrder['op_selprod_id'], 0, $siteLangId));

    $canCancelOrder = (in_array($childOrder["op_status_id"], (array)Orders::getBuyerAllowedOrderCancellationStatuses())) ? 1 : 0;
    $canReturnRefund = (in_array($childOrder["op_status_id"], (array)Orders::getBuyerAllowedOrderReturnStatuses())) ? 1 : 0;

    if (true === $primaryOrder) {
        if ($childOrder['opd_sold_or_rented'] == applicationConstants::ORDER_TYPE_SALE) {
            $cancelAge = $childOrder['shop_cancellation_age'];
            $returnAge = $childOrderDetail['selprod_return_age'];
            if (0 < $childOrder['selprod_cancellation_age']) {
                $cancelAge = $childOrder['selprod_cancellation_age'];
            }
            if ($childOrderDetail['selprod_return_age'] == '') {
                $returnAge = $childOrderDetail['shop_return_age'];
            }
            $cancelDaysSpent = round((time() - strtotime($childOrder['order_date_added'])) / (60 * 60 * 24));
            $canCancelOrder = (empty($cancelAge) || $cancelAge < $cancelDaysSpent) ? false : $canCancelOrder;

            if (isset($childOrder['op_delivery_time'])) {
                $returnDaysSpent = round((time() - strtotime($childOrder['op_delivery_time'])) / (60 * 60 * 24));
                $canReturnRefund = ($returnAge < $returnDaysSpent) ? false : $canReturnRefund;
            }
        }
        if ($childOrder['opd_sold_or_rented'] == applicationConstants::ORDER_TYPE_RENT && strtotime($childOrderDetail['opd_rental_start_date']) <= strtotime(date('Y-m-d'))) {
            $canReturnRefund = false;
        }
        if ($childOrder['opd_extend_from_op_id'] > 0) {
            $canReturnRefund = false;
        }
        if (isset($returnAge) && $returnAge <= 0) {
            $canReturnRefund = false;
        }
        if (!FatApp::getConfig('CONF_ALLOW_RENTAL_ORDER_CANCEL_FROM_BUYER_END', FatUtility::VAR_INT, 0)) {
            $canCancelOrder = false;
        }
    }
    $childArr[$index]['canCancelOrder'] = ($canCancelOrder && false === OrderCancelRequest::getCancelRequestById($childOrder['op_id']) ? 1 : 0);

    $childArr[$index]['canReturnOrder'] = ($canReturnRefund && $childOrder['return_request'] == 0  ? 1 : 0);

    $canSubmitFeedback = Orders::canSubmitFeedback($childOrder['order_user_id'], $childOrder['order_id'], $childOrder['op_selprod_id']);
    $isValidForReview = in_array($childOrder["op_status_id"], SelProdReview::getBuyerAllowedOrderReviewStatuses());

    $childArr[$index]['canSubmitFeedback'] = ($canSubmitFeedback && $isValidForReview) ? 1 : 0;

    $childArr[$index]['canReOrder'] = ($childOrder['opd_sold_or_rented'] == 1 ? 1 : 0);
    
    $cartTotal = $cartTotal + CommonHelper::orderProductAmount($childOrder, 'cart_total');
    $shippingCharges = $shippingCharges + CommonHelper::orderProductAmount($childOrder, 'shipping');

    $volumeDiscount = CommonHelper::orderProductAmount($childOrder, 'VOLUME_DISCOUNT');
    $totalVolumeDiscount += $volumeDiscount;

    $durationDiscountAmount = CommonHelper::orderProductAmount($childOrder, 'DURATION_DISCOUNT');
    $totalDurationDiscount += $durationDiscountAmount;
    
    $rewardPointDiscount = CommonHelper::orderProductAmount($childOrder, 'REWARDPOINT');

    $orderDiscountTotal = CommonHelper::orderProductAmount($childOrder, 'DISCOUNT');
    $totalOrderDiscountTotal += $orderDiscountTotal;
    $securityAmount = $childOrder['opd_rental_security'] * $childOrder['op_qty'];
    
    if (isset($childOrder['order_is_rfq']) && $childOrder['order_is_rfq'] == applicationConstants::YES) {
        $securityAmount = $childOrder['order_security_total'];
        $totalSecurityAmount += $childOrder['order_security_total'];
    } else {
        $totalSecurityAmount += $childOrder['opd_rental_security'] * $childOrder['op_qty'];
    }
    $totalLateCharges += $childOrder['charge_total_amount'];
    $childArr[$index]['charge_total_amount'] = CommonHelper::displayMoneyFormat($childOrder['charge_total_amount']);
    $childArr[$index]['priceDetail'] = array(
        array(
            'key' => Labels::getLabel('LBL_Ordered_Quantity', $siteLangId),
            'value' => $childOrder['op_qty'],
        ),
        array(
            'key' => Labels::getLabel('LBL_Price', $siteLangId),
            'value' => CommonHelper::displayMoneyFormat($childOrder['op_unit_price'] * $childOrder['op_qty']),
        )
    );

    if (0 < CommonHelper::orderProductAmount($childOrder, 'shipping')) {
        $childArr[$index]['priceDetail'][] = array(
            'key' => Labels::getLabel('LBL_Shipping_Charges', $siteLangId),
            'value' => CommonHelper::displayMoneyFormat(CommonHelper::orderProductAmount($childOrder, 'shipping')),
        );

        /* $shippingSummaryDetails[] = [
            'ship_product_name' => (trim($childOrder['op_selprod_title']) == '') ? $childOrder['op_product_identifier'] : $childOrder['op_selprod_title'],
            'ship_product_qty' => $childOrder['op_qty'],
            'ship_product_shipping_label' => $childOrder['opshipping_label'],
            'ship_product_image_url' => $childArr[$index]['product_image_url'],
            'ship_cost' => CommonHelper::displayMoneyFormat(CommonHelper::orderProductAmount($childOrder, 'SHIPPING'), true, false, true, false, true),
        ]; */
    }

    if (0 != $volumeDiscount) {
        $childArr[$index]['priceDetail'][] = array(
            'key' => Labels::getLabel('LBL_Volume/Loyalty_Discount', $siteLangId),
            'value' => CommonHelper::displayMoneyFormat($volumeDiscount),
        );
    }
    if (0 != $totalDurationDiscount) {
        $childArr[$index]['priceDetail'][] = array(
            'key' => Labels::getLabel('LBL_Duration_Discount', $siteLangId),
            'value' => CommonHelper::displayMoneyFormat($totalDurationDiscount),
        );
    }

    $taxCharges = [];
    /* if(empty($op_id)){
        unset($childOrder['taxOptions']);
    } */
 
   $addonTax = 0;
   if (!empty($services)) {
       foreach ($services as $service) {
           $addonTotal += CommonHelper::orderProductAmount($service, 'cart_total');
            $addonTax += CommonHelper::orderProductAmount($service, 'TAX');
            $orderDiscountTotal += CommonHelper::orderProductAmount($service, 'DISCOUNT');
            $rewardPointDiscount += CommonHelper::orderProductAmount($service, 'REWARDPOINT');
            $orderNetTotal += CommonHelper::orderProductAmount($service,'NETAMOUNT');
            
            $addonTitle = (trim($service['op_selprod_title']) == '') ? $service['op_product_identifier'] : $service['op_selprod_title'];
            $addonImgUrl = UrlHelper::generateFullUrl('image', 'addonProduct', array($service['op_selprod_id'], "THUMB", 0, $siteLangId)); 
            $childArr[$index]['addons'][] = [
                'addonTitle' => $addonTitle,
                'addonImage' => $addonImgUrl,
                'addonQty' => $service['op_qty'],
            ];
           
            /* foreach ($service['taxOptions'] as $key => $val) {
                if (0 >= $val['value']) {
                    continue;
                }   
                $taxCharges[] = [
                    'key' => CommonHelper::displayTaxPercantage($val, true),
                    'value' => CommonHelper::displayMoneyFormat($val['value']),
                ];
                $taxOptionsTotal[$key]['key'] = CommonHelper::displayTaxPercantage($val);

                if (!isset($taxOptionsTotal[$key]['value'])) {
                    $taxOptionsTotal[$key]['value'] = 0;
                }
                $taxOptionsTotal[$key]['value'] += $val['value'];
            }  */  
            
        }
        if (0 < $addonTotal) {
            $childArr[$index]['priceDetail'][] = array(
                'key' => Labels::getLabel('LBL_Addon_Amount', $siteLangId),
                'value' => CommonHelper::displayMoneyFormat($addonTotal),
            );
        }
    }

    $totalTax +=  $addonTax;
 
    if (0 < $securityAmount) {
        $childArr[$index]['priceDetail'][] = array(
            'key' => Labels::getLabel('LBL_Security_Amount', $siteLangId),
            'value' => CommonHelper::displayMoneyFormat($securityAmount),
        );
    }

 
    if (empty($childOrder['taxOptions'])) {
        $totalTax += CommonHelper::orderProductAmount($childOrder, 'TAX');
       
        /* $childArr[$index]['priceDetail'][] = array(
            'key' => Labels::getLabel('LBL_Tax_Charges', $siteLangId),
            'value' => CommonHelper::displayMoneyFormat($totalTax),
        ); */

    } else {
        foreach ($childOrder['taxOptions'] as $key => $val) {
            if (0 >= $val['value']) {
                continue;
            }
            $totalTax += $val['value'];

            /* $taxCharges[] = [
                'key' => CommonHelper::displayTaxPercantage($val, true),
                'value' => CommonHelper::displayMoneyFormat($val['value']),
            ];

            $taxOptionsTotal[$key]['key'] = CommonHelper::displayTaxPercantage($val);

            if (!isset($taxOptionsTotal[$key]['value'])) {
                $taxOptionsTotal[$key]['value'] = 0;
            }
            $taxOptionsTotal[$key]['value'] += $val['value']; */
        }

        //$childArr[$index]['priceDetail'] = array_merge($childArr[$index]['priceDetail'], $taxCharges);
    }

    if (0 < $totalTax) {
        $childArr[$index]['priceDetail'][] = array(
            'key' => Labels::getLabel('LBL_Tax_Charges', $siteLangId),
            'value' => CommonHelper::displayMoneyFormat($totalTax),
        );
    }

    if (0 != $orderDiscountTotal) {
        $childArr[$index]['priceDetail'][] = array(
            'key' => Labels::getLabel('LBL_Discount', $siteLangId),
            'value' => CommonHelper::displayMoneyFormat($orderDiscountTotal),
        );
    }

    if (0 != $rewardPointDiscount) {
        $childArr[$index]['priceDetail'][] = array(
            'key' => Labels::getLabel('LBL_Reward_Point_Discount', $siteLangId),
            'value' => CommonHelper::displayMoneyFormat($rewardPointDiscount),
        );
    }

  
    if (0 != $childOrder['op_rounding_off']) {
        $roundingOff += $childOrder['op_rounding_off'];
        $childArr[$index]['priceDetail'][] = array(
            'key' => (0 < $childOrder['op_rounding_off']) ? Labels::getLabel('LBL_Rounding_Up', $siteLangId) : Labels::getLabel('LBL_Rounding_Down', $siteLangId),
            'value' => CommonHelper::displayMoneyFormat($childOrder['op_rounding_off'])
        );
    }

    $paymentMethodName = $childOrder['plugin_name'] ?: $childOrder['plugin_identifier'];
    if (0 < $childOrder['order_pmethod_id'] && 0 < $childOrder['order_is_wallet_selected']) {
        $paymentMethodName .= ' + ';
    }
    if (0 < $childOrder['order_is_wallet_selected']) {
        $paymentMethodName .= Labels::getLabel("LBL_Wallet", $siteLangId);
    }
    $childArr[$index]['plugin_name'] = $paymentMethodName;

    $orderObj = new Orders($childOrder['order_id']);
    if ($childOrder['plugin_code'] == 'CashOnDelivery') {
        $processingStatuses = $orderObj->getAdminAllowedUpdateOrderStatuses(true);
    } else {
        $processingStatuses = $orderObj->getAdminAllowedUpdateOrderStatuses(false, $childOrder['op_product_type']);
    }

    $childArr[$index]['totalAmount'] = array(
        'key' => Labels::getLabel('LBL_Total', $siteLangId),
        'value' => CommonHelper::displayMoneyFormat($orderNetTotal),
    );
    
  
}




$orderDetail['comments'] = array_values($orderDetail['comments']);


$signature_url = '';
if ($signatureData) {
    $uploadedTime = AttachedFile::setTimeParam($signatureData['afile_updated_at']);
    $signature_url = UrlHelper::getCachedUrl(UrlHelper::generateFullFileUrl('image', 'signature', array($signatureData['afile_record_id'], 0, "ORIGINAL", $signatureData['afile_id'], true)), CONF_IMG_CACHE_TIME, '.jpg');
}
if ($shopAgreementArr) {
    foreach ($shopAgreementArr as $key => $val) {
        $shopAgreementArrData[] = [
            'shop_name' => $val['shopName'],
            'agreement_file_name' => AttachedFile::getAttributesById($val['agreementFileId'], 'afile_name'),
            'agreement_url' => UrlHelper::generateFullFileUrl('Buyer', 'downloadDigitalFile', [$key, $val['agreementFileId'], AttachedFile::FILETYPE_SHOP_AGREEMENT], '/app-api/'.MOBILE_APP_API_VERSION.'/'),
        ];
    }
}
$updatedStatus = [];
if (!empty($orderDetail['comments'])) {
    if (count($orderDetail['comments']) > 1) {
        $updatedStatus[] = reset($orderDetail['comments']);
        $updatedStatus[] = end($orderDetail['comments']);
    } else {
        $updatedStatus[] = reset($orderDetail['comments']);
    }
}

if(!empty($orderDetail['payments'])){
    $orderStatusArr = Orders::getOrderPaymentStatusArr($siteLangId);
    foreach($orderDetail['payments'] as $key => $value){
        $orderDetail['payments'][$key]['opayment_txn_status'] = $orderStatusArr[$value['opayment_txn_status']];
        $orderDetail['payments'][$key]['opayment_amount'] = CommonHelper::displayMoneyFormat($value['opayment_amount'], true, false, true, false, true);
        
    }
}

foreach($childArr as $index => $val){
    if ($val['opd_sold_or_rented'] == applicationConstants::ORDER_TYPE_RENT) {
        $duration = CommonHelper::getDifferenceBetweenDates($val['opd_rental_start_date'], $val['opd_rental_end_date'], $val['op_selprod_user_id'], $val['opd_rental_type']);
        $childArr[$index]['duration']  = CommonHelper::displayProductRentalDuration($duration, $val['opd_rental_type'], $siteLangId);
    }else{
        $childArr[$index]['duration']  = '';
    }
    $childArr[$index]['opd_duration_price']  =  CommonHelper::displayMoneyFormat($val['opd_duration_price'], true, false, true, false, true);
    $childArr[$index]['opd_rental_price'] =  CommonHelper::displayMoneyFormat($val['opd_rental_price'], true, false, true, false, true);
    $childArr[$index]['order_net_amount'] =  CommonHelper::displayMoneyFormat($val['order_net_amount'], true, false, true, false, true);
}
$orderDetail['order_net_amount'] =  CommonHelper::displayMoneyFormat($val['order_net_amount'], true, false, true, false, true);

$canExtendOrder = true;
if (0 < $opId) {
   
    if (strtotime($childOrderDetail['opd_rental_end_date']) < strtotime(date('Y-m-d H:i')) && in_array($childOrderDetail['op_status_id'], OrderStatus::statusArrForLateChargeNote())) {
        $canExtendOrder = false;
    }
}else{
    $canExtendOrder = false;
}

if (true == $primaryOrder && $childOrderDetail['opd_sold_or_rented'] == applicationConstants::ORDER_TYPE_RENT) { 
    if (FatApp::getConfig("CONF_DEFAULT_DEIVERED_ORDER_STATUS") == $childOrderDetail["op_status_id"] && true == $primaryOrder && $childOrderDetail['opd_extend_from_op_id'] <= 0 && empty($extendChildOrder) && $childOrderDetail['opd_product_type'] != SellerProduct::PRODUCT_TYPE_ADDON && $canExtendOrder == true) { 
            $canExtendOrder = true;
    }else{
        $canExtendOrder = false;
    }
}
$addOns = [];
if (!empty($services)) {
    foreach ($services as $key => $service) {
        $addonTitle = (trim($service['op_selprod_title']) == '') ? $service['op_product_identifier'] : $service['op_selprod_title'];
        $addonImgUrl =UrlHelper::generateFullUrl('image', 'addonProduct', array($service['op_selprod_id'], "THUMB", 0, $siteLangId)); 
        $addOns[] = [
            'addonTitle' => $addonTitle,
            'addonImage' => $addonImgUrl,
        ];
    }
}

$orderDetail['totalLateCharges']   = CommonHelper::displayMoneyFormat($totalLateCharges, true, false, true, false, true);
$orderDetail['updatedStatus']   = $updatedStatus;

$extendedOrderDetails = [];
if (true == $primaryOrder && $childOrderDetail['opd_sold_or_rented'] == applicationConstants::ORDER_TYPE_RENT) { 
    if ($parentOrderId != '') {
        $extendedOrderDetails = [
            'label' => Labels::getLabel('LBL_This_order_is_extended_from_', $siteLangId),
            'orderId' => $parentOrderId, 
            'orderProductId' => $extendFromOpId
        ];
    }
    if (!empty($extendChildOrder)) {
        $extendedOrderDetails = [
            'label' => Labels::getLabel('LBL_This_order_is_extended_By', $siteLangId),
            'orderId' => $extendChildOrder['opd_order_id'],
            'orderProductId' => $extendChildOrder['opd_op_id']
        ];
    }
}

foreach ($verificationFldsData as $key => $val) {
    if ($val['ovd_vflds_type'] == VerificationFields::FLD_TYPE_TEXTBOX) {
        $verificationFldsData[$key]['ovd_value'] = trim($val['ovd_value']) != '' ? $val['ovd_value'] : Labels::getLabel('LBL_N/A', $siteLangId);
    } else {
        $file_row = AttachedFile::getAttachment(AttachedFile::FILETYPE_VERIFICATION_ATTACHMENT, $orderDetail['order_order_id'], $val['ovd_vfld_id'], 0, true, 0, false);
        $verificationFldsData[$key]['ovd_value'] = !empty($file_row) ? $file_row['afile_name']: Labels::getLabel('LBL_N/A', $siteLangId);
        $verificationFldsData[$key]['ovd_file_url'] = UrlHelper::generateFullFileUrl('Buyer', 'downloadAttachedFile', array($orderDetail['order_order_id'], $val['ovd_vfld_id']), '/app-api/'.MOBILE_APP_API_VERSION.'/');   
    }
}

$data = array(
    'orderDetail' => $orderDetail,
    'childOrderDetail' => $childArr,
    'orderStatuses' => !empty($orderStatuses) ? $orderStatuses : (object)array(),
    'primaryOrder' => $primaryOrder,
    'languages' => !empty($languages) ? $languages : (object)array(),
    'yesNoArr' => $yesNoArr,
    'signatureUrl' => $signature_url,
    'shopAgreementArr' => $shopAgreementArrData ?? null,
    'frmOrderComments' =>  $frmOrderComments,
    'verificationFldsData'=>$verificationFldsData,
    'canExtendOrder'=>(int) $canExtendOrder,
    'dateToRentalEndTxt' => $dateToRentalEndTxt,
    'addOns' => $addOns,
    'messageSent' => 0,
    'threadId' => 0,
    'messageId' => 0,
    'parentOrderId' => $parentOrderId ?? '',
    'extendFromOpId' => $extendFromOpId ?? '',
    'extendChildOrder' => !empty($extendChildOrder) ? $extendChildOrder :(object)array(),
    'extendedOrderDetails' => (object) $extendedOrderDetails,
);
if (!empty($thread_id)) {
    $data['messageSent'] = applicationConstants::ACTIVE;
    $data['threadId'] = $thread_id;
}
if (!empty($message_id)) {
    $data['messageId'] = $message_id;
}

//if (!$primaryOrder) {
$data['orderSummary'] = [
    [
        'key' => Labels::getLabel('LBL_CART_TOTAL', $siteLangId),
        'value' => $cartTotal,
    ]
];
if (0 != $totalDurationDiscount) {
    $data['orderSummary'][] = [
        'key' => Labels::getLabel('LBL_Duration_Discount', $siteLangId),
        'value' => $totalDurationDiscount,
    ];
}


if (0 < $totalSecurityAmount) {
    $data['orderSummary'][] = [
        'key' => Labels::getLabel('LBL_Security_Amount', $siteLangId),
        'value' => $totalSecurityAmount,
    ];
}
if (0 < $addonTotal) {
    $data['orderSummary'][] = [
        'key' => Labels::getLabel('LBL_Addon_Total', $siteLangId),
        'value' => $addonTotal,
    ];
}

if (0 < $shippingCharges) {
    $data['orderSummary'][] = [
        'key' => Labels::getLabel('LBL_Shipping_Charges', $siteLangId),
        'value' => $shippingCharges,
    ];
}

// if (!empty($taxOptionsTotal)) {
//     $data['orderSummary'] = array_merge($data['orderSummary'], $taxOptionsTotal);
// } else {
    $data['orderSummary'][] = [
        'key' => Labels::getLabel('LBL_TAX_CHARGES', $siteLangId),
        'value' => $totalTax,
    ];
// }


if (0 != $totalOrderDiscountTotal) {
    $data['orderSummary'][] = [
        'key' => Labels::getLabel('LBL_Discount', $siteLangId),
        'value' => $totalOrderDiscountTotal,
    ];
}

if (0 != $totalVolumeDiscount) {
    $data['orderSummary'][] = [
        'key' => Labels::getLabel('LBL_Volume/Loyalty_Discount', $siteLangId),
        'value' => $totalVolumeDiscount,
    ];
}

if (0 != $orderDetail['order_reward_point_value']) {
    $data['orderSummary'][] = [
        'key' => Labels::getLabel('LBL_REWARD_POINTS', $siteLangId),
        'value' => $orderDetail['order_reward_point_value'],
    ];
}

if (0 != $roundingOff) {
    $data['orderSummary'][] = array(
        'key' => (0 < $roundingOff) ? Labels::getLabel('LBL_Rounding_Up', $siteLangId) : Labels::getLabel('LBL_Rounding_Down', $siteLangId),
        'value' => $roundingOff
    );
}
// if (0 < $orderDetail['order_net_amount']) {
//     $data['orderSummary'][] = [
//         'key' => Labels::getLabel('LBL_Total', $siteLangId),
//         'value' => $orderDetail['order_net_amount'],
//     ];
// }
$data['orderSummary'] = !empty($data['orderSummary']) ? array_values($data['orderSummary']) : [];
array_walk($data['orderSummary'], function (&$val) {
    $val['value'] = CommonHelper::displayMoneyFormat($val['value'], true, false, true, false, true);
});
//}

if (empty($orderDetail)) {
    $status = applicationConstants::OFF;
}
