<?php defined('SYSTEM_INIT') or die('Invalid Usage.');

foreach ($requests as $key => $request) {
    $requests[$key]['statusName'] = array_key_exists('ocrequest_status', $request) ? $OrderCancelRequestStatusArr[$request['ocrequest_status']] : '';
    $requests[$key]['product_image_url'] = UrlHelper::generateFullUrl('image', 'product', array($request['selprod_product_id'], "THUMB", $request['op_selprod_id'], 0, $siteLangId));
}
foreach ($requests as $key => $row) {
    $requests[$key]['amount_text'] = "";
    if (!empty($row['order_net_amount'])) {
        $orderTotalAmount = CommonHelper::orderProductAmount($row, 'netamount');
        $amt = CommonHelper::displayMoneyFormat($orderTotalAmount, true, true);
        $requests[$key]['order_amount'] = $amt;
        if ($row['opd_sold_or_rented'] == applicationConstants::ORDER_TYPE_RENT && $row['ocrequest_is_penalty_applicable'] > 0) {
            $shippingCharges = $row['shipping_charges'];
            $orderTotalAmount = CommonHelper::orderProductAmount($row, 'netamount') - ($row['opd_rental_security'] * $row['op_qty']) - $shippingCharges;
            $refunableAmount = ($orderTotalAmount * $row['ocrequest_refund_amount'] / 100) + $shippingCharges;
            $amt .= '<br>' . sprintf(Labels::getLabel('LBL_Order_rental_start_date_%s', $siteLangId), FatDate::format($row['opd_rental_start_date']));
            $amt .= '<br>' . sprintf(Labels::getLabel('LBL_Order_Cancel_Before_%s_hours', $siteLangId), $row['ocrequest_hours_before_rental']);
            $amt .= '<br>' . sprintf(Labels::getLabel('LBL_Refundable_Amount(After_Penalty_%s_)', $siteLangId), $row['ocrequest_refund_amount'] . '%') . ' ' . CommonHelper::displayMoneyFormat($refunableAmount, true, true) . '<small>(' . Labels::getLabel('LBL_Exc_Security_Amount', $siteLangId) . ')</small>';
        }
        $requests[$key]['amount_text'] = $amt;
    }
}

$OrderCancelRequestStatusArr = array_values(array('-1' => Labels::getLabel('LBL_Status_Does_Not_Matter', $siteLangId)) + $OrderCancelRequestStatusArr);

$data = array(
    'requests' => $requests,
    'page' => $page,
    'pageCount' => $pageCount,
    'recordCount' => $recordCount,
    'OrderCancelRequestStatusArr' => $OrderCancelRequestStatusArr
);

if (empty($requests)) {
    $status = applicationConstants::OFF;
}
