<?php defined('SYSTEM_INIT') or die('Invalid Usage.');

$searchFrm = $data['frmProductSearch'];
$sortBy = $searchFrm->getField('sortBy')->options;
if(!empty($sortBy)){
    $sortByArr = [];
    foreach($sortBy as $key=> $val){
        $sortByArr[] = ['value'=>$key,'label'=> $val]; 
    }
    $data['sortBy'] = $sortByArr;
}
unset($data['frmProductSearch'], $data['postedData']);

if(!empty($data['products'])){

    foreach ($data['products'] as $key => $product) {
        $uploadedTime = AttachedFile::setTimeParam($product['product_updated_on']);
        $data['products'][$key]['product_image_url'] = UrlHelper::getCachedUrl(UrlHelper::generateFullUrl('image', 'product', array($product['product_id'], 'PRODUCT_LAYOUT_4', $product['selprod_id'], 0, $siteLangId)) . $uploadedTime, CONF_IMG_CACHE_TIME, '.jpg');
    }
    $data['products'] = array_values($data['products']);

}

if (empty($data)) {
    $status = applicationConstants::OFF;
}
unset($data['searchForm']);

$data['desktop_url'] = "";
$data['tablet_url'] = "";
$data['mobile_url'] = "";
$brandImgArr = AttachedFile::getMultipleAttachments(AttachedFile::FILETYPE_BRAND_IMAGE, $data['recordId'], 0, $siteLangId);
if (!empty($brandImgArr)) {
    foreach ($brandImgArr as $slideScreen) {
        $uploadedTime = AttachedFile::setTimeParam($slideScreen['afile_updated_at']);
        
        switch ($slideScreen['afile_screen']) {
            case applicationConstants::SCREEN_MOBILE:
                $fileRow = CommonHelper::getImageAttributes(AttachedFile::FILETYPE_BRAND_IMAGE, $data['recordId'], 0, 0, applicationConstants::SCREEN_MOBILE);
                $mobile_url = UrlHelper::getCachedUrl(UrlHelper::generateFullUrl('Image', 'BrandImage', array($data['recordId'], $siteLangId, 'MOBILE', 0, applicationConstants::SCREEN_MOBILE)) . $uploadedTime, CONF_IMG_CACHE_TIME, '.jpg') . ",";
                $data['mobile_url'] = $mobile_url;
                break;
            case applicationConstants::SCREEN_IPAD:
                $fileRow = CommonHelper::getImageAttributes(AttachedFile::FILETYPE_BRAND_IMAGE, $data['recordId'], 0, 0, applicationConstants::SCREEN_IPAD);
                $tablet_url = UrlHelper::getCachedUrl(UrlHelper::generateFullUrl('Image', 'BrandImage', array($data['recordId'], $siteLangId, 'TABLET', 0, applicationConstants::SCREEN_IPAD)) . $uploadedTime, CONF_IMG_CACHE_TIME, '.jpg') . ",";
                $data['tablet_url'] = $tablet_url;
                break;
            case applicationConstants::SCREEN_DESKTOP:
                $fileRow = CommonHelper::getImageAttributes(AttachedFile::FILETYPE_BRAND_IMAGE, $data['recordId'], 0, 0, applicationConstants::SCREEN_DESKTOP);
                $desktop_url = UrlHelper::getCachedUrl(UrlHelper::generateFullUrl('Image', 'BrandImage', array($data['recordId'], $siteLangId, 'DESKTOP', 0, applicationConstants::SCREEN_DESKTOP)) . $uploadedTime, CONF_IMG_CACHE_TIME, '.jpg') . ",";
                $data['desktop_url'] = $desktop_url;
                break;
        }
    }
}

$data['brand_logo'] = "";
$fileData = AttachedFile::getAttachment(AttachedFile::FILETYPE_BRAND_LOGO, $data['recordId'], 0, 0, false);
if ($fileData['afile_id'] > 0) {
    $data['brand_logo'] = UrlHelper::getCachedUrl(UrlHelper::generateFullUrl('image', 'brand', array($data['recordId'], $siteLangId, 'COLLECTION_PAGE')), CONF_IMG_CACHE_TIME, '.jpg');
}