<?php defined('SYSTEM_INIT') or die('Invalid Usage.');

$data = array(
    'personalInfo' => (object)$personalInfo,
    'bankInfo' => (object)$bankInfo,
    'privacyPolicyLink' => UrlHelper::generateFullUrl('cms', 'view', array($privacyPolicyLink)),
    'faqLink' => UrlHelper::generateFullUrl('custom', 'faq'),
    'referralModuleIsEnabled' => FatApp::getConfig("CONF_ENABLE_REFERRER_MODULE", FatUtility::VAR_INT, 0),
    'hasDigitalProducts' => $hasDigitalProducts,
    'splitPaymentMethods' => array_values($splitPaymentMethods),
);

$data['gdprRequests'] = [];
if (!empty($gdprRequest) && $gdprRequest['ureq_status'] == UserGdprRequest::STATUS_COMPLETE) {
    $data['gdprRequests'] = [
        [
            'label' => Labels::getLabel('LBL_GDPR_Requests', $siteLangId),
            'downloadUrl' => UrlHelper::generateFullFileUrl('GdprRequests', 'downloadRequestData', [UserGdprRequest::REQUEST_TYPE_GDPR_REQUEST], '/app-api/'.MOBILE_APP_API_VERSION.'/')
        ],
        [
            'label' => Labels::getLabel('LBL_Personal_Information', $siteLangId),
            'downloadUrl' => UrlHelper::generateFullFileUrl('GdprRequests', 'downloadRequestData', [UserGdprRequest::REQUEST_TYPE_PERSONAL_INFO], '/app-api/'.MOBILE_APP_API_VERSION.'/'),
        ]
    ];

    if (User::isSeller()) { 
        $data['gdprRequests'] = array_merge($data['gdprRequests'], [
            [
                'label' => Labels::getLabel('LBL_Shop_Information', $siteLangId),
                'downloadUrl' => UrlHelper::generateFullFileUrl('GdprRequests', 'downloadRequestData', [UserGdprRequest::REQUEST_TYPE_SHOP_INFO], '/app-api/'.MOBILE_APP_API_VERSION.'/'),
            ],
            [
                'label' => Labels::getLabel('LBL_Social_Platform_Details', $siteLangId),
                'downloadUrl' => UrlHelper::generateFullFileUrl('GdprRequests', 'downloadRequestData', [UserGdprRequest::REQUEST_TYPE_SOCIAL_PLATFORM], '/app-api/'.MOBILE_APP_API_VERSION.'/'),
            ],
            [
                'label' => Labels::getLabel('LBL_Pickup_Address', $siteLangId),
                'downloadUrl' => UrlHelper::generateFullFileUrl('GdprRequests', 'downloadRequestData', [UserGdprRequest::REQUEST_TYPE_PICKUP_ADDRESS], '/app-api/'.MOBILE_APP_API_VERSION.'/'),
            ], 
            [
                'label' => Labels::getLabel('LBL_Sales', $siteLangId),
                'downloadUrl' => UrlHelper::generateFullFileUrl('GdprRequests', 'downloadRequestData', [UserGdprRequest::REQUEST_TYPE_SALES], '/app-api/'.MOBILE_APP_API_VERSION.'/'),
            ]
        ]);
    }

    if (User::isBuyer()) {
        $data['gdprRequests'] = array_merge($data['gdprRequests'], [
            [
                'label' => Labels::getLabel('LBL_Purchase', $siteLangId),
                'downloadUrl' => UrlHelper::generateFullFileUrl('GdprRequests', 'downloadRequestData', [UserGdprRequest::REQUEST_TYPE_PURCHASE], '/app-api/'.MOBILE_APP_API_VERSION.'/'),
            ]
        ]);
    }

}

if (empty((array)$personalInfo) && empty((array)$bankInfo)) {
    $status = applicationConstants::OFF;
}
