<?php

class OrderPayController extends MyAppController
{
    private $order_id = null;
    public function __construct($action)
    {
        parent::__construct($action);
        $this->set('exculdeMainHeaderDiv', true);
    }


    public function Recharge($orderId)
    {
        $this->order_id = $orderId;
        $isAjaxCall = FatUtility::isAjaxCall();

        if (!UserAuthentication::isUserLogged()) {
            $message = Labels::getLabel('MSG_Your_Session_seems_to_be_expired', $this->siteLangId);
            if (true === MOBILE_APP_API_CALL) {
                LibHelper::dieJsonError($message);
            }
            Message::addErrorMessage($message);
            if ($isAjaxCall) {
                FatUtility::dieWithError(Message::getHtml());
            }
            CommonHelper::redirectUserReferer();
        }

        if ($orderId == '' || ((isset($_SESSION['wallet_recharge_cart']) && !empty($_SESSION['wallet_recharge_cart']) && $orderId != $_SESSION['wallet_recharge_cart']["order_id"]))) {
            $message = Labels::getLabel('MSG_Invalid_Access', $this->siteLangId);
            if (true === MOBILE_APP_API_CALL) {
                LibHelper::dieJsonError($message);
            }
            Message::addErrorMessage($message);
            FatUtility::dieWithError(Message::getHtml());
        }

        $loggedUserId = UserAuthentication::getLoggedUserId();
        $srch = Orders::getSearchObject();
        $srch->doNotCalculateRecords();
        $srch->doNotLimitRecords();
        $srch->addCondition('order_id', '=', $orderId);
        $srch->addCondition('order_user_id', '=', $loggedUserId);
        $srch->addCondition('order_payment_status', '=', Orders::ORDER_PAYMENT_PENDING);
        $srch->addCondition('order_type', '=', Orders::ORDER_WALLET_RECHARGE);
        $rs = $srch->getResultSet();
        $orderInfo = FatApp::getDb()->fetch($rs);

        if (!$orderInfo) {
            $message = Labels::getLabel('MSG_Invalid_Access', $this->siteLangId);
            if (true === MOBILE_APP_API_CALL) {
                LibHelper::dieJsonError($message);
            }
            Message::addErrorMessage($message);
            if ($isAjaxCall) {
                FatUtility::dieWithError(Message::getHtml());
            }
            CommonHelper::redirectUserReferer();
        }

        $ordeCartData = json_decode($orderInfo['order_cart_data'], true);
        if (empty($ordeCartData['order_id']) || empty($ordeCartData['op_id'])) {
            $message = Labels::getLabel('MSG_Invalid_Access', $this->siteLangId);
            if (true === MOBILE_APP_API_CALL) {
                LibHelper::dieJsonError($message);
            }
            Message::addErrorMessage($message);
            if ($isAjaxCall) {
                FatUtility::dieWithError(Message::getHtml());
            }
            CommonHelper::redirectUserReferer();
        }

        $srch = new OrderProductSearch($this->siteLangId, true, true);
        $srch->doNotCalculateRecords();
        $srch->doNotLimitRecords();

        $srch->addCondition('order_id', '=', $ordeCartData['order_id']);
        $srch->addCondition('op_id', '=', $ordeCartData['op_id']);

        $srch->addCondition('order_user_id', '=', $loggedUserId);
        $srch->addCondition('order_payment_status', '=', Orders::ORDER_PAYMENT_PAID);
        $srch->addCondition('order_is_full_paid', '=', applicationConstants::NO);
        $srch->addCondition('order_type', '=', Orders::ORDER_PRODUCT);

        $rs = $srch->getResultSet();
        $pendingOrderInfo = FatApp::getDb()->fetch($rs);
        if (!$pendingOrderInfo) {
            $message = Labels::getLabel('MSG_Invalid_Access', $this->siteLangId);
            if (true === MOBILE_APP_API_CALL) {
                LibHelper::dieJsonError($message);
            }
            Message::addErrorMessage($message);
            if ($isAjaxCall) {
                FatUtility::dieWithError(Message::getHtml());
            }
            CommonHelper::redirectUserReferer();
        }

        $this->set('orderInfo', $orderInfo);
        $obj = new Extrapage();
        $headerData = $obj->getContentByPageType(Extrapage::CHECKOUT_PAGE_HEADER_BLOCK, $this->siteLangId);
        $pmSrch = PaymentMethods::getSearchObject($this->siteLangId);
        $pmSrch->doNotCalculateRecords();
        $pmSrch->doNotLimitRecords();
        $pmSrch->addMultipleFields(Plugin::ATTRS);
        $pmRs = $pmSrch->getResultSet();
        $paymentMethods = FatApp::getDb()->fetchAll($pmRs);
        $excludePaymentGatewaysArr = applicationConstants::getExcludePaymentGatewayArr();


        $userWalletBalance = User::getUserBalance($loggedUserId);
        $WalletPaymentForm = $this->getWalletPaymentForm($this->siteLangId);
        $cartSummary = $this->getOrderDetails($orderId)['cart_summary'];

        if ($userWalletBalance >= $orderInfo['order_net_amount'] && isset($cartSummary['cartWalletSelected']) && $cartSummary['cartWalletSelected']) {
            $WalletPaymentForm->addFormTagAttribute('action', UrlHelper::generateUrl('WalletPay', 'Charge', array($orderId)));
            $WalletPaymentForm->fill(array('order_id' => $orderId));
            $WalletPaymentForm->setFormTagAttribute('onsubmit', 'confirmOrder(this); return(false);');
            $WalletPaymentForm->addSubmitButton('', 'btn_submit', Labels::getLabel('LBL_Pay_Now', $this->siteLangId));
        }

        $this->set('cartSummary', $cartSummary);
        $this->set('canUseWalletForPayment', PaymentMethods::canUseWalletForPayment());
        $this->set('userWalletBalance', $userWalletBalance);
        $this->set('WalletPaymentForm', $WalletPaymentForm);

        $this->set('paymentMethods', $paymentMethods);
        $this->set('excludePaymentGatewaysArr', $excludePaymentGatewaysArr);
        $this->set('headerData', $headerData);

        if (true === MOBILE_APP_API_CALL) {
            $this->_template->render();
        }
        $this->_template->render(true, true);
    }

    public function walletSelection()
    {

        $payFromWallet = FatApp::getPostedData('payFromWallet', FatUtility::VAR_INT, 0);
        $loggedUserId = UserAuthentication::getLoggedUserId();
        $userWalletBalance = User::getUserBalance($loggedUserId, true);
        $orderInfo = $this->getOrderDetails($_SESSION['wallet_recharge_cart']['order_id']);
        $payFromWallet = FatApp::getPostedData('payFromWallet', Fatutility::VAR_INT, 0);
        $orderObj = new Orders();
        $walletSelectedAmount = 0;
        if ($payFromWallet == 1 && $userWalletBalance) {
            $walletSelectedAmount = min($userWalletBalance, $orderInfo['order_net_amount']);
        }
        $orderObj->updateOrderInfo($orderInfo['order_id'], array('order_is_wallet_selected' => $payFromWallet, 'order_wallet_amount_charge' => $walletSelectedAmount));
        $this->_template->render(false, false, 'json-success.php');
    }


    private function getOrderDetails(string $orderId): array
    {
        $loggedUserId = UserAuthentication::getLoggedUserId();
        $srch = Orders::getSearchObject();
        $srch->doNotCalculateRecords();
        $srch->doNotLimitRecords();
        $srch->addCondition('order_id', '=', $orderId);
        $srch->addCondition('order_user_id', '=', $loggedUserId);
        $srch->addCondition('order_payment_status', '=', Orders::ORDER_PAYMENT_PENDING);
        $srch->addCondition('order_type', '=', Orders::ORDER_WALLET_RECHARGE);
        $rs = $srch->getResultSet();
        $orderDetail = FatApp::getDb()->fetch($rs);
        $rs = $srch->getResultSet();
        $orderDetail = FatApp::getDb()->fetch($rs);
        if (empty($orderDetail)) {
            return [];
        }
        $isWalletSelected = $orderDetail['order_is_wallet_selected'];
        $walletCharges = $orderDetail['order_wallet_amount_charge'];

        $orderObj = new Orders();
        $cartSummary = array(
            'cartTotal' => $orderDetail['order_net_amount'],
            'shippingTotal' => 0,
            'originalShipping' => 0,
            'cartTaxTotal' => 0,
            'cartDiscounts' => 0,
            'cartVolumeDiscount' => 0,
            'cartRewardPoints' => 0,
            'cartWalletSelected' => $isWalletSelected,
            'siteCommission' => $orderDetail['order_site_commission'],
            'orderNetAmount' => $orderDetail['order_net_amount'],
            'WalletAmountCharge' => $walletCharges,
            'isCodEnabled' => 0,
            'isCodValidForNetAmt' => 0,
            'orderPaymentGatewayCharges' => $orderDetail['order_net_amount'] - $walletCharges,
            'netChargeAmount' => $orderDetail['order_net_amount'] - $walletCharges,
            'taxOptions' => 0,
            'prodTaxOptions' => 0,
            'roundingOff' => 0,
            'total_paid_amount' => $orderObj->getOrderPaymentPaid($orderId),
            'total_amount' => $orderDetail['order_net_amount'],
            'total_security' => 0,
        );
        $orderDetail['cart_summary'] = $cartSummary;
        return $orderDetail;
    }

    private function getWalletPaymentForm($langId)
    {
        $frm = new Form('frmWalletPayment');
        $frm->addHiddenField('', 'order_id');
        $frm->addHiddenField('', 'order_type', Orders::ORDER_WALLET_RECHARGE);

        return $frm;
    }

    private function getPaymentTabForm($langId, $paymentMethodCode = '')
    {
        $frm = new Form('frmPaymentTabForm');
        $frm->setFormTagAttribute('id', 'frmPaymentTabForm');

        if (in_array(strtolower($paymentMethodCode), ['cashondelivery', 'payatstore'])) {
            CommonHelper::addCaptchaField($frm);
        }
        $frm->addSubmitButton('', 'btn_submit', Labels::getLabel('LBL_Confirm_Payment', $langId));
        $frm->addHiddenField('', 'order_type');
        $frm->addHiddenField('', 'order_id');
        $frm->addHiddenField('', 'plugin_id');
        return $frm;
    }

}
