<?php

class LoggedUserController extends MyAppController
{
    public $userParentId = 0;
    public $userId = 0;
    public $userPrivilege = 0;
	
    public function __construct($action)
    {
        parent::__construct($action);

        UserAuthentication::checkLogin();
        $this->userId = UserAuthentication::getLoggedUserId();
        $userObj = new User($this->userId);
        $userInfo = $userObj->getUserInfo(array(), false, false);
        $isLoginByAdmin = (isset($_SESSION[User::ADMIN_SESSION_ELEMENT_NAME]) && !empty($_SESSION[User::ADMIN_SESSION_ELEMENT_NAME]));
        if (false == $userInfo || (!UserAuthentication::isGuestUserLogged() && ($userInfo['credential_active'] != applicationConstants::ACTIVE) && !$isLoginByAdmin  )) {
            if (FatUtility::isAjaxCall()) {
                Message::addErrorMessage(Labels::getLabel('MSG_Session_seems_to_be_expired', CommonHelper::getLangId()));
                FatUtility::dieWithError(Message::getHtml());
            }

            FatApp::redirectUser(UrlHelper::generateUrl('GuestUser', 'logout'));
        }

        if (isset($userInfo['credential_active']) && $userInfo['credential_active'] == 0 && !UserAuthentication::isGuestUserLogged()) {
            if (FatUtility::isAjaxCall()) {
                Message::addErrorMessage(Labels::getLabel('MSG_Session_seems_to_be_expired', CommonHelper::getLangId()));
                FatUtility::dieWithError(Message::getHtml());
            }
            FatApp::redirectUser(UrlHelper::generateUrl('GuestUser', 'logout'));
        }

        if (0 < $userInfo['user_parent']) {
            $parentUser = new User($userInfo['user_parent']);
            $parentUserInfo = $parentUser->getUserInfo(array(), true, true);
            if (false == $parentUserInfo || ($parentUserInfo['credential_active'] != applicationConstants::ACTIVE && !$isLoginByAdmin)) {
                if (FatUtility::isAjaxCall()) {
                    Message::addErrorMessage(Labels::getLabel('MSG_Session_seems_to_be_expired', CommonHelper::getLangId()));
                    FatUtility::dieWithError(Message::getHtml());
                }
                FatApp::redirectUser(UrlHelper::generateUrl('GuestUser', 'logout'));
            }
        }

        if (!isset($_SESSION[UserAuthentication::SESSION_ELEMENT_NAME]['activeTab'])) {
            $userPreferedDashboardType = ($userInfo['user_preferred_dashboard']) ? $userInfo['user_preferred_dashboard'] : $userInfo['user_registered_initially_for'];

            switch ($userPreferedDashboardType) {
                case User::USER_TYPE_BUYER:
                    $_SESSION[UserAuthentication::SESSION_ELEMENT_NAME]['activeTab'] = 'B';
                    break;
                case User::USER_TYPE_SELLER:
                    $_SESSION[UserAuthentication::SESSION_ELEMENT_NAME]['activeTab'] = 'S';
                    break;
                case User::USER_TYPE_AFFILIATE:
                    $_SESSION[UserAuthentication::SESSION_ELEMENT_NAME]['activeTab'] = 'AFFILIATE';
                    break;
                case User::USER_TYPE_ADVERTISER:
                    $_SESSION[UserAuthentication::SESSION_ELEMENT_NAME]['activeTab'] = 'Ad';
                    break;
            }
        }

        if ((!UserAuthentication::isGuestUserLogged() && $userInfo['credential_verified'] != 1) && !($_SESSION[User::ADMIN_SESSION_ELEMENT_NAME] && $_SESSION[User::ADMIN_SESSION_ELEMENT_NAME] > 0)) {
            FatApp::redirectUser(UrlHelper::generateUrl('GuestUser', 'logout'));
        }

        if ($this->userId < 1) {
            FatApp::redirectUser(UrlHelper::generateUrl('GuestUser', 'logout'));
        }

        /* Thease actions are used while configuring Phone from "Configure Email/Phone Page". */
        $allowedActions = ['getotp', 'resendotp', 'validateotp'];
        $addPhoneValidaion = true;
        if (true == SmsArchive::canSendSms()) {
            $addPhoneValidaion = empty($userInfo['user_phone']) ? true : false;
        }
        if (!in_array(strtolower($action), $allowedActions) && empty($userInfo['user_phone']) && empty($userInfo['credential_email'])) {
            if (true == SmsArchive::canSendSms()) {
                $message = Labels::getLabel('MSG_PLEASE_CONFIGURE_YOUR_EMAIL_OR_PHONE', $this->siteLangId);
            } else {
                $message = Labels::getLabel('MSG_PLEASE_CONFIGURE_YOUR_EMAIL', $this->siteLangId);
            }

            if (true === MOBILE_APP_API_CALL) {
                LibHelper::dieJsonError($message);
            }
            Message::addErrorMessage($message);
            FatApp::redirectUser(UrlHelper::generateUrl('GuestUser', 'configureEmail'));
        }

        $this->userParentId = (0 < $userInfo['user_parent']) ? $userInfo['user_parent'] : UserAuthentication::getLoggedUserId();

        $this->initCommonValues();
    }

    private function initCommonValues()
    {
        $this->set('isUserDashboard', true);
        $this->userPrivilege = UserPrivilege::getInstance();
        $this->set('userPrivilege', $this->userPrivilege);
    }

    protected function getOrderCancellationRequestsSearchForm($langId, int $orderType = applicationConstants::ORDER_TYPE_SALE)
    {
        $frm = new Form('frmOrderCancellationRequest');
        $frm->addTextBox(Labels::getLabel('LBL_Search_By_(Order_Id/Invoice_Number)', $langId), 'op_invoice_number');
        $frm->addSelectBox(Labels::getLabel('LBL_Status', $langId), 'ocrequest_status', array('-1' => Labels::getLabel('LBL_Status_Does_Not_Matter', $langId)) + OrderCancelRequest::getRequestStatusArr($langId), '', array(), '');
        $frm->addDateField(Labels::getLabel('LBL_Date_From', $langId), 'ocrequest_date_from', '', array('readonly' => 'readonly', 'class' => 'field--calender'));
        $frm->addDateField(Labels::getLabel('LBL_Date_To', $langId), 'ocrequest_date_to', '', array('readonly' => 'readonly', 'class' => 'field--calender'));

        $fldSubmit = $frm->addSubmitButton('', 'btn_submit', Labels::getLabel('LBL_Search', $langId));
        $fldCancel = $frm->addButton("", "btn_clear", Labels::getLabel("LBL_Clear", $langId), array('onclick' => 'clearOrderCancelRequestSearch();'));
        $frm->addHiddenField('', 'page');
        $frm->addHiddenField('', 'order_product_type', $orderType);
        return $frm;
    }

    protected function getOrderReturnRequestsSearchForm(int $langId, int $orderFor = applicationConstants::ORDER_TYPE_SALE)
    {
        $frm = new Form('frmOrderReturnRequest');
        $frm->addTextBox(Labels::getLabel('LBL_Keyword', $langId), 'keyword');
        $frm->addSelectBox(Labels::getLabel('LBL_Status', $langId), 'orrequest_status', array('-1' => Labels::getLabel('LBL_Status_Does_Not_Matter', $langId)) + OrderReturnRequest::getRequestStatusArr($langId), '', array(), '');
        $returnRquestArray = OrderReturnRequest::getRequestTypeArr($langId);
        if (count($returnRquestArray) > applicationConstants::YES) {
            $frm->addSelectBox(Labels::getLabel('LBL_Request_Type', $langId), 'orrequest_type', array('-1' => Labels::getLabel('LBL_Request_Type_Does_Not_Matter', $langId)) + $returnRquestArray, '', array(), '');
        } else {
            $frm->addHiddenField('', 'orrequest_type', '-1');
        }
        $frm->addDateField(Labels::getLabel('LBL_Date_From', $langId), 'orrequest_date_from', '', array('readonly' => 'readonly', 'class' => 'field--calender'));
        $frm->addDateField(Labels::getLabel('LBL_Date_To', $langId), 'orrequest_date_to', '', array('readonly' => 'readonly', 'class' => 'field--calender'));
        $fldSubmit = $frm->addSubmitButton('', 'btn_submit', Labels::getLabel('LBL_Search', $langId));
        $fldCancel = $frm->addButton("", "btn_clear", Labels::getLabel("LBL_Clear", $langId), array('onclick' => 'clearOrderReturnRequestSearch();'));
        $frm->addHiddenField('', 'page');
        $frm->addHiddenField('', 'order_product_for', $orderFor);
        return $frm;
    }

    protected function getOrderReturnRequestMessageSearchForm($langId)
    {
        $frm = new Form('frmOrderReturnRequestMsgsSrch');
        $frm->addHiddenField('', 'page');
        $frm->addHiddenField('', 'orrequest_id');
        return $frm;
    }

    protected function getOrderReturnRequestMessageForm($langId)
    {
        $frm = new Form('frmOrderReturnRequestMessge');
        $frm->setRequiredStarPosition('');
        $fld = $frm->addTextArea('', 'orrmsg_msg');
        $fld->requirements()->setRequired();
        $fld->requirements()->setCustomErrorMessage(Labels::getLabel('MSG_Message_is_mandatory', $langId));
        $frm->addHiddenField('', 'orrmsg_orrequest_id');
        $frm->addSubmitButton('', 'btn_submit', Labels::getLabel('LBL_Submit', $langId));
        return $frm;
    }
}
