<?php defined('SYSTEM_INIT') or die('Invalid Usage.');?>
<div class="table-responsive table-scrollable js-scrollable tablewrap">
<?php
$arr_flds = array(
    'listserial' => Labels::getLabel('LBL_#', $adminLangId),
    'vflds_identifier' => Labels::getLabel('LBL_Field_Identifier', $adminLangId),
    'vflds_type' => Labels::getLabel('LBL_Field_Type', $adminLangId),
    'vflds_required' => Labels::getLabel('LBL_IS_REQUIRED', $adminLangId),
    'vflds_active' => Labels::getLabel('LBL_Active', $adminLangId),
    'action' => Labels::getLabel('LBL_Action(s)', $adminLangId),
);
if (!$canEdit) {
    unset($arr_flds['select_all']);
}
$tbl = new HtmlElement('table', array('width' => '100%', 'class' => 'table table-hovered  table-justified'));
$th = $tbl->appendElement('thead')->appendElement('tr');
foreach ($arr_flds as $key => $val) {
    if ('select_all' == $key) {
        $th->appendElement('th')->appendElement('plaintext', array(), '<label class="checkbox"><input title="' . $val . '" type="checkbox" onclick="selectAll( $(this) )" class="selectAll-js"></label>', true);
    } else {
        $e = $th->appendElement('th', array(), $val);
    }
}

$sr_no = 0;
foreach ($listing as $sn => $row) {
    $sr_no++;
    $tr = $tbl->appendElement('tr', array());
    $tr->setAttribute("id", $row['vflds_id']);

    foreach ($arr_flds as $key => $val) {
        $td = $tr->appendElement('td');
        switch ($key) {
            case 'listserial':
                $td->appendElement('plaintext', array(), $sr_no);
                break;
            case 'vflds_identifier':
                if (empty($row['vflds_name'])) {
                    $td->appendElement('plaintext', array(), $row['vflds_name'], true);
                    $td->appendElement('br', array());
                    $td->appendElement('plaintext', array(), '(' . $row[$key] . ')', true);
                } else {
                    $td->appendElement('plaintext', array(), $row[$key], true);
                }
                break;
            case 'vflds_type':
                $fldsTypeArr = VerificationFields::getFldTypeArr($adminLangId);
                $str = isset($row[$key]) ? $fldsTypeArr[$row[$key]] : '';
                $td->appendElement('plaintext', array(), $str, true);
                break;
            case 'vflds_required':
                $yesNoArr = applicationConstants::getYesNoArr($adminLangId);
                $str = isset($row[$key]) ? $yesNoArr[$row[$key]] : '';
                $td->appendElement('plaintext', array(), $str, true);
                break;
            case 'vflds_active':
                $active = "";
                if ($row['vflds_active']) {
                    $active = 'checked';
                }

                $statusAct = ($canEdit === true) ? 'toggleStatus(event,this,' . applicationConstants::YES . ')' : 'toggleStatus(event,this,' . applicationConstants::NO . ')';
                $statusClass = ($canEdit === false) ? 'disabled' : '';
                $str = '<label class="switch switch-sm switch-icon ' . $statusClass . '">
                     <input ' . $active . ' type="checkbox" id="switch' . $row['vflds_id'] . '" value="' . $row['vflds_id'] . '" onclick="' . $statusAct . '" class="switch-labels"/>
                                      	</label>';
                $td->appendElement('plaintext', array(), $str, true);

                break;
            case 'action':
                if ($canEdit) {
                    $actionArr = [
                        [
                            "title" => Labels::getLabel('LBL_Edit', $adminLangId),
                            "icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#edit'></use></svg>",
                            "onclick" => "addFieldForm(" . $row['vflds_id'] . ")"
                        ]
                    ];
                    $this->includeTemplate('_partial/actions.php', ['actionArr' => $actionArr, 'td' => $td, 'adminLangId' => $adminLangId,'id'=>$row['vflds_id']], false);
                }
                break;
            default:
                $td->appendElement('plaintext', array(), $row[$key], true);
                break;
        }
    }
}


echo $tbl->getHtml();
if (count($listing) == 0) {
    $this->includeTemplate('_partial/no-record-found.php', array('adminLangId' => $adminLangId));
}
?>
</div>