<?php defined('SYSTEM_INIT') or die('Invalid Usage.');
$formType = 'table';
$formTitle = Labels::getLabel('LBL_User_Details', $adminLangId);
require_once(CONF_THEME_PATH . 'default/_partial/bootstrap-model/header.php');

?>
<section class="card section">
    <div class="card-body extra">
        <div class="form-section">
            <form class="form web_form form_horizontal">
                <div class="row">
                    <div class="col-md-12">
                        <h3 class="h3"><i class="ion-person icon"></i>
                            <?php echo Labels::getLabel('LBL_Profile_Information', $adminLangId); ?></h3>
                    </div>
                </div>
                <div class="rowbody">
                    <div class="listview">
                        <dl class="list">
                            <dt><?php echo Labels::getLabel('LBL_Full_Name', $adminLangId); ?></dt>
                            <dd><?php echo "<a href='javascript:void(0)' onclick='redirectfunc(\"" . UrlHelper::generateUrl('Users') . "\", " . $supplierRequest['user_id'] . ")'>" . $supplierRequest['user_name'] . "</a>"; ?>
                            </dd>
                        </dl>
                        <dl class="list">
                            <dt><?php echo Labels::getLabel('LBL_Email', $adminLangId); ?></dt>
                            <dd><?php echo $supplierRequest['credential_email']; ?></dd>
                        </dl>
                        <dl class="list">
                            <dt><?php echo Labels::getLabel('LBL_Username', $adminLangId); ?></dt>
                            <dd><?php echo $supplierRequest['credential_username']; ?></dd>
                        </dl>
                    </div>
                </div>
            </form>
        </div>
        <div class="form-section">
            <form class="form web_form form_horizontal">
                <div class="row">
                    <div class="col-md-12">
                        <h3 class="h3"><i class="ion-person icon"></i>
                            <?php echo Labels::getLabel('LBL_Additional_Information', $adminLangId); ?></h3>
                    </div>
                </div>
                <div class="rowbody">
                    <div class="listview">
                        <dl class="list">
                            <dt><?php echo Labels::getLabel('LBL_Reference_Number', $adminLangId); ?></dt>
                            <dd><?php echo $supplierRequest['usuprequest_reference']; ?></dd>
                        </dl>
                        <dl class="list">
                            <dt><?php echo Labels::getLabel('LBL_Status', $adminLangId); ?></dt>
                            <dd><?php echo $reqStatusArr[$supplierRequest['usuprequest_status']]; ?></dd>
                        </dl>
                        <?php if ($supplierRequest['usuprequest_comments'] != '') { ?>
                        <dl class="list">
                            <dt><?php echo Labels::getLabel('LBL_Comments/Reason', $adminLangId); ?></dt>
                            <dd><?php echo nl2br($supplierRequest['usuprequest_comments']); ?></dd>
                        </dl>
                        <?php } ?>
                    </div>
                </div>
            </form>
        </div>
        <div class="form-section">
            <form class="form web_form form_horizontal">
                <div class="row">
                    <div class="col-md-12">
                        <h3 class="h3"><i class="ion-person icon"></i>
                            <?php echo Labels::getLabel('LBL_Seller_Information', $adminLangId); ?></h3>
                    </div>
                </div>
                <div class="rowbody">
                    <div class="listview">
                        <?php foreach ($supplierRequest['field_values'] as $val) { ?>
                        <dl class="list">
                            <dt><?php
								if ($val['sformfield_caption'] != '') {
									echo $val['sformfield_caption'];
								} else {
									echo $val['sformfield_identifier'];
								} ?>
                            </dt>
                            <dd><?php if ($val['afile_physical_path'] != '') {
									echo "<a href='" . UrlHelper::generateUrl('Users', 'downloadAttachment', array($supplierRequest['user_id'], $val['sfreqvalue_formfield_id'])) . "'>" . $val['sfreqvalue_text'] . "</a>";
								} else {
									if ($val['sformfield_type'] == User::USER_FIELD_TYPE_PHONE) {
										echo filter_var($val['sfreqvalue_text'], FILTER_SANITIZE_NUMBER_INT);
									} else {
										echo nl2br($val['sfreqvalue_text']);
									}
								}
								?></dd>
                        </dl>
                        <?php } ?>
                    </div>
                </div>
            </form>
        </div>
    </div>

</section>