<?php defined('SYSTEM_INIT') or die('Invalid Usage.');

$recordId = (int) $user_id;

$tabsButtons = [
    [
        'attr' => [
            'onclick' => 'userForm(' . $recordId . ')',
            'title' => Labels::getLabel('LBL_General', $adminLangId),
        ],
        'label' => Labels::getLabel('LBL_General', $adminLangId),
        'isActive' => false
    ],
    [
        'attr' => [
            'onclick' => 'addBankInfoForm(' . $recordId . ')',
            'title' => Labels::getLabel('LBL_Bank_Info', $adminLangId),
        ],
        'label' => Labels::getLabel('LBL_Bank_Info', $adminLangId),
        'isActive' => false
    ],
    [
        'attr' => [
            'onclick' => 'addUserAddress(' . $recordId . ')',
            'title' => Labels::getLabel('LBL_Addresses', $adminLangId),
        ],
        'label' => Labels::getLabel('LBL_Addresses', $adminLangId),
        'isActive' => true,
        'isPrimary' => true
    ],
];

$formTitle = Labels::getLabel('LBL_User_Addresses', $adminLangId);
$formType = 'table';
require_once(CONF_THEME_PATH . 'default/_partial/bootstrap-model/header.php');
?>
<section class="card section">
    <div class="need-remove">
        <div class="tabs_panel_wrap">
            <div class="card-head" style=" padding-bottom:20px">
                <h4><?php echo Labels::getLabel('LBL_Address_Listing', $adminLangId); ?></h4>
                <a href="javascript:void(0)" class="themebtn btn-default btn btn-brand btn-sm"
                    onClick="addOneAddress(<?php echo $user_id ?>,0)"><?php echo Labels::getLabel('LBL_Add_New', $adminLangId); ?></a>
            </div>
            <div class="tabs_panel">
                <?php
                $arr_flds = array(
                    'listserial' => Labels::getLabel('LBL_#', $adminLangId),
                    'addr_title' => Labels::getLabel('LBL_Identifier', $adminLangId),
                    'user_address' => Labels::getLabel('LBL_Address', $adminLangId),
                    'addr_is_default' => Labels::getLabel('LBL_Default', $adminLangId),
                    'action' => Labels::getLabel('LBL_Action(s)', $adminLangId),
                );
                $tbl = new HtmlElement('table', array('width' => '100%', 'class' => 'table table-hovered table-justified'));
                $th = $tbl->appendElement('thead')->appendElement('tr');
                foreach ($arr_flds as $key => $val) {
                    $e = $th->appendElement('th', array(), $val, true);
                }
                $sr_no = 0;
                foreach ($addresses as $sn => $row) {
                    $sr_no++;
                    $tr = $tbl->appendElement('tr');

                    foreach ($arr_flds as $key => $val) {
                        $td = $tr->appendElement('td');
                        switch ($key) {
                            case 'listserial':
                                $td->appendElement('plaintext', array(), $sr_no);
                                break;
                            case 'user_address':
                                $address = $row['addr_name'] . '<br>';
                                $address .= $row['addr_address1'];
                                $address .= (!empty($row['add_address2'])) ? ',' . $row['addr_address2'] . '<br>' : '<br>';
                                $address .= (!empty($row['addr_city'])) ? $row['addr_city'] . ',' : '';
                                $address .= (!empty($row['state_name'])) ? $row['state_name'] . '<br>' : '';
                                $address .= (!empty($row['country_name'])) ? $row['country_name'] . '<br>' : '';
                                $address .= (!empty($row['addr_zip'])) ? Labels::getLabel('LBL_Postal_Code', $adminLangId) . ': ' . $row['addr_zip'] . '<br>' : '';
                                $address .= (!empty($row['addr_phone'])) ? Labels::getLabel('LBL_Phone', $adminLangId) . ': ' . $row['addr_dial_code'] . ' ' . $row['addr_phone'] . '<br>' : '';

                                $td->appendElement('plaintext', array(), $address, true);
                                break;
                            case 'addr_is_default':
                                $str = ($row['addr_is_default'] == 1) ? Labels::getLabel('LBL_Yes', $adminLangId) : Labels::getLabel('LBL_No', $adminLangId);
                                $td->appendElement('plaintext', array(), $str, true);
                                break;
                            case 'action':
                                if ($canEdit) {
                                    $actionArr = [
                                        [
                                            "title" => Labels::getLabel('LBL_Edit', $adminLangId),
                                            "icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#edit'></use></svg>",
                                            "onclick" => "addOneAddress(" . $row['addr_record_id'] . "," . $row['addr_id'] . ")"
                                        ],
                                        [
                                            "title" => Labels::getLabel('LBL_Delete', $adminLangId),
                                            "icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#delete'></use></svg>",
                                            "onclick" => "deleteAddress(" . $row['addr_record_id'] . "," . $row['addr_id'] . ")"
                                        ]
                                    ];
                                    $this->includeTemplate('_partial/actions.php', ['actionArr' => $actionArr, 'td' => $td, 'adminLangId' => $adminLangId, 'id' => $key], false);
                                }
                                break;
                            default:
                                $td->appendElement('plaintext', array(), $row[$key], true);
                                break;
                        }
                    }
                }

                echo $tbl->getHtml();
                if (count($addresses) == 0) {
                    $this->includeTemplate('_partial/no-record-found.php', array('adminLangId' => $adminLangId));
                }
                ?>
            </div>
        </div>
    </div>
</section>

<?php /*
<section class="card section">
<h1><?php echo Labels::getLabel('LBL_User_Addresses', $adminLangId); ?></h1>
<div class="need-remove">
<ul class="nav-tabs nav-tabs-line tabs_nav">
  <li class="nav-tabs-item"><a class="nav-tabs-link" href="javascript:void(0)"
          onclick="userForm(<?php echo $user_id ?>);"><?php echo Labels::getLabel('LBL_General', $adminLangId); ?></a>
  </li>
  <li class="nav-tabs-item"><a class="nav-tabs-link" href="javascript:void(0)"
          onclick="addBankInfoForm(<?php echo $user_id ?>);"><?php echo Labels::getLabel('LBL_Bank_Info', $adminLangId); ?></a>
  </li>
  <li class="nav-tabs-item"><a class="nav-tabs-link active" href="javascript:void(0)"
          onclick="userAddresses(<?php echo $user_id ?>);"><?php echo Labels::getLabel('LBL_Addresses', $adminLangId); ?></a>
  </li>
</ul>
<div class="tabs_panel_wrap">
  <a href="javascript:void(0)" class="themebtn btn-default btn btn-brand btn-sm"
      onClick="addOneAddress(<?php echo $user_id ?>,0)"><?php echo Labels::getLabel('LBL_Add_New', $adminLangId); ?></a>
  <div class="tabs_panel">
      <?php
      $arr_flds = array(
          'listserial' => Labels::getLabel('LBL_#', $adminLangId),
          'addr_title' => Labels::getLabel('LBL_Identifier', $adminLangId),
          'user_address' => Labels::getLabel('LBL_Address', $adminLangId),
          'addr_is_default' => Labels::getLabel('LBL_Default', $adminLangId),
          'action' => Labels::getLabel('LBL_Action(s)', $adminLangId),
      );
      $tbl = new HtmlElement('table', array('width' => '100%', 'class' => 'table table-hovered table-justified'));
      $th = $tbl->appendElement('thead')->appendElement('tr');
      foreach ($arr_flds as $key => $val) {
          $e = $th->appendElement('th', array(), $val, true);
      }
      $sr_no = 0;
      foreach ($addresses as $sn => $row) {
          $sr_no++;
          $tr = $tbl->appendElement('tr');

          foreach ($arr_flds as $key => $val) {
              $td = $tr->appendElement('td');
              switch ($key) {
                  case 'listserial':
                      $td->appendElement('plaintext', array(), $sr_no);
                      break;
                  case 'user_address':
                      $address = $row['addr_name'] . '<br>';
                      $address .= $row['addr_address1'];
                      $address .= (!empty($row['add_address2'])) ? ',' . $row['addr_address2'] . '<br>' : '<br>';
                      $address .= (!empty($row['addr_city'])) ? $row['addr_city'] . ',' : '';
                      $address .= (!empty($row['state_name'])) ? $row['state_name'] . '<br>' : '';
                      $address .= (!empty($row['country_name'])) ? $row['country_name'] . '<br>' : '';
                      $address .= (!empty($row['addr_zip'])) ? Labels::getLabel('LBL_Postal_Code', $adminLangId) . ': ' . $row['addr_zip'] . '<br>' : '';
                      $address .= (!empty($row['addr_phone'])) ? Labels::getLabel('LBL_Phone', $adminLangId) . ': ' . $row['addr_dial_code'] . ' ' . $row['addr_phone'] . '<br>' : '';

                      $td->appendElement('plaintext', array(), $address, true);
                      break;
                  case 'addr_is_default':
                      $str = ($row['addr_is_default'] == 1) ? Labels::getLabel('LBL_Yes', $adminLangId) : Labels::getLabel('LBL_No', $adminLangId);
                      $td->appendElement('plaintext', array(), $str, true);
                      break;
                  case 'action':
                      if ($canEdit) {
                          $actionArr = [
                              [
                                  "title" => Labels::getLabel('LBL_Edit', $adminLangId),
                                  "icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#edit'></use></svg>",
                                  "onclick" => "addOneAddress(" . $row['addr_record_id'] . "," . $row['addr_id'] . ")"
                              ],
                              [
                                  "title" => Labels::getLabel('LBL_Delete', $adminLangId),
                                  "icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#delete'></use></svg>",
                                  "onclick" => "deleteAddress(" . $row['addr_record_id'] . "," . $row['addr_id'] . ")"
                              ]
                          ];
                          $this->includeTemplate('_partial/actions.php', ['actionArr' => $actionArr, 'td' => $td, 'adminLangId' => $adminLangId,'id'=>$key], false);
                      }
                      break;
                  default:
                      $td->appendElement('plaintext', array(), $row[$key], true);
                      break;
              }
          }
      }
      
      echo $tbl->getHtml();
      if (count($addresses) == 0) {
          $this->includeTemplate('_partial/no-record-found.php', array('adminLangId' => $adminLangId));
      }
      ?>
  </div>
</div>
</div>
</section>
*/
?>