<?php defined('SYSTEM_INIT') or die('Invalid Usage.');

$frm = $addressFrm;

$addressFrm->setFormTagAttribute('id', 'addressFrm');
$addressFrm->setFormTagAttribute('class', 'form web_form form_horizontal');

$addressFrm->setFormTagAttribute('onsubmit', 'setupAddress(this); return(false);');

$addressFrm->developerTags['colClassPrefix'] = 'col-md-';
$addressFrm->developerTags['fld_default_col'] = 12;

$countryFld = $addressFrm->getField('addr_country_id');
$countryFld->setFieldTagAttribute('id', 'addr_country_id');
$countryFld->setFieldTagAttribute('onChange', 'getCountryStates(this.value,' . $stateId . ',\'#addr_state_id\')');

$stateFld = $addressFrm->getField('addr_state_id');
$stateFld->setFieldTagAttribute('id', 'addr_state_id');

$recordId = (int) $user_id;

$tabsButtons = [
	[
		'attr' => [
			'onclick' => 'userForm(' . $recordId . ')',
			'title' => Labels::getLabel('LBL_General', $adminLangId),
		],
		'label' => Labels::getLabel('LBL_General', $adminLangId),
		'isActive' => false,
	],
	[
		'attr' => [
			'onclick' => 'addBankInfoForm(' . $recordId . ')',
			'title' => Labels::getLabel('LBL_Bank_Info', $adminLangId),
		],
		'label' => Labels::getLabel('LBL_Bank_Info', $adminLangId),
		'isActive' => false
	],
	[
		'attr' => [
			'onclick' => 'addUserAddress(' . $recordId . ')',
			'title' => Labels::getLabel('LBL_Addresses', $adminLangId),
		],
		'label' => Labels::getLabel('LBL_Addresses', $adminLangId),
		'isActive' => true,
		'isPrimary' => true
	],
];

$formTitle = Labels::getLabel('LBL_User_Addresses', $adminLangId);
require_once(CONF_THEME_PATH . 'default/_partial/bootstrap-model/header.php');
?>
<?php echo $addressFrm->getFormHtml(); ?>
<?php
require_once(CONF_THEME_PATH . 'default/_partial/bootstrap-model/footer.php');
?>

<?php /*
<section class="card section">
<div class="card-head  modal-header">
<h4><?php echo Labels::getLabel('LBL_User_Addresses', $adminLangId); ?></h4>
</div>
<div class="card-body extra">
<div class="need-remove">
  <ul class="nav-tabs nav-tabs-line tabs_nav">
	  <li class="nav-tabs-item"><a class="nav-tabs-link" href="javascript:void(0)"
			  onclick="userForm(<?php echo $user_id ?>);"><?php echo Labels::getLabel('LBL_General', $adminLangId); ?></a>
	  </li>
	  <li class="nav-tabs-item"><a class="nav-tabs-link" href="javascript:void(0)"
			  onclick="addBankInfoForm(<?php echo $user_id ?>);"><?php echo Labels::getLabel('LBL_Bank_Info', $adminLangId); ?></a>
	  </li>
	  <li class="nav-tabs-item"><a class="nav-tabs-link active" href="javascript:void(0)"
			  onclick="addUserAddress(<?php echo $user_id ?>);"><?php echo Labels::getLabel('LBL_Addresses', $adminLangId); ?></a>
	  </li>
  </ul>
  <div class="tabs_panel_wrap">
	  <div class="tabs_panel">
		  <?php echo $addressFrm->getFormHtml(); ?>
	  </div>
  </div>
</div>
</div>
</section>
*/ ?>
<script language="javascript">
	$(document).ready(function () {
		getCountryStates($("#addr_country_id").val(), <?php echo $stateId; ?>, '#addr_state_id');
		stylePhoneNumberFld("input[name='addr_phone']");
	});	
</script>

<?php
if (isset($countryIso) && !empty($countryIso)) { ?>
		<script>
			langLbl.defaultCountryCode = '<?php echo $countryIso; ?>';
		</script>
<?php } ?>