<?php
$frm->setFormTagAttribute('class', 'form web_form form_horizontal layout--' . $formLayout);
$frm->setFormTagAttribute('onsubmit', 'setupTheme(this); return(false);');
$frm->setFormTagAttribute('dir', $formLayout);
echo $frm->getFormTag();
?>

<div class="form">
    <div class="form-group">
        <label class="label">
            <?php
            $fld = $frm->getField('theme_font_family');
            $fld->addFieldTagAttribute('data-value', $fld->value);
            echo $frm->getField('theme_font_family')->getCaption();
            ?>
        </label>
        <div class="dropdown dropdown-font-family">
            <?php
            echo $frm->getFieldHtml('theme_font_family_url');
            echo $frm->getFieldHtml('theme_font_family');
            ?>
        </div>
    </div>
    <div class="form-group">
        <label class="label">
            <?php
            $fld = $frm->getField('theme_font_weight[]');
            $fld->addFieldTagAttribute('id', 'font-weight-js');
            echo $frm->getField('theme_font_weight[]')->getCaption();
            ?>
        </label>

        <div class="dropdown dropdown-font-weight-js">
            <?php echo $frm->getFieldHtml('theme_font_weight[]'); ?>
            <div class="list-tag-wrapper d-none">
                <ul class="list-tags" id="selected-options"></ul>
            </div>
        </div>
    </div>


    <div class="form-group">
        <label class="label">
            <?php
            $fld = $frm->getField('theme_color');
            $fld->addFieldTagAttribute('class', 'form-color jscolor themeColor--js');
            $fld->addFieldTagAttribute('data-bg', 'none');
            $fld->addFieldTagAttribute('data-jscolor', '{}');
            echo $fld->getCaption();
            ?>
        </label>
        <div class="">
            <div>
                <div class="input-group color-picker">
                    <?php echo $frm->getFieldHtml('theme_color'); ?>
                </div>
            </div>
        </div>
    </div>
    <div class="form-group">
        <label class="label">
            <?php
            $fld = $frm->getField('theme_color_inverse');
            $fld->addFieldTagAttribute('class', 'form-color jscolor themeColorInverse--js');
            $fld->addFieldTagAttribute('data-bg', 'none');
            $fld->addFieldTagAttribute('data-jscolor', '{}');
            echo $fld->getCaption();
            ?>
        </label>
        <div class="">
            <div name="backendbgcolorprimaryinverse">
                <div class="input-group color-picker">
                    <?php echo $frm->getFieldHtml('theme_color_inverse'); ?>
                </div>
            </div>
        </div>
    </div>

    <?php $fld = $frm->getField('theme_secondary_color');
    if (!empty($fld)) { ?>
        <div class="form-group">
            <label class="label">
                <?php
                $fld = $frm->getField('theme_secondary_color');
                $fld->addFieldTagAttribute('class', 'form-color jscolor');
                $fld->addFieldTagAttribute('data-bg', 'none');
                $fld->addFieldTagAttribute('data-jscolor', '{}');
                echo $fld->getCaption();
                ?>
            </label>
            <div class="">
                <div name="backendbgcolorprimaryinverse">
                    <div class="input-group color-picker">
                        <?php echo $frm->getFieldHtml('theme_secondary_color'); ?>
                    </div>
                </div>
            </div>
        </div>
    <?php } ?>

    <?php $fld = $frm->getField('theme_secondary_color_inverse');
    if (!empty($fld) && 0) { ?>
        <div class="form-group">
            <label class="label">
                <?php
                $fld->addFieldTagAttribute('class', 'form-color jscolor themeColorInverse--js');
                $fld->addFieldTagAttribute('data-bg', 'none');
                $fld->addFieldTagAttribute('data-jscolor', '{}');
                echo $fld->getCaption();
                ?>
            </label>
            <div class="">
                <div name="backendbgcolorprimaryinverse">
                    <div class="input-group color-picker">
                        <?php echo $frm->getFieldHtml('theme_secondary_color_inverse'); ?>
                    </div>
                </div>
            </div>
        </div>
    <?php } ?>
    <div class="form-group">
        <div class="alert alert-primary d-flex align-items-center img-disclaimer">
            <svg class="svg me-3" width="50" height="50" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16"
                role="img" aria-label="Warning:">
                <path
                    d="M8.982 1.566a1.13 1.13 0 0 0-1.96 0L.165 13.233c-.457.778.091 1.767.98 1.767h13.713c.889 0 1.438-.99.98-1.767L8.982 1.566zM8 5c.535 0 .954.462.9.995l-.35 3.507a.552.552 0 0 1-1.1 0L7.1 5.995A.905.905 0 0 1 8 5zm.002 6a1 1 0 1 1 0 2 1 1 0 0 1 0-2z" />
            </svg>
            <div>
                <?php echo Labels::getLabel('LBL_DISCLAIMER:_INVERSE_COLOR_SHOULD_BE_IN_CONTRAST_TO_THE_THEME_COLOR', $adminLangId); ?>
            </div>

        </div>

    </div>
    <div class="form-group ">
        <?php echo $frm->getFieldHtml('theme_id'); ?>
        <?php
        $fld = $frm->getField('btn_submit');
        $fld->addFieldTagAttribute('class', 'btn btn-brand btn-block mt-2');

        echo $frm->getFieldHtml('btn_submit');
        ?>
    </div>
</div>
</form>
<?php echo $frm->getExternalJS(); ?>
<script>
    var font_weight_html = $('.dropdodivfont-weight-js').html();
    var font_weights = '<?php echo json_encode($fontWeights); ?>';
</script>